/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.entity.Role;
import cms.tmx.manage.models.RoleMngModel;
import cms.tmx.manage.models.RoleMngServiceImpl;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateRoleBasic
extends MxTabContent {
    @FXML
    private ComboBox<String> cmbPartyId;
    @FXML
    private TextField txtId;
    @FXML
    private TextField txtName;
    @FXML
    private TextArea txtMark;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private RoleMngServiceImpl roleMng;
    @Inject
    private RoleMngModel roleModel;
    private Role roleUpdate;
    private static final Logger logger = LogManager.getLogger(UpdateRoleBasic.class);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.roleUpdate = this.roleModel.getCommonRole();
        this.initValues();
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.txtId.textProperty().bindBidirectional((Property)this.roleUpdate.idProperty());
        this.txtName.textProperty().bindBidirectional((Property)this.roleUpdate.nameProperty());
        this.txtMark.textProperty().bindBidirectional((Property)this.roleUpdate.desProperty());
        this.cmbPartyId.valueProperty().bindBidirectional((Property)this.roleUpdate.partyNameProperty());
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtMark.setTextFormatter((TextFormatter)new MxFormatter(100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.txtMark.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB == event.getCode()) {
                this.txtName.requestFocus();
                event.consume();
            }
        });
    }

    private void initValues() {
        Platform.runLater(() -> this.txtName.requestFocus());
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            this.roleMng.updateRole(this.roleUpdate);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Role getRoleUpdate() {
        return this.roleUpdate;
    }

    public void setRoleUpdate(Role roleUpdate) {
        this.roleUpdate = roleUpdate;
    }

    public ComboBox<String> getCmbParty() {
        return this.cmbPartyId;
    }

    public void setCmbParty(ComboBox<String> cmbPartyId) {
        this.cmbPartyId = cmbPartyId;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextArea getTxtMark() {
        return this.txtMark;
    }

    public void setTxtMark(TextArea txtMark) {
        this.txtMark = txtMark;
    }
}

