/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IUserApi;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.User;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.utils.StringUtils;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdatePwdDialog
extends DialogObj {
    @FXML
    private TextField txtName;
    @FXML
    private PasswordField pwdOldPwd;
    @FXML
    private Label lbOldPwdErr;
    @FXML
    private PasswordField pwdPwd;
    @FXML
    private Label lbPwdErr;
    @FXML
    private PasswordField pwdPwdConfirm;
    @FXML
    private Label lbPwdConfirmErr;
    @FXML
    private Label lbPwdRepeatErr;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private IUserApi uapi;
    @Inject
    private IBaseApi bpi;
    @Inject
    private UserMngServiceImpl userService;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private User user;
    private static final Logger logger = LogManager.getLogger(UpdatePwdDialog.class);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private static final int ERROR_USER_PWD_SAME = 3117;

    @FXML
    public void initialize() {
        this.initValues();
        this.addCheck();
    }

    private void addCheck() {
        this.pwdOldPwd.setTextFormatter((TextFormatter)new MxFormatter("^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*$", 20));
        this.pwdPwd.setTextFormatter((TextFormatter)new MxFormatter("^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*$", 20));
        this.pwdPwdConfirm.setTextFormatter((TextFormatter)new MxFormatter("^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*$", 20));
        this.pwdOldPwd.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                try {
                    if (!this.uapi.VerifyUserPassword(this.bpi.getUserId(), this.pwdOldPwd.getText())) {
                        this.lbOldPwdErr.setOpacity(1.0);
                    } else {
                        this.lbOldPwdErr.setOpacity(0.0);
                        this.save.set(true);
                    }
                }
                catch (MException e) {
                    this.lbOldPwdErr.setOpacity(1.0);
                    logger.error("\u5bc6\u7801\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
                }
            }
        });
        this.registerCheck((Node)this.lbOldPwdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> true, (Observable[])new Observable[]{this.pwdOldPwd.focusedProperty()}));
        this.registerCheck((Node)this.lbPwdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pwdPwd.focusedProperty().get() && !TextFieldUtils.isPwd((TextField)this.pwdPwd).get()) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pwdPwd.focusedProperty(), TextFieldUtils.isPwd((TextField)this.pwdPwd)}));
        this.registerCheck((Node)this.lbPwdConfirmErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pwdPwdConfirm.focusedProperty().get() && !this.pwdPwdConfirm.getText().equals(this.pwdPwd.getText())) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pwdPwdConfirm.focusedProperty()}));
    }

    private void initValues() {
        try {
            this.user = this.userService.getActiveUser();
            this.txtName.setText(this.user.getName());
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.pwdPwd.setTooltip(new Tooltip("\u8981\u6c42\u81f3\u5c118\u4f4d\uff0c\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u7279\u6b8a\u5b57\u7b26\u81f3\u5c113\u79cd\u7ec4\u5408\u642d\u914d"));
    }

    public boolean isOK(ButtonType bt) {
        block5: {
            try {
                if (this.check()) break block5;
                return false;
            }
            catch (MException ex) {
                if (ex.getCode() == 3117) {
                    this.lbPwdRepeatErr.setText("\u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e00\u81f4");
                    this.lbPwdRepeatErr.setTextFill((Paint)Color.RED);
                    this.showTips(this.lbPwdRepeatErr);
                } else {
                    logger.error((Object)ex, (Throwable)ex);
                    this.mAlert.alert(Alert.AlertType.ERROR, String.valueOf(ex.getCode()) + ex.getMessage());
                }
                return false;
            }
        }
        this.userMng.resetPwd(this.user.getId(), this.pwdPwdConfirm.getText());
        this.eCore.put((Object)"password", (Object)this.pwdPwdConfirm.getText());
        this.lbPwdRepeatErr.setText("\u5bc6\u7801\u4fee\u6539\u6210\u529f");
        this.lbPwdRepeatErr.setTextFill((Paint)Color.WHITE);
        this.showTips(this.lbPwdRepeatErr);
        return false;
    }

    private void showTips(Label lb) {
        lb.requestFocus();
        lb.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> lb.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
    }

    private boolean check() {
        if (this.pwdOldPwd.getText().isEmpty()) {
            this.lbOldPwdErr.setOpacity(1.0);
            return false;
        }
        if (!StringUtils.isPwd((String)this.pwdPwd.getText())) {
            this.lbPwdErr.setOpacity(1.0);
            this.lbPwdConfirmErr.setOpacity(1.0);
            return false;
        }
        if (!this.pwdPwd.getText().equals(this.pwdPwdConfirm.getText())) {
            this.lbPwdConfirmErr.setOpacity(1.0);
            return false;
        }
        return true;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    public PasswordField getPwdPwdConfirm() {
        return this.pwdPwdConfirm;
    }

    public void setPwdPwdConfirm(PasswordField pwdPwdConfirm) {
        this.pwdPwdConfirm = pwdPwdConfirm;
    }
}

