/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.Product;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.ProductMngModel;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UpdateProductBasic
extends MxTabContent {
    @FXML
    private TextField txtId;
    @FXML
    private TextField txtProdName;
    @FXML
    private TextArea txtProdAttach;
    @FXML
    private Label lbProdNameErr;
    @FXML
    private Label lbTypeErr;
    @FXML
    private Label lbInstErr;
    @FXML
    private Label lbAlert;
    @FXML
    private DatePicker start_date;
    @FXML
    private DatePicker end_date;
    @FXML
    private TextField txtProdShare;
    @FXML
    private TextField txtProdMnger;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private ComboBox<String> cmbOrgId;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private ProductMngModel productModel;
    private Product product;
    @Inject
    private ProductMngServiceImpl productMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private MObjFactory of;
    @Inject
    private IUiRightService model;
    private static final Logger logger = LogManager.getLogger(UpdateProductBasic.class);
    private Party party;
    private String productId;

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.product = (Product)this.of.create(Product.class);
        this.product.update((Object)this.productModel.getCommonProduct());
        this.bind();
        this.initialValues();
        this.addCheck();
    }

    private void addCheck() {
        this.txtProdName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtProdMnger.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtProdShare.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 15));
        this.txtProdAttach.setTextFormatter((TextFormatter)new MxFormatter(1000));
        this.registerCheck((Node)this.lbProdNameErr, (ObservableBooleanValue)TextFieldUtils.isNotEmpty((TextField)this.txtProdName));
        this.registerCheck((Node)this.lbInstErr, (ObservableBooleanValue)this.cmbOrgId.valueProperty().isNotNull());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.valueProperty().isNotNull());
        this.model.registerCheck((Control)this.txtProdShare, new String[]{"saveProductShares"});
        this.txtProdShare.setVisible(true);
    }

    private void initialValues() {
        try {
            MxNode node = MxNodeFactory.create((String)"productType", (String)"1");
            this.cmbType.setItems(node.getNodes());
            this.cmbType.getSelectionModel().select(0);
            DatePickerUtils.setDateLimit((DatePicker)this.start_date, (DatePicker)this.end_date, (boolean)false);
            this.setTime(this.start_date, this.product.getBeginDate());
            this.setTime(this.end_date, this.product.getEndDate());
            DatePickerUtils.setFormat((DatePicker)this.start_date, (String)"yyyy-MM-dd");
            DatePickerUtils.setFormat((DatePicker)this.end_date, (String)"yyyy-MM-dd");
            this.start_date.setEditable(false);
            this.end_date.setEditable(false);
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void setTime(DatePicker picker, String time) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            if (time.isEmpty()) {
                return;
            }
            calendar.setTime(sdf.parse(time));
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            picker.setValue((Object)LocalDate.of(year, month, day));
        }
        catch (ParseException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void bind() {
        this.cmbType.valueProperty().bindBidirectional((Property)this.product.typeProperty());
        this.txtProdName.textProperty().bindBidirectional((Property)this.product.nameProperty());
        this.txtProdMnger.textProperty().bindBidirectional((Property)this.product.managerProperty());
        this.txtProdAttach.textProperty().bindBidirectional((Property)this.product.desProperty());
        this.txtProdShare.textProperty().bindBidirectional((Property)this.product.sharesProperty());
        this.start_date.getEditor().textProperty().bindBidirectional((Property)this.product.beginDateProperty());
        this.end_date.getEditor().textProperty().bindBidirectional((Property)this.product.endDateProperty());
        this.cmbOrgId.valueProperty().bindBidirectional((Property)this.product.partyNameProperty());
        this.txtId.textProperty().bindBidirectional((Property)this.product.idProperty());
        this.start_date.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.BACK_SPACE == event.getCode() || KeyCode.DELETE == event.getCode()) {
                this.start_date.getEditor().setText("");
                event.consume();
            }
        });
        this.end_date.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.BACK_SPACE == event.getCode() || KeyCode.DELETE == event.getCode()) {
                this.end_date.getEditor().setText("");
                event.consume();
            }
        });
        this.lbAlert.focusedProperty().addListener((Observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            this.product.update(this.productModel.getCommonProduct(), true);
            this.productMng.updateProduct(this.product);
            this.productModel.getCommonProduct().update((Object)this.product);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextArea getTxtProdAttach() {
        return this.txtProdAttach;
    }

    public void setTxtProdAttach(TextArea txtProdAttach) {
        this.txtProdAttach = txtProdAttach;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public TextField getTxtProdName() {
        return this.txtProdName;
    }

    public void setTxtProdName(TextField txtProdName) {
        this.txtProdName = txtProdName;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public ComboBox<MxNode> getCmbType() {
        return this.cmbType;
    }

    public void setCmbType(ComboBox<MxNode> cmbType) {
        this.cmbType = cmbType;
    }
}

