/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Post;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.PostMngModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdatePostBasic
extends MxTabContent {
    @FXML
    private ComboBox<String> cmbPartntId;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private TextField txtId;
    @FXML
    private TextField txtName;
    @FXML
    private TextArea txtMark;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbTypeErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private PostMngModel postModel;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private MObjFactory of;
    private Post postUpdate;
    private static final Logger logger = LogManager.getLogger(UpdatePostBasic.class);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.postUpdate = this.postModel.getCommonPost();
        this.initValues();
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.txtId.textProperty().bindBidirectional((Property)this.postUpdate.idProperty());
        this.txtName.textProperty().bindBidirectional((Property)this.postUpdate.nameProperty());
        this.txtMark.textProperty().bindBidirectional((Property)this.postUpdate.descProperty());
        this.cmbPartntId.valueProperty().bindBidirectional((Property)this.postUpdate.partyNameProperty());
        this.cmbType.valueProperty().bindBidirectional((Property)this.postUpdate.typeProperty());
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtMark.setTextFormatter((TextFormatter)new MxFormatter(100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.getSelectionModel().selectedItemProperty().isNotNull());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.txtMark.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB == event.getCode()) {
                this.txtName.requestFocus();
                event.consume();
            }
        });
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"post_type", (String)"2");
        this.cmbType.setItems(node.getNodes());
        Platform.runLater(() -> this.txtName.requestFocus());
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            this.postMng.updatePost(this.postUpdate);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Post getPostUpdate() {
        return this.postUpdate;
    }

    public void setPostUpdate(Post postUpdate) {
        this.postUpdate = postUpdate;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextArea getTxtMark() {
        return this.txtMark;
    }

    public void setTxtMark(TextArea txtMark) {
        this.txtMark = txtMark;
    }
}

