/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.ClearingModel;
import cms.tmx.manage.models.PortfolioMngModel;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdatePortfolioBasic
extends MxTabContent {
    @FXML
    private ComboBox<String> cmbParty;
    @FXML
    private ComboBox<MxNodePwf> cmbCarryType;
    @FXML
    private TextField txtId;
    @FXML
    private TextField txtName;
    @FXML
    private TextField txtYears;
    @FXML
    private TextArea txtMark;
    @FXML
    private DatePicker txtCarryDay;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbPartyErr;
    @FXML
    private Label lbYears;
    @FXML
    private Label lbCarryDay;
    @FXML
    private Label lbAlert;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @FXML
    private CheckBox ckIsFun;
    @FXML
    private CheckBox ckIsSecu;
    @FXML
    private CheckBox ckExportFW;
    @FXML
    private CheckBox cbExternalAsset;
    @FXML
    private Label lbNonTradableAsset;
    @FXML
    private ComboBox<MxNode> cmbNonTradableAsset;
    @FXML
    private Label lbDataSource;
    @FXML
    private ComboBox<MxNode> cmbDataSource;
    @FXML
    private Label lbAutoSyncConf;
    @FXML
    private ComboBox<String> cmbAutoSyncConf;
    @FXML
    private Label lbExternalPort;
    @FXML
    private ComboBox<String> cmbExternalPort;
    @FXML
    private Label lbExternalPortErr;
    @FXML
    private Label lbExternalId;
    @FXML
    private TextField txtExternalId;
    @FXML
    private Label lbExternalName;
    @FXML
    private TextField txtExternalName;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private PortfolioMngModel portfolioModel;
    @Inject
    private IFundAccountApi fundAccountApi;
    @Inject
    private ISecAccountApi secAccountApi;
    @Inject
    private ClearingModel clearingModel;
    @Inject
    private MObjFactory of;
    private Portfolio portfolioUpdate;
    private static final Logger logger = LogManager.getLogger(UpdatePortfolioBasic.class);
    private String carryDate = "";
    private String lastTradingDay = "";
    public static SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
    private static final String FORMAT = "yyyy-MM-dd";
    private LocalDate defultDate;

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.portfolioUpdate = (Portfolio)this.of.create(Portfolio.class);
        this.portfolioUpdate.update((Object)this.portfolioModel.getCommonPortfolio());
        this.carryDate = UpdatePortfolioBasic.getCurrYearLast();
        this.initValues();
        this.bind();
        this.addCheck();
    }

    public static String getCurrYearLast() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return UpdatePortfolioBasic.getYearLast(currentYear);
    }

    public static String getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        String sDate = f.format(currYearLast);
        return sDate;
    }

    private void bind() {
        this.txtId.textProperty().bindBidirectional((Property)this.portfolioUpdate.idProperty());
        this.txtName.textProperty().bindBidirectional((Property)this.portfolioUpdate.nameProperty());
        this.txtMark.textProperty().bindBidirectional((Property)this.portfolioUpdate.desProperty());
        this.txtYears.textProperty().bindBidirectional((Property)this.portfolioUpdate.carryYearsProperty());
        this.txtYears.setTextFormatter((TextFormatter)new MxFormatter("[1-9]", 1));
        this.cmbParty.valueProperty().bindBidirectional((Property)this.portfolioUpdate.partyNameProperty());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        if (this.portfolioUpdate.getIsVerifyFund() == 2) {
            this.ckIsFun.setSelected(true);
        } else {
            this.ckIsFun.setSelected(false);
        }
        if (this.portfolioUpdate.getIsVerifySecu() == 2) {
            this.ckIsSecu.setSelected(true);
        } else {
            this.ckIsSecu.setSelected(false);
        }
        this.ckExportFW.setSelected(this.portfolioUpdate.getExportSettlement() == 1);
        MxNode node = MxNodeFactory.create((String)"non_tradable_assets", (String)"0");
        this.cmbNonTradableAsset.setItems(node.getNodes());
        this.cmbNonTradableAsset.setValue((Object)node);
        this.cmbNonTradableAsset.valueProperty().bindBidirectional((Property)this.portfolioUpdate.nonTradableAssetProperty());
        node = MxNodeFactory.create((String)"accnt_data_source", (String)"1");
        this.cmbDataSource.setItems(node.getNodes());
        this.cmbDataSource.setValue((Object)node);
        this.cmbAutoSyncConf.setValue((Object)"\u6570\u636e\u4e2d\u53f0");
        this.cmbAutoSyncConf.setDisable(true);
        this.cmbDataSource.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.dataSourceChanged((MxNode)now));
        this.cmbDataSource.getSelectionModel().select((Object)this.portfolioUpdate.getDataSource());
        this.cmbDataSource.setDisable(true);
        this.cbExternalAsset.selectedProperty().addListener((ob, old, now) -> this.externalAccntCheck((Boolean)now));
        this.cbExternalAsset.setSelected(this.portfolioUpdate.isExternalAsset());
        this.cbExternalAsset.setDisable(true);
        if (this.portfolioUpdate.isExternalAsset() && "1".equals(this.portfolioUpdate.getDataSource().getRaw())) {
            this.cmbExternalPort.setValue((Object)this.portfolioUpdate.getExternalAccnt());
            Tooltip tooltip = new Tooltip();
            tooltip.setText(this.portfolioUpdate.getExternalAccnt());
            this.cmbExternalPort.setTooltip(tooltip);
        }
        this.externalAccntCheck(this.cbExternalAsset.isSelected());
        this.txtExternalId.setText(this.portfolioUpdate.getExternalId());
        this.txtExternalName.setText(this.portfolioUpdate.getExternalName());
    }

    private void externalAccntCheck(Boolean now) {
        this.lbNonTradableAsset.setVisible(false);
        this.cmbNonTradableAsset.setVisible(false);
        this.lbDataSource.setVisible(false);
        this.cmbDataSource.setVisible(false);
        this.lbAutoSyncConf.setVisible(false);
        this.cmbAutoSyncConf.setVisible(false);
        this.lbExternalPort.setVisible(false);
        this.cmbExternalPort.setVisible(false);
        this.lbExternalId.setVisible(false);
        this.txtExternalId.setVisible(false);
        this.lbExternalName.setVisible(false);
        this.txtExternalName.setVisible(false);
        if (now.booleanValue()) {
            this.lbDataSource.setVisible(now.booleanValue());
            this.cmbDataSource.setVisible(now.booleanValue());
            this.lbExternalId.setVisible(now.booleanValue());
            this.txtExternalId.setVisible(now.booleanValue());
            this.lbExternalName.setVisible(now.booleanValue());
            this.txtExternalName.setVisible(now.booleanValue());
            this.dataSourceChanged((MxNode)this.cmbDataSource.getSelectionModel().getSelectedItem());
        } else {
            this.lbNonTradableAsset.setVisible(now == false);
            this.cmbNonTradableAsset.setVisible(now == false);
        }
    }

    private void dataSourceChanged(MxNode node) {
        boolean isAuto = "1".equals(node.getRaw());
        this.lbAutoSyncConf.setVisible(isAuto);
        this.cmbAutoSyncConf.setVisible(isAuto);
        this.lbExternalPort.setVisible(isAuto);
        this.cmbExternalPort.setVisible(isAuto);
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-\\(\\).]*", 20));
        this.txtMark.setTextFormatter((TextFormatter)new MxFormatter(100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.txtExternalId.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 20));
        this.txtExternalName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?\\(\\)]*", 100));
    }

    private void initValues() {
        Platform.runLater(() -> this.txtName.requestFocus());
        if (this.portfolioUpdate.getCarryCode() != 3) {
            this.txtYears.setEditable(false);
            this.lbYears.setOpacity(0.0);
            this.txtYears.setOpacity(0.0);
        }
        if (this.portfolioUpdate.getCarryCode() == 1) {
            this.txtCarryDay.setEditable(false);
            this.lbCarryDay.setOpacity(0.0);
            this.txtCarryDay.setOpacity(0.0);
        }
        this.carryDate = UpdatePortfolioBasic.getCurrYearLast();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        try {
            this.lastTradingDay = this.clearingModel.getLastTradingDay();
        }
        catch (MException ex) {
            logger.error("\u83b7\u53d6\u6e05\u7b97\u65e5\u5f02\u5e38\uff1a " + ex.getMessage(), (Throwable)ex);
        }
        try {
            Date newDate = formatter.parse(this.lastTradingDay);
            DatePickerUtils.setDaysLaterTrading((DatePicker)this.txtCarryDay, (String)f.format(newDate));
        }
        catch (Exception e) {
            logger.error("\u8f6c\u5316\u6e05\u7b97\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff1a " + this.lastTradingDay, (Throwable)e);
        }
        this.defultDate = LocalDate.parse(this.carryDate, DateTimeFormatter.ofPattern(FORMAT));
        DatePickerUtils.setFormat((DatePicker)this.txtCarryDay, (String)FORMAT);
        if (!this.portfolioUpdate.getCarryDay().isEmpty()) {
            try {
                Date carryDay = formatter.parse(this.portfolioUpdate.getCarryDay());
                LocalDate oldDate = carryDay.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                this.txtCarryDay.setValue((Object)oldDate);
            }
            catch (Exception e) {
                logger.error("\u8f6c\u5316\u6e05\u7b97\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff1a " + this.lastTradingDay, (Throwable)e);
            }
        }
        MxNodePwf nodePwf = MxNodeFactory.createPwf((String)"carry_type", (String)"1");
        ObservableList listCarry = nodePwf.getPwfNodes();
        this.cmbCarryType.setItems(listCarry);
        this.cmbCarryType.getSelectionModel().select(this.portfolioUpdate.getCarryCode() - 1);
        this.cmbCarryType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.portfolioUpdate.setCarryCode(Integer.parseInt(now.getRaw()));
                if (!"3".equals(now.getRaw())) {
                    this.txtYears.clear();
                    this.txtYears.setEditable(false);
                    this.lbYears.setOpacity(0.0);
                    this.txtYears.setOpacity(0.0);
                } else {
                    this.txtYears.setEditable(true);
                    this.lbYears.setOpacity(1.0);
                    this.txtYears.setOpacity(1.0);
                    this.txtYears.textProperty().setValue("1");
                }
                if (!"1".equals(now.getRaw())) {
                    this.txtCarryDay.setValue((Object)this.defultDate);
                    this.lbCarryDay.setOpacity(1.0);
                    this.txtCarryDay.setOpacity(1.0);
                } else {
                    this.txtCarryDay.setValue(null);
                    this.lbCarryDay.setOpacity(0.0);
                    this.txtCarryDay.setOpacity(0.0);
                }
            }
        });
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        boolean f = false;
        boolean s = false;
        if (this.ckIsFun.isSelected()) {
            if (this.portfolioUpdate.getIsVerifyFund() == 1) {
                this.portfolioUpdate.setIsVerifyFund(2);
                f = true;
            }
        } else if (this.portfolioUpdate.getIsVerifyFund() == 2) {
            this.portfolioUpdate.setIsVerifyFund(1);
            f = true;
        }
        if (this.ckIsSecu.isSelected()) {
            if (this.portfolioUpdate.getIsVerifySecu() == 1) {
                this.portfolioUpdate.setIsVerifySecu(2);
                s = true;
            }
        } else if (this.portfolioUpdate.getIsVerifySecu() == 2) {
            this.portfolioUpdate.setIsVerifySecu(1);
            s = true;
        }
        this.portfolioUpdate.setExportSettlement(this.ckExportFW.isSelected() ? 1 : 0);
        if (this.txtCarryDay.getValue() != null) {
            this.portfolioUpdate.setCarryDay(((LocalDate)this.txtCarryDay.getValue()).toString().replaceAll("-", ""));
        }
        if (this.txtYears.isEditable() && this.txtYears.getText().isEmpty()) {
            Platform.runLater(() -> {
                this.lbAlert.setText("\u5e74\u8f93\u5165\u6846\u4e0d\u80fd\u4e3a\u7a7a");
                this.lbAlert.requestFocus();
            });
            return false;
        }
        if (this.cbExternalAsset.isSelected()) {
            this.portfolioUpdate.setExternalId(this.txtExternalId.getText());
            this.portfolioUpdate.setExternalName(this.txtExternalName.getText());
        }
        try {
            this.updateSubFund(f);
            this.updateSubSec(s);
            this.portfolioUpdate.update(this.portfolioModel.getCommonPortfolio(), true);
            this.portfolioMng.updatePortfolio(this.portfolioUpdate);
            this.portfolioModel.getCommonPortfolio().update((Object)this.portfolioUpdate);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    private void updateSubFund(boolean f) throws MException {
        PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
        newBuilder.setPortfolioId(this.portfolioUpdate.getId());
        if (f) {
            List subFundAccountList = this.fundAccountApi.getSubFundAccountList("CCS", newBuilder.build());
            for (PAccount.SubFundAccnt item : subFundAccountList) {
                this.portfolioMng.updateSubFundAccnt(item, "CCS", item.getStatus(), this.portfolioUpdate.getIsVerifyFund());
            }
        }
    }

    private void updateSubSec(boolean s) throws MException {
        PAccount.SubSecAccnt.Builder newBuilder2 = PAccount.SubSecAccnt.newBuilder();
        newBuilder2.setPortfolioId(this.portfolioUpdate.getId());
        if (s) {
            List subSecAccounts = this.secAccountApi.getSubSecAccounts("CCS", newBuilder2.build());
            this.portfolioMng.updateSubSecAccnts(subSecAccounts, this.portfolioUpdate.getIsVerifySecu(), -1, "CCS");
        }
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextArea getTxtMark() {
        return this.txtMark;
    }

    public void setTxtMark(TextArea txtMark) {
        this.txtMark = txtMark;
    }

    public Portfolio getPortfolioUpdate() {
        return this.portfolioUpdate;
    }

    public void setPortfolioUpdate(Portfolio portfolioUpdate) {
        this.portfolioUpdate = portfolioUpdate;
    }
}

