/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Party;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.PartyMngModel;
import cms.tmx.manage.models.PartyMngServiceImpl;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdatePartyBasic
extends MxTabContent {
    @FXML
    private TextField txtParent;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private ComboBox<MxNode> cmbIDType;
    @FXML
    private TextField txtFullName;
    @FXML
    private TextField txtName;
    @FXML
    private TextField txtID;
    @FXML
    private TextField txtCode;
    @FXML
    private TextField txtContacter;
    @FXML
    private TextField txtPhone;
    @FXML
    private TextField txtAddr;
    @FXML
    private TextField txtEmail;
    @FXML
    private TextArea txtMark;
    @FXML
    private Label lbFullNameErr;
    @FXML
    private Label lbEmailErr;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbCodeErr;
    @FXML
    private Label lbAlert;
    @FXML
    public Button btnSaveBasic;
    @FXML
    private Label labSuccess;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private PartyMngModel partyModel;
    private Button btnNew;
    private Party party;
    private static final Logger logger = LogManager.getLogger(UpdatePartyBasic.class);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.party = this.partyModel.getCommonParty();
        this.initValues();
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.txtFullName.textProperty().bindBidirectional((Property)this.party.fullNameProperty());
        this.txtName.textProperty().bindBidirectional((Property)this.party.nameProperty());
        this.txtID.textProperty().bindBidirectional((Property)this.party.codeProperty());
        this.cmbIDType.valueProperty().bindBidirectional((Property)this.party.creditTypeProperty());
        this.txtContacter.textProperty().bindBidirectional((Property)this.party.contactorProperty());
        this.txtPhone.textProperty().bindBidirectional((Property)this.party.phoneProperty());
        this.txtAddr.textProperty().bindBidirectional((Property)this.party.addressProperty());
        this.txtEmail.textProperty().bindBidirectional((Property)this.party.emailProperty());
        this.txtMark.textProperty().bindBidirectional((Property)this.party.descProperty());
        this.txtCode.textProperty().bindBidirectional((Property)this.party.idProperty());
        this.txtID.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (((MxNode)this.cmbIDType.getSelectionModel().getSelectedItem()).getRaw().isEmpty()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.cmbIDType.getSelectionModel().selectedItemProperty()}));
        this.cmbIDType.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.getRaw().isEmpty()) {
                this.txtID.setText("");
            }
        });
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.txtMark.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB == event.getCode()) {
                this.txtFullName.requestFocus();
                event.consume();
            }
        });
    }

    private void addCheck() {
        this.txtFullName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?\\(\\)]*", 50));
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*", 20));
        this.txtContacter.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtPhone.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
        this.txtID.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 50));
        this.txtAddr.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 100));
        this.txtMark.setTextFormatter((TextFormatter)new MxFormatter(1000));
        this.txtEmail.setTextFormatter((TextFormatter)new MxFormatter(500));
        this.registerCheck((Node)this.lbFullNameErr, (ObservableBooleanValue)this.txtFullName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> ((MxNode)this.cmbIDType.getSelectionModel().getSelectedItem()).getRaw().isEmpty() | !this.txtID.getText().isEmpty(), (Observable[])new Observable[]{this.txtID.focusedProperty(), this.cmbIDType.getSelectionModel().selectedItemProperty()}));
        this.registerCheck((Node)this.lbEmailErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!(this.txtEmail.getText().isEmpty() || this.txtEmail.focusedProperty().get() || TextFieldUtils.isEmail((String)this.txtEmail.getText()))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtEmail.focusedProperty()}));
    }

    private void initValues() {
        try {
            MxNode node = MxNodeFactory.create((String)"credit_type", (String)"");
            this.cmbIDType.setItems(node.getNodes());
            this.txtParent.setDisable(true);
            Party root = this.partyMng.getParty(this.party.getParentId());
            if (root == null) {
                return;
            }
            this.txtParent.setText(root.getName());
            Platform.runLater(() -> this.txtFullName.requestFocus());
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            this.partyMng.updateParty(this.party);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextField getTxtParent() {
        return this.txtParent;
    }

    public void setTxtParent(TextField txtParent) {
        this.txtParent = txtParent;
    }

    public Button getBtnNew() {
        return this.btnNew;
    }

    public void setBtnNew(Button btnNew) {
        this.btnNew = btnNew;
    }

    public TextArea getTxtMark() {
        return this.txtMark;
    }

    public void setTxtMark(TextArea txtMark) {
        this.txtMark = txtMark;
    }

    public TextField getTxtID() {
        return this.txtID;
    }

    public void setTxtID(TextField txtID) {
        this.txtID = txtID;
    }

    public TextField getTxtEmail() {
        return this.txtEmail;
    }

    public void setTxtEmail(TextField txtEmail) {
        this.txtEmail = txtEmail;
    }
}

