/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.DateStrConverter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.MacInfo;
import cms.tmx.entity.UpdateInfo;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.UpdateMngServiceImpl;
import cms.tmx.manage.parts.AddVersionDialog;
import cms.tmx.manage.parts.RemittedListDialog;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import javax.inject.Inject;

public class UpdateMngPart
extends MxPart {
    @FXML
    private DatePicker beginDate;
    @FXML
    private DatePicker endDate;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemitList;
    @FXML
    private TableView<UpdateInfo> tableUpdate;
    @FXML
    private TableColumn<UpdateInfo, String> index;
    @FXML
    private TableColumn<UpdateInfo, String> curVersion;
    @FXML
    private TableColumn<UpdateInfo, String> preVersion;
    @FXML
    private TableColumn<UpdateInfo, String> description;
    @FXML
    private TableColumn<UpdateInfo, String> releaseDate;
    @FXML
    private TableColumn<UpdateInfo, String> releaseTime;
    @FXML
    private TableColumn<UpdateInfo, Object> updateList;
    @FXML
    private TableColumn<UpdateInfo, Object> opera;
    @FXML
    private TableColumn<UpdateInfo, String> creator;
    @FXML
    private TableColumn<UpdateInfo, String> createTime;
    @FXML
    private TableColumn<UpdateInfo, String> updater;
    @FXML
    private TableColumn<UpdateInfo, String> updateTime;
    @FXML
    private CheckBox cbDefault;
    private ObservableList<UpdateInfo> olist = FxUtils.newList();
    private List<MacInfo> RemitList = new ArrayList<MacInfo>();
    @Inject
    private UpdateMngServiceImpl updateService;
    @Inject
    private MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;

    @FXML
    private void initialize() {
        this.createTable();
        this.initCtrl();
        this.initValue();
        this.bind();
        this.listener();
        this.exe.execute(() -> this.query());
    }

    private void initCtrl() {
        this.beginDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.endDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        LocalDate now = LocalDate.now();
        LocalDate monthsAgo = now.minusMonths(1L);
        this.beginDate.setValue((Object)monthsAgo);
        this.endDate.setValue((Object)now);
    }

    private void initValue() {
    }

    private void bind() {
    }

    private void listener() {
        this.updateService.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.olist.setAll(this.updateService.getObList());
            this.tableUpdate.sort();
        }));
    }

    private void createTable() {
        this.tableUpdate.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableUpdate);
        this.updateList.setCellValueFactory(data -> this.setDetail((UpdateInfo)data.getValue()));
        this.opera.setCellValueFactory(data -> this.setOperate((UpdateInfo)data.getValue()));
        this.description.setCellFactory(data -> new TooltipTableCell<UpdateInfo, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((UpdateInfo)this.getValue()).getDescription();
                }
                return null;
            }
        });
        this.tableUpdate.setItems(this.olist);
        this.createTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableUpdate.getSortOrder().add(this.createTime);
    }

    @FXML
    private void rightRefresh() {
        try {
            this.check();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return;
        }
        this.query();
    }

    private void check() throws MException {
        if (this.beginDate.getValue() == null) {
            throw new MException(1, "\u8bf7\u9009\u62e9\u8d77\u59cb\u65e5\u671f");
        }
        if (this.endDate.getValue() == null) {
            throw new MException(1, "\u8bf7\u9009\u62e9\u7ed3\u675f\u65e5\u671f");
        }
    }

    @FXML
    private void query() {
        this.updateService.setBeginDate(((LocalDate)this.beginDate.getValue()).toString().replaceAll("-", ""));
        this.updateService.setEndDate(((LocalDate)this.endDate.getValue()).toString().replaceAll("-", ""));
        this.updateService.query();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableUpdate);
    }

    @FXML
    private void export() {
        try {
            ExcelUtils.writeExcel(this.tableUpdate, (String)"\u5347\u7ea7\u7ba1\u7406");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u5bfc\u51faEXCEL\u5f02\u5e38" + e);
        }
    }

    @FXML
    private void add() {
        AddVersionDialog obj = (AddVersionDialog)((Object)this.of.create(AddVersionDialog.class));
        obj.setAdd(true);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7248\u672c");
        dialog.launch();
        this.query();
    }

    @FXML
    private void showRemit() {
        RemittedListDialog obj = (RemittedListDialog)((Object)this.of.create(RemittedListDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u8c41\u514d\u540d\u5355");
        dialog.launch();
    }

    protected ReadOnlyObjectWrapper<Object> setDetail(UpdateInfo versionInfo) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button detail = new Button("\u8be6\u60c5");
        detail.getStyleClass().add((Object)"btnOperation");
        detail.setOnAction(event -> this.showDetail(versionInfo));
        box.getChildren().addAll((Object[])new Node[]{detail});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    protected ReadOnlyObjectWrapper<Object> setOperate(UpdateInfo versionInfo) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button update = new Button("\u4fee\u6539");
        update.getStyleClass().add((Object)"btnOperation");
        update.setOnAction(event -> this.updateVersion(versionInfo));
        box.getChildren().addAll((Object[])new Node[]{update});
        Button delete = new Button("\u5220\u9664");
        delete.getStyleClass().add((Object)"btnOperation");
        delete.setOnAction(event -> this.deleteVersion(versionInfo));
        box.getChildren().addAll((Object[])new Node[]{delete});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void deleteVersion(UpdateInfo versionInfo) {
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u5220\u9664\u7248\u672c" + versionInfo.getCurVersion())) {
            return;
        }
        try {
            this.updateService.delete(versionInfo.getVersionId());
        }
        catch (MException | Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u7248\u672c\u5220\u9664\u5931\u8d25" + e);
            return;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u7248\u672c\u5220\u9664\u6210\u529f");
        this.query();
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.createTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableUpdate.getSortOrder().add(this.createTime);
        this.tableUpdate.sort();
    }

    private void updateVersion(UpdateInfo versionInfo) {
        AddVersionDialog obj = (AddVersionDialog)((Object)this.of.create(AddVersionDialog.class));
        obj.setAdd(false);
        obj.setVersion(versionInfo);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u7248\u672c");
        dialog.launch();
        this.query();
    }

    private void showDetail(UpdateInfo versionInfo) {
        AddVersionDialog obj = (AddVersionDialog)((Object)this.of.create(AddVersionDialog.class));
        obj.setAdd(false);
        obj.setView(true);
        obj.setVersion(versionInfo);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u67e5\u770b\u8be6\u60c5");
        dialog.launch();
    }
}

