/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.Search;
import cms.tmx.core.MException;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.Party;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.FuncMngServiceImpl;
import cms.tmx.manage.parts.MxConverter;
import cms.tmx.manage.parts.MxNodeSuggest;
import java.util.Collection;
import java.util.HashMap;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateFuncDialog
extends DialogObj {
    @FXML
    private TextField txtParent;
    @FXML
    private TextField txtName;
    @FXML
    private TextField txtSort;
    @FXML
    private TextField txtId;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbSortErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label lbTypeErr;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private Label labSuccess;
    @FXML
    private Button btnSaveBasic;
    @FXML
    private Label lbIdErr;
    @Inject
    private FuncMngServiceImpl funcMng;
    @Inject
    private FuncModule func;
    private Party party;
    private String newFuncId = "";
    private static final Logger logger = LogManager.getLogger(UpdateFuncDialog.class);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        MxNode node = MxNodeFactory.create((String)"module_type", (String)"1");
        this.cmbType.setItems(node.getNodes());
        this.newFuncId = this.func.getId();
        HashMap<String, MxNode> map = new HashMap<String, MxNode>();
        for (MxNode n : node.getNodes()) {
            map.put(n.getValue(), n);
        }
        MxConverter conver = new MxConverter(map);
        this.cmbType.setConverter(conver);
        MxNodeSuggest suggest = MxNodeSuggest.getMxNodeSuggest();
        suggest.addPossibleSuggestions((Collection)node.getNodes());
        Search.bindAutoCompletion((TextField)this.cmbType.getEditor(), (Callback)suggest, conver);
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.func.nameProperty());
        MxBindings.bindSI((Property)this.txtSort.textProperty(), (Property)this.func.sortProperty());
        this.txtId.textProperty().bindBidirectional((Property)this.func.idProperty());
        this.txtParent.textProperty().bindBidirectional((Property)this.func.parentNameProperty());
        this.cmbType.valueProperty().bindBidirectional((Property)this.func.moduleTypeProperty());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    private void addCheck() {
        this.txtId.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 6));
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtSort.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 3));
        this.registerCheck((Node)this.lbIdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtId.getText().length() == 6) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtId.textProperty()}));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbSortErr, (ObservableBooleanValue)this.txtSort.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.getSelectionModel().selectedItemProperty().isNotNull());
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            if (!this.newFuncId.isEmpty()) {
                if (this.newFuncId.equals(this.func.getId())) {
                    this.funcMng.updateFunc(this.func);
                } else {
                    this.funcMng.addFunc(this.func);
                    this.funcMng.delFuc(this.newFuncId);
                    this.newFuncId = this.func.getId();
                }
            }
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.CANCEL};
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextField getTxtSort() {
        return this.txtSort;
    }

    public void setTxtSort(TextField txtSort) {
        this.txtSort = txtSort;
    }

    public FuncModule getfunc() {
        return this.func;
    }

    public void setfunc(FuncModule func) {
        this.func = func;
    }

    public static void main(String[] args) {
    }
}

