/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.entity.Blacklist;
import cms.tmx.manage.IBlacklistService;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateBlacklistDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(UpdateBlacklistDialog.class);
    @FXML
    private TextField txtIP;
    @FXML
    private TextField txtSource;
    @FXML
    private TextField txtDesc;
    @FXML
    private Label lbAlert;
    private Blacklist blacklist;
    @Inject
    private IBlacklistService iBlacklist;
    private int type;
    private static final int UPDATE_IP_BLACKLIST = 2;

    @Inject
    public UpdateBlacklistDialog() {
        super("AddBlacklistDialog.fxml");
    }

    @FXML
    public void initialize() {
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.txtIP.textProperty().bindBidirectional((Property)this.blacklist.ipProperty());
        this.txtSource.textProperty().bindBidirectional((Property)this.blacklist.sourceProperty());
        this.txtDesc.textProperty().bindBidirectional((Property)this.blacklist.descProperty());
    }

    private void addCheck() {
        this.txtIP.setEditable(false);
        this.txtSource.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 50));
        this.txtDesc.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 50));
    }

    public boolean isOK(ButtonType bt) {
        try {
            this.type = 2;
            this.iBlacklist.updateBlacklist(this.blacklist, this.type);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        return true;
    }

    public Blacklist getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(Blacklist blacklist) {
        this.blacklist = blacklist;
    }
}

