/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.javafx.MxNode;
import cms.tmx.manage.models.AssetGrpMngModel;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.parts.AddPortfolioBasic;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateAssetGrpBasic
extends MxTabContent {
    @FXML
    private ComboBox<String> cmbParty;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private TextField txtName;
    @FXML
    private TextArea txtDesc;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbPartyErr;
    @FXML
    private Label lbTypeErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private AssetGrpMngModel assetGrpMngModel;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private MObjFactory of;
    private Party party;
    private AssetGrp assetGrpUpdate;
    private static final Logger logger = LogManager.getLogger(AddPortfolioBasic.class);
    private static final int ERROR_ASSETGRP_UNRIGISTERED = 3053;
    private static final int ERROR_ASSETGRP_NOT_EXIST = 3054;
    private static final int ERROR_ASSETGRP_NAME_EXIST = 3063;
    BooleanProperty result = new SimpleBooleanProperty(true);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.assetGrpUpdate = (AssetGrp)this.of.create(AssetGrp.class);
        this.assetGrpUpdate.update(this.assetGrpMngModel.getCommonAssetGrp());
        this.bind();
        this.initValues();
        this.addCheck();
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.assetGrpUpdate.nameProperty());
        this.txtDesc.textProperty().bindBidirectional((Property)this.assetGrpUpdate.desProperty());
        this.cmbParty.valueProperty().bindBidirectional((Property)this.assetGrpUpdate.partyNameProperty());
        this.cmbType.valueProperty().bindBidirectional((Property)this.assetGrpUpdate.typeProperty());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtDesc.setTextFormatter((TextFormatter)new MxFormatter(100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.getSelectionModel().selectedItemProperty().isNotNull());
    }

    private void initValues() {
        Platform.runLater(() -> this.txtName.requestFocus());
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            this.assetGrpMng.updateAssetGrp(this.assetGrpUpdate);
            this.assetGrpMngModel.getCommonAssetGrp().update(this.assetGrpUpdate);
        }
        catch (MException e2) {
            if (e2.getCode() == 3063) {
                this.lbAlert.setText("\u8d44\u4ea7\u7ec4\u540d\u79f0\u5df2\u5b58\u5728");
            } else if (e2.getCode() == 3054) {
                this.lbAlert.setText("\u8d44\u4ea7\u7ec4\u4e0d\u5b58\u5728");
            } else if (e2.getCode() == 3053) {
                this.lbAlert.setText("\u8d44\u4ea7\u7ec4\u5df2\u505c\u7528");
            } else {
                this.lbAlert.setText(e2.getMessage());
            }
            logger.error("\u4fee\u6539\u8d44\u4ea7\u7ec4\u5f02\u5e38", (Throwable)e2);
            Platform.runLater(() -> this.lbAlert.requestFocus());
            return false;
        }
        this.result.setValue(Boolean.valueOf(false));
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextArea getTxtDesc() {
        return this.txtDesc;
    }

    public void setTxtDesc(TextArea txtDesc) {
        this.txtDesc = txtDesc;
    }
}

