/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.control.search.Search;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Account;
import cms.tmx.entity.AccountGroup;
import cms.tmx.entity.SecClassify;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxListUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountGrpMngServiceImpl;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PartyMngServiceImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateAccountGrpDialog
extends DialogObj {
    @FXML
    private TextField txtName;
    @FXML
    private ComboBox<String> cmbParty;
    @FXML
    private ComboBox<Account> cmbAccnt;
    @FXML
    private TableView<Account> tableAccnt;
    @FXML
    private Label lbMessage;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbPartyErr;
    @FXML
    private TableColumn<Account, String> account;
    @FXML
    private TableColumn<Account, HBox> colOperate;
    @FXML
    private AccountGrpMngServiceImpl accntService;
    @FXML
    private Button btnAdd;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private CheckBox cboxClassifyType;
    @FXML
    private TextField txtClassifyId;
    @FXML
    private Label lbClassifyErr;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private AccountGrpMngServiceImpl accountGrpMng;
    @Inject
    private MObjFactory of;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyMngServiceImpl partyMng;
    private AccountGroup accountGroup;
    private Map<String, Account> mapAccnt = new HashMap<String, Account>();
    private MxList<Account> mlist = new MxList();
    private Set<Account> accntSet = new HashSet<Account>();
    private Set<Account> accntOldSet = new HashSet<Account>();
    private ObservableList<Account> accntList = FXCollections.observableList(new LinkedList());
    private static final Logger logger = LogManager.getLogger(UpdateAccountGrpDialog.class);
    private BaseSuggestion<Account> suggestAccnt = new BaseSuggestion<Account>(){
        private Comparator<Account> cp = new Comparator<Account>(){

            @Override
            public int compare(Account o1, Account o2) {
                return o1.getInvestorId().compareTo(o2.getInvestorId());
            }
        };

        protected Comparator<Account> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(Account si, BaseAutoCompletion.ISuggestionRequest req) {
            return si.getInvestorId().indexOf(req.getUserText()) != -1;
        }
    };
    private BaseSuggestion<SecClassify> suggestSecClassify = new BaseSuggestion<SecClassify>(){
        private Comparator<SecClassify> cp = new Comparator<SecClassify>(){

            @Override
            public int compare(SecClassify o1, SecClassify o2) {
                if (o1.getSecClassifyId() < o2.getSecClassifyId()) {
                    return -1;
                }
                if (o1.getSecClassifyId() == o2.getSecClassifyId()) {
                    return 0;
                }
                if (o1.getSecClassifyId() > o2.getSecClassifyId()) {
                    return 1;
                }
                return 0;
            }
        };

        protected Comparator<SecClassify> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(SecClassify si, BaseAutoCompletion.ISuggestionRequest req) {
            return si.getSecClassifyName().indexOf(req.getUserText()) != -1;
        }
    };

    @FXML
    public void initialize() throws MException {
        this.createTableView();
        this.initValues();
        this.bind();
        this.exe.execute(() -> this.initDefaultValues());
    }

    private void initDefaultValues() {
        try {
            List<Account> accounts = this.accountGrpMng.GetAccountGroupDetails(this.accountGroup.getId());
            this.accntOldSet.addAll(accounts);
            this.accntSet.addAll(accounts);
            this.mlist.addAll(accounts);
            String partyId = this.accountGroup.getPartyId();
            ObservableList<Account> listAccount = this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING);
            listAccount.addAll((Collection<Account>)this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            for (Account ext : listAccount) {
                this.accntList.add((Object)ext);
                this.mapAccnt.put(ext.getInvestorId(), ext);
            }
            for (Account a : this.mlist.getList()) {
                if (MxListUtils.has(this.accntList, (Object)a)) continue;
                this.mlist.remove((MxObject)a);
            }
            this.suggestAccnt.addPossibleSuggestions(this.accntList);
            LinkedList<String> partyIds = new LinkedList<String>();
            this.partyMng.getPartyList(partyId, PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING).forEach(item -> partyIds.add(item.getId()));
            partyIds.add(partyId);
            LinkedList<SecClassify> classifyList = new LinkedList<SecClassify>();
            classifyList.addAll(this.accountGrpMng.getSecClassifyList(partyIds));
            if (!this.accountGroup.getClassifyId().isEmpty()) {
                for (SecClassify item2 : classifyList) {
                    if (!this.accountGroup.getClassifyId().equals(String.valueOf(item2.getSecClassifyId()))) continue;
                    Platform.runLater(() -> {
                        this.txtClassifyId.setUserData((Object)item2);
                        this.txtClassifyId.setText(item2.getSecClassifyName());
                    });
                    break;
                }
            }
            this.suggestSecClassify.setAllSuggestions(classifyList);
        }
        catch (MException e) {
            this.lbMessage.setText(e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void bind() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtName.textProperty().bindBidirectional((Property)this.accountGroup.nameProperty());
        this.cboxClassifyType.selectedProperty().bindBidirectional((Property)this.accountGroup.classifyTypeProperty());
        this.cmbParty.valueProperty().bindBidirectional((Property)this.accountGroup.partyNameProperty());
        this.cmbType.valueProperty().bindBidirectional((Property)this.accountGroup.grpTypeProperty());
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbClassifyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cboxClassifyType.selectedProperty().get() && !this.txtClassifyId.focusedProperty().get() && this.txtClassifyId.getUserData() == null) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtClassifyId.focusedProperty(), this.txtClassifyId.textProperty(), this.cboxClassifyType.selectedProperty()}));
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"grp_type", (String)"2");
        this.cmbType.setItems(node.getNodes());
        Search.bindAutoCompletion((TextField)this.cmbAccnt.getEditor(), this.suggestAccnt, (StringConverter)new AccountConverter()).setPrefWidth(this.cmbAccnt.getPrefWidth());
        Search.bindAutoCompletion((TextField)this.txtClassifyId, this.suggestSecClassify).setPrefWidth(this.txtClassifyId.getPrefWidth());
        this.cmbParty.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.cmbAccnt.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAccnt.setConverter((StringConverter)new AccountConverter());
        this.cmbAccnt.setItems(this.accntList);
        this.cboxClassifyType.selectedProperty().addListener((ob, old, now) -> {
            if (now != null && now.booleanValue()) {
                this.txtClassifyId.setDisable(false);
            } else {
                this.txtClassifyId.setDisable(true);
            }
        });
    }

    private void createTableView() {
        this.account.setCellValueFactory(data -> ((Account)data.getValue()).investorIdProperty());
        this.colOperate.setCellValueFactory(data -> this.setOperate((Account)data.getValue()));
        this.tableAccnt.setPlaceholder((Node)new Label());
        this.tableAccnt.setItems(this.mlist.getList());
    }

    public void refreshTable() throws MException {
        Account account = (Account)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (account != null && !MxListUtils.has((List)this.mlist.getList(), (Object)account)) {
            this.mlist.add((MxObject)account);
            this.accntSet.add(account);
            this.lbMessage.setText("");
        } else {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u8be5\u8d26\u6237\u5df2\u5b58\u5728");
        }
    }

    @FXML
    private void add() throws MException {
        if (this.cmbAccnt.getValue() == null) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u8bf7\u6dfb\u52a0\u6b63\u786e\u7684\u8d26\u6237");
            return;
        }
        this.refreshTable();
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(Account ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> {
            this.mlist.remove((MxObject)ap);
            this.accntSet.remove(ap);
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    public boolean isOK(ButtonType bt) {
        try {
            if (this.cboxClassifyType.isSelected() && this.txtClassifyId.getUserData() != null && this.txtClassifyId.getUserData() instanceof SecClassify) {
                SecClassify s = (SecClassify)SecClassify.class.cast(this.txtClassifyId.getUserData());
                this.accountGroup.setClassifyId(String.valueOf(s.getSecClassifyId()));
            }
            this.accountGrpMng.updateAccountGrp(this.accountGroup);
            LinkedList<Account> needAdd = new LinkedList<Account>();
            LinkedList<Account> needDel = new LinkedList<Account>();
            for (Account obj : this.accntSet) {
                if (this.accntOldSet.contains(obj)) continue;
                needAdd.add(obj);
            }
            for (Account old : this.accntOldSet) {
                if (this.accntSet.contains(old)) continue;
                needDel.add(old);
            }
            if (needAdd.size() > 0) {
                this.accountGrpMng.AssignAccountsToGroup(this.accountGroup.getId(), this.accountGroup.getGrpType().getRaw(), needAdd, PCommon.Operation.OP_ADD);
            }
            if (needDel.size() > 0) {
                this.accountGrpMng.AssignAccountsToGroup(this.accountGroup.getId(), this.accountGroup.getGrpType().getRaw(), needDel, PCommon.Operation.OP_DELETE);
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbMessage.setText(e.getMessage());
                this.lbMessage.requestFocus();
            });
            return false;
        }
        return true;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public AccountGroup getAccountGroup() {
        return this.accountGroup;
    }

    public void setAccountGroup(AccountGroup accountGroup) {
        this.accountGroup = accountGroup;
    }

    class AccountConverter
    extends StringConverter<Account> {
        AccountConverter() {
        }

        public String toString(Account info) {
            if (info == null) {
                return "";
            }
            return String.format("%s", info.getInvestorId());
        }

        public Account fromString(String string) {
            Account e = (Account)UpdateAccountGrpDialog.this.mapAccnt.get(string);
            if (e != null) {
                return e;
            }
            return null;
        }
    }
}

