/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.BsDict;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.TradeCounter;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountMngModel;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.ClearingModel;
import cms.tmx.manage.models.CurCmbModel;
import cms.tmx.manage.models.ExcCmbModelSp;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.manage.parts.AddAccountDialog;
import cms.tmx.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateAccountBasic
extends MxTabContent {
    @FXML
    private TextField txtAccount;
    @FXML
    private TextField txtAcctName;
    @FXML
    private TextField txtAcctPwd;
    @FXML
    private TextField txtCfmPwd;
    @FXML
    private TextField txtYears;
    @FXML
    private DatePicker txtCarryDay;
    @FXML
    private Label lbCur;
    @FXML
    private Label lbExc;
    @FXML
    private Label lbEchangeErr;
    @FXML
    private Label lbCurrencyErr;
    @FXML
    private Label lbAccountErr;
    @FXML
    private Label lbAcctNameErr;
    @FXML
    private Label lbCmfPwdErr;
    @FXML
    private Label lbPwd;
    @FXML
    private Label lbCfmPwd;
    @FXML
    private Label lbAlert;
    @FXML
    private Label lbYears;
    @FXML
    private Label lbCarryDay;
    @FXML
    private ComboBox<TradeCounter> cmbBrokerName;
    @FXML
    private ComboBox<TradeCounter> cmbTradeName;
    @FXML
    private ComboBox<MxNodePwf> cmbExchange;
    @FXML
    private ComboBox<Party> cmbPartyName;
    @FXML
    private ComboBox<MxNodePwf> cmbCurrency;
    @FXML
    private ComboBox<MxNodePwf> cmbCarryType;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @FXML
    public CheckBox cbAuthNeeq;
    @FXML
    public CheckBox cbAuthOtc;
    @FXML
    private CheckBox cbAuthFileOrder;
    @FXML
    private CheckBox cbMultiCenter;
    @FXML
    private Label lbNonTradableAsset;
    @FXML
    private ComboBox<MxNode> cmbNonTradableAsset;
    @FXML
    private CheckBox cbExternalAsset;
    @FXML
    private Label lbDataSource;
    @FXML
    private ComboBox<MxNode> cmbDataSource;
    @FXML
    private Label lbAutoSyncConf;
    @FXML
    private ComboBox<String> cmbAutoSyncConf;
    @FXML
    private Label lbExternalAcc;
    @FXML
    private ComboBox<String> cmbExternalAcc;
    @Inject
    private AccountMngModel accntModel;
    @Inject
    private MObjFactory of;
    @Inject
    private AccountMngServiceImpl acctMng;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private TradeCounterServiceImpl counterMng;
    @Inject
    private ClearingModel clearingModel;
    private Account account;
    private CurCmbModel curModel = new CurCmbModel();
    private ExcCmbModelSp excModel = new ExcCmbModelSp();
    private static final Logger logger = LogManager.getLogger(AddAccountDialog.class);
    private String carryDate = "";
    private String lastTradingDay = "";
    public static SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
    private ObservableList<Account> listAcc = FxUtils.newList();
    private static final String FORMAT = "yyyy-MM-dd";
    private LocalDate defultDate;
    private MxNodePwf neeqMarket;
    private MxNodePwf otcMarket;
    BooleanProperty result = new SimpleBooleanProperty(false);

    @Inject
    public UpdateAccountBasic() {
        super("AddAccountBasic.fxml");
    }

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.cbMultiCenter.setVisible(false);
        this.cbMultiCenter.setDisable(true);
        this.account = this.accntModel.getCommonAccount();
        this.account.setPwd("");
        this.cmbBrokerName.setDisable(true);
        this.cmbTradeName.setDisable(true);
        this.cmbPartyName.setDisable(true);
        this.txtAccount.setDisable(true);
        this.cmbCurrency.setDisable(true);
        this.lbPwd.setVisible(false);
        this.lbCfmPwd.setVisible(false);
        this.txtAcctPwd.setVisible(false);
        this.txtCfmPwd.setVisible(false);
        if (this.account.getCarryCode() != 3) {
            this.txtYears.setEditable(false);
            this.lbYears.setOpacity(0.0);
            this.txtYears.setOpacity(0.0);
        }
        if (this.account.getCarryCode() == 1) {
            this.txtCarryDay.setEditable(false);
            this.lbCarryDay.setOpacity(0.0);
            this.txtCarryDay.setOpacity(0.0);
        }
        this.intiValues();
        this.bindUIs();
        this.addCheck();
    }

    private void intiValues() {
        try {
            this.counterMng.getTradeCounterList();
            this.cmbBrokerName.setItems(this.counterMng.getBroker());
            this.cmbBrokerName.setConverter((StringConverter)new StringConverter<TradeCounter>(){

                public String toString(TradeCounter object) {
                    return object.getBrokerName();
                }

                public TradeCounter fromString(String string) {
                    return null;
                }
            });
            ObservableList listParty = FxUtils.newList();
            Party party = this.partyMng.getParty(this.account.getPartyId());
            listParty.add((Object)party);
            this.cmbPartyName.setItems(listParty);
            this.cmbPartyName.setValue((Object)party);
            this.cmbPartyName.setDisable(true);
            this.curModel.initCellFactory(this.cmbCurrency, this.lbCur);
            MxNodePwf nodePwf = MxNodeFactory.createPwf((String)"currency_type", (String)"CNY");
            ObservableList listCur = nodePwf.getPwfNodes();
            this.cmbCurrency.setItems(listCur);
            for (MxNodePwf item : listCur) {
                if (!this.account.getCurStr().contains(item.getValue())) continue;
                this.curModel.check(item, false);
            }
            this.excModel.initCellFactory(this.cmbExchange, this.lbExc, null);
            nodePwf = MxNodeFactory.createPwf((String)"market_code", (String)"XSHG");
            ObservableList listExc = nodePwf.getPwfNodes();
            this.cmbExchange.setItems(listExc);
            for (MxNodePwf item : listExc) {
                if ("NEEQ".equals(item.getRaw())) {
                    this.neeqMarket = item;
                } else if ("XOTC".equals(item.getRaw())) {
                    this.otcMarket = item;
                }
                if (!this.account.getSecExchange().contains(item.getValue())) continue;
                this.excModel.check(item, true);
            }
            ObservableList<MxNodePwf> list = this.excModel.getCheckItems();
            if (list.size() == 1 && ((MxNodePwf)list.get(0)).getRaw().equals("XCFE")) {
                this.cmbCurrency.setDisable(true);
            }
            nodePwf = MxNodeFactory.createPwf((String)"carry_type", (String)"1");
            ObservableList listCarry = nodePwf.getPwfNodes();
            this.cmbCarryType.setItems(listCarry);
            this.cmbCarryType.getSelectionModel().select(this.account.getCarryCode() - 1);
            this.carryDate = UpdateAccountBasic.getCurrYearLast();
            this.lastTradingDay = this.clearingModel.getLastTradingDay();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            this.defultDate = LocalDate.parse(this.carryDate, DateTimeFormatter.ofPattern(FORMAT));
            if (!this.account.getCarryDay().isEmpty()) {
                try {
                    Date carryDay = formatter.parse(this.account.getCarryDay());
                    LocalDate oldDate = carryDay.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    this.txtCarryDay.setValue((Object)oldDate);
                }
                catch (Exception e) {
                    logger.error("\u8f6c\u5316\u6e05\u7b97\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff1a " + this.lastTradingDay, (Throwable)e);
                }
            }
            try {
                Date newDate = formatter.parse(this.lastTradingDay);
                DatePickerUtils.setDaysLaterTrading((DatePicker)this.txtCarryDay, (String)f.format(newDate));
            }
            catch (Exception e) {
                logger.error("\u8f6c\u5316\u6e05\u7b97\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff1a " + this.lastTradingDay, (Throwable)e);
            }
            DatePickerUtils.setFormat((DatePicker)this.txtCarryDay, (String)FORMAT);
            this.cmbCarryType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
                if (now != null) {
                    this.account.setCarryCode(Integer.parseInt(now.getRaw()));
                    if (!"3".equals(now.getRaw())) {
                        this.txtYears.clear();
                        this.txtYears.setEditable(false);
                        this.lbYears.setOpacity(0.0);
                        this.txtYears.setOpacity(0.0);
                    } else {
                        this.txtYears.setEditable(true);
                        this.lbYears.setOpacity(1.0);
                        this.txtYears.setOpacity(1.0);
                        this.txtYears.textProperty().setValue("1");
                    }
                    if (!"1".equals(now.getRaw())) {
                        this.txtCarryDay.setValue((Object)this.defultDate);
                        this.lbCarryDay.setOpacity(1.0);
                        this.txtCarryDay.setOpacity(1.0);
                    } else {
                        this.txtCarryDay.setValue(null);
                        this.lbCarryDay.setOpacity(0.0);
                        this.txtCarryDay.setOpacity(0.0);
                    }
                }
            });
            this.txtAcctPwd.setDisable(true);
            this.txtCfmPwd.setDisable(true);
            this.lbPwd.setDisable(true);
            this.lbCfmPwd.setDisable(true);
            this.txtAccount.setDisable(true);
            this.cbAuthNeeq.setSelected(this.account.isNeeqEnable());
            this.cbAuthOtc.setSelected(this.account.isOtcEnable());
            this.cbMultiCenter.setSelected(this.account.isMultiCenter());
            this.cbAuthFileOrder.setSelected(this.account.isFileOrderManualConfirmation());
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            logger.error((Object)e, (Throwable)e);
        }
        MxNode node = MxNodeFactory.create((String)"non_tradable_assets", (String)"0");
        this.cmbNonTradableAsset.setItems(node.getNodes());
        this.cmbNonTradableAsset.setValue((Object)node);
        node = MxNodeFactory.create((String)"accnt_data_source", (String)"1");
        this.cmbDataSource.setItems(node.getNodes());
        this.cmbDataSource.setValue((Object)node);
        this.cmbAutoSyncConf.setValue((Object)"\u6570\u636e\u4e2d\u53f0");
        this.cmbAutoSyncConf.setDisable(true);
    }

    public static String getCurrYearLast() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return UpdateAccountBasic.getYearLast(currentYear);
    }

    public static String getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        String sDate = f.format(currYearLast);
        return sDate;
    }

    private void bindUIs() {
        this.txtAccount.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9@]*", 32));
        this.txtAcctName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 32));
        this.txtCfmPwd.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.txtAcctPwd.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.txtAccount.textProperty().bindBidirectional((Property)this.account.investorIdProperty());
        this.txtAcctName.textProperty().bindBidirectional((Property)this.account.nameProperty());
        this.txtYears.textProperty().bindBidirectional((Property)this.account.carryYearsProperty());
        this.txtYears.setTextFormatter((TextFormatter)new MxFormatter("[1-9]", 1));
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.cmbBrokerName.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.account.setBrokerId(now.getBrokerId());
                this.cmbTradeName.getSelectionModel().clearSelection();
                this.cmbTradeName.setItems(this.counterMng.getTradeCounterList(now.getBrokerId()));
                if ("99999".equals(now.getBrokerId())) {
                    this.cbMultiCenter.setVisible(true);
                } else {
                    this.cbMultiCenter.setVisible(false);
                    this.cbMultiCenter.setSelected(false);
                }
                for (TradeCounter item : this.counterMng.getTradeCounterList(now.getBrokerId())) {
                    String id = item.getId();
                    if (!this.account.getTradePlatformId().equals(id)) continue;
                    this.cmbTradeName.getSelectionModel().select((Object)item);
                    if ("99999-01-01".equals(this.account.getTradePlatformId())) {
                        this.cbAuthNeeq.setVisible(true);
                        this.cbAuthOtc.setVisible(true);
                    } else {
                        this.cbAuthNeeq.setVisible(false);
                        this.cbAuthOtc.setVisible(false);
                    }
                    if ("99999-01-01".equals(now.getId()) || "77777-01-01".equals(now.getId()) || "77777-01-02".equals(now.getId()) || "99999-02-02".equals(now.getId()) || "88888-01-01".equals(now.getId()) || "88888-01-02".equals(now.getId()) || "99999-02-01".equals(now.getId()) || "99999-02-02".equals(now.getId()) || "99999-02-03".equals(now.getId())) {
                        this.cbAuthFileOrder.setVisible(true);
                        break;
                    }
                    this.cbAuthFileOrder.setVisible(false);
                    break;
                }
            }
        });
        for (TradeCounter item : this.counterMng.getBroker()) {
            String brokerId = item.getBrokerId();
            if (!this.account.getBrokerId().equals(brokerId)) continue;
            this.cmbBrokerName.getSelectionModel().select((Object)item);
            break;
        }
        this.cmbTradeName.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.account.setTradePlatformId(now.getId());
                for (MxNodePwf item : this.cmbExchange.getItems()) {
                    if (this.account.getSecExchange().contains(item.getValue())) {
                        this.excModel.check(item, false);
                        continue;
                    }
                    this.excModel.clearCheck(item, false);
                }
            } else {
                for (MxNodePwf item : this.cmbExchange.getItems()) {
                    this.excModel.clearCheck(item, false);
                }
            }
        });
        this.cbAuthNeeq.selectedProperty().addListener((ob, oldV, newV) -> {
            if ("99999-01-01".equals(((TradeCounter)this.cmbTradeName.getValue()).getCounterId()) && newV.booleanValue()) {
                this.excModel.check(this.neeqMarket, false);
            } else {
                this.excModel.clearCheck(this.neeqMarket, false);
            }
        });
        this.cbAuthOtc.selectedProperty().addListener((ob, oldV, newV) -> {
            if ("99999-01-01".equals(((TradeCounter)this.cmbTradeName.getValue()).getCounterId()) && newV.booleanValue()) {
                this.excModel.check(this.otcMarket, false);
            } else {
                this.excModel.clearCheck(this.otcMarket, false);
            }
        });
        this.cbMultiCenter.selectedProperty().addListener((ob, oldV, newV) -> {
            if (newV.booleanValue()) {
                if (!StringUtils.isEmpty((String)this.txtAccount.getText()) && !this.txtAccount.getText().contains("@")) {
                    String suffix = (String)BsDict.PLATFORM_ID_SUFFIX_MAP.get(((TradeCounter)this.cmbTradeName.getSelectionModel().getSelectedItem()).getCounterId());
                    this.txtAccount.setText(String.valueOf(this.txtAccount.getText()) + suffix);
                }
            } else if (this.txtAccount.getText().contains("@")) {
                this.txtAccount.setText(this.txtAccount.getText().split("@")[0]);
            }
        });
        this.cmbNonTradableAsset.valueProperty().bindBidirectional((Property)this.account.nonTradableAssetProperty());
        this.cmbDataSource.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.dataSourceChanged((MxNode)now));
        this.cmbDataSource.getSelectionModel().select((Object)this.account.getDataSource());
        this.cmbDataSource.setDisable(true);
        this.cbExternalAsset.selectedProperty().addListener((ob, old, now) -> this.externalAccntCheck((Boolean)now));
        this.cbExternalAsset.setSelected(this.account.isExternalAsset());
        this.cbExternalAsset.setDisable(true);
        if (this.account.isExternalAsset() && "1".equals(this.account.getDataSource().getRaw())) {
            this.cmbExternalAcc.setValue((Object)this.account.getExternalAccnt());
            Tooltip tooltip = new Tooltip();
            tooltip.setText(this.account.getExternalAccnt());
            this.cmbExternalAcc.setTooltip(tooltip);
        }
        this.externalAccntCheck(this.cbExternalAsset.isSelected());
    }

    private void externalAccntCheck(Boolean now) {
        this.lbNonTradableAsset.setVisible(false);
        this.cmbNonTradableAsset.setVisible(false);
        this.lbDataSource.setVisible(false);
        this.cmbDataSource.setVisible(false);
        this.lbAutoSyncConf.setVisible(false);
        this.cmbAutoSyncConf.setVisible(false);
        this.lbExternalAcc.setVisible(false);
        this.cmbExternalAcc.setVisible(false);
        if (now.booleanValue()) {
            this.lbDataSource.setVisible(now.booleanValue());
            this.cmbDataSource.setVisible(now.booleanValue());
            this.dataSourceChanged((MxNode)this.cmbDataSource.getSelectionModel().getSelectedItem());
        } else {
            this.lbNonTradableAsset.setVisible(now == false);
            this.cmbNonTradableAsset.setVisible(now == false);
        }
    }

    private void dataSourceChanged(MxNode node) {
        boolean isAuto = "1".equals(node.getRaw());
        this.lbAutoSyncConf.setVisible(isAuto);
        this.cmbAutoSyncConf.setVisible(isAuto);
        this.lbExternalAcc.setVisible(isAuto);
        this.cmbExternalAcc.setVisible(isAuto);
    }

    private void addCheck() {
        this.registerCheck((Node)this.lbAccountErr, (ObservableBooleanValue)this.txtAccount.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbAcctNameErr, (ObservableBooleanValue)this.txtAcctName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbEchangeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.excModel.getCheckItems().isEmpty(), (Observable[])new Observable[]{this.excModel.getCheckItems()}));
        this.registerCheck((Node)this.lbCurrencyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.curModel.getCheckItems().isEmpty(), (Observable[])new Observable[]{this.curModel.getCheckItems()}));
    }

    @FXML
    public boolean saveBasic() {
        block16: {
            if (!this.valid()) {
                return false;
            }
            LinkedList listExc = new LinkedList();
            this.excModel.getCheckItems().forEach(node -> {
                boolean bl = listExc.add(node.getRaw());
            });
            this.account.setSecExc(listExc);
            String excStr = ((Object)listExc).toString();
            excStr = excStr.substring(1, excStr.length() - 1);
            this.account.setSecExchange(excStr);
            LinkedList listCur = new LinkedList();
            this.curModel.getCheckItems().forEach(node -> {
                boolean bl = listCur.add(node.getRaw());
            });
            this.account.setCurrency(listCur);
            if (this.txtCarryDay.getValue() != null) {
                this.account.setCarryDay(((LocalDate)this.txtCarryDay.getValue()).toString().replaceAll("-", ""));
            }
            if (!this.txtYears.isEditable() || !this.txtYears.getText().isEmpty()) break block16;
            Platform.runLater(() -> {
                this.lbAlert.setText("\u5e74\u8f93\u5165\u6846\u4e0d\u80fd\u4e3a\u7a7a");
                this.lbAlert.requestFocus();
            });
            return false;
        }
        try {
            if ("99999-01-01".equals(this.account.getTradePlatformId()) && this.cbAuthNeeq.isVisible() && this.cbAuthNeeq.isSelected()) {
                this.account.setNeeqEnable(true);
            } else {
                this.account.setNeeqEnable(false);
            }
            if ("99999-01-01".equals(this.account.getTradePlatformId()) && this.cbAuthOtc.isVisible() && this.cbAuthOtc.isSelected()) {
                this.account.setOtcEnable(true);
            } else {
                this.account.setOtcEnable(false);
            }
            if (this.cbAuthFileOrder.isVisible() && this.cbAuthFileOrder.isSelected()) {
                this.account.setFileOrderManualConfirmation(true);
            } else {
                this.account.setFileOrderManualConfirmation(false);
            }
            if (this.cbMultiCenter.isVisible() && this.cbMultiCenter.isSelected()) {
                this.account.setMultiCenter(true);
            } else {
                this.account.setMultiCenter(false);
            }
            this.acctMng.updateAccount(this.account);
            ObservableList<MxNodePwf> listNewCur = this.curModel.getNewItems();
            if (listNewCur.size() > 0) {
                for (MxNodePwf node2 : listNewCur) {
                    this.account.setCurCode(node2.getRaw());
                    this.fundMng.addFundAccount(this.account);
                }
            }
            for (String curCode : this.account.getCurrency()) {
                if (listNewCur.contains((Object)curCode)) continue;
                this.account.setCurCode(curCode);
                this.fundMng.updateFundAccount(this.account);
            }
            this.labSuccess.setVisible(true);
            Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> {
                this.labSuccess.setVisible(false);
                this.result.setValue(Boolean.valueOf(!this.result.get()));
            }, new KeyValue[0])});
            animation.setCycleCount(1);
            animation.setAutoReverse(false);
            animation.play();
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        return true;
    }

    public void setAccount(Account account) {
        this.account = account;
    }
}

