/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.TradeCounter;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TradeCounterMngPart
extends MxPart {
    @FXML
    private TableView<TradeCounter> tableCounter;
    @FXML
    private TableColumn<TradeCounter, String> secExchange;
    @FXML
    private TextField txtSearch;
    @FXML
    private Label totalCount;
    @FXML
    private Button btnQuery;
    @Inject
    private ExecutorService exe;
    @Inject
    private TradeCounterServiceImpl counterMng;
    @Inject
    private MxAlert mAlert;
    private List<TradeCounter> filterList = new LinkedList<TradeCounter>();
    private static final Logger logger = LogManager.getLogger(TradeCounterMngPart.class);
    private MxList<TradeCounter> mlist = new MxList();
    private Predicate<TradeCounter> pd = pf -> {
        String param = this.txtSearch.getText().trim();
        return pf.getName().contains(param);
    };
    private InvalidationListener accModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableCounter.sort();
    };

    @FXML
    public void initialize() {
        this.bingUI();
        this.exe.execute(() -> this.query());
        this.createTableView();
    }

    private void bingUI() {
        this.txtSearch.textProperty().addListener(this.accModel);
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter(32));
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableCounter);
    }

    @FXML
    private void rightRefresh() {
        this.query();
    }

    @FXML
    private void refresh() {
        this.rightRefresh();
    }

    private void query() {
        try {
            this.mlist.clear();
            this.filterList.clear();
            this.filterList.addAll((Collection<TradeCounter>)this.counterMng.getTradeCounterList());
            this.mlist.addAll(this.filterList);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
            Collections.sort(this.mlist.getList(), (o1, o2) -> {
                if (Integer.parseInt(o1.getBrokerId()) > Integer.parseInt(o2.getBrokerId())) {
                    return 1;
                }
                return -1;
            });
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTableView() {
        this.addViwer(this.tableCounter);
        this.tableCounter.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableCounter);
        this.tableCounter.setItems(this.mlist.getList());
    }
}

