/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.entity.PwdExpiredCtrl;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.IUserService;
import java.util.concurrent.ExecutorService;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemSettingsDialog
extends DialogObj {
    @FXML
    private TextField txtDays;
    @FXML
    private Label lbDaysErr;
    @FXML
    private Label labSuccess;
    @FXML
    private Button btnSaveBasic;
    @Inject
    private IUserService service;
    private PwdExpiredCtrl pwd;
    @Inject
    private ExecutorService es;
    private static final Logger logger = LogManager.getLogger(SystemSettingsDialog.class);

    @FXML
    public void initialize() {
        this.addCheck();
        this.initValue();
        this.bind();
    }

    private void bind() {
        this.labSuccess.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.labSuccess.setVisible(false);
            }
        });
    }

    private void initValue() {
        this.es.execute(() -> {
            try {
                this.pwd = this.service.getPwdCtrl();
                MxBindings.bindSI((Property)this.txtDays.textProperty(), (Property)this.pwd.pwd_expired_durationProperty());
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    this.labSuccess.setText(e.getMessage());
                    this.labSuccess.requestFocus();
                });
                logger.error("get pwdCtrl error", (Throwable)e);
            }
        });
    }

    private void addCheck() {
        this.txtDays.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 3));
        this.registerCheck((Node)this.lbDaysErr, (ObservableBooleanValue)this.txtDays.textProperty().isNotEmpty());
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            this.service.updatePwdCtrl(this.pwd);
            this.labSuccess.setText("\u4fdd\u5b58\u6210\u529f");
            this.labSuccess.setTextFill((Paint)Color.WHITE);
        }
        catch (MException ex) {
            Platform.runLater(() -> {
                this.labSuccess.setText(String.valueOf(ex.getMessage()) + "\uff0c\u4fdd\u5b58\u5931\u8d25");
                this.labSuccess.setTextFill((Paint)Color.RED);
                this.labSuccess.requestFocus();
            });
            logger.error("update pwdCtrl error", (Throwable)ex);
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public TextField getTxtDays() {
        return this.txtDays;
    }

    public void setTxtDays(TextField txtDays) {
        this.txtDays = txtDays;
    }

    public Label getLbDaysErr() {
        return this.lbDaysErr;
    }

    public void setLbDaysErr(Label lbDaysErr) {
        this.lbDaysErr = lbDaysErr;
    }

    public Label getLabSuccess() {
        return this.labSuccess;
    }

    public void setLabSuccess(Label labSuccess) {
        this.labSuccess = labSuccess;
    }

    public Button getBtnSaveBasic() {
        return this.btnSaveBasic;
    }

    public void setBtnSaveBasic(Button btnSaveBasic) {
        this.btnSaveBasic = btnSaveBasic;
    }
}

