/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.BatchJob;
import cms.tmx.manage.models.BatchjobServiceImpl;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.time.LocalDate;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;

public class SynHisDialog
extends DialogObj {
    protected static final String FORMAT = "yyyy-MM-dd";
    Account account = new Account();
    @FXML
    private TextField txtStartHour;
    @FXML
    private TextField txtStartMinute;
    @FXML
    protected DatePicker beginDateText;
    @FXML
    protected DatePicker endDateText;
    @Inject
    protected MxAlert alert;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.BatchJobService batchJobApi;
    @Inject
    private BatchjobServiceImpl batchjobServiceImpl;
    BatchJob batchJob = new BatchJob();
    String beginDate = "";
    String endDate = "";
    String startTime = "";
    public String start = "";
    public String end = "";

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.CLOSE, ButtonType.OK};
    }

    @FXML
    public void initialize() {
        this.txtStartHour.setText("16");
        this.txtStartMinute.setText("30");
        this.initControls();
        this.initParam();
        this.checks();
    }

    protected boolean isOK(ButtonType bt) {
        if ("".equals(this.beginDateText.getValue()) || "".equals(this.beginDateText.getValue())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u5f00\u59cb\u6216\u8005\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String info = "\u662f\u5426\u786e\u5b9a\u540c\u6b65" + this.account.getId() + "\u8d26\u53f7" + ((LocalDate)this.beginDateText.getValue()).toString() + "-" + ((LocalDate)this.endDateText.getValue()).toString() + "\u65e5\u671f\u4e4b\u95f4\u7684\u5386\u53f2\u6570\u636e";
        this.beginDate = ((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", "");
        this.endDate = ((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", "");
        this.startTime = String.valueOf(this.txtStartHour.getText()) + ":" + this.txtStartMinute.getText();
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, info)) {
            this.updateBatchJob();
        }
        return true;
    }

    private void updateBatchJob() {
        try {
            this.batchjobServiceImpl.addBatchjob(this.batchJob, this.beginDate, this.endDate, this.startTime);
            this.batchJob.setBatchStatus(1);
            this.batchjobServiceImpl.addBatchjob(this.batchJob, this.beginDate, this.endDate, this.startTime);
        }
        catch (MException e) {
            e.printStackTrace();
        }
    }

    private void initControls() {
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.txtStartHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartHour));
        this.txtStartMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartMinute));
    }

    public void setDefTime() {
        if (this.start.isEmpty() || this.end.isEmpty()) {
            return;
        }
        int first = this.start.indexOf(":");
        int second = this.start.indexOf(":", first + 1);
        this.txtStartHour.setText(this.start.substring(0, first));
        this.txtStartMinute.setText(this.start.substring(first + 1, second));
        first = this.end.indexOf(":");
        second = this.end.indexOf(":", first + 1);
    }

    private void checks() {
    }

    private void initParam() {
        this.batchJob.setOpUser(this.baseApi.getOpUser());
        this.batchJob.setMarket(this.getAccount().getSecExc().toString());
        this.batchJob.setMarketGrp(MarketUtils.findMarketGrp((List)this.getAccount().getSecExc()));
        this.batchJob.setBatchStatus(1);
    }

    protected void setDate() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : Integer.parseInt(txt.getText());
    }
}

