/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Interface;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.InterfaceMngModel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SetInterfaceDialog
extends DialogObj {
    @FXML
    private TextField txtSearch;
    @FXML
    private TableView<Interface> tableInterface;
    @FXML
    private TableColumn<Interface, Boolean> selected;
    @Inject
    private InterfaceMngModel interfaceMng;
    @Inject
    private ExecutorService exe;
    private List<String> interfaceNumberList = new LinkedList<String>();
    private List<String> initList = new LinkedList<String>();
    private MxList<Interface> mList = new MxList();
    private List<Interface> filterList = new LinkedList<Interface>();
    private static final Logger logger = LogManager.getLogger(SetInterfaceDialog.class);
    private Predicate<Interface> pd = inerface -> {
        String idName = this.txtSearch.getText().trim();
        return inerface.getId().toLowerCase().contains(idName.toLowerCase()) || inerface.getName().toLowerCase().contains(idName.toLowerCase()) || inerface.getDes().toLowerCase().contains(idName.toLowerCase());
    };
    private InvalidationListener interfaceModel = ob -> {
        this.mList.update(this.filterList, this.pd);
        this.tableInterface.sort();
    };

    @FXML
    public void initialize() {
        Platform.runLater(() -> this.txtSearch.requestFocus());
        this.createTableView();
        this.initValue();
        this.addListener();
    }

    private void addListener() {
        this.txtSearch.textProperty().addListener(this.interfaceModel);
        this.tableInterface.setOnMouseClicked(e -> {
            if (this.tableInterface.getSelectionModel().getSelectedItem() == null) {
                return;
            }
            if (((Interface)this.tableInterface.getSelectionModel().getSelectedItem()).isSelected()) {
                ((Interface)this.tableInterface.getSelectionModel().getSelectedItem()).setSelected(false);
            } else {
                ((Interface)this.tableInterface.getSelectionModel().getSelectedItem()).setSelected(true);
            }
        });
    }

    private void initValue() {
        this.exe.execute(() -> {
            try {
                this.filterList = this.interfaceMng.getAllInterface();
                this.mList.addAll(this.filterList);
                this.mList.getList().stream().filter(item -> this.initList.contains(item.getId())).forEach(item -> item.setSelected(true));
                this.initList.forEach(item -> this.interfaceNumberList.add((String)item));
            }
            catch (MException e) {
                this.tableInterface.setPlaceholder((Node)new Label(e.getMessage()));
                logger.error((Object)e, (Throwable)e);
            }
        });
    }

    private void createTableView() {
        this.tableInterface.setPlaceholder((Node)new Label());
        this.selected.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        TableUtils.initValueFactory(this.tableInterface);
        this.tableInterface.setItems(this.mList.getList());
    }

    protected boolean isOK(ButtonType bt) {
        if (bt == ButtonType.OK) {
            this.interfaceNumberList.clear();
            this.filterList.forEach(item -> {
                if (item.isSelected()) {
                    this.interfaceNumberList.add(item.getId());
                }
            });
            this.interfaceNumberList = this.interfaceNumberList.stream().distinct().collect(Collectors.toList());
        }
        return true;
    }

    public List<String> getInterfaceNumberList() {
        return this.interfaceNumberList;
    }

    public void setInterfaceNumberList(List<String> interfaceNumberList) {
        this.interfaceNumberList = interfaceNumberList;
    }

    public List<String> getInitList() {
        return this.initList;
    }

    public void setInitList(List<String> initList) {
        this.initList = initList;
    }
}

