/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.Role;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.FuncMngServiceImpl;
import cms.tmx.manage.models.RoleMngModel;
import cms.tmx.manage.models.RoleMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoleRelateFuncSuperTabContent
extends MxTabContent {
    @FXML
    private TreeTableColumn<FuncModule, Boolean> colFunction;
    @FXML
    private TreeTableColumn<FuncModule, Boolean> isSelected;
    @FXML
    private TreeTableView<FuncModule> treeTableFunc;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveRights;
    @Inject
    private RoleMngServiceImpl roleMng;
    @Inject
    private FuncMngServiceImpl funcMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private RoleMngModel roleModel;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    private static final Logger logger = LogManager.getLogger(RoleRelateFuncSuperTabContent.class);
    private Map<String, TreeItem<FuncModule>> map = new HashMap<String, TreeItem<FuncModule>>();
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private ObservableList<TreeItem<FuncModule>> allFunc = FxUtils.newList();
    private List<String> allFuncIds = new LinkedList<String>();
    private List<String> oldChoiceList = new LinkedList<String>();
    private List<String> newChoiceList = new LinkedList<String>();
    private FuncModule funcModule;
    private TreeItem<FuncModule> root;
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private Role role;

    @FXML
    public void initialize() {
        this.role = this.roleModel.getCommonRole();
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updateAssignRoleSuperControl"})));
        this.createTableView();
        this.initRoot();
        this.exe.execute(() -> this.initValue());
    }

    public synchronized void initValue() {
        List<FuncModule> funcModules;
        block5: {
            this.allFunc.clear();
            this.root.setExpanded(false);
            this.root.getChildren().clear();
            this.allFuncIds.clear();
            funcModules = this.funcMng.getAllFunc();
            this.oldChoiceList = this.funcMng.getFuncByRole(this.role.getId());
            if (!funcModules.isEmpty()) break block5;
            Platform.runLater(() -> this.treeTableFunc.refresh());
            return;
        }
        try {
            try {
                funcModules.forEach(item -> {
                    if (!"F00000".equals(item.getId())) {
                        this.allFunc.add((Object)new TreeItem(item));
                    }
                });
                this.allFunc.add(this.root);
                this.allFunc.forEach(item -> {
                    String id = ((FuncModule)item.getValue()).getId();
                    this.allFuncIds.add(id);
                    if (this.oldChoiceList.contains(id)) {
                        ((FuncModule)item.getValue()).setSelected(true);
                    }
                });
                this.buildTree(this.root, ((FuncModule)this.root.getValue()).getId());
            }
            catch (MException e) {
                Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> this.treeTableFunc.refresh());
            }
        }
        catch (Throwable throwable) {
            Platform.runLater(() -> this.treeTableFunc.refresh());
            throw throwable;
        }
        Platform.runLater(() -> this.treeTableFunc.refresh());
    }

    private void initRoot() {
        FuncModule fModule = new FuncModule();
        fModule.setId("F00000");
        fModule.setName("\u529f\u80fd\u6811");
        this.root = new TreeItem((Object)fModule);
        this.treeTableFunc.setRoot(this.root);
    }

    private void createTableView() {
        this.isSelected.setCellValueFactory(cellDate -> ((FuncModule)cellDate.getValue().getValue()).selectedProperty());
        this.isSelected.setCellFactory(cellDate -> new MxCheckBoxTreeTableCell());
        this.colFunction.setCellFactory(cellDate -> new MxFuncCheckBoxTreeTableCell());
    }

    @FXML
    public boolean saveRights() {
        boolean flag = false;
        try {
            this.newChoiceList.clear();
            for (Map.Entry<String, TreeItem<FuncModule>> entry : this.map.entrySet()) {
                if (!((FuncModule)entry.getValue().getValue()).isSelected()) continue;
                this.newChoiceList.add(entry.getKey());
                if (this.oldChoiceList.contains(entry.getKey())) continue;
                flag = true;
            }
            for (String id : this.oldChoiceList) {
                if (this.newChoiceList.contains(id) || !this.allFuncIds.contains(id)) continue;
                flag = true;
                break;
            }
            this.roleMng.assignFuncToRole(this.role.getId(), this.newChoiceList);
        }
        catch (MException e2) {
            this.mAlert.alert(Alert.AlertType.ERROR, String.valueOf(e2.getMessage()) + "!\u90e8\u5206\u529f\u80fd\u5173\u8054\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5173\u8054!");
            logger.error((Object)e2, (Throwable)e2);
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        if (flag) {
            this.exe.execute(() -> {
                this.initValue();
                this.sendMsgToWeb(this.role.getId());
            });
        }
        return true;
    }

    public FuncModule getFuncModule() {
        return this.funcModule;
    }

    public void setFuncModule(FuncModule funcModule) {
        this.funcModule = funcModule;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    private void buildTree(TreeItem<FuncModule> root, String rootId) {
        block0: for (TreeItem itemI : this.allFunc) {
            this.map.put(((FuncModule)itemI.getValue()).getId(), (TreeItem<FuncModule>)itemI);
            String idI = ((FuncModule)itemI.getValue()).getId();
            String parentIdI = ((FuncModule)itemI.getValue()).getParentId();
            if (idI.isEmpty()) continue;
            if (parentIdI.equals(rootId)) {
                root.getChildren().add((Object)itemI);
                continue;
            }
            for (TreeItem itemJ : this.allFunc) {
                String idJ = ((FuncModule)itemJ.getValue()).getId();
                if (!idJ.equals(parentIdI)) continue;
                itemJ.getChildren().add((Object)itemI);
                continue block0;
            }
        }
        Comparator<TreeItem<FuncModule>> compare = new Comparator<TreeItem<FuncModule>>(){

            @Override
            public int compare(TreeItem<FuncModule> o1, TreeItem<FuncModule> o2) {
                if (((FuncModule)o1.getValue()).isSelected()) {
                    if (((FuncModule)o2.getValue()).isSelected()) {
                        return ((FuncModule)o1.getValue()).getSort() > ((FuncModule)o2.getValue()).getSort() ? 1 : -1;
                    }
                    return -1;
                }
                if (((FuncModule)o2.getValue()).isSelected()) {
                    return 1;
                }
                return ((FuncModule)o1.getValue()).getSort() > ((FuncModule)o2.getValue()).getSort() ? 1 : -1;
            }
        };
        Collections.sort(root.getChildren(), compare);
        for (TreeItem one : root.getChildren()) {
            Collections.sort(one.getChildren(), compare);
            for (TreeItem two : one.getChildren()) {
                Collections.sort(two.getChildren(), compare);
                for (TreeItem three : two.getChildren()) {
                    Collections.sort(three.getChildren(), compare);
                }
            }
        }
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private void sendMsgToWeb(String roleId) {
        if (!StringUtils.isEmpty((String)roleId)) {
            MEvent event = new MEvent();
            event.put((Object)"type", (Object)"role");
            event.put((Object)"id", (Object)roleId);
            this.es.postEvent("refresh_web_cache", event);
        }
    }

    private class MxCheckBoxTreeTableCell<S, T>
    extends TreeTableCell<FuncModule, T> {
        FuncModule funcItem;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.funcItem = (FuncModule)this.getTreeTableRow().getItem();
                if (this.funcItem == null) {
                    return;
                }
                this.checkbox = new CheckBox();
                this.checkbox.selectedProperty().bindBidirectional((Property)this.funcItem.selectedProperty());
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.checkbox.selectedProperty().get()));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!RoleRelateFuncSuperTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{RoleRelateFuncSuperTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(Boolean selected) {
            RoleRelateFuncSuperTabContent.this.save.set(true);
            if (selected.booleanValue()) {
                this.selectChdItems((TreeItem<FuncModule>)this.getTreeTableRow().getTreeItem(), true);
                this.selectPrtItems((TreeItem<FuncModule>)this.getTreeTableRow().getTreeItem(), true);
            } else {
                this.selectChdItems((TreeItem<FuncModule>)this.getTreeTableView().getTreeItem(this.getIndex()), false);
                this.selectPrtItems((TreeItem<FuncModule>)this.getTreeTableView().getTreeItem(this.getIndex()), false);
            }
        }

        private void selectChdItems(TreeItem<FuncModule> seleItem, Boolean selected) {
            if (seleItem.getChildren() != null) {
                seleItem.getChildren().forEach(item -> {
                    ((FuncModule)item.getValue()).selectedProperty().set(selected.booleanValue());
                    if (!item.getChildren().isEmpty()) {
                        this.selectChdItems((TreeItem<FuncModule>)item, selected);
                    }
                });
            }
        }

        private void selectPrtItems(TreeItem<FuncModule> seleItem, Boolean selected) {
            if (seleItem != null) {
                TreeItem item = seleItem.getParent();
                if (item == null) {
                    return;
                }
                if (selected.booleanValue()) {
                    ((FuncModule)item.getValue()).selectedProperty().set(selected.booleanValue());
                    this.selectPrtItems((TreeItem<FuncModule>)item, true);
                } else {
                    ObservableList brotheres = item.getChildren();
                    boolean flag = false;
                    for (TreeItem brother : brotheres) {
                        if (!((FuncModule)brother.getValue()).isSelected() || seleItem == brother) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        ((FuncModule)item.getValue()).selectedProperty().set(false);
                        this.selectPrtItems((TreeItem<FuncModule>)item, false);
                    }
                }
            }
        }
    }

    private class MxFuncCheckBoxTreeTableCell<S, T>
    extends TreeTableCell<FuncModule, T> {
        private String text = "";
        Label label = null;
        FuncModule funcItem;
        private final PseudoClass leaf = PseudoClass.getPseudoClass((String)"treeLeaf");
        private final PseudoClass notLeaf = PseudoClass.getPseudoClass((String)"treeNotLeaf");

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.funcItem = (FuncModule)this.getTreeTableRow().getItem();
                if (this.funcItem == null) {
                    return;
                }
                this.text = this.funcItem.getName();
                this.label = new Label(this.text);
                this.setGraphic((Node)this.label);
                if (this.getTreeTableRow().getTreeItem().isLeaf()) {
                    this.getTreeTableRow().pseudoClassStateChanged(this.leaf, true);
                    this.getTreeTableRow().pseudoClassStateChanged(this.notLeaf, false);
                } else {
                    this.getTreeTableRow().pseudoClassStateChanged(this.notLeaf, true);
                    this.getTreeTableRow().pseudoClassStateChanged(this.leaf, false);
                }
            }
        }
    }
}

