/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.Party;
import cms.tmx.entity.Role;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.FuncMngServiceImpl;
import cms.tmx.manage.models.FuncTreeModel;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.manage.models.RoleMngServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AddPublicRoleDialog;
import cms.tmx.manage.parts.AddRoleDialog;
import cms.tmx.manage.parts.UpdatePublicRoleDialog;
import cms.tmx.manage.parts.UpdateRoleDialog;
import cms.tmx.rights.IRightService;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;

public class RoleMngPart
extends MxPart {
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Role> tableRole;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<Role, String> partyId;
    @FXML
    private TableColumn<Role, String> postName;
    @FXML
    private TableColumn<Role, String> des;
    @FXML
    private TableColumn<Role, String> colOpera;
    @FXML
    private TableColumn<Role, MxNode> roleType;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @FXML
    private Button btnPublicAdd;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private RoleMngServiceImpl roleMng;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @FXML
    private TableColumn<Role, String> creator;
    @FXML
    private TableColumn<Role, String> updater;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private PartyFactory pFactory;
    private Role selectTableRole;
    private TreeItem<Party> selectTreeParty;
    private MxList<Role> mlist = new MxList();
    private List<Role> filterList = new LinkedList<Role>();
    private static final Logger logger = LogManager.getLogger(RoleMngPart.class);
    private static final String IS_ENABLE_ROLE = "\u662f\u5426\u542f\u7528\u8be5\u89d2\u8272";
    private static final String IS_DISABLE_ROLE = "\u662f\u5426\u505c\u7528\u8be5\u89d2\u8272";
    private static final String ALERT = "\u63d0\u793a";
    private Predicate<Role> pd = role -> {
        String name = this.txtSearch.getText().trim();
        return role.getName().contains(name);
    };
    private InvalidationListener roleModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableRole.sort();
    };
    private boolean settingFlag = false;
    private boolean statusFlag = false;
    private boolean publicSettingFlag = false;
    private boolean publicStatusFlag = false;
    @Inject
    private IRightService irs;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private FuncMngServiceImpl funcMng;
    @Inject
    private FuncTreeModel funcTree;

    @FXML
    public void initialize() {
        TreeItem<Party> root = this.initRoot();
        this.exe.execute(() -> {
            this.initTree(root);
            this.query(((Party)root.getValue()).getId());
        });
        this.bind();
        this.createTableView();
        this.checkRights();
    }

    private void initTree(TreeItem<Party> root) {
        block5: {
            try {
                try {
                    ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryRoleControl"});
        this.model.registerCheckAll((Control)this.btnAdd, new String[]{"addRoleControl", "saveRoleBasic"});
        this.model.registerCheckAll((Control)this.btnPublicAdd, new String[]{"addPublicRoleControl", "savePublicRoleBasic"});
        this.statusFlag = this.model.registerCheck(new String[]{"enableRoleControl"});
        this.settingFlag = this.model.registerCheck(new String[]{"saveRoleBasic", "lookRoleBasic", "updateAssignRoleControl", "queryAssignRoleControl", "updateAssignRoleSuperControl", "queryAssignRoleSuperControl"});
        this.settingFlag = this.settingFlag && this.model.registerCheck(new String[]{"updateRoleControl"});
        this.publicStatusFlag = this.model.registerCheck(new String[]{"enablePublicRoleControl"});
        this.publicSettingFlag = this.model.registerCheck(new String[]{"savePublicRoleBasic", "lookPublicRoleBasic", "updateAssignRoleControl", "queryAssignRoleControl", "updateAssignRoleSuperControl", "queryAssignRoleSuperControl"});
        this.publicSettingFlag = this.publicSettingFlag && this.model.registerCheck(new String[]{"updatePublicRoleControl"});
    }

    protected void afterTableRestore() {
        this.treeParty.getSelectionModel().select(0);
        this.selectTreeParty = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.roleModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.selectTableRole = null;
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()));
        });
        this.tableRole.setOnMouseClicked(event -> {
            if (this.tableRole.getSelectionModel().getSelectedItem() != null) {
                this.selectTableRole = (Role)this.tableRole.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        this.addViwer(this.tableRole);
        this.tableRole.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableRole);
        this.partyId.setCellValueFactory(cellData -> {
            String partyId = ((Role)cellData.getValue()).getPartyId();
            Party party = this.partyTree.getParty(partyId);
            if (party == null) {
                try {
                    this.partyTree.refresh();
                    party = this.partyTree.getParty(partyId);
                }
                catch (MException e) {
                    logger.error("refresh party error", (Throwable)e);
                }
            }
            SimpleStringProperty flage = new SimpleStringProperty("");
            if (party != null && "0".equals(((Role)cellData.getValue()).getRoleType().getRaw())) {
                flage.set(party.getName());
                ((Role)cellData.getValue()).setPartyName(flage.get());
            }
            return flage;
        });
        this.roleType.setCellValueFactory(data -> ((Role)data.getValue()).roleTypeProperty());
        this.des.setCellFactory(data -> new AutoTableCell());
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((Role)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((Role)data.getValue()).getUpdater()));
        this.postName.setCellValueFactory(data -> ((Role)data.getValue()).postNameProperty());
        this.postName.setCellFactory(data -> new TooltipTableCell<Role, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((Role)this.getValue()).getPostName();
            }
        });
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableRole));
        this.tableRole.setItems(this.mlist.getList());
    }

    private void onItemClicked(TreeItem<Party> item) {
        this.selectTreeParty = item;
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void query(String partyId) {
        try {
            List<Role> listPost = this.roleMng.getRoleListByParty(partyId);
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            listPost.forEach(item -> {
                this.filterList.add((Role)item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
            this.tableRole.sort();
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void refresh() {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            this.treeParty.getSelectionModel().select(this.partyMng.getUserParty().getId().equals(((Party)this.selectTreeParty.getValue()).getId()) ? root : this.selectTreeParty);
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            this.tableRole.getSelectionModel().select((Object)this.selectTableRole);
            this.tableRole.scrollTo((Object)this.selectTableRole);
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void refreshTable() {
        if (this.selectTreeParty == null) {
            return;
        }
        this.query(((Party)this.selectTreeParty.getValue()).getId());
        this.tableRole.getSelectionModel().select((Object)this.selectTableRole);
        this.tableRole.scrollTo((Object)this.selectTableRole);
    }

    public void add() {
        AddRoleDialog obj = (AddRoleDialog)((Object)this.of.create(AddRoleDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        obj.setParty(treeItem == null ? (Party)this.treeParty.getRoot().getValue() : (Party)treeItem.getValue());
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u89d2\u8272");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            if (!obj.getNewRoleId().isEmpty()) {
                this.selectTableRole = this.roleMng.getRoleDetail(obj.getNewRoleId());
                this.refreshTable();
            }
        }
        catch (MException | Exception e) {
            logger.error((Object)e, e);
        }
    }

    public void addPublicRole() {
        AddPublicRoleDialog obj = (AddPublicRoleDialog)((Object)this.of.create(AddPublicRoleDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        obj.setParty(treeItem == null ? (Party)this.treeParty.getRoot().getValue() : (Party)treeItem.getValue());
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u516c\u6709\u89d2\u8272");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            if (!obj.getNewRoleId().isEmpty()) {
                this.selectTableRole = this.roleMng.getRoleDetail(obj.getNewRoleId());
                this.refreshTable();
            }
        }
        catch (MException | Exception e) {
            logger.error((Object)e, e);
        }
    }

    public void update() {
        this.selectTableRole = (Role)this.tableRole.getSelectionModel().getSelectedItem();
        if (this.selectTableRole == null) {
            return;
        }
        try {
            if (this.selectTableRole.getRoleType().getRaw().equals("0")) {
                UpdateRoleDialog obj = (UpdateRoleDialog)((Object)this.of.create(UpdateRoleDialog.class));
                Role roleSet = (Role)this.of.create(Role.class);
                roleSet.update((Object)this.selectTableRole);
                obj.setRoleUpdate(roleSet);
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u89d2\u8272");
                dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
                dialog.getButton(ButtonType.CANCEL).setVisible(false);
                dialog.launch();
                this.refreshTable();
            } else if (this.selectTableRole.getRoleType().getRaw().equals("1")) {
                UpdatePublicRoleDialog obj = (UpdatePublicRoleDialog)((Object)this.of.create(UpdatePublicRoleDialog.class));
                Role roleSet = (Role)this.of.create(Role.class);
                roleSet.update((Object)this.selectTableRole);
                obj.setRoleUpdate(roleSet);
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u89d2\u8272");
                dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
                dialog.getButton(ButtonType.CANCEL).setVisible(false);
                dialog.launch();
                this.refreshTable();
            }
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void enable() {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_ENABLE_ROLE, ALERT)) {
            try {
                this.roleMng.enableRole((Role)this.tableRole.getSelectionModel().getSelectedItem(), true);
                this.refreshTable();
                this.sendMsgToWeb((Role)this.tableRole.getSelectionModel().getSelectedItem());
            }
            catch (MException e) {
                this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public void disable() {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_DISABLE_ROLE, ALERT)) {
            try {
                this.roleMng.enableRole((Role)this.tableRole.getSelectionModel().getSelectedItem(), false);
                this.refreshTable();
                this.sendMsgToWeb((Role)this.tableRole.getSelectionModel().getSelectedItem());
            }
            catch (MException e) {
                this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void sendMsgToWeb(Role role) {
        if (!StringUtils.isEmpty((String)role.getId())) {
            MEvent event = new MEvent();
            event.put((Object)"type", (Object)"role");
            event.put((Object)"id", (Object)role.getId());
            this.es.postEvent("refresh_web_cache", event);
        }
    }

    @FXML
    private void rightRefresh() {
        this.refresh();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableRole);
    }

    @FXML
    private void exportExcel() {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet spreadsheet = workbook.createSheet();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleOne = workbook.createCellStyle();
        cellStyleOne.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        cellStyleOne.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleTwo = workbook.createCellStyle();
        cellStyleTwo.setFillForegroundColor(IndexedColors.ROSE.getIndex());
        cellStyleTwo.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleThree = workbook.createCellStyle();
        cellStyleThree.setFillForegroundColor(IndexedColors.TAN.getIndex());
        cellStyleThree.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFRow row = null;
        row = spreadsheet.createRow(0);
        String[] head = new String[]{"\u89d2\u8272\u4ee3\u7801", "\u89d2\u8272\u540d\u79f0", "\u6240\u5c5e\u673a\u6784", "\u89d2\u8272\u72b6\u6001", "\u89d2\u8272\u7c7b\u578b", "\u83dc\u5355ID", "\u83dc\u5355\u540d\u79f0", "\u83dc\u5355\u5c42\u7ea7", "\u7236\u7ea7\u83dc\u5355ID", "\u5206\u7c7b"};
        int j = 0;
        while (j < head.length) {
            HSSFCell cell = row.createCell(j);
            cell.setCellValue(head[j]);
            cell.setCellStyle(cellStyle);
            ++j;
        }
        HashMap<String, LinkedList<FuncModule>> mapFunc = new HashMap<String, LinkedList<FuncModule>>();
        try {
            List funcModules = this.irs.getFuncListByUserPost(this.postMng.getUserPost().getId());
            for (FuncModule func : funcModules) {
                LinkedList<FuncModule> list = (LinkedList<FuncModule>)mapFunc.get(func.getParentId());
                if (list == null) {
                    list = new LinkedList<FuncModule>();
                    mapFunc.put(func.getParentId(), list);
                }
                list.add(func);
            }
            for (List list : mapFunc.values()) {
                Collections.sort(list, (o1, o2) -> o1.getSort() - o2.getSort());
            }
            for (Role role : this.tableRole.getItems()) {
                List<String> choiceList = this.funcMng.getFuncByRole(role.getId());
                HashMap<String, String> mapCheck = new HashMap<String, String>();
                for (String id : choiceList) {
                    mapCheck.put(id, id);
                }
                List listFunc1 = (List)mapFunc.get("F00000");
                if (listFunc1 == null) continue;
                for (FuncModule func1 : listFunc1) {
                    List listFunc2;
                    if (mapCheck.containsKey(func1.getId())) {
                        this.createCell(spreadsheet, cellStyleOne, head, role, func1, "1");
                    }
                    if ((listFunc2 = (List)mapFunc.get(func1.getId())) == null) continue;
                    for (FuncModule func2 : listFunc2) {
                        List listFunc3;
                        if (mapCheck.containsKey(func2.getId())) {
                            this.createCell(spreadsheet, cellStyleTwo, head, role, func2, "2");
                        }
                        if ((listFunc3 = (List)mapFunc.get(func2.getId())) == null) continue;
                        for (FuncModule func3 : listFunc3) {
                            if (!mapCheck.containsKey(func3.getId())) continue;
                            this.createCell(spreadsheet, cellStyleThree, head, role, func3, "3");
                        }
                    }
                }
            }
            int j2 = 0;
            while (j2 < head.length) {
                spreadsheet.setDefaultColumnWidth(18);
                ++j2;
            }
            FileChooser chooser = new FileChooser();
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("excel files (*.xls)", new String[]{".xls"});
            chooser.getExtensionFilters().add((Object)filter);
            chooser.setInitialFileName("\u89d2\u8272\u529f\u80fd\u83dc\u5355");
            File file = chooser.showSaveDialog(null);
            if (file != null) {
                FileOutputStream out = new FileOutputStream(file);
                workbook.write((OutputStream)out);
                workbook.close();
                out.close();
            } else {
                workbook.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void createCell(HSSFSheet spreadsheet, HSSFCellStyle cellStyleOne, String[] head, Role role, FuncModule func, String floor) {
        int last = spreadsheet.getLastRowNum();
        HSSFRow row = spreadsheet.createRow(++last);
        int j = 0;
        while (j < head.length) {
            HSSFCell cell = row.createCell(j);
            if (head[j].equals("\u89d2\u8272\u4ee3\u7801")) {
                cell.setCellValue(role.getId());
            } else if (head[j].equals("\u89d2\u8272\u540d\u79f0")) {
                cell.setCellValue(role.getName());
            } else if (head[j].equals("\u6240\u5c5e\u673a\u6784")) {
                cell.setCellValue(role.getPartyName());
            } else if (head[j].equals("\u89d2\u8272\u72b6\u6001")) {
                cell.setCellValue(role.getStatus().getValue());
            } else if (head[j].equals("\u89d2\u8272\u7c7b\u578b")) {
                cell.setCellValue(role.getRoleType().getValue());
            } else if (head[j].equals("\u83dc\u5355ID")) {
                cell.setCellValue(func.getId());
            } else if (head[j].equals("\u83dc\u5355\u540d\u79f0")) {
                cell.setCellValue(func.getName());
            } else if (head[j].equals("\u83dc\u5355\u5c42\u7ea7")) {
                cell.setCellValue(floor);
            } else if (head[j].equals("\u7236\u7ea7\u83dc\u5355ID")) {
                cell.setCellValue(func.getParentId());
            } else if (head[j].equals("\u5206\u7c7b")) {
                cell.setCellValue(func.getModuleType().getValue());
            }
            cell.setCellStyle(cellStyleOne);
            ++j;
        }
    }

    private class AutoTableCell<S, T>
    extends TableCell<Role, T> {
        Role role;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.role = (Role)Role.class.cast(this.getTableRow().getItem());
                if (this.role == null) {
                    return;
                }
                if (!this.role.getDes().isEmpty()) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(this.role.getDes());
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(this.role.getDes());
            }
        }
    }

    private class OperaCell
    extends TableCell<Role, String> {
        final Label updateLab = new Label("\u8bbe\u7f6e");
        final HBox paddedLabel = new HBox();
        final Label statusLab = new Label("\u65e0");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    RoleMngPart.this.update();
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof Role) {
                        Role r = (Role)OperaCell.this.getTableRow().getItem();
                        RoleMngPart.this.selectTableRole = r;
                        if ("\u505c\u7528".equals(r.getStatus().getValue())) {
                            OperaCell.this.statusLab.setText("\u542f\u7528");
                            RoleMngPart.this.enable();
                        } else {
                            OperaCell.this.statusLab.setText("\u505c\u7528");
                            RoleMngPart.this.disable();
                        }
                    }
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof Role) {
                    Role r = (Role)this.getTableRow().getItem();
                    if ("\u505c\u7528".equals(r.getStatus().getValue())) {
                        this.statusLab.setText("\u542f\u7528");
                    } else {
                        this.statusLab.setText("\u505c\u7528");
                    }
                    this.paddedLabel.getChildren().remove((Object)this.updateLab);
                    this.paddedLabel.getChildren().remove((Object)this.statusLab);
                    if (r.getRoleType().getRaw().equals("0")) {
                        if (RoleMngPart.this.settingFlag) {
                            this.paddedLabel.getChildren().add((Object)this.updateLab);
                        }
                        if (RoleMngPart.this.statusFlag) {
                            HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
                            this.paddedLabel.getChildren().add((Object)this.statusLab);
                        }
                    } else if (r.getRoleType().getRaw().equals("1")) {
                        if (RoleMngPart.this.publicSettingFlag) {
                            this.paddedLabel.getChildren().add((Object)this.updateLab);
                        }
                        if (RoleMngPart.this.publicStatusFlag) {
                            HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
                            this.paddedLabel.getChildren().add((Object)this.statusLab);
                        }
                    }
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

