/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.User;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.utils.StringUtils;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResetPwdDialog
extends DialogObj {
    @FXML
    private TextField txtName;
    @FXML
    private PasswordField pwdPwd;
    @FXML
    private Label lbPwdErr;
    @FXML
    private PasswordField pwdPwdConfirm;
    @FXML
    private Label lbPwdConfirmErr;
    @FXML
    private Label lbPwdRepeatErr;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private MxAlert mAlert;
    private User user;
    private static final Logger logger = LogManager.getLogger(ResetPwdDialog.class);
    private static final int ERROR_USER_PWD_SAME = 3117;

    @FXML
    public void initialize() {
        this.initValues();
        this.addCheck();
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.pwdPwd.setTextFormatter((TextFormatter)new MxFormatter("^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*$", 20));
        this.pwdPwdConfirm.setTextFormatter((TextFormatter)new MxFormatter("^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*$", 20));
        this.registerCheck((Node)this.lbPwdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pwdPwd.focusedProperty().get() && !TextFieldUtils.isPwd((TextField)this.pwdPwd).get()) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pwdPwd.focusedProperty(), TextFieldUtils.isPwd((TextField)this.pwdPwd)}));
        this.registerCheck((Node)this.lbPwdConfirmErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pwdPwdConfirm.focusedProperty().get() && !this.pwdPwdConfirm.getText().equals(this.pwdPwd.getText())) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pwdPwdConfirm.focusedProperty()}));
    }

    private void initValues() {
        this.txtName.setText(this.user.getName());
        this.pwdPwd.setTooltip(new Tooltip("\u8981\u6c42\u81f3\u5c118\u4f4d\uff0c\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u7279\u6b8a\u5b57\u7b26\u81f3\u5c113\u79cd\u7ec4\u5408\u642d\u914d"));
    }

    public boolean isOK(ButtonType bt) {
        block5: {
            try {
                if (this.check()) break block5;
                return false;
            }
            catch (MException ex) {
                if (ex.getCode() == 3117) {
                    this.lbPwdRepeatErr.setText("\u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e00\u81f4");
                    this.lbPwdRepeatErr.setTextFill((Paint)Color.RED);
                    this.showTips(this.lbPwdRepeatErr);
                } else {
                    logger.error((Object)ex, (Throwable)ex);
                    this.mAlert.alert(Alert.AlertType.ERROR, String.valueOf(ex.getCode()) + ex.getMessage());
                }
                return false;
            }
        }
        this.userMng.resetPwd(this.user.getId(), this.pwdPwdConfirm.getText());
        this.lbPwdRepeatErr.setText("\u5bc6\u7801\u4fee\u6539\u6210\u529f");
        this.lbPwdRepeatErr.setTextFill((Paint)Color.WHITE);
        this.showTips(this.lbPwdRepeatErr);
        return false;
    }

    private void showTips(Label lb) {
        lb.requestFocus();
        lb.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> lb.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
    }

    private boolean check() {
        if (!StringUtils.isPwd((String)this.pwdPwd.getText())) {
            this.lbPwdErr.setOpacity(1.0);
            this.lbPwdConfirmErr.setOpacity(1.0);
            return false;
        }
        if (!this.pwdPwd.getText().equals(this.pwdPwdConfirm.getText())) {
            this.lbPwdConfirmErr.setOpacity(1.0);
            return false;
        }
        return true;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}

