/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.MacInfo;
import cms.tmx.entity.Party;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.update.api.UpdateApi;
import cms.tmx.http.update.dto.Member;
import cms.tmx.http.update.dto.UpdateMembersReq;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemittedListDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(RemittedListDialog.class);
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<MacInfo> tableMacInfo;
    @FXML
    private TableColumn<MacInfo, String> colPartyId;
    @FXML
    private TableColumn<MacInfo, String> colPartyName;
    @FXML
    private TableColumn<MacInfo, String> colMac;
    @FXML
    private TableColumn<MacInfo, Boolean> colNoUpdate;
    @FXML
    private Button btnSave;
    @FXML
    private TextField txtSearch;
    @Inject
    private MObjFactory of;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private MxAlert alert;
    @Inject
    private UpdateApi updateApi;
    @Inject
    private HttpBaseApi httpBaseApi;
    protected CheckBox checkBox = new CheckBox();
    private MxList<MacInfo> macInfoList = new MxList();
    private List<MacInfo> orMacList = new ArrayList<MacInfo>();
    private TreeItem<Party> selectTreeParty;
    private Predicate<MacInfo> pd = item -> {
        String selectedPartId = "P0000001";
        if (this.selectTreeParty != null) {
            selectedPartId = ((Party)this.selectTreeParty.getValue()).getId();
        }
        if ("P0000001".equals(selectedPartId)) {
            if (StringUtils.isEmpty((String)this.txtSearch.getText())) {
                return true;
            }
            return item.getPartyId().contains(this.txtSearch.getText()) || item.getPartyName().contains(this.txtSearch.getText()) || item.getMac().contains(this.txtSearch.getText());
        }
        if (!item.getPartyId().equals(selectedPartId)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtSearch.getText())) {
            return true;
        }
        return item.getPartyId().contains(this.txtSearch.getText()) || item.getPartyName().contains(this.txtSearch.getText()) || item.getMac().contains(this.txtSearch.getText());
    };

    @FXML
    public void initialize() {
        this.initTree();
        this.createTable();
        this.exe.execute(() -> {
            if (this.treeParty.getRoot() == null) {
                return;
            }
            this.treeParty.getSelectionModel().select(0);
        });
        this.queryMacInfos();
        this.treeParty.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            this.selectTreeParty = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
            this.macInfoList.filter(this.orMacList, this.pd);
        });
        this.btnSave.setOnMouseClicked(event -> this.saveRemittedList());
        this.checkBox.selectedProperty().addListener((ob, oldV, newV) -> {
            ObservableList observableList = this.macInfoList.getList();
            synchronized (observableList) {
                this.macInfoList.getList().forEach(item -> item.setNoUpdate(newV.booleanValue()));
            }
        });
        this.txtSearch.textProperty().addListener((ob, oldV, newV) -> this.macInfoList.filter(this.orMacList, this.pd));
    }

    private void queryMacInfos() {
        List members = null;
        try {
            members = this.updateApi.getMembersExcludes();
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u5347\u7ea7\u540d\u5355\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u5347\u7ea7\u540d\u5355\u5931\u8d25" + (Object)((Object)e));
        }
        ArrayList<MacInfo> macs = new ArrayList<MacInfo>();
        if (members != null) {
            for (Member member : members) {
                MacInfo macInfo = new MacInfo();
                macInfo.update(member);
                Party party = this.partyTree.getParty(macInfo.getPartyId());
                if (party != null) {
                    macInfo.setPartyName(party.getName());
                }
                macs.add(macInfo);
            }
        }
        this.orMacList.clear();
        this.orMacList.addAll(macs);
        this.macInfoList.update(this.orMacList);
        this.tableMacInfo.sort();
    }

    private void initTree() {
        try {
            TreeItem<Party> root = this.partyTree.getRoot();
            this.treeParty.setRoot(root);
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void saveRemittedList() {
        UpdateMembersReq req = new UpdateMembersReq();
        ArrayList<Member> members = new ArrayList<Member>();
        for (MacInfo macInfo : this.orMacList) {
            if (!macInfo.isNoUpdate()) continue;
            Member member = new Member();
            member.setMac(macInfo.getMac());
            member.setPartyId(macInfo.getPartyId());
            member.setPartyName(macInfo.getPartyName());
            members.add(member);
        }
        req.setMember(members);
        req.setUser(this.httpBaseApi.getHttpOpUser());
        try {
            this.updateApi.updateMembersExcludes(req);
        }
        catch (MException e) {
            logger.error("\u66f4\u65b0\u8c41\u514d\u540d\u5355\u51fa\u9519, version" + (Object)((Object)e));
            this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u8c41\u514d\u540d\u5355\u51fa\u9519" + (Object)((Object)e));
            return;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u66f4\u65b0\u8c41\u514d\u540d\u5355\u6210\u529f");
    }

    private void createTable() {
        this.colNoUpdate.setGraphic((Node)this.checkBox);
        this.colNoUpdate.setCellValueFactory(data -> ((MacInfo)data.getValue()).noUpdateProperty());
        this.colNoUpdate.setCellFactory(data -> new MxCheckBoxTableCell());
        this.colNoUpdate.setSortable(false);
        this.colNoUpdate.getTableView().setEditable(true);
        this.colPartyId.setCellValueFactory(data -> ((MacInfo)data.getValue()).partyIdProperty());
        this.colPartyName.setCellValueFactory(data -> ((MacInfo)data.getValue()).partyNameProperty());
        this.colMac.setCellValueFactory(data -> ((MacInfo)data.getValue()).macProperty());
        this.tableMacInfo.setItems(this.macInfoList.getList());
        this.colPartyId.setSortType(TableColumn.SortType.ASCENDING);
        this.tableMacInfo.getSortOrder().add(this.colPartyId);
    }

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }
}

