/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.Account;
import cms.tmx.entity.Post;
import cms.tmx.entity.Product;
import cms.tmx.entity.Role;
import cms.tmx.entity.SecClassify;
import cms.tmx.entity.TradeCounter;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.factory.AccountStepAttributeFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountGrpMngServiceImpl;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.CurCmbModel;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.manage.models.ProductMngModel;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.manage.models.WorkFlowMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.MathUtils;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class ProductWorkFlowTabContent
extends MxTabContent {
    @FXML
    private TableView<Account> tableAccnt;
    @FXML
    private TableColumn<Account, String> index;
    @FXML
    private TableColumn<Account, String> brokerId;
    @FXML
    private TableColumn<Account, String> tradePlatformId;
    @FXML
    private ComboBox<MxNode> cmbArr;
    @FXML
    private Label lbMsg;
    @FXML
    private ComboBox<WorkFlowDescriptor> cmbFlow;
    @FXML
    private TableView<AccntStepAttribute> tableStep;
    @FXML
    private TableColumn<AccntStepAttribute, String> indexS;
    @FXML
    private TableColumn<AccntStepAttribute, Boolean> frozenCapital;
    @FXML
    private TableColumn<AccntStepAttribute, Boolean> distributeFlag;
    @FXML
    private TableColumn<AccntStepAttribute, GridPane> objIds;
    @FXML
    private TableColumn<AccntStepAttribute, CheckComboBox<MxNode>> enableAction;
    @FXML
    private TableColumn<AccntStepAttribute, GridPane> approvalClassify;
    @FXML
    private TableColumn<AccntStepAttribute, GridPane> orderAmount;
    @FXML
    private TableColumn<AccntStepAttribute, GridPane> approvalSide;
    @FXML
    private TableColumn<AccntStepAttribute, GridPane> approvalSpon;
    @FXML
    private TableColumn<AccntStepAttribute, Boolean> fastApr;
    private ObservableList<MxObject> sponsors = FxUtils.newList();
    private ObservableList<String> sponsorIds = FxUtils.newList();
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private ProductMngModel productMngModel;
    @Inject
    private ExecutorService exe;
    @Inject
    private TradeCounterServiceImpl counterMng;
    @Inject
    private WorkFlowMngServiceImpl workFlowMng;
    @Inject
    private AccountStepAttributeFactory af;
    @Inject
    private MxAlert mAlert;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private AccountGrpMngServiceImpl accountGrpMng;
    @Inject
    private IUiRightService model;
    private Product selectProduct;
    private Account oldAccount;
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private BooleanProperty change = new SimpleBooleanProperty(false);
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private MxList<Account> mlist = new MxList();
    private ObservableList<WorkFlowDescriptor> flows = FxUtils.newList();
    private Map<Integer, WorkFlowDescriptor> mapFlow = new HashMap<Integer, WorkFlowDescriptor>();
    private Map<String, AccntStepAttribute> mapStep = new HashMap<String, AccntStepAttribute>();
    private Map<String, WorkFlowDescriptor> relationMap = new HashMap<String, WorkFlowDescriptor>();
    private ObservableList<Post> listPost = FxUtils.newList();
    private ObservableList<SecClassify> listSecClassify = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(ProductWorkFlowTabContent.class);
    private MxNode actionNode;
    @FXML
    private GridPane gridSetting;
    @Inject
    private PartyMngServiceImpl partyMng;
    @FXML
    private ComboBox<MxNodePwf> comInstType;
    @FXML
    private Label lbInstType;
    @FXML
    private ComboBox<MxNode> cmbFreeze;
    @FXML
    private TextField txtFreeze;
    private CurCmbModel instModel = new CurCmbModel();
    private static final String DEFAULT_NODE = "4";
    private static final String DEFAULT_FREEZE = "10.00";
    private static final int TWO_INST = 3;
    private static final int THREE = 2;
    private static final int TWO_ADVICE = 1;
    private static final int THREE_RISK = 4;
    private static final int FOUR = 5;
    private static final int TWO_INST_RISK_WARN = 6;
    private static final int DISTRIBUTE = 7;
    private static final int MAIL = 8;
    private Map<String, SecClassify> mapSecClassify = new HashMap<String, SecClassify>();
    private Map<String, String> mapStrClassify = new HashMap<String, String>();
    private MxNode side = new MxNode();
    private static final String SURE_NOT_SAVE = "\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private BaseSuggestion<SecClassify> suggestSec = new BaseSuggestion<SecClassify>(){
        private Comparator<SecClassify> cp = new Comparator<SecClassify>(){

            @Override
            public int compare(SecClassify o1, SecClassify o2) {
                return o1.getSecClassifyName().compareTo(o2.getSecClassifyName());
            }
        };

        protected Comparator<SecClassify> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(SecClassify si, BaseAutoCompletion.ISuggestionRequest req) {
            return si.getSecClassifyName().contains(req.getUserText());
        }
    };
    private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
    private static final String MST_DEF_TEXT = "\u8bf7\u52a1\u5fc5\u9009\u62e9\u804c\u4f4d\u6216\u7528\u6237";

    @FXML
    public void initialize() {
        this.gridSetting.setVisible(false);
        this.selectProduct = this.productMngModel.getCommonProduct();
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updateProductWorkFlowControl"})));
        this.side = MxNodeFactory.create((String)"ins_template_side");
        this.initCombox();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> this.initDefaultValue());
    }

    private void initCombox() {
        String precent = "^(-?(([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|((-)?100(\\.(\\d){0,2})?)|-$";
        this.txtFreeze.setText(DEFAULT_FREEZE);
        this.txtFreeze.setTextFormatter((TextFormatter)new MxFormatter(precent, 9));
        this.txtFreeze.focusedProperty().addListener((ob, old, now) -> {
            if (this.txtFreeze.getText().equals("-")) {
                this.txtFreeze.setText("0.00");
            } else {
                String txt = StringUtils.toThousands((String)this.txtFreeze.getText(), (int)2);
                this.txtFreeze.setText(txt);
            }
        });
        MxNode targetNode = MxNodeFactory.create((String)"target", (String)"2");
        ObservableList targetNodes = targetNode.getNodes();
        this.cmbArr.setItems(targetNodes);
        this.cmbFlow.setItems(this.flows);
        this.cmbFlow.setDisable(true);
        this.cmbFlow.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (!this.canUpdate.get()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.canUpdate}));
        this.actionNode = MxNodeFactory.create((String)"enable_action", (String)"1");
        MxNodePwf typeNode = MxNodeFactory.createPwf((String)"instruction_type", (String)"1");
        this.instModel.initCellFactory(this.comInstType, this.lbInstType);
        ObservableList types = typeNode.getPwfNodes();
        types.remove(1);
        for (MxNodePwf node : types) {
            if (!node.getRaw().equals(DEFAULT_NODE)) continue;
            this.instModel.check(node, false);
            node.setDisable(true);
            node.setSelected(true);
        }
        this.comInstType.setItems(types);
        MxNode freezeNode = MxNodeFactory.create((String)"freeze_price", (String)"1");
        ObservableList freezes = freezeNode.getNodes();
        this.cmbFreeze.setItems(freezes);
        this.cmbFreeze.getSelectionModel().select(0);
    }

    public void initDefaultValue() {
        try {
            LinkedList<String> ids = new LinkedList<String>();
            ids.add(this.selectProduct.getId());
            ObservableList<Account> accntList = this.accountMng.getAccountListByProduct(ids);
            this.mlist.update(accntList);
            this.workFlowMng.getDescriptors(new LinkedList<Integer>()).forEach(item -> {
                if (item.getId() != 7 && item.getId() != 8 && this.mapFlow.get(item.getId()) == null) {
                    this.mapFlow.put(item.getId(), (WorkFlowDescriptor)item);
                    this.flows.add(item);
                }
            });
            this.counterMng.getTradeCounterList();
            if (this.mlist.getList().size() <= 0) {
                Platform.runLater(() -> {
                    this.cmbFlow.getSelectionModel().clearSelection();
                    this.lbMsg.setText("");
                });
            } else {
                Platform.runLater(() -> {
                    this.tableAccnt.getSelectionModel().selectFirst();
                    this.selectOne();
                });
            }
        }
        catch (MException e) {
            Platform.runLater(() -> this.lbMsg.setText(e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void onItemClicked(MouseEvent event) {
        this.selectOne();
    }

    private void selectOne() {
        Account now;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE)) {
                this.tableAccnt.getSelectionModel().select((Object)this.oldAccount);
                return;
            }
            this.save.set(false);
        }
        if ((now = (Account)this.tableAccnt.getSelectionModel().getSelectedItem()) == null) {
            return;
        }
        this.lbMsg.setText("");
        this.oldAccount = now;
        try {
            LinkedList<String> partyIds = new LinkedList<String>();
            this.partyMng.getPartyList(now.getPartyId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING).forEach(item -> partyIds.add(item.getId()));
            partyIds.add(now.getPartyId());
            this.listSecClassify = FXCollections.observableList(this.accountGrpMng.getSecClassifyList(partyIds));
            this.listSecClassify.forEach(item -> {
                this.mapSecClassify.put(String.valueOf(item.getSecClassifyName()) + "(" + item.getSecClassifyId() + ")", (SecClassify)item);
                this.mapStrClassify.put(String.valueOf(item.getSecClassifyId()), item.getSecClassifyName());
            });
            List<String> postIds = this.postMng.getPostIdViaExtAccnt(now.getId());
            this.listPost = FXCollections.observableList(this.postMng.getPosts(postIds));
            WorkFlowDescriptor flowdesc = this.workFlowMng.getFlowAssignInfoViaAccntId(now.getId(), 1);
            List steps = flowdesc.getSteps();
            this.relationMap.put(flowdesc.getAccntId(), flowdesc);
            steps.forEach(item -> this.mapStep.put(String.valueOf(flowdesc.getAccntId()) + flowdesc.getId() + item.getStepId(), (AccntStepAttribute)item));
            WorkFlowDescriptor flow = this.mapFlow.get("");
            this.cmbFlow.getSelectionModel().clearSelection();
            this.tableStep.refresh();
            this.change.set(true);
            if (steps.size() > 0) {
                flow = this.mapFlow.get(flowdesc.getId());
            }
            this.cmbFlow.getSelectionModel().select((Object)flow);
            this.save.set(false);
        }
        catch (MException e) {
            Platform.runLater(() -> this.lbMsg.setText(e.getMessage()));
        }
    }

    private void bind() {
        this.tableAccnt.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.cmbFlow.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            try {
                this.sponsors.clear();
                this.sponsorIds.clear();
                if (now != null) {
                    this.tableStep.getItems().clear();
                    this.tableStep.setItems(FXCollections.observableList(new LinkedList(now.getSteps())));
                    now.getSteps().forEach(item -> {
                        String id = "";
                        if (this.tableAccnt.getSelectionModel().getSelectedItem() != null) {
                            id = ((Account)this.tableAccnt.getSelectionModel().getSelectedItem()).getId();
                        }
                        AccntStepAttribute step = this.mapStep.get(String.valueOf(id) + now.getId() + item.getStepId());
                        if (4 == now.getId()) {
                            this.approvalClassify.setVisible(true);
                            this.approvalSide.setVisible(true);
                            this.approvalSpon.setVisible(true);
                        } else {
                            this.approvalClassify.setVisible(false);
                            this.approvalSide.setVisible(false);
                            this.approvalSpon.setVisible(false);
                        }
                        if (5 == now.getId()) {
                            this.orderAmount.setVisible(true);
                        } else {
                            this.orderAmount.setVisible(false);
                        }
                        if (4 == now.getId() || 2 == now.getId()) {
                            this.fastApr.setVisible(true);
                        } else {
                            this.fastApr.setVisible(false);
                        }
                        if (step == null) {
                            step = this.af.create();
                            step.setStepId(item.getStepId());
                            if (now.getSteps().size() == 2 && 1 == now.getId()) {
                                if (item.getStepId() == 1) {
                                    step.setDistributeFlag(true);
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("2");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(32);
                                } else if (item.getStepId() == 2) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(88);
                                }
                            } else if (now.getSteps().size() == 2 && 3 == now.getId()) {
                                if (item.getStepId() == 1) {
                                    step.setDistributeFlag(true);
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(1);
                                } else if (item.getStepId() == 2) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(152);
                                }
                            } else if (now.getSteps().size() == 2 && 6 == now.getId()) {
                                if (item.getStepId() == 1) {
                                    step.setDistributeFlag(true);
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(1);
                                } else if (item.getStepId() == 2) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(152);
                                }
                            } else if (now.getSteps().size() == 3 && 2 == now.getId()) {
                                if (item.getStepId() == 1) {
                                    step.setDistributeFlag(true);
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("2");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(32);
                                } else if (item.getStepId() == 2) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(76);
                                } else if (item.getStepId() == 3) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(24);
                                }
                            } else if (now.getSteps().size() == 3 && 4 == now.getId()) {
                                if (item.getStepId() == 1) {
                                    step.setDistributeFlag(true);
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(1);
                                } else if (item.getStepId() == 2) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(12);
                                } else if (item.getStepId() == 3) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(24);
                                }
                            } else if (now.getSteps().size() == 4 && 5 == now.getId()) {
                                if (item.getStepId() == 1) {
                                    step.setDistributeFlag(true);
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(1);
                                } else if (item.getStepId() == 2 || item.getStepId() == 3) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(12);
                                } else if (item.getStepId() == 4) {
                                    step.getOffFlag().setRaw("2");
                                    step.getTarget().setRaw("2");
                                    step.getInstructType().setRaw("1");
                                    step.getSameLevelAction().setRaw("1");
                                    step.setEnableAction(24);
                                }
                            }
                        }
                        item.update((Object)step);
                    });
                    if (now.getSteps().size() > 0) {
                        this.cmbArr.getSelectionModel().select((Object)((AccntStepAttribute)now.getSteps().get(0)).getTarget());
                        this.save.set(false);
                    } else {
                        this.lbMsg.setText("");
                        this.save.set(true);
                    }
                } else {
                    this.tableStep.setItems(FXCollections.observableList(new LinkedList()));
                }
            }
            catch (Exception e) {
                logger.error("\u6307\u4ee4\u6d41\u6a21\u677f\u8bbe\u7f6e\u52a0\u8f7d\u51fa\u9519", (Throwable)e);
            }
        });
    }

    private void createTableView() {
        this.tableAccnt.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableAccnt);
        this.brokerId.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            Account account = (Account)data.getValue();
            for (TradeCounter item : this.counterMng.getBroker()) {
                if (!item.getBrokerId().equals(account.getBrokerId())) continue;
                name.setValue(item.getBrokerName());
                break;
            }
            return name;
        });
        this.tradePlatformId.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            Account account = (Account)data.getValue();
            for (TradeCounter item : this.counterMng.getTradeCounterList(account.getBrokerId())) {
                if (!item.getId().equals(account.getTradePlatformId())) continue;
                name.setValue(item.getName());
                break;
            }
            return name;
        });
        this.tableAccnt.setItems(this.mlist.getList());
        this.indexS.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(this.tableStep.getItems().indexOf(data.getValue()) + 1)));
        ((TableColumn)this.tableStep.getColumns().get(1)).setCellValueFactory((Callback)new PropertyValueFactory("stepName"));
        ((TableColumn)this.tableStep.getColumns().get(2)).setCellValueFactory((Callback)new PropertyValueFactory("instructType"));
        ((TableColumn)this.tableStep.getColumns().get(3)).setCellValueFactory((Callback)new PropertyValueFactory("offFlag"));
        this.frozenCapital.setCellValueFactory((Callback)new PropertyValueFactory("frozenCapital"));
        this.frozenCapital.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.objIds.setCellValueFactory(data -> this.setOperateRole((AccntStepAttribute)data.getValue()));
        this.enableAction.setCellValueFactory(data -> this.setOperateAction((AccntStepAttribute)data.getValue()));
        ((TableColumn)this.tableStep.getColumns().get(7)).setCellValueFactory((Callback)new PropertyValueFactory("sameLevelAction"));
        this.distributeFlag.setCellValueFactory((Callback)new PropertyValueFactory("distributeFlag"));
        this.distributeFlag.setCellFactory(cellDate -> new DxCheckBoxTableCell());
        this.distributeFlag.setEditable(false);
        this.approvalClassify.setCellValueFactory(data -> this.setOperateApprovalClassify((AccntStepAttribute)data.getValue()));
        this.approvalSide.setCellValueFactory(data -> this.setOperateApprovalSide((AccntStepAttribute)data.getValue()));
        this.approvalSpon.setCellValueFactory(data -> this.setOperateApprovalSpon((AccntStepAttribute)data.getValue()));
        this.orderAmount.setCellValueFactory(data -> this.setOrderAmount((AccntStepAttribute)data.getValue()));
        this.fastApr.setCellValueFactory((Callback)new PropertyValueFactory("fastApr"));
        this.fastApr.setCellFactory(cellDate -> new DxxxCheckBoxTableCell());
    }

    private ReadOnlyObjectWrapper<GridPane> setOperateApprovalSpon(AccntStepAttribute step) {
        GridPane pane = new GridPane();
        try {
            CheckComboBox cmbSponsor = new CheckComboBox();
            cmbSponsor.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                if (!this.canUpdate.get()) {
                    return true;
                }
                return false;
            }, (Observable[])new Observable[]{this.canUpdate}));
            if (step.getStepId() == 2) {
                cmbSponsor.getItems().setAll(this.listPost);
                ArrayList<String> obIds = new ArrayList<String>();
                for (MxObject ob2 : this.sponsors) {
                    if (ob2 instanceof Role) {
                        String roleId = ((Role)Role.class.cast(ob2)).getId();
                        obIds.add(roleId);
                        continue;
                    }
                    if (!(ob2 instanceof Post)) continue;
                    String postId = ((Post)Post.class.cast(ob2)).getId();
                    obIds.add(postId);
                }
                ArrayList<Post> toCheck = new ArrayList<Post>();
                for (Post post : this.listPost) {
                    if (!obIds.contains(post.getId())) {
                        cmbSponsor.getItems().remove((Object)post);
                    }
                    if (!step.getSponsorIds().contains((Object)post.getId())) continue;
                    toCheck.add(post);
                }
                for (MxObject mxObject : toCheck) {
                    cmbSponsor.getCheckModel().check((Object)mxObject);
                }
                cmbSponsor.setVisible(true);
            } else {
                cmbSponsor.setVisible(false);
            }
            cmbSponsor.setMinWidth(100.0);
            ListChangeListener sponlis = ob -> {
                ArrayList checkedItems = new ArrayList(cmbSponsor.getCheckModel().getCheckedItems());
                cmbSponsor.getCheckModel().clearChecks();
                cmbSponsor.getItems().clear();
                cmbSponsor.getItems().addAll(this.sponsors);
                for (MxObject mxObject : cmbSponsor.getItems()) {
                    if (!checkedItems.contains(mxObject)) continue;
                    cmbSponsor.getCheckModel().check((Object)mxObject);
                }
            };
            this.sponsors.addListener(sponlis);
            ListChangeListener sponsorLis = ob -> {
                step.getSponsorIds().clear();
                this.sponsorIds.clear();
                ObservableList checkedItems = cmbSponsor.getCheckModel().getCheckedItems();
                for (MxObject obj : checkedItems) {
                    if (obj instanceof Role) {
                        String roleId = ((Role)Role.class.cast(obj)).getId();
                        step.getSponsorIds().add((Object)roleId);
                        this.sponsorIds.add((Object)roleId);
                        continue;
                    }
                    if (!(obj instanceof Post)) continue;
                    String postId = ((Post)Post.class.cast(obj)).getId();
                    step.getSponsorIds().add((Object)postId);
                    this.sponsorIds.add((Object)postId);
                }
            };
            cmbSponsor.getCheckModel().getCheckedItems().addListener(sponsorLis);
            pane.addColumn(0, new Node[]{cmbSponsor});
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return new ReadOnlyObjectWrapper((Object)pane);
    }

    private ReadOnlyObjectWrapper<GridPane> setOperateApprovalSide(AccntStepAttribute step) {
        GridPane pane = new GridPane();
        try {
            CheckComboBox cmbSide = new CheckComboBox();
            cmbSide.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                if (!this.canUpdate.get()) {
                    return true;
                }
                return false;
            }, (Observable[])new Observable[]{this.canUpdate}));
            cmbSide.setMinWidth(100.0);
            cmbSide.getItems().addAll((Collection)this.side.getNodes());
            if (step.getStepId() == 2) {
                if (!step.getSides().isEmpty()) {
                    for (MxNode node : cmbSide.getItems()) {
                        for (Integer side : step.getSides()) {
                            if (!String.valueOf(side).equals(node.getRaw())) continue;
                            cmbSide.getCheckModel().check((Object)node);
                        }
                    }
                }
                cmbSide.setVisible(true);
            } else {
                cmbSide.setVisible(false);
            }
            ListChangeListener sideLis = ob -> {
                step.getSides().clear();
                ObservableList checkedItems = cmbSide.getCheckModel().getCheckedItems();
                for (MxNode sideNode : checkedItems) {
                    step.getSides().add((Object)Integer.valueOf(sideNode.getRaw()));
                }
            };
            cmbSide.getCheckModel().getCheckedItems().addListener(sideLis);
            pane.addColumn(0, new Node[]{cmbSide});
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return new ReadOnlyObjectWrapper((Object)pane);
    }

    private ReadOnlyObjectWrapper<GridPane> setOperateApprovalClassify(AccntStepAttribute step) {
        GridPane pane = new GridPane();
        try {
            ComboBox cmbSec = new ComboBox();
            cmbSec.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                if (!this.canUpdate.get()) {
                    return true;
                }
                return false;
            }, (Observable[])new Observable[]{this.canUpdate}));
            cmbSec.setEditable(true);
            cmbSec.setMinWidth(100.0);
            if (step.getStepId() == 2) {
                if (!step.getClassifyIds().isEmpty()) {
                    String id = step.getClassifyIds().toString().substring(1, step.getClassifyIds().toString().length() - 1);
                    cmbSec.getEditor().setText(String.valueOf(this.mapStrClassify.get(id)) + "(" + id + ")");
                }
                cmbSec.setVisible(true);
            } else {
                cmbSec.setVisible(false);
            }
            cmbSec.setItems(this.listSecClassify);
            cmbSec.setConverter((StringConverter)new SecClassifyConverter());
            Search.bindAutoCompletion((TextField)cmbSec.getEditor(), this.suggestSec, (StringConverter)new SecClassifyConverter()).setPrefWidth(cmbSec.getPrefWidth());
            this.suggestSec.setAllSuggestions(this.listSecClassify);
            cmbSec.getEditor().setOnMouseClicked(event -> cmbSec.getEditor().selectAll());
            cmbSec.getEditor().setTextFormatter((TextFormatter)new MxFormatter(60));
            cmbSec.getEditor().textProperty().addListener((ob, old, now) -> {
                LinkedList<String> ids = new LinkedList<String>();
                if (this.mapSecClassify.get(now) != null) {
                    ids.add(String.valueOf(this.mapSecClassify.get(cmbSec.getEditor().getText()).getSecClassifyId()));
                    step.setClassifyIds(ids);
                } else {
                    step.setClassifyIds(ids);
                }
            });
            pane.addColumn(0, new Node[]{cmbSec});
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return new ReadOnlyObjectWrapper((Object)pane);
    }

    private ReadOnlyObjectWrapper<GridPane> setOrderAmount(AccntStepAttribute step) {
        GridPane pane = new GridPane();
        try {
            TextField amount = new TextField();
            amount.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([1-9]{1}))(\\.\\d{0,2})?$", 12));
            amount.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                if (!this.canUpdate.get()) {
                    return true;
                }
                return false;
            }, (Observable[])new Observable[]{this.canUpdate}));
            amount.setEditable(true);
            amount.setMinWidth(100.0);
            if (step.getStepId() == 3) {
                if (step.getOrderAmount() > 0.0) {
                    amount.setText(StringUtils.toStr((double)step.getOrderAmount(), (int)2));
                }
                amount.setVisible(true);
            } else {
                amount.setVisible(false);
            }
            amount.textProperty().addListener((ob, old, now) -> step.setOrderAmount(StringUtils.parseDouble((String)now)));
            pane.addColumn(0, new Node[]{amount});
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return new ReadOnlyObjectWrapper((Object)pane);
    }

    private ReadOnlyObjectWrapper<GridPane> setOperateRole(AccntStepAttribute step) {
        GridPane pane = new GridPane();
        try {
            Label lab = new Label("");
            CheckComboBox ccmb = new CheckComboBox();
            ccmb.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                if (!this.canUpdate.get()) {
                    return true;
                }
                return false;
            }, (Observable[])new Observable[]{this.canUpdate}));
            if ("2".equals(step.getTarget().getRaw())) {
                ccmb.getItems().setAll(this.listPost);
                ArrayList<Post> posts = new ArrayList<Post>();
                for (Post post : this.listPost) {
                    for (String item : step.getObjIds()) {
                        if (!post.getId().equals(item)) continue;
                        ccmb.getCheckModel().check((Object)post);
                        posts.add(post);
                    }
                }
                if (step.getStepId() == 1) {
                    this.sponsors.setAll(posts);
                }
                ObservableList checkedItems = ccmb.getCheckModel().getCheckedItems();
                String s = "";
                for (MxObject mxObj : checkedItems) {
                    if (mxObj instanceof Role) {
                        Role role = (Role)Role.class.cast(mxObj);
                        s = String.valueOf(s) + role.getName() + " ";
                        continue;
                    }
                    if (!(mxObj instanceof Post)) continue;
                    Post post = (Post)Post.class.cast(mxObj);
                    s = String.valueOf(s) + post.getName() + " ";
                }
                lab.setTooltip(new Tooltip(s));
                String txt = "";
                if (checkedItems.size() == 0) {
                    this.save.set(false);
                    txt = MST_DEF_TEXT;
                }
                this.setMstText(txt);
            }
            if (step.getStepId() == 1) {
                for (MxObject obj : ccmb.getItems()) {
                    ccmb.getItemBooleanProperty((Object)obj).addListener((oldValue, observa, newValue) -> {
                        Post post;
                        if (!newValue.booleanValue()) {
                            if (obj instanceof Role) {
                                Role role = (Role)Role.class.cast(obj);
                                if (this.sponsorIds.contains((Object)role.getId())) {
                                    this.mAlert.alert(Alert.AlertType.ERROR, "\u8be5\u804c\u4f4d\u5df2\u8bbe\u7f6e\u4e3a\u5ba1\u6279\u6761\u4ef6-\u53d1\u8d77\u4eba\uff0c\u8bf7\u5148\u53d6\u6d88");
                                    Platform.runLater(() -> ccmb.getCheckModel().check((Object)role));
                                    return;
                                }
                                this.sponsors.remove((Object)obj);
                            } else if (obj instanceof Post) {
                                Post post2 = (Post)Post.class.cast(obj);
                                if (this.sponsorIds.contains((Object)post2.getId())) {
                                    this.mAlert.alert(Alert.AlertType.ERROR, "\u8be5\u804c\u4f4d\u5df2\u8bbe\u7f6e\u4e3a\u5ba1\u6279\u6761\u4ef6-\u53d1\u8d77\u4eba\uff0c\u8bf7\u5148\u53d6\u6d88");
                                    Platform.runLater(() -> ccmb.getCheckModel().check((Object)post2));
                                    return;
                                }
                                this.sponsors.remove((Object)obj);
                            }
                        } else if (obj instanceof Role) {
                            Role role = (Role)Role.class.cast(obj);
                            if (!this.sponsorIds.contains((Object)role.getId())) {
                                this.sponsors.add((Object)obj);
                            }
                        } else if (obj instanceof Post && !this.sponsorIds.contains((Object)(post = (Post)Post.class.cast(obj)).getId())) {
                            this.sponsors.add((Object)obj);
                        }
                    });
                }
            }
            ccmb.getCheckModel().getCheckedItems().addListener(ob -> {
                this.lbMsg.setText("");
                ObservableList checkedItems = ccmb.getCheckModel().getCheckedItems();
                String s = "";
                LinkedList<String> ids = new LinkedList<String>();
                for (MxObject mxObj : checkedItems) {
                    if (mxObj instanceof Role) {
                        Role role = (Role)Role.class.cast(mxObj);
                        s = String.valueOf(s) + role.getName() + " ";
                        ids.add(role.getId());
                        continue;
                    }
                    if (!(mxObj instanceof Post)) continue;
                    Post post = (Post)Post.class.cast(mxObj);
                    s = String.valueOf(s) + post.getName() + " ";
                    ids.add(post.getId());
                }
                step.setObjIds(ids);
                lab.setTooltip(new Tooltip(s));
                if (checkedItems.size() == 0) {
                    this.save.set(false);
                    this.setMstText(MST_DEF_TEXT);
                } else {
                    if (((WorkFlowDescriptor)this.cmbFlow.getSelectionModel().getSelectedItem()).getId() == 4) {
                        this.lbMsg.setText("\u5ba1\u6279\u6761\u4ef6\u4e4b\u5916\u7684\u54c1\u79cd\u65e0\u9700\u98ce\u63a7\u5ba1\u6279");
                    } else {
                        this.setMstText("");
                    }
                    this.save.set(true);
                }
            });
            pane.add((Node)ccmb, 0, 0);
            pane.add((Node)lab, 0, 0);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return new ReadOnlyObjectWrapper((Object)pane);
    }

    private ReadOnlyObjectWrapper<CheckComboBox<MxNode>> setOperateAction(AccntStepAttribute step) {
        CheckComboBox ccmb = new CheckComboBox();
        ccmb.setDisable(true);
        ccmb.getItems().addAll((Collection)this.actionNode.getNodes());
        int[] actions = MathUtils.binaryToDecimal((int)step.getEnableAction());
        int i = 0;
        while (i < actions.length) {
            if (actions[i] == 1) {
                ccmb.getCheckModel().check((Object)this.actionNode.getNode(String.valueOf((int)Math.pow(2.0, i))));
            }
            ++i;
        }
        ccmb.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = ccmb.getCheckModel().getCheckedItems();
            step.setEnableAction(0);
            for (MxNode mxObj : checkedItems) {
                if (mxObj.getRaw().isEmpty()) continue;
                int total = step.getEnableAction();
                int a = Integer.parseInt(mxObj.getRaw());
                step.setEnableAction(total + a);
            }
        });
        return new ReadOnlyObjectWrapper((Object)ccmb);
    }

    private void initFrozenCapital(List<AccntStepAttribute> steps) {
        steps.forEach(asa -> {
            if (asa.getStepId() == 1 && asa.isFrozenCapital()) {
                steps.forEach(step -> {
                    if (step.getStepId() == 2 || step.getStepId() == 3 || step.getStepId() == 4) {
                        step.setSelected(true);
                    }
                });
            } else if (asa.getStepId() == 2 && asa.isFrozenCapital()) {
                steps.forEach(step -> {
                    if (step.getStepId() == 3 || step.getStepId() == 4) {
                        step.setSelected(true);
                    }
                });
            } else if (asa.getStepId() == 3 && asa.isFrozenCapital()) {
                steps.forEach(step -> {
                    if (step.getStepId() == 4) {
                        step.setSelected(true);
                    }
                });
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @FXML
    public boolean save() {
        String accountId = this.tableAccnt.getSelectionModel().getSelectedItem() != null ? ((Account)this.tableAccnt.getSelectionModel().getSelectedItem()).getId() : "";
        boolean flag = false;
        try {
            flag = this.workFlowMng.checkInsStatus(accountId, 1);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
        }
        try {
            this.save.set(false);
            WorkFlowDescriptor f = this.relationMap.get(accountId);
            int flowDescId = ((WorkFlowDescriptor)this.cmbFlow.getSelectionModel().getSelectedItem()).getId();
            String flowAttriId = "";
            if (f != null) {
                if (!flag) {
                    this.lbMsg.setText("\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u6307\u4ee4\uff0c\u4e0d\u53ef\u5bf9\u6307\u4ee4\u6d41\u8fdb\u884c\u4fee\u6539\uff0c\u4fdd\u5b58\u5931\u8d25");
                    Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)2000.0), e -> this.lbMsg.setText(""), new KeyValue[0])});
                    animation.setCycleCount(1);
                    animation.setAutoReverse(false);
                    animation.play();
                    this.save.set(true);
                    return false;
                }
                flowAttriId = f.getWorkflowAttrId();
                if (f.getId() == flowDescId) {
                    for (AccntStepAttribute item2 : f.getSteps()) {
                        for (AccntStepAttribute a : this.tableStep.getItems()) {
                            if (!item2.getStepAttriId().equals(a.getStepAttriId()) || !item2.getFlowAttriId().equals(a.getFlowAttriId())) continue;
                            item2.update((Object)a);
                            if (a.getObjIds().size() <= 0) {
                                this.save.set(true);
                                this.setMstText(MST_DEF_TEXT);
                                return false;
                            }
                            if (a.getObjIds().size() <= 10) continue;
                            this.save.set(true);
                            this.lbMsg.setText("\u4fdd\u5b58\u5931\u8d25\uff0c\u6700\u591a\u9009\u62e910\u4e2a\u804c\u4f4d\uff01");
                            return false;
                        }
                    }
                    this.workFlowMng.updateAssignAccntToFlow(f);
                    this.tableStep.getItems().forEach(item -> {
                        this.mapStep.put(String.valueOf(accountId) + flowDescId + item.getStepId(), null);
                        this.mapStep.put(String.valueOf(accountId) + flowDescId + item.getStepId(), (AccntStepAttribute)item);
                    });
                    this.relationMap.put(accountId, f);
                    this.labSuccess.setVisible(true);
                    Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
                    animation.setCycleCount(1);
                    animation.setAutoReverse(false);
                    animation.play();
                    return false;
                }
                if (this.tableStep.getItems().size() > 0) {
                    if (accountId.isEmpty()) {
                        this.lbMsg.setText("\u672a\u6307\u5b9a\u8d26\u53f7\uff0c\u4fdd\u5b58\u5931\u8d25");
                        return false;
                    }
                    for (AccntStepAttribute a : this.tableStep.getItems()) {
                        if (a.getObjIds().size() <= 0) {
                            this.save.set(true);
                            this.setMstText(MST_DEF_TEXT);
                            return false;
                        }
                        if (a.getObjIds().size() <= 10) continue;
                        this.save.set(true);
                        this.lbMsg.setText("\u4fdd\u5b58\u5931\u8d25\uff0c\u6700\u591a\u9009\u62e910\u4e2a\u804c\u4f4d\uff01");
                        return false;
                    }
                }
                this.workFlowMng.deleteWorkflowAttr(flowAttriId);
                this.relationMap.put(accountId, null);
                this.mapStep.clear();
            }
            if (this.tableStep.getItems().size() > 0) {
                WorkFlowDescriptor w = new WorkFlowDescriptor();
                if (accountId.isEmpty()) {
                    this.lbMsg.setText("\u672a\u6307\u5b9a\u8d26\u53f7\uff0c\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                w.setAccntId(accountId);
                for (AccntStepAttribute a : this.tableStep.getItems()) {
                    w.getSteps().add(a);
                    if (a.getObjIds().size() <= 0) {
                        this.save.set(true);
                        this.setMstText(MST_DEF_TEXT);
                        return false;
                    }
                    if (a.getObjIds().size() <= 10) continue;
                    this.save.set(true);
                    this.lbMsg.setText("\u4fdd\u5b58\u5931\u8d25\uff0c\u6700\u591a\u9009\u62e910\u4e2a\u804c\u4f4d\uff01");
                    return false;
                }
                w.setId(flowDescId);
                String newFlowAttriId = this.workFlowMng.assignAccntToFlow(w);
                w.setWorkflowAttrId(newFlowAttriId);
                this.tableStep.getItems().forEach(item -> {
                    this.mapStep.put(String.valueOf(accountId) + flowDescId + item.getStepId(), null);
                    this.mapStep.put(String.valueOf(accountId) + flowDescId + item.getStepId(), (AccntStepAttribute)item);
                });
                this.relationMap.put(accountId, w);
            }
            this.labSuccess.setVisible(true);
            Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
            animation.setCycleCount(1);
            animation.setAutoReverse(false);
            animation.play();
            this.selectOne();
        }
        catch (MException e3) {
            this.save.set(true);
            Platform.runLater(() -> this.lbMsg.setText(e3.getMessage()));
        }
        return false;
    }

    private void setMstText(String txt) {
        WorkFlowDescriptor work = (WorkFlowDescriptor)this.cmbFlow.getSelectionModel().getSelectedItem();
        if (work != null && (work.getId() == 1 || work.getId() == 2)) {
            txt = String.valueOf(txt) + (txt.isEmpty() ? "\u64a4\u9500\u5efa\u8bae\u5fc5\u987b\u7ecf\u8fc7\u5ba1\u6279" : "\uff0c\u64a4\u9500\u5efa\u8bae\u5fc5\u987b\u7ecf\u8fc7\u5ba1\u6279");
        }
        this.lbMsg.setText(txt);
    }

    public Product getSelectProduct() {
        return this.selectProduct;
    }

    public void setSelectProduct(Product selectProduct) {
        this.selectProduct = selectProduct;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    public final BooleanProperty changeProperty() {
        return this.change;
    }

    public final boolean isChange() {
        return this.changeProperty().get();
    }

    public final void setChange(boolean change) {
        this.changeProperty().set(change);
    }

    private class DxCheckBoxTableCell
    extends CheckBoxTableCell<AccntStepAttribute, Boolean> {
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected());
                this.setGraphic((Node)this.checkbox);
            }
        }

        private void checkBoxSelected() {
            ProductWorkFlowTabContent.this.save.set(true);
        }
    }

    private class DxxxCheckBoxTableCell
    extends CheckBoxTableCell<AccntStepAttribute, Boolean> {
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                AccntStepAttribute obj = (AccntStepAttribute)this.getTableRow().getItem();
                if (obj != null) {
                    int id = ((WorkFlowDescriptor)ProductWorkFlowTabContent.this.cmbFlow.getSelectionModel().getSelectedItem()).getId();
                    if (obj.getStepId() == 2 && (4 == id || 2 == id)) {
                        this.checkbox.setVisible(true);
                    } else {
                        this.checkbox.setVisible(false);
                    }
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected());
            }
        }

        private void checkBoxSelected() {
            ProductWorkFlowTabContent.this.save.set(true);
        }
    }

    private class MxCheckBoxTableCell
    extends CheckBoxTableCell<AccntStepAttribute, Boolean> {
        private CheckBox checkBox;

        private MxCheckBoxTableCell() {
        }

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkBox = (CheckBox)field.get((Object)this);
                    System.err.println(System.identityHashCode(this.checkBox));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                AccntStepAttribute obj = (AccntStepAttribute)this.getTableRow().getItem();
                if (obj != null) {
                    this.checkBox.disableProperty().bind((ObservableValue)obj.selectedProperty());
                }
                ObservableList initList = this.getTableView().getItems();
                ProductWorkFlowTabContent.this.initFrozenCapital((List)initList);
                this.checkBox.setOnMouseClicked(event -> {
                    block5: {
                        block4: {
                            ProductWorkFlowTabContent.this.save.set(true);
                            ObservableList asaList = this.getTableView().getItems();
                            this.getTableRow().pseudoClassStateChanged(ProductWorkFlowTabContent.this.MXSELECTED, this.checkBox.isSelected());
                            if (!this.checkBox.isSelected()) break block4;
                            if (obj == null) break block5;
                            for (AccntStepAttribute accntStepAttribute2 : asaList.subList(obj.getStepId() - 1, asaList.size())) {
                                if (accntStepAttribute2.getStepId() != obj.getStepId()) {
                                    accntStepAttribute2.setSelected(true);
                                } else {
                                    accntStepAttribute2.setSelected(false);
                                }
                                accntStepAttribute2.setFrozenCapital(true);
                            }
                            break block5;
                        }
                        for (AccntStepAttribute asa : this.getTableView().getItems()) {
                            asa.setSelected(false);
                            asa.setFrozenCapital(false);
                        }
                    }
                });
                if (obj != null) {
                    System.err.println(obj.frozenCapitalProperty());
                    this.checkBox.selectedProperty().bindBidirectional((Property)obj.frozenCapitalProperty());
                }
                this.getTableRow().pseudoClassStateChanged(ProductWorkFlowTabContent.this.MXSELECTED, this.checkBox.isSelected());
            }
        }
    }

    class SecClassifyConverter
    extends StringConverter<SecClassify> {
        SecClassifyConverter() {
        }

        public String toString(SecClassify info) {
            if (info == null) {
                return "";
            }
            return String.valueOf(info.getSecClassifyName()) + "(" + info.getSecClassifyId() + ")";
        }

        public SecClassify fromString(String string) {
            SecClassify e = (SecClassify)ProductWorkFlowTabContent.this.mapSecClassify.get(string);
            if (e != null) {
                return e;
            }
            return null;
        }
    }

    public static class StrSuggest
    extends BaseSuggestion<String> {
        private Comparator<String> cp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };

        protected Comparator<String> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(String str, BaseAutoCompletion.ISuggestionRequest req) {
            String userTextLower = req.getUserText().toLowerCase();
            String suggestionStr = str.toString().toLowerCase();
            return suggestionStr.contains(userTextLower);
        }
    }
}

