/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.Product;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.ProductMngModel;
import cms.tmx.manage.models.ProductRelateAccntModel;
import cms.tmx.rights.IUiRightService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProductRelateAccountTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u8d26\u6237\u6388\u6743\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Account> tableAccnt;
    @FXML
    private TableColumn<Account, String> index;
    @FXML
    private TableColumn<Account, Boolean> select;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private ProductMngModel productMngModel;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private ProductRelateAccntModel productModel;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @Inject
    private PartyFactory pFactory;
    private Account selectTableAccnt;
    private Party selectTreeParty;
    private Product selectProduct;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<Account> mlist = new MxList();
    private List<Account> filterList = new LinkedList<Account>();
    private static final Logger logger = LogManager.getLogger(ProductRelateAccountTabContent.class);
    private List<Account> listAccnts = new LinkedList<Account>();
    private Set<Account> setAccnts = new HashSet<Account>();
    private Set<Account> oldAccnts = new HashSet<Account>();
    private Map<String, Account> map = new HashMap<String, Account>();
    private Predicate<Account> pd = obj -> {
        Account accnt;
        String idName = this.txtSearch.getText().trim();
        return obj instanceof Account && ((accnt = obj).getName().contains(idName) || accnt.getInvestorId().contains(idName));
    };
    private InvalidationListener accntModel = ob -> Platform.runLater(() -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAccnt.sort();
        this.tableAccnt.refresh();
    });
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectProduct = this.productMngModel.getCommonProduct();
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updateProductRelateAccountControl"})));
        TreeItem<Party> root = this.initRoot();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> {
            this.initTree(root);
            this.initDefaultValue();
        });
    }

    public void initDefaultValue() {
        TreeItem root = this.treeParty.getRoot();
        this.treeParty.getSelectionModel().select((Object)root);
        this.oldSelectParty = root;
        this.listAccnts.clear();
        this.oldAccnts.clear();
        this.setAccnts.clear();
        try {
            LinkedList<String> ids = new LinkedList<String>();
            ids.add(this.selectProduct.getId());
            this.listAccnts.addAll((Collection<Account>)this.accountMng.getAccountListByProduct(ids));
            this.oldAccnts.addAll(this.listAccnts);
            this.setAccnts.addAll(this.listAccnts);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
        this.query(((Party)root.getValue()).getId());
        for (MxObject obj : this.mlist.getList()) {
            if (!(obj instanceof Account)) continue;
            Account accnt = (Account)obj;
            this.map.put(accnt.getId(), accnt);
        }
        this.productModel.setSelectProduct(this.selectProduct);
        this.productModel.setOldAccnts(this.oldAccnts);
        this.productModel.setSetAccnts(this.setAccnts);
        this.productModel.setM(this.map);
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.accntModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.tableAccnt.setOnMouseClicked(event -> {
            if (this.tableAccnt.getSelectionModel().getSelectedItem() != null) {
                this.selectTableAccnt = (Account)this.tableAccnt.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        TableUtils.isAuto(this.index);
        ((TableColumn)this.tableAccnt.getColumns().get(2)).setCellValueFactory((Callback)new PropertyValueFactory("investorId"));
        ((TableColumn)this.tableAccnt.getColumns().get(3)).setCellValueFactory((Callback)new PropertyValueFactory("name"));
        ((TableColumn)this.tableAccnt.getColumns().get(4)).setCellValueFactory((Callback)new PropertyValueFactory("status"));
        ((TableColumn)this.tableAccnt.getColumns().get(5)).setCellValueFactory((Callback)new PropertyValueFactory("secExchange"));
        ((TableColumn)this.tableAccnt.getColumns().get(6)).setCellValueFactory((Callback)new PropertyValueFactory("partyName"));
        ((TableColumn)this.tableAccnt.getColumns().get(7)).setCellValueFactory((Callback)new PropertyValueFactory("productName"));
        this.select.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.select.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.tableAccnt.setItems(this.mlist.getList());
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.setAccnts.clear();
            this.setAccnts.addAll(this.listAccnts);
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        try {
            LinkedList<Account> listAccount = new LinkedList<Account>();
            listAccount.addAll((Collection<Account>)this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            listAccount.addAll((Collection<Account>)this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            this.mlist.clear();
            this.filterList.clear();
            this.filterList.addAll(listAccount);
            listAccount.forEach(item -> {
                Account acct;
                if (item instanceof Account && this.setAccnts.contains(acct = (Account)Account.class.cast(item))) {
                    item.setSelected(true);
                }
            });
            Platform.runLater(() -> {
                this.mlist.update(this.filterList, this.pd);
                if (this.selectTableAccnt == null) {
                    return;
                }
                this.tableAccnt.getSelectionModel().select((Object)this.selectTableAccnt);
            });
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean save() {
        try {
            this.save.set(false);
            this.productModel.submit();
        }
        catch (MException e2) {
            this.mAlert.alert(Alert.AlertType.ERROR, e2.getDesc().isEmpty() ? "\u5173\u8054\u5f02\u5e38" : e2.getDesc());
            logger.error((Object)e2, (Throwable)e2);
            this.tableAccnt.refresh();
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    public Product getSelectProduct() {
        return this.selectProduct;
    }

    public void setSelectProduct(Product selectProduct) {
        this.selectProduct = selectProduct;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Account, T> {
        Account obj;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    if (this.getTableRow() == null) {
                        return;
                    }
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (this.getTableRow().getItem() instanceof Account) {
                    this.obj = (Account)Account.class.cast(this.getTableRow().getItem());
                }
                if (this.obj == null) {
                    return;
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.obj));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!ProductRelateAccountTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    if (!this.obj.getProductId().isEmpty() && !this.obj.getProductId().equals(ProductRelateAccountTabContent.this.selectProduct.getId())) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{ProductRelateAccountTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(Account accnt) {
            ProductRelateAccountTabContent.this.save.set(true);
            if (accnt.selectedProperty().get()) {
                ProductRelateAccountTabContent.this.setAccnts.add(accnt);
            } else {
                ProductRelateAccountTabContent.this.setAccnts.remove(accnt);
            }
        }
    }
}

