/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.Product;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AddProductDialog;
import cms.tmx.manage.parts.UpdateProductDialog;
import cms.tmx.rights.IUiRightService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProductMngPart
extends MxPart {
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Product> tableProduct;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<Product, String> colOpera;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @Inject
    private PartyMngServiceImpl partMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private ProductMngServiceImpl productMng;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @Inject
    private MxAlert mAlert;
    @FXML
    private TableColumn<Product, String> creator;
    @FXML
    private TableColumn<Product, String> updater;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private PartyFactory pFactory;
    private TreeItem<Party> root;
    private Product selectTableProduct;
    private TreeItem<Party> selectTreeParty;
    private MxList<Product> mlist = new MxList();
    private List<Product> filterList = new LinkedList<Product>();
    private static final Logger logger = LogManager.getLogger(ProductMngPart.class);
    private static final String IS_ENABLE_PRODUCT = "\u662f\u5426\u542f\u7528\u8be5\u4ea7\u54c1";
    private static final String IS_DISABLE_PRODUCT = "\u662f\u5426\u505c\u7528\u8be5\u4ea7\u54c1";
    private static final String ALERT = "\u63d0\u793a";
    private Predicate<Product> pd = inst -> {
        String idName = this.txtSearch.getText().trim();
        return inst.getName().contains(idName);
    };
    private InvalidationListener instModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableProduct.sort();
    };
    private boolean settingFlag = false;
    private boolean statusFlag = false;

    @FXML
    public void initialize() {
        this.root = this.initRoot();
        this.exe.execute(() -> {
            this.initTree(this.root);
            this.query(((Party)this.root.getValue()).getId());
        });
        this.bind();
        this.createTableView();
        this.checkRights();
    }

    private void initTree(TreeItem<Party> root) {
        block5: {
            try {
                try {
                    ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryProductControl"});
        this.model.registerCheckAll((Control)this.btnAdd, new String[]{"addProductControl", "saveProductBasic"});
        this.statusFlag = this.model.registerCheck(new String[]{"enableProductControl"});
        this.settingFlag = this.model.registerCheck(new String[]{"saveProductBasic", "lookProductBasic", "updateProductRelateAccountControl", "queryProductRelateAccountControl", "queryProductWorkFlowControl", "updateProductWorkFlowControl", "queryProductExtraAssetControl", "updateProductExtraAssetControl"});
        this.settingFlag = this.settingFlag && this.model.registerCheck(new String[]{"updateProductControl"});
    }

    protected void afterTableRestore() {
        this.treeParty.getSelectionModel().select(this.root);
        this.selectTreeParty = this.root;
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.instModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.selectTableProduct = null;
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()));
        });
        this.tableProduct.setOnMouseClicked(event -> {
            if (this.tableProduct.getSelectionModel().getSelectedItem() == null) {
                return;
            }
            this.selectTableProduct = (Product)this.tableProduct.getSelectionModel().getSelectedItem();
        });
    }

    private void createTableView() {
        this.addViwer(this.tableProduct);
        this.tableProduct.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableProduct);
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((Product)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((Product)data.getValue()).getUpdater()));
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableProduct));
        this.tableProduct.setItems(this.mlist.getList());
    }

    private void onItemClicked(TreeItem<Party> item) {
        this.selectTreeParty = item;
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void query(String partyId) {
        try {
            List<Product> listProduct = this.productMng.getProducts(partyId);
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            listProduct.forEach(item -> {
                this.filterList.add((Product)item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void refreshTable() {
        if (this.selectTreeParty == null) {
            return;
        }
        this.query(((Party)this.selectTreeParty.getValue()).getId());
        this.tableProduct.getSelectionModel().select((Object)this.selectTableProduct);
        this.tableProduct.scrollTo((Object)this.selectTableProduct);
    }

    @FXML
    public void refresh() {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            if (this.partMng.getUserParty().getId().equals(((Party)this.selectTreeParty.getValue()).getId())) {
                this.treeParty.getSelectionModel().select(root);
            } else {
                this.treeParty.getSelectionModel().select(this.selectTreeParty);
            }
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            this.tableProduct.getSelectionModel().select((Object)this.selectTableProduct);
            this.tableProduct.scrollTo((Object)this.selectTableProduct);
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void add() {
        AddProductDialog obj = (AddProductDialog)((Object)this.of.create(AddProductDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            obj.setParty((Party)this.treeParty.getRoot().getValue());
        } else {
            obj.setParty((Party)treeItem.getValue());
        }
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u4ea7\u54c1");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            if (!obj.getNewProductId().isEmpty()) {
                this.selectTableProduct = this.productMng.getProductDetail(obj.getNewProductId());
                this.refreshTable();
            }
        }
        catch (MException | Exception e) {
            logger.error((Object)e, e);
        }
    }

    @FXML
    public void update() {
        UpdateProductDialog obj = (UpdateProductDialog)((Object)this.of.create(UpdateProductDialog.class));
        Product pro = (Product)this.tableProduct.getSelectionModel().getSelectedItem();
        Product productSet = (Product)this.of.create(Product.class);
        productSet.update((Object)pro);
        obj.setProduct(productSet);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u4ea7\u54c1");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            this.refreshTable();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void enable() {
        try {
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_ENABLE_PRODUCT, ALERT)) {
                this.productMng.enableProduct((Product)this.tableProduct.getSelectionModel().getSelectedItem(), true);
                this.refreshTable();
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void disable() {
        try {
            if ("P0000001".equals(((Product)this.tableProduct.getSelectionModel().getSelectedItem()).getId())) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u65e0\u4fee\u6539\u6743\u9650");
                return;
            }
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_DISABLE_PRODUCT, ALERT)) {
                this.productMng.enableProduct((Product)this.tableProduct.getSelectionModel().getSelectedItem(), false);
                this.refreshTable();
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void rightRefresh() {
        this.refresh();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableProduct);
    }

    private class OperaCell
    extends TableCell<Product, String> {
        final Label updateLab = new Label("\u8bbe\u7f6e");
        final HBox paddedLabel = new HBox();
        final Label statusLab = new Label("\u65e0");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            if (ProductMngPart.this.settingFlag) {
                this.paddedLabel.getChildren().add((Object)this.updateLab);
                HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
            }
            if (ProductMngPart.this.statusFlag) {
                this.paddedLabel.getChildren().add((Object)this.statusLab);
            }
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    ProductMngPart.this.update();
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof Product) {
                        Product r = (Product)OperaCell.this.getTableRow().getItem();
                        ProductMngPart.this.selectTableProduct = r;
                        if ("\u505c\u7528".equals(r.getStatus().getValue())) {
                            OperaCell.this.statusLab.setText("\u542f\u7528");
                            ProductMngPart.this.enable();
                        } else {
                            OperaCell.this.statusLab.setText("\u505c\u7528");
                            ProductMngPart.this.disable();
                        }
                    }
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof Product) {
                    Product r = (Product)this.getTableRow().getItem();
                    if ("\u505c\u7528".equals(r.getStatus().getValue())) {
                        this.statusLab.setText("\u542f\u7528");
                    } else {
                        this.statusLab.setText("\u505c\u7528");
                    }
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

