/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.entity.Party;
import cms.tmx.entity.Post;
import cms.tmx.entity.Role;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PostMngModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.manage.models.RoleMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostRelateRoleTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u529f\u80fd\u6388\u6743\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableColumn<Role, String> des;
    @FXML
    private TableColumn<Role, MxNode> roleType;
    @FXML
    private TableColumn<Role, String> partyName;
    @FXML
    private TableColumn<Role, Boolean> selected;
    @FXML
    private TableView<Role> tableRole;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private PostMngModel postModel;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private RoleMngServiceImpl roleMng;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyFactory pFactory;
    @Inject
    private IUiRightService model;
    private static final Logger logger = LogManager.getLogger(PostRelateRoleTabContent.class);
    private Role selectTableRole;
    private Party selectTreeParty;
    private Post selectPost;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<Role> mlist = new MxList();
    private List<Role> filterList = new LinkedList<Role>();
    private List<String> listRoleIds = new LinkedList<String>();
    private Map<String, Role> map = new HashMap<String, Role>();
    private ObservableSet<String> setRoleIds = FXCollections.observableSet(new HashSet());
    private ObservableSet<String> oldRoleIds = FXCollections.observableSet(new HashSet());
    private Predicate<Role> pd = role -> {
        String idName = this.txtSearch.getText().trim();
        return role.getName().contains(idName) || role.getId().contains(idName);
    };
    private InvalidationListener roleModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableRole.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectPost = this.postModel.getCommonPost();
        this.labSuccess.setVisible(false);
        TreeItem<Party> root = this.initRoot();
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updatePostRealteRoleControl"})));
        this.exe.execute(() -> {
            this.initTree(root);
            this.createTableView();
            this.bind();
            this.initDefaultValue();
        });
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initDefaultValue() {
        TreeItem root = this.treeParty.getRoot();
        if (root == null) {
            return;
        }
        this.treeParty.getSelectionModel().select((Object)root);
        this.oldSelectParty = root;
        try {
            this.listRoleIds.addAll(this.roleMng.getRoleIdListByPost(this.selectPost.getId()));
            this.oldRoleIds.addAll(this.listRoleIds);
            this.setRoleIds.addAll(this.listRoleIds);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
        if (root.getValue() == null) {
            return;
        }
        this.query(((Party)root.getValue()).getId());
        for (Role obj : this.mlist.getList()) {
            this.map.put(obj.getId(), obj);
        }
    }

    private void initTree(TreeItem<Party> root) {
        block5: {
            try {
                try {
                    ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.roleModel);
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.tableRole.setOnMouseClicked(event -> {
            if (this.tableRole.getSelectionModel().getSelectedItem() == null) {
                return;
            }
            this.selectTableRole = (Role)this.tableRole.getSelectionModel().getSelectedItem();
        });
    }

    private void createTableView() {
        TableUtils.initValueFactory(this.tableRole);
        this.des.setCellFactory(data -> new AutoTableCell());
        this.selected.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.roleType.setCellValueFactory(data -> ((Role)data.getValue()).roleTypeProperty());
        this.partyName.setCellValueFactory(cellData -> {
            Party party = this.partyTree.getParty(((Role)cellData.getValue()).getPartyId());
            SimpleStringProperty flage = new SimpleStringProperty("");
            if (party == null || "1".equals(((Role)cellData.getValue()).getRoleType().getRaw())) {
                return flage;
            }
            flage.set(party.getName());
            ((Role)cellData.getValue()).setPartyName(flage.get());
            return flage;
        });
        this.tableRole.setItems(this.mlist.getList());
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.setRoleIds.clear();
            this.setRoleIds.addAll(this.listRoleIds);
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        try {
            LinkedList<Role> listAccount = new LinkedList<Role>();
            listAccount.addAll(this.roleMng.getRoleListByParty(partyId));
            this.mlist.clear();
            this.filterList.clear();
            this.filterList.addAll(listAccount);
            listAccount.forEach(item -> {
                if (this.setRoleIds.contains((Object)item.getId())) {
                    item.setSelected(true);
                }
            });
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
            this.tableRole.sort();
            if (this.selectTableRole == null) {
                return;
            }
            this.tableRole.getSelectionModel().select((Object)this.selectTableRole);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean save() {
        try {
            this.save.set(false);
            this.submit();
        }
        catch (MException e2) {
            this.mAlert.alert(Alert.AlertType.ERROR, e2.getMessage());
            logger.error((Object)e2, (Throwable)e2);
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    private void submit() throws MException {
        boolean k = false;
        MEvent event = new MEvent(1999, "");
        for (String obj : this.setRoleIds) {
            if (this.oldRoleIds.contains((Object)obj)) continue;
            try {
                this.postMng.assignRoleToPost(obj, this.selectPost.getId(), PCommon.Operation.OP_ADD);
                this.oldRoleIds.add((Object)obj);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                this.map.get(obj).setSelected(false);
                event.setDesc(String.valueOf(event.getDesc()) + this.map.get(obj).getName() + e.getDesc() + "\n");
                k = true;
            }
        }
        Iterator it = this.oldRoleIds.iterator();
        while (it.hasNext()) {
            String old = (String)it.next();
            if (this.setRoleIds.contains((Object)old)) continue;
            try {
                this.postMng.assignRoleToPost(old, this.selectPost.getId(), PCommon.Operation.OP_DELETE);
                it.remove();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                this.map.get(old).setSelected(true);
                this.setRoleIds.add((Object)old);
                event.setDesc(String.valueOf(event.getDesc()) + this.map.get(old).getName() + e.getDesc() + "\n");
                k = true;
            }
        }
        this.sendMsgToWeb(this.selectPost);
        if (k) {
            throw new MException(event);
        }
    }

    private void sendMsgToWeb(Post post) {
        if (!StringUtils.isEmpty((String)post.getId())) {
            MEvent event = new MEvent();
            event.put((Object)"type", (Object)"post");
            event.put((Object)"id", (Object)post.getId());
            this.es.postEvent("refresh_web_cache", event);
        }
    }

    public Post getSelectPost() {
        return this.selectPost;
    }

    public void setSelectPost(Post selectPost) {
        this.selectPost = selectPost;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class AutoTableCell<S, T>
    extends TableCell<Role, T> {
        Role role;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else {
                this.role = (Role)Role.class.cast(this.getTableRow().getItem());
                if (this.role == null) {
                    return;
                }
                if (!this.role.getDes().isEmpty()) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(this.role.getDes());
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(this.role.getDes());
            }
        }
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Role, T> {
        Role roleItem;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                this.roleItem = (Role)this.getTableRow().getItem();
                if (this.roleItem == null) {
                    return;
                }
                this.setGraphic((Node)this.checkbox);
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.roleItem));
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!PostRelateRoleTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{PostRelateRoleTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(Role role) {
            PostRelateRoleTabContent.this.save.set(true);
            if (role.selectedProperty().get()) {
                PostRelateRoleTabContent.this.setRoleIds.add((Object)role.getId());
            } else {
                PostRelateRoleTabContent.this.setRoleIds.remove((Object)role.getId());
            }
        }
    }
}

