/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.entity.Party;
import cms.tmx.entity.Post;
import cms.tmx.entity.Product;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostRelateProductDialog
extends DialogObj {
    @FXML
    private TableColumn<Product, String> des;
    @FXML
    private TableColumn<Product, String> partyName;
    @FXML
    private TableColumn<Product, Boolean> selected;
    @FXML
    private TableView<Product> tableProduct;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private ProductMngServiceImpl productMng;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private IUiRightService model;
    private static final Logger logger = LogManager.getLogger(PostRelateProductDialog.class);
    private ObservableList<Product> allProduct = FxUtils.newList();
    private List<String> allProductIds = new LinkedList<String>();
    private List<String> oldChooiceList = new LinkedList<String>();
    private List<String> newChooiceList = new LinkedList<String>();
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private Post post;
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.initValue();
        this.createTableView();
    }

    public ButtonType[] getTypes() {
        if (this.model.registerCheck(new String[]{"updatePostRealateProductControl"})) {
            return super.getTypes();
        }
        this.canUpdate.setValue(Boolean.valueOf(false));
        return new ButtonType[]{ButtonType.CANCEL};
    }

    private void initValue() {
        try {
            this.allProduct = FXCollections.observableList(this.productMng.getProducts(this.postMng.getUserPost().getPartyId()));
            if (this.allProduct.isEmpty()) {
                return;
            }
            this.tableProduct.setItems(this.allProduct);
            this.oldChooiceList = this.productMng.getProductIdsByPostId(this.post.getId());
            this.allProduct.forEach(item -> {
                String id = item.getId();
                this.allProductIds.add(id);
                if (this.oldChooiceList.contains(id)) {
                    item.setSelected(true);
                }
            });
            this.partyTree.getRoot();
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void createTableView() {
        TableUtils.initValueFactory(this.tableProduct);
        this.selected.setCellFactory(cellDate -> new MCheckBoxTableCell());
        this.partyName.setCellValueFactory(cellData -> {
            String partyId = ((Product)cellData.getValue()).getPartyId();
            Party party = this.partyTree.getParty(partyId);
            SimpleStringProperty flage = new SimpleStringProperty("");
            if (party != null) {
                flage.set(party.getName());
                ((Product)cellData.getValue()).setPartyName(flage.get());
            }
            return flage;
        });
    }

    public boolean isOK(ButtonType bt) {
        try {
            FilteredList chooiceRoleList = this.tableProduct.getItems().filtered(item -> item.isSelected());
            for (Product product : chooiceRoleList) {
                String id = product.getId();
                this.newChooiceList.add(id);
                if (this.oldChooiceList.contains(id)) continue;
                this.postMng.assignProductToPost(id, this.post.getId(), PCommon.Operation.OP_ADD);
            }
            for (String id : this.oldChooiceList) {
                if (this.newChooiceList.contains(id) || !this.allProductIds.contains(id)) continue;
                this.postMng.assignProductToPost(id, this.post.getId(), PCommon.Operation.OP_DELETE);
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, String.valueOf(e.getCode()) + e.getMessage());
            logger.error((Object)e, (Throwable)e);
            return false;
        }
        return true;
    }

    public Post getPost() {
        return this.post;
    }

    public void setPost(Post post) {
        this.post = post;
    }

    private class MCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Product, T> {
        Product RoleItem;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                this.RoleItem = (Product)this.getTableRow().getItem();
                if (this.RoleItem == null) {
                    return;
                }
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!PostRelateProductDialog.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{PostRelateProductDialog.this.canUpdate}));
            }
        }
    }
}

