/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.entity.Party;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.Post;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.manage.models.PostMngModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.manage.models.WorkFlowMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostRelatePortfolioTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u6295\u7ec4\u6388\u6743\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableColumn<Portfolio, String> des;
    @FXML
    private TableColumn<Portfolio, String> partyName;
    @FXML
    private TableColumn<Portfolio, Boolean> selected;
    @FXML
    private TableView<Portfolio> tablePortfolio;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private PostMngModel postModel;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private PortfolioMngServiceImpl PortfolioMng;
    @Inject
    private IPortfolioApi portfolioApi;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyFactory pFactory;
    @Inject
    private WorkFlowMngServiceImpl workFlowMng;
    @Inject
    private IUiRightService model;
    private static final Logger logger = LogManager.getLogger(PostRelatePortfolioTabContent.class);
    private Portfolio selectTablePortfolio;
    private Party selectTreeParty;
    private Post selectPost;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<Portfolio> mlist = new MxList();
    private List<Portfolio> filterList = new LinkedList<Portfolio>();
    private List<String> listPortfolioIds = new LinkedList<String>();
    private Map<String, Portfolio> map = new HashMap<String, Portfolio>();
    private ObservableSet<String> setPortfolioIds = FXCollections.observableSet(new HashSet());
    private ObservableSet<String> oldPortfolioIds = FXCollections.observableSet(new HashSet());
    private Predicate<Portfolio> pd = Portfolio2 -> {
        String idName = this.txtSearch.getText().trim();
        return Portfolio2.getName().contains(idName) || Portfolio2.getId().contains(idName);
    };
    private InvalidationListener PortfolioModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tablePortfolio.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectPost = this.postModel.getCommonPost();
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updatePostRealatePortfolioControl"})));
        TreeItem<Party> root = this.initRoot();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> {
            this.initTree(root);
            this.initDefaultValue();
        });
    }

    private void initDefaultValue() {
        TreeItem root = this.treeParty.getRoot();
        this.treeParty.getSelectionModel().select((Object)root);
        this.oldSelectParty = root;
        try {
            if (!this.selectPost.getId().isEmpty()) {
                this.listPortfolioIds.addAll(this.portfolioApi.getPortfolioIdsByPost(this.selectPost.getId()));
            }
            this.oldPortfolioIds.addAll(this.listPortfolioIds);
            this.setPortfolioIds.addAll(this.listPortfolioIds);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
        this.query(((Party)root.getValue()).getId());
        for (Portfolio obj : this.mlist.getList()) {
            this.map.put(obj.getId(), obj);
        }
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.PortfolioModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.tablePortfolio.setOnMouseClicked(event -> {
            if (this.tablePortfolio.getSelectionModel().getSelectedItem() != null) {
                this.selectTablePortfolio = (Portfolio)this.tablePortfolio.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        TableUtils.initValueFactory(this.tablePortfolio);
        this.des.setCellFactory(data -> new AutoTableCell());
        this.selected.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.partyName.setCellValueFactory(cellData -> {
            String partyId = ((Portfolio)cellData.getValue()).getPartyId();
            Party party = this.partyTree.getParty(partyId);
            SimpleStringProperty flage = new SimpleStringProperty("");
            if (party != null) {
                flage.set(party.getName());
                ((Portfolio)cellData.getValue()).setPartyName(flage.get());
            }
            return flage;
        });
        this.tablePortfolio.setItems(this.mlist.getList());
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.setPortfolioIds.clear();
            this.setPortfolioIds.addAll(this.listPortfolioIds);
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        try {
            LinkedList<Portfolio> listAccount = new LinkedList<Portfolio>();
            listAccount.addAll(this.PortfolioMng.getPortfoliosByParty(partyId));
            this.mlist.clear();
            this.filterList.clear();
            this.filterList.addAll(listAccount);
            listAccount.forEach(item -> {
                if (this.setPortfolioIds.contains((Object)item.getId())) {
                    item.setSelected(true);
                }
            });
            this.mlist.update(this.filterList, this.pd);
            if (this.selectTablePortfolio == null) {
                return;
            }
            this.tablePortfolio.getSelectionModel().select((Object)this.selectTablePortfolio);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean save() {
        try {
            this.save.set(false);
            this.submit();
        }
        catch (MException e2) {
            this.mAlert.alert(Alert.AlertType.ERROR, e2.getMessage());
            logger.error((Object)e2, (Throwable)e2);
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    private void submit() throws MException {
        boolean k = false;
        MEvent event = new MEvent(1999, "");
        for (String obj : this.setPortfolioIds) {
            if (this.oldPortfolioIds.contains((Object)obj)) continue;
            try {
                this.postMng.assignPortfolioToPost(obj, this.selectPost.getId(), PCommon.Operation.OP_ADD);
                this.oldPortfolioIds.add((Object)obj);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                this.map.get(obj).setSelected(false);
                event.setDesc(String.valueOf(event.getDesc()) + this.map.get(obj).getName() + e.getDesc() + "\n");
                k = true;
            }
        }
        Iterator it = this.oldPortfolioIds.iterator();
        while (it.hasNext()) {
            String old = (String)it.next();
            if (this.setPortfolioIds.contains((Object)old)) continue;
            try {
                boolean flag = this.workFlowMng.checkInsStatus(old, 2, this.selectPost.getId());
                if (!flag) continue;
                this.postMng.assignPortfolioToPost(old, this.selectPost.getId(), PCommon.Operation.OP_DELETE);
                it.remove();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                this.map.get(old).setSelected(true);
                this.setPortfolioIds.add((Object)old);
                event.setDesc(String.valueOf(event.getDesc()) + this.map.get(old).getName() + e.getDesc() + "\n");
                k = true;
            }
        }
        if (k) {
            throw new MException(event);
        }
    }

    public Post getSelectPost() {
        return this.selectPost;
    }

    public void setSelectPost(Post selectPost) {
        this.selectPost = selectPost;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class AutoTableCell<S, T>
    extends TableCell<Portfolio, T> {
        Portfolio portfolio;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else {
                this.portfolio = (Portfolio)Portfolio.class.cast(this.getTableRow().getItem());
                if (this.portfolio == null) {
                    return;
                }
                if (!this.portfolio.getDes().isEmpty()) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(this.portfolio.getDes());
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(this.portfolio.getDes());
            }
        }
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Portfolio, T> {
        Portfolio roleItem;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                this.roleItem = (Portfolio)this.getTableRow().getItem();
                if (this.roleItem == null) {
                    return;
                }
                this.setGraphic((Node)this.checkbox);
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.roleItem));
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!PostRelatePortfolioTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{PostRelatePortfolioTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(Portfolio role) {
            PostRelatePortfolioTabContent.this.save.set(true);
            if (role.selectedProperty().get()) {
                PostRelatePortfolioTabContent.this.setPortfolioIds.add((Object)role.getId());
            } else {
                PostRelatePortfolioTabContent.this.setPortfolioIds.remove((Object)role.getId());
            }
        }
    }
}

