/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Party;
import cms.tmx.entity.Post;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PostMngModel;
import cms.tmx.manage.parts.PostRelatePortfolioTabContent;
import cms.tmx.rights.IUiRightService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostRelateAssetGrpTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u8d44\u4ea7\u7ec4\u6388\u6743\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    public static final int ERROR_PARTY_NOT_EXIST_CODE = 3066;
    public static final String ERROR_PARTY_NOT_EXIST = "\u8be5\u8282\u70b9\u5b50\u5b59\u8282\u70b9\u4e0d\u5b58\u5728";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableColumn<AssetGrp, String> des;
    @FXML
    private TableColumn<AssetGrp, String> status;
    @FXML
    private TableColumn<AssetGrp, String> partyName;
    @FXML
    private TableColumn<AssetGrp, Boolean> selected;
    @FXML
    private TableView<AssetGrp> tableAssetGrp;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private PostMngModel postModel;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private IAssetGrpApi assetGrpApi;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyFactory pFactory;
    @Inject
    private IUiRightService model;
    private static final Logger logger = LogManager.getLogger(PostRelatePortfolioTabContent.class);
    private AssetGrp selectTableAssetGrp;
    private Party selectTreeParty;
    private Post selectPost;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<AssetGrp> mlist = new MxList();
    private List<AssetGrp> filterList = new LinkedList<AssetGrp>();
    private List<String> listAssetGrpIds = new LinkedList<String>();
    private List<String> setAssetGrpIds = new LinkedList<String>();
    private Boolean all = true;
    private Predicate<AssetGrp> pd = AssetGrp2 -> {
        String idName = this.txtSearch.getText().trim();
        return AssetGrp2.getName().contains(idName) || AssetGrp2.getId().contains(idName);
    };
    private InvalidationListener assetGrpModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAssetGrp.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectPost = this.postModel.getCommonPost();
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updatePostRealateAssetGrpControl"})));
        TreeItem<Party> root = this.initRoot();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> {
            this.initTree(root);
            this.initDefaultValue();
        });
    }

    private void initDefaultValue() {
        TreeItem root = this.treeParty.getRoot();
        this.treeParty.getSelectionModel().select((Object)root);
        this.oldSelectParty = root;
        try {
            if (!this.selectPost.getId().isEmpty()) {
                this.listAssetGrpIds.addAll(this.assetGrpApi.getAssetGrpIdsByPost(this.selectPost.getId()));
            }
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
        if (this.oldSelectParty.getChildren().isEmpty()) {
            this.all = false;
        }
        this.query(((Party)root.getValue()).getId(), this.all);
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.assetGrpModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event, true));
        this.tableAssetGrp.setOnMouseClicked(event -> {
            if (this.tableAssetGrp.getSelectionModel().getSelectedItem() != null) {
                this.selectTableAssetGrp = (AssetGrp)this.tableAssetGrp.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        TableUtils.initValueFactory(this.tableAssetGrp);
        this.des.setCellFactory(data -> new AutoTableCell());
        this.selected.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.status.setCellValueFactory(data -> ((AssetGrp)data.getValue()).statusTextProperty());
        this.partyName.setCellValueFactory(cellData -> {
            String partyId = ((AssetGrp)cellData.getValue()).getPartyId();
            Party party = this.partyTree.getParty(partyId);
            SimpleStringProperty flage = new SimpleStringProperty("");
            if (party != null) {
                flage.set(party.getName());
                ((AssetGrp)cellData.getValue()).setPartyName(flage.get());
            }
            return flage;
        });
        this.tableAssetGrp.setItems(this.mlist.getList());
    }

    private void onItemClicked(MouseEvent event, Boolean all) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        if (item.getChildren().isEmpty()) {
            all = false;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId(), all);
    }

    private void query(String partyId, Boolean all) {
        this.setAssetGrpIds.clear();
        try {
            LinkedList<AssetGrp> assetGrps = new LinkedList<AssetGrp>();
            assetGrps.addAll(this.assetGrpMng.getAssetGrpsByPartyId(partyId, all));
            this.mlist.clear();
            this.filterList.clear();
            assetGrps.forEach(item -> {
                if (this.listAssetGrpIds.contains(item.getId())) {
                    item.setSelected(true);
                    this.setAssetGrpIds.add(item.getId());
                }
            });
            this.filterList.addAll(assetGrps);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
            if (this.selectTableAssetGrp == null) {
                return;
            }
            this.tableAssetGrp.getSelectionModel().select((Object)this.selectTableAssetGrp);
        }
        catch (MException e) {
            if (e.getCode() == 3066) {
                this.mAlert.alert(Alert.AlertType.ERROR, ERROR_PARTY_NOT_EXIST);
            } else {
                Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
            logger.error("\u804c\u4f4d\u6388\u6743\u8d44\u4ea7\u7ec4\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    public boolean save() {
        try {
            this.save.set(false);
            this.submit();
        }
        catch (MException e2) {
            this.mAlert.alert(Alert.AlertType.ERROR, e2.getMessage());
            logger.error((Object)e2, (Throwable)e2);
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    private void submit() throws MException {
        try {
            this.assetGrpApi.assignAssetGrpToPost(this.setAssetGrpIds, this.selectPost.getId());
        }
        catch (MException e) {
            logger.error("\u804c\u4f4d\u5173\u8054\u8d44\u4ea7\u7ec4\u5f02\u5e38", (Throwable)e);
        }
    }

    public Post getSelectPost() {
        return this.selectPost;
    }

    public void setSelectPost(Post selectPost) {
        this.selectPost = selectPost;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class AutoTableCell<S, T>
    extends TableCell<AssetGrp, T> {
        AssetGrp assetGrp;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else {
                this.assetGrp = (AssetGrp)AssetGrp.class.cast(this.getTableRow().getItem());
                if (this.assetGrp == null) {
                    return;
                }
                if (!this.assetGrp.getDes().isEmpty()) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(this.assetGrp.getDes());
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(this.assetGrp.getDes());
            }
        }
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<AssetGrp, T> {
        AssetGrp assetGrpItem;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                this.assetGrpItem = (AssetGrp)this.getTableRow().getItem();
                if (this.assetGrpItem == null) {
                    return;
                }
                this.setGraphic((Node)this.checkbox);
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.assetGrpItem));
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!PostRelateAssetGrpTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{PostRelateAssetGrpTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(AssetGrp assetGrp) {
            PostRelateAssetGrpTabContent.this.save.set(true);
            if (assetGrp.selectedProperty().get()) {
                PostRelateAssetGrpTabContent.this.setAssetGrpIds.add(assetGrp.getId());
            } else {
                PostRelateAssetGrpTabContent.this.setAssetGrpIds.remove(assetGrp.getId());
            }
        }
    }
}

