/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.Post;
import cms.tmx.entity.ProductAccount;
import cms.tmx.entity.factory.AccountFactory;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PostMngModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.manage.models.PostRelateAccntModel;
import cms.tmx.manage.models.WorkFlowMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostRelateAccountTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u8d26\u6237\u6388\u6743\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<ProductAccount> tableAccnt;
    @FXML
    private TableColumn<MxObject, String> index;
    @FXML
    private TableColumn<MxObject, Boolean> select;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @FXML
    public CheckBox cboxAutoAss;
    @Inject
    private PostMngModel postModel;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private PostRelateAccntModel praModel;
    @Inject
    private AccountFactory af;
    @Inject
    private PartyFactory pFactory;
    @Inject
    private WorkFlowMngServiceImpl workFlowMng;
    @Inject
    private IUiRightService model;
    private ProductAccount selectTableAccnt;
    private Party selectTreeParty;
    private Post selectPost;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<ProductAccount> mlist = new MxList();
    private List<ProductAccount> filterList = new LinkedList<ProductAccount>();
    private static final Logger logger = LogManager.getLogger(PostRelateAccountTabContent.class);
    private List<ProductAccount> listAccnts = new LinkedList<ProductAccount>();
    private Map<String, ProductAccount> mapAccnts = new HashMap<String, ProductAccount>();
    private ObservableSet<ProductAccount> setAccnts = FXCollections.observableSet(new HashSet());
    private ObservableSet<ProductAccount> oldAccnts = FXCollections.observableSet(new HashSet());
    private Predicate<ProductAccount> pd = obj -> {
        ProductAccount accnt;
        String idName = this.txtSearch.getText().trim();
        return obj instanceof ProductAccount && ((accnt = obj).getName().contains(idName) || accnt.getInvestorId().contains(idName) || accnt.getProductName().contains(idName));
    };
    private InvalidationListener accntModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAccnt.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectPost = this.postModel.getCommonPost();
        this.cboxAutoAss.setSelected(this.selectPost.isAutoAssocaite());
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updatePostRealateAccountControl"})));
        TreeItem<Party> root = this.initRoot();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> {
            this.initTree(root);
            this.initDefaultValue();
        });
    }

    private void initDefaultValue() {
        TreeItem root = this.treeParty.getRoot();
        this.treeParty.getSelectionModel().select((Object)root);
        this.oldSelectParty = root;
        try {
            ObservableList<Account> l = this.accountMng.getAccountListByPost(this.selectPost.getId());
            for (Account a : l) {
                ProductAccount pa = this.af.createProductAccount();
                pa.update((Object)a);
                this.listAccnts.add(pa);
            }
            this.oldAccnts.addAll(this.listAccnts);
            this.setAccnts.addAll(this.listAccnts);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
        this.query(((Party)root.getValue()).getId());
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.accntModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.tableAccnt.setOnMouseClicked(event -> {
            if (this.tableAccnt.getSelectionModel().getSelectedItem() != null) {
                this.selectTableAccnt = (ProductAccount)this.tableAccnt.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        TableUtils.isAuto(this.index);
        TableUtils.isCheckBox(this.select);
        ((TableColumn)this.tableAccnt.getColumns().get(2)).setCellValueFactory((Callback)new PropertyValueFactory("productName"));
        ((TableColumn)this.tableAccnt.getColumns().get(3)).setCellValueFactory((Callback)new PropertyValueFactory("productPartyName"));
        ((TableColumn)this.tableAccnt.getColumns().get(4)).setCellValueFactory((Callback)new PropertyValueFactory("investorId"));
        ((TableColumn)this.tableAccnt.getColumns().get(5)).setCellValueFactory((Callback)new PropertyValueFactory("name"));
        ((TableColumn)this.tableAccnt.getColumns().get(6)).setCellValueFactory((Callback)new PropertyValueFactory("status"));
        ((TableColumn)this.tableAccnt.getColumns().get(7)).setCellValueFactory((Callback)new PropertyValueFactory("secExchange"));
        ((TableColumn)this.tableAccnt.getColumns().get(8)).setCellValueFactory((Callback)new PropertyValueFactory("partyName"));
        this.select.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.select.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.tableAccnt.setItems(this.mlist.getList());
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.setAccnts.clear();
            this.setAccnts.addAll(this.listAccnts);
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        try {
            LinkedList<ProductAccount> listAccount = new LinkedList<ProductAccount>();
            listAccount.addAll(this.praModel.query(partyId));
            this.mlist.clear();
            this.filterList.clear();
            listAccount.forEach(item -> {
                this.filterList.add((ProductAccount)item);
                this.mapAccnts.put(item.getId(), (ProductAccount)item);
            });
            listAccount.forEach(item -> {
                ProductAccount acct;
                if (item instanceof ProductAccount && this.setAccnts.contains((Object)(acct = (ProductAccount)ProductAccount.class.cast(item)))) {
                    item.setSelected(true);
                }
            });
            this.mlist.update(this.filterList, this.pd);
            if (this.selectTableAccnt == null) {
                return;
            }
            this.tableAccnt.getSelectionModel().select((Object)this.selectTableAccnt);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean save() {
        try {
            this.save.set(false);
            this.submit();
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            this.mAlert.alert(Alert.AlertType.ERROR, e2.getMessage());
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    private void submit() throws MException {
        boolean k = false;
        MEvent event = new MEvent(1999, "");
        for (ProductAccount obj : this.setAccnts) {
            if (this.oldAccnts.contains((Object)obj)) continue;
            try {
                this.postMng.assignAccountToPost(obj.getId(), this.selectPost.getId(), PCommon.Operation.OP_ADD);
                this.oldAccnts.add((Object)obj);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                this.mapAccnts.get(obj.getId()).setSelected(false);
                event.setDesc(String.valueOf(event.getDesc()) + obj.getInvestorId() + e.getDesc() + "\n");
                k = true;
            }
        }
        Iterator it = this.oldAccnts.iterator();
        while (it.hasNext()) {
            ProductAccount old = (ProductAccount)it.next();
            if (this.setAccnts.contains((Object)old)) continue;
            try {
                boolean flag = this.workFlowMng.checkInsStatus(old.getId(), 1, this.selectPost.getId());
                if (!flag) continue;
                this.postMng.assignAccountToPost(old.getId(), this.selectPost.getId(), PCommon.Operation.OP_DELETE);
                it.remove();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                this.mapAccnts.get(old.getId()).setSelected(true);
                this.setAccnts.add((Object)old);
                event.setDesc(String.valueOf(event.getDesc()) + old.getInvestorId() + e.getDesc() + "\n");
                k = true;
            }
        }
        if (k) {
            throw new MException(event);
        }
    }

    public Post getSelectPost() {
        return this.selectPost;
    }

    public void setSelectPost(Post selectPost) {
        this.selectPost = selectPost;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    @FXML
    public void autoAssocaite() {
        try {
            this.selectPost.setAutoAssocaite(this.cboxAutoAss.isSelected());
            this.postMng.updatePost(this.selectPost);
        }
        catch (MException e) {
            logger.error("post auto assocaite failed", (Throwable)e);
        }
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<MxObject, T> {
        MxObject obj;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (this.getTableRow().getItem() instanceof ProductAccount) {
                    this.obj = (MxObject)ProductAccount.class.cast(this.getTableRow().getItem());
                }
                if (this.obj == null) {
                    return;
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.obj));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!PostRelateAccountTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{PostRelateAccountTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(MxObject obj) {
            PostRelateAccountTabContent.this.save.set(true);
            if (obj instanceof ProductAccount) {
                ProductAccount accnt = (ProductAccount)ProductAccount.class.cast(obj);
                if (accnt.selectedProperty().get()) {
                    PostRelateAccountTabContent.this.setAccnts.add((Object)accnt);
                } else {
                    PostRelateAccountTabContent.this.setAccnts.remove((Object)accnt);
                }
            }
        }
    }
}

