/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.PartyControl;
import cms.tmx.entity.Post;
import cms.tmx.entity.PostControl;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PostMngModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostControlTabContent
extends MxTabContent {
    @FXML
    public CheckBox cboxMac;
    @FXML
    public TextField txtMac;
    @FXML
    public Label lbMacError;
    @FXML
    public Button btnAddMac;
    @FXML
    public TableView<PostControl> tableMac;
    @FXML
    public TableColumn<PostControl, String> index;
    @FXML
    public TableColumn<PostControl, String> colMac;
    @FXML
    public TableColumn<PostControl, HBox> colOperaMac;
    @FXML
    public CheckBox cboxIp;
    @FXML
    public TextField txtIp;
    @FXML
    public Label lbIpError;
    @FXML
    public Button btnAddIp;
    @FXML
    public TableView<PostControl> tableIp;
    @FXML
    public TableColumn<PostControl, String> indexIp;
    @FXML
    public TableColumn<PostControl, String> colIp;
    @FXML
    public TableColumn<PostControl, HBox> colOperaIp;
    @FXML
    public Label lbMessage;
    @FXML
    public Label lbMessageSpec;
    @FXML
    public Button btnSave;
    @FXML
    private Label labSuccess;
    @Inject
    public PostMngServiceImpl postMng;
    @Inject
    public PartyMngServiceImpl partyMng;
    @Inject
    private MObjFactory of;
    @Inject
    public ExecutorService exe;
    @Inject
    private PostMngModel postModel;
    private ObservableList<PostControl> listMac = FxUtils.newList();
    private ObservableList<PostControl> listIp = FxUtils.newList();
    private ObservableList<PartyControl> listPartyMac = FxUtils.newList();
    private ObservableList<PartyControl> listPartyIp = FxUtils.newList();
    private Post selectPost;
    @Inject
    private MxAlert alert;
    public static final Logger logger = LogManager.getLogger(PostControlTabContent.class);
    private static final int ADD_POSTCONTROL = 1;
    private static final int UPDATE_POSTCONTROL = 2;
    private static final int DELETE_POSTCONTROL = 3;
    private static final String ERROR_PARTY_NOT_MAC_CONTROL = "\u65e0\u6cd5\u6dfb\u52a0\uff0c\u8bf7\u5148\u5728\"\u57fa\u7840\u7ba1\u7406->\u673a\u6784\u7ba1\u7406\"\u9762\u677f\u542f\u7528\u6240\u5728\u673a\u6784\u7684MAC\u63a7\u5236\u529f\u80fd\uff0c\u518d\u56de\u5230\u672c\u9875\u9762\u91cd\u65b0\u6dfb\u52a0";
    private static final String ERROR_PARTY_NOT_IP_CONTROL = "\u65e0\u6cd5\u6dfb\u52a0\uff0c\u8bf7\u5148\u5728\"\u57fa\u7840\u7ba1\u7406->\u673a\u6784\u7ba1\u7406\"\u9762\u677f\u542f\u7528\u6240\u5728\u673a\u6784\u7684IP\u63a7\u5236\u529f\u80fd\uff0c\u518d\u56de\u5230\u672c\u9875\u9762\u91cd\u65b0\u6dfb\u52a0";
    private List<PartyControl> pCList = FxUtils.newList();

    @FXML
    public void initialize() {
        this.selectPost = this.postModel.getCommonPost();
        this.labSuccess.setVisible(false);
        this.exe.execute(() -> {
            this.initValues();
            this.initPartyControl();
        });
        this.addListener();
        this.createTableView();
        this.initBtn();
        this.initTextField();
    }

    public void initTextField() {
        this.txtMac.setTextFormatter((TextFormatter)new MxFormatter("^([0-9a-fA-F]{1,2})(([0-9a-fA-F]{0,2}){0,5})$", 12));
        this.txtIp.setTextFormatter((TextFormatter)new MxFormatter("^([0-9]{1,3})((\\.[0-9]{0,3}){0,3})$", 15));
    }

    public void initBtn() {
        this.btnAddIp.disableProperty().bind((ObservableValue)this.txtIp.textProperty().isEmpty());
        this.btnAddMac.disableProperty().bind((ObservableValue)this.txtMac.textProperty().isEmpty());
    }

    public void addListener() {
        this.tableMac.disableProperty().bind((ObservableValue)this.cboxMac.selectedProperty().not());
        this.tableIp.disableProperty().bind((ObservableValue)this.cboxIp.selectedProperty().not());
        this.lbMessageSpec.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.lbMessageSpec.setOpacity(0.0);
            }
        });
        this.txtMac.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbMacError.setOpacity(0.0);
                this.lbMacError.setText("");
            }
        });
        this.txtIp.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbIpError.setOpacity(0.0);
                this.lbIpError.setText("");
            }
        });
    }

    public void initValues() {
        try {
            this.listMac.clear();
            this.listIp.clear();
            List<PostControl> list = this.postMng.getPostControl(this.selectPost.getId());
            if (list == null || list.isEmpty()) {
                return;
            }
            Map<Integer, List<PostControl>> map = list.stream().collect(Collectors.groupingBy(PostControl::getType));
            this.listMac.addAll(map.get(PostControlType.MAC.code) == null ? this.listMac : FXCollections.observableList(map.get(PostControlType.MAC.code)));
            this.listIp.addAll(map.get(PostControlType.IP.code) == null ? this.listIp : FXCollections.observableList(map.get(PostControlType.IP.code)));
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u804c\u4f4d\u63a7\u5236\u5f02\u5e38", (Throwable)e);
            this.lbMessage.setText(e.getMessage().isEmpty() ? "\u67e5\u8be2\u804c\u4f4d\u63a7\u5236\u5f02\u5e38" : e.getMessage());
        }
        Platform.runLater(() -> {
            this.cboxMac.setSelected(this.listMac.isEmpty() ? false : ((PostControl)this.listMac.get(0)).isFlag());
            this.cboxIp.setSelected(this.listIp.isEmpty() ? false : ((PostControl)this.listIp.get(0)).isFlag());
        });
    }

    private void initPartyControl() {
        try {
            this.listPartyMac.clear();
            this.listPartyIp.clear();
            this.pCList.clear();
            List<PartyControl> list = this.partyMng.getPartyControl(this.selectPost.getPartyId());
            if (!list.isEmpty()) {
                list.forEach(item -> {
                    if (item.isFlag()) {
                        this.pCList.add((PartyControl)item);
                    }
                });
            }
            if (this.pCList.isEmpty()) {
                return;
            }
            Map<Integer, List<PartyControl>> map = this.pCList.stream().collect(Collectors.groupingBy(PartyControl::getType));
            this.listPartyMac.addAll(map.get(PostControlType.MAC.code) == null ? this.listPartyMac : FXCollections.observableList(map.get(PostControlType.MAC.code)));
            this.listPartyIp.addAll(map.get(PostControlType.IP.code) == null ? this.listPartyIp : FXCollections.observableList(map.get(PostControlType.IP.code)));
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u673a\u6784\u63a7\u5236\u5f02\u5e38", (Throwable)e);
            this.lbMessage.setText(e.getMessage().isEmpty() ? "\u67e5\u8be2\u673a\u6784\u63a7\u5236\u5f02\u5e38" : e.getMessage());
        }
        Platform.runLater(() -> {
            this.cboxMac.setSelected(this.listMac.isEmpty() ? false : ((PostControl)this.listMac.get(0)).isFlag());
            this.cboxIp.setSelected(this.listIp.isEmpty() ? false : ((PostControl)this.listIp.get(0)).isFlag());
        });
    }

    public void createTableView() {
        TableUtils.isAuto(this.index);
        this.index.setSortable(false);
        TableUtils.isAuto(this.indexIp);
        this.indexIp.setSortable(false);
        this.colMac.setCellValueFactory(data -> ((PostControl)data.getValue()).valueProperty());
        this.colIp.setCellValueFactory(data -> ((PostControl)data.getValue()).valueProperty());
        this.colOperaMac.setCellValueFactory(data -> this.setOperateMac((PostControl)data.getValue()));
        this.colOperaIp.setCellValueFactory(data -> this.setOperateIp((PostControl)data.getValue()));
        this.tableMac.setPlaceholder((Node)new Label());
        this.tableIp.setPlaceholder((Node)new Label());
        this.tableMac.setItems(this.listMac);
        this.tableIp.setItems(this.listIp);
    }

    public ReadOnlyObjectWrapper<HBox> setOperateMac(final PostControl ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                PostControlTabContent.this.tableMac.getSelectionModel().select((Object)ap);
                if (PostControlTabContent.this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664?")) {
                    PostControlTabContent.this.delMac();
                }
            }
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    public ReadOnlyObjectWrapper<HBox> setOperateIp(final PostControl ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                PostControlTabContent.this.tableIp.getSelectionModel().select((Object)ap);
                if (PostControlTabContent.this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664?")) {
                    PostControlTabContent.this.delIp();
                }
            }
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    @FXML
    public void addMac() {
        if (this.listPartyMac.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, ERROR_PARTY_NOT_MAC_CONTROL);
            return;
        }
        if (!this.checkMac()) {
            return;
        }
        PostControl mac = new PostControl();
        mac.setType(PostControlType.MAC.code);
        mac.setValue(this.txtMac.getText());
        try {
            this.postMng.operatePostControl(mac, 1, this.selectPost.getId(), this.selectPost.getPartyId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
            this.initValues();
            this.txtMac.clear();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u65b0\u589e\u804c\u4f4d\u63a7\u5236Mac\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean checkMac() {
        if (!this.txtMac.getText().isEmpty() && !StringUtils.isMac((String)this.txtMac.getText())) {
            this.lbMacError.setText("\u8bf7\u8f93\u5165\u6b63\u786eMac");
            this.lbMacError.setOpacity(1.0);
            return false;
        }
        if (!this.listMac.isEmpty() && this.listMac.stream().filter(item -> item.getValue().equalsIgnoreCase(this.txtMac.getText())).findFirst().isPresent()) {
            this.lbMacError.setText("Mac\u5df2\u5b58\u5728");
            this.lbMacError.setOpacity(1.0);
            return false;
        }
        return true;
    }

    @FXML
    public void addIp() {
        if (this.listPartyIp.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, ERROR_PARTY_NOT_IP_CONTROL);
            return;
        }
        if (!this.checkIp()) {
            return;
        }
        PostControl ip = new PostControl();
        ip.setType(PostControlType.IP.code);
        ip.setValue(this.txtIp.getText());
        try {
            this.postMng.operatePostControl(ip, 1, this.selectPost.getId(), this.selectPost.getPartyId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
            this.initValues();
            this.txtIp.clear();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u65b0\u589e\u804c\u4f4d\u63a7\u5236Ip\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean checkIp() {
        if (!this.txtIp.getText().isEmpty() && !StringUtils.isIp((String)this.txtIp.getText())) {
            this.lbIpError.setText("\u8bf7\u8f93\u5165\u6b63\u786eIp");
            this.lbIpError.setOpacity(1.0);
            return false;
        }
        if (!this.listIp.isEmpty() && this.listIp.stream().filter(item -> item.getValue().equalsIgnoreCase(this.txtIp.getText())).findFirst().isPresent()) {
            this.lbIpError.setText("Ip\u5df2\u5b58\u5728");
            this.lbIpError.setOpacity(1.0);
            return false;
        }
        return true;
    }

    @FXML
    private void delMac() {
        PostControl item = (PostControl)this.tableMac.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        PostControl control = (PostControl)this.of.create(PostControl.class);
        control.update((Object)item);
        try {
            this.postMng.operatePostControl(control, 3, this.selectPost.getId(), this.selectPost.getPartyId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u6210\u529f", "\u63d0\u793a");
            this.listMac.remove((Object)control);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u5220\u9664\u804c\u4f4d\u63a7\u5236Mac\u5931\u8d25", (Throwable)e);
        }
        this.initValues();
    }

    private void delIp() {
        PostControl item = (PostControl)this.tableIp.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        PostControl control = (PostControl)this.of.create(PostControl.class);
        control.update((Object)item);
        try {
            this.postMng.operatePostControl(control, 3, this.selectPost.getId(), this.selectPost.getPartyId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u6210\u529f", "\u63d0\u793a");
            this.listIp.remove((Object)control);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u5220\u9664\u804c\u4f4d\u63a7\u5236Ip\u5931\u8d25", (Throwable)e);
        }
    }

    @FXML
    public boolean savePostControl() {
        this.valid();
        if (this.listMac.isEmpty() && this.cboxMac.isSelected() || this.listIp.isEmpty() && this.cboxIp.isSelected()) {
            this.lbMessageSpec.setOpacity(1.0);
            Platform.runLater(() -> this.lbMessageSpec.requestFocus());
            return false;
        }
        LinkedList<PostControl> PostControls = new LinkedList<PostControl>();
        PostControls.addAll((Collection<PostControl>)this.listMac);
        PostControls.addAll((Collection<PostControl>)this.listIp);
        try {
            this.postMng.updatePostControl(PostControls, 2, this.selectPost.getId(), this.selectPost.getPartyId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
        }
        catch (MException e2) {
            logger.error("\u804c\u4f4d\u63a7\u5236\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25", (Throwable)e2);
            Platform.runLater(() -> {
                this.lbMessage.setText(e2.getMessage().isEmpty() ? "\u804c\u4f4d\u63a7\u5236\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25" : e2.getMessage());
                this.lbMessage.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Post getSelectPost() {
        return this.selectPost;
    }

    public void setSelectPost(Post selectPost) {
        this.selectPost = selectPost;
    }

    static enum PostControlType {
        MAC("mac", 1),
        IP("ip", 2);

        private String desc;
        private int code;

        private PostControlType(String desc, int code) {
            this.desc = desc;
            this.code = code;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getCode() {
            return this.code;
        }
    }
}

