/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PortfolioMngModel;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.manage.models.PortfolioRelateAccntModel;
import cms.tmx.rights.IUiRightService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortfolioRelateAccountTabContent
extends MxTabContent {
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Account> tableAccnt;
    @FXML
    private TableColumn<Account, String> index;
    @FXML
    private TableColumn<Account, Boolean> selected;
    @FXML
    private TableView<SecAccount> tableView;
    @FXML
    private TableColumn<SecAccount, String> secIndex;
    @FXML
    private TableColumn<SecAccount, Boolean> secSelected;
    @FXML
    private TableColumn<SecAccount, String> inverstorId;
    @FXML
    private TableColumn<SecAccount, String> inverstorSecId;
    @FXML
    private TableColumn<SecAccount, MxNode> exchange;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private PortfolioMngModel portfolioMngModel;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private PortfolioRelateAccntModel praModel;
    @Inject
    private MxAlert mAlert;
    @Inject
    private IUiRightService model;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyFactory pFactory;
    private Account selectTableAccnt;
    private Party selectTreeParty;
    private Portfolio selectPortfolio;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty btnDisable = new SimpleBooleanProperty(true);
    private MxList<Account> mlist = new MxList();
    private List<Account> filterList = new LinkedList<Account>();
    private MxList<SecAccount> secAccnts = new MxList();
    private static final Logger logger = LogManager.getLogger(PortfolioRelateAccountTabContent.class);
    private static final String SURE_NOT_SAVE = "\u6295\u7ec4\u8d26\u6237\u6743\u9650\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    protected CheckBox cBox = new CheckBox();
    private List<String> listAccnts = new LinkedList<String>();
    private Map<String, PPortfolio.PortAccntAssignDetails> oldAssMap = new HashMap<String, PPortfolio.PortAccntAssignDetails>();
    private Map<String, Account> map = new HashMap<String, Account>();
    private ObservableSet<String> oldAccnts = FXCollections.observableSet(new HashSet());
    private List<SecAccount> oldSelects = new LinkedList<SecAccount>();
    private List<SecAccount> newSelects = new LinkedList<SecAccount>();
    private Predicate<Account> pd = obj -> {
        String idName = this.txtSearch.getText().trim();
        if (obj instanceof Account) {
            Account accnt = (Account)Account.class.cast(obj);
            if (!this.selectPortfolio.getId().isEmpty() && this.selectPortfolio.isExternalAsset() != accnt.isExternalAsset()) {
                return false;
            }
            if (accnt.getName().contains(idName) || accnt.getInvestorId().contains(idName)) {
                return true;
            }
        }
        return false;
    };
    private InvalidationListener accntModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAccnt.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectPortfolio = this.portfolioMngModel.getCommonPortfolio();
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updatePortfolioAssignAccntControl"})));
        TreeItem<Party> root = this.initRoot();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> {
            this.initTree(root);
            this.initDefaultValue();
        });
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void initDefaultValue() {
        TreeItem root = this.treeParty.getRoot();
        this.treeParty.getSelectionModel().select((Object)root);
        this.oldSelectParty = root;
        try {
            for (PPortfolio.PortAccntAssignDetails detail : this.portfolioMng.getAccntIdoByPortfolio(this.selectPortfolio.getId())) {
                if (detail.getAccntType() == 2 && detail.getAssignStatus() == 1) {
                    this.listAccnts.add(detail.getParentId());
                }
                this.oldAssMap.put(detail.getParentId(), detail);
            }
            this.oldAccnts.addAll(this.listAccnts);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
        this.query(((Party)root.getValue()).getId());
        for (MxObject obj : this.mlist.getList()) {
            if (!(obj instanceof Account)) continue;
            Account accnt = (Account)obj;
            this.map.put(accnt.getId(), accnt);
        }
        this.praModel.setSelectPortfolio(this.selectPortfolio);
        this.praModel.setOldAccnts(this.oldAccnts);
        this.praModel.setMap(this.map);
        this.praModel.setOldAssMap(this.oldAssMap);
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.accntModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.tableAccnt.setOnMouseClicked(event -> this.onAccountTableClicked((MouseEvent)event));
        this.btnSave.disableProperty().bind((ObservableValue)this.btnDisable);
        this.cBox.setOnMouseClicked(e -> {
            this.btnDisable.setValue(Boolean.valueOf(false));
            ObservableList observableList = this.secAccnts.getList();
            synchronized (observableList) {
                this.secAccnts.getList().forEach(event -> event.setSelected(this.cBox.isSelected()));
            }
            this.newSelects.clear();
            if (this.cBox.isSelected()) {
                this.newSelects.addAll((Collection<SecAccount>)this.secAccnts.getList());
            }
        });
        this.portfolioMng.addExternalAssetChangedProperty().addListener(this.accntModel);
    }

    @PreDestroy
    private void close() {
        this.portfolioMng.addExternalAssetChangedProperty().removeListener(this.accntModel);
    }

    private void createTableView() {
        TableUtils.isAuto(this.index);
        ((TableColumn)this.tableAccnt.getColumns().get(2)).setCellValueFactory((Callback)new PropertyValueFactory("investorId"));
        ((TableColumn)this.tableAccnt.getColumns().get(3)).setCellValueFactory((Callback)new PropertyValueFactory("name"));
        ((TableColumn)this.tableAccnt.getColumns().get(4)).setCellValueFactory((Callback)new PropertyValueFactory("status"));
        ((TableColumn)this.tableAccnt.getColumns().get(5)).setCellValueFactory((Callback)new PropertyValueFactory("secExchange"));
        ((TableColumn)this.tableAccnt.getColumns().get(6)).setCellValueFactory((Callback)new PropertyValueFactory("partyName"));
        this.selected.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.selected.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.tableAccnt.setItems(this.mlist.getList());
        this.tableAccnt.setEditable(false);
        TableUtils.initValueFactory(this.tableView);
        TableUtils.isAuto(this.secIndex);
        this.secSelected.setGraphic((Node)this.cBox);
        this.secSelected.setSortable(false);
        this.secSelected.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.secSelected.setCellFactory(cellDate -> new SecCheckBoxTableCell());
        this.tableView.setEditable(true);
        this.tableView.setItems(this.secAccnts.getList());
        this.tableView.setPlaceholder((Node)new Label());
    }

    private void onAccountTableClicked(MouseEvent event) {
        if (this.tableAccnt.getSelectionModel().getSelectedItem() == null) {
            return;
        }
        if (!this.btnDisable.get() && this.secAccnts.getList().size() > 0 && !this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
            this.tableAccnt.getSelectionModel().select((Object)this.selectTableAccnt);
            return;
        }
        this.btnDisable.setValue(Boolean.valueOf(true));
        this.selectTableAccnt = (Account)this.tableAccnt.getSelectionModel().getSelectedItem();
        Account account = (Account)Account.class.cast(this.selectTableAccnt);
        try {
            List<SecAccount> list = this.praModel.getSecAccounts(account);
            this.oldSelects.clear();
            this.newSelects.clear();
            this.secAccnts.clear();
            for (SecAccount secAccount : list) {
                if (!secAccount.isSelected()) continue;
                this.oldSelects.add(secAccount);
                this.newSelects.add(secAccount);
            }
            this.secAccnts.addAll(list);
            this.cBox.setSelected(false);
        }
        catch (MException | Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, e);
        }
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (!this.btnDisable.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.oldSelects.clear();
            this.newSelects.clear();
            this.secAccnts.clear();
            this.cBox.setSelected(false);
            this.btnDisable.set(true);
        }
        if ((item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem()) != null && this.oldSelectParty != null && ((Party)item.getValue()).getId().equals(((Party)this.oldSelectParty.getValue()).getId())) {
            return;
        }
        this.oldSelectParty = item;
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        try {
            LinkedList<Account> listAccount = new LinkedList<Account>();
            listAccount.addAll((Collection<Account>)this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            listAccount.addAll((Collection<Account>)this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            this.mlist.clear();
            this.filterList.clear();
            this.filterList.addAll(listAccount);
            this.mlist.update(this.filterList, this.pd);
            listAccount.forEach(item -> {
                Account acct;
                if (item instanceof Account && this.oldAccnts.contains((Object)(acct = (Account)Account.class.cast(item)).getId())) {
                    acct.setSelected(true);
                }
            });
            if (this.selectTableAccnt == null) {
                return;
            }
            this.tableAccnt.getSelectionModel().select((Object)this.selectTableAccnt);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FXML
    public boolean save() {
        try {
            String oldAccntId;
            if (this.selectPortfolio.isExternalAsset() && this.oldAccnts.size() >= 1 && !(oldAccntId = (String)this.oldAccnts.iterator().next()).equals(this.selectTableAccnt.getId())) {
                String topInfo = "\u5916\u90e8\u8d44\u4ea7\u6295\u7ec4\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff0c\u8be5\u64cd\u4f5c\u5c06\u4f1a\u53d6\u6d88\u5173\u8054\u539f\u6709\u8d44\u4ea7\u8d26\u53f7\uff0c\u540c\u65f6\u5173\u8054\u5f53\u524d\u52fe\u9009\u7684\u8d44\u91d1\u8d26\u53f7";
                if (!this.mAlert.check(false, Alert.AlertType.CONFIRMATION, topInfo)) {
                    return false;
                }
                for (Account item : this.mlist.getList()) {
                    Account acct;
                    if (!(item instanceof Account) || !oldAccntId.equals((acct = (Account)Account.class.cast(item)).getId())) continue;
                    List<SecAccount> listOldAcc = this.praModel.getSecAccounts(acct).stream().filter(sec -> sec.isSelected()).collect(Collectors.toList());
                    this.praModel.submitNew(acct, listOldAcc, new LinkedList<SecAccount>(), listOldAcc.size());
                    acct.setSelected(false);
                }
            }
            this.btnDisable.set(true);
            this.praModel.submitNew(this.selectTableAccnt, this.oldSelects, this.newSelects, this.secAccnts.getList().size());
            this.oldSelects.clear();
            this.oldSelects.addAll(this.newSelects);
            this.selectTableAccnt.setSelected(!this.newSelects.isEmpty());
            this.tableAccnt.refresh();
        }
        catch (MException | Exception e2) {
            this.mAlert.alert(Alert.AlertType.ERROR, e2.getMessage());
            logger.error((Object)e2, e2);
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    public Portfolio getSelectPortfolio() {
        return this.selectPortfolio;
    }

    public void setSelectPortfolio(Portfolio selectPortfolio) {
        this.selectPortfolio = selectPortfolio;
    }

    public final BooleanProperty saveProperty() {
        return this.btnDisable;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Account, T> {
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.setGraphic((Node)this.checkbox);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private class SecCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<SecAccount, T> {
        SecAccount obj;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (this.getTableRow().getItem() instanceof SecAccount) {
                    this.obj = (SecAccount)SecAccount.class.cast(this.getTableRow().getItem());
                }
                if (this.obj == null) {
                    return;
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.obj));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!PortfolioRelateAccountTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{PortfolioRelateAccountTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(SecAccount obj) {
            PortfolioRelateAccountTabContent.this.btnDisable.set(false);
            if (obj.selectedProperty().get()) {
                if (!PortfolioRelateAccountTabContent.this.newSelects.contains(obj)) {
                    PortfolioRelateAccountTabContent.this.newSelects.add(obj);
                }
            } else if (PortfolioRelateAccountTabContent.this.newSelects.contains(obj)) {
                PortfolioRelateAccountTabContent.this.newSelects.remove(obj);
            }
            PortfolioRelateAccountTabContent.this.tableAccnt.refresh();
        }
    }
}

