/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.entity.factory.PortfolioFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AddPortfolioDialog;
import cms.tmx.manage.parts.FundTransferDialog;
import cms.tmx.manage.parts.UpdatePortfolioDialog;
import cms.tmx.rights.IUiRightService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortfolioMngPart
extends MxPart {
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Portfolio> tablePortfolio;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<Portfolio, MxNode> type;
    @FXML
    private TableColumn<Portfolio, String> validityPeriod;
    @FXML
    private TableColumn<Portfolio, Number> duration;
    @FXML
    private TableColumn<Portfolio, String> benchmark;
    @FXML
    private TableColumn<Portfolio, String> des;
    @FXML
    private TableColumn<Portfolio, String> colOpera;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @FXML
    private Button btnFundTransfer;
    @FXML
    private Button btnPosiTransfer;
    @FXML
    private Button btnPosiOtcTransfer;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private MObjFactory of;
    @Inject
    private PortfolioFactory pf;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @FXML
    private TableColumn<Portfolio, String> creator;
    @FXML
    private TableColumn<Portfolio, String> updater;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private PartyFactory pFactory;
    @FXML
    private TableColumn<Portfolio, String> shares;
    private TreeItem<Party> root;
    private Portfolio selectTablePortfolio;
    private TreeItem<Party> selectTreeParty;
    private MxList<Portfolio> mlist = new MxList();
    private List<Portfolio> filterList = new LinkedList<Portfolio>();
    private static final Logger logger = LogManager.getLogger(PortfolioMngPart.class);
    private static final String IS_ENABLE_PORTFOLIO = "\u662f\u5426\u542f\u7528\u8be5\u6295\u8d44\u7ec4\u5408";
    private static final String IS_DISABLE_PORTFOLIO = "\u662f\u5426\u505c\u7528\u8be5\u6295\u8d44\u7ec4\u5408";
    private static final String ALERT = "\u63d0\u793a";
    private Predicate<Portfolio> pd = portfolio -> {
        String name = this.txtSearch.getText().trim();
        return portfolio.getName().contains(name);
    };
    private InvalidationListener portfolioModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tablePortfolio.sort();
    };
    private boolean settingFlag = false;
    private boolean statusFlag = false;

    @FXML
    public void initialize() {
        this.root = this.initRoot();
        this.exe.execute(() -> {
            this.initTree(this.root);
            this.query(((Party)this.root.getValue()).getId());
        });
        this.bind();
        this.createTableView();
        this.checkRights();
    }

    private void initTree(TreeItem<Party> root) {
        block5: {
            try {
                try {
                    ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryPortfolioControl"});
        this.model.registerCheckAll((Control)this.btnAdd, new String[]{"addPortfolioControl", "savePortfolioBasic"});
        this.model.registerCheck((Control)this.btnFundTransfer, new String[]{"fundTransfer"});
        this.model.registerCheck((Control)this.btnPosiTransfer, new String[]{"posiTransfer"});
        this.model.registerCheck((Control)this.btnPosiOtcTransfer, new String[]{"posiOtcTransfer"});
        this.statusFlag = this.model.registerCheck(new String[]{"enablePortfolioControl"});
        this.settingFlag = this.model.registerCheck(new String[]{"savePortfolioBasic", "lookPortfolioBasic", "queryPortfolioAssignAccntControl", "updatePortfolioAssignAccntControl", "queryPortfolioWorkFlowControl", "updatePortfolioWorkFlowControl", "savePortfolioBench", "lookPortfolioBench"});
        this.settingFlag = this.settingFlag && this.model.registerCheck(new String[]{"updatePortfolioControl"});
        boolean flag = this.model.registerCheck(new String[]{"savePortfolioBench", "lookPortfolioBench"});
        if (!flag) {
            this.tablePortfolio.getColumns().remove(this.type);
            this.tablePortfolio.getColumns().remove(this.validityPeriod);
            this.tablePortfolio.getColumns().remove(this.duration);
            this.tablePortfolio.getColumns().remove(this.benchmark);
        }
        this.tablePortfolio.getColumns().remove(this.shares);
    }

    protected void afterTableRestore() {
        this.treeParty.getSelectionModel().select(this.root);
        this.selectTreeParty = this.root;
    }

    private void bind() {
        MxNode node = MxNodeFactory.create((String)"post_status", (String)"1");
        node.load("post_status", "1");
        this.txtSearch.textProperty().addListener(this.portfolioModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.selectTablePortfolio = null;
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()));
        });
        this.tablePortfolio.setOnMouseClicked(event -> {
            if (this.tablePortfolio.getSelectionModel().getSelectedItem() != null) {
                this.selectTablePortfolio = (Portfolio)this.tablePortfolio.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        this.addViwer(this.tablePortfolio);
        this.tablePortfolio.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tablePortfolio);
        this.validityPeriod.setCellValueFactory(data -> this.setTime((Portfolio)data.getValue()));
        this.duration.setCellValueFactory(cellData -> new SimpleIntegerProperty(Integer.valueOf(((Portfolio)cellData.getValue()).getValPeriod()).intValue()));
        this.des.setCellFactory(data -> new AutoTableCell());
        this.benchmark.setCellValueFactory(data -> {
            List list = ((Portfolio)data.getValue()).getBenchmarkList();
            SimpleStringProperty flage = new SimpleStringProperty("");
            int i = 0;
            while (i < list.size()) {
                String s;
                String id = (String)list.get(i);
                if (i == list.size() - 1) {
                    s = String.valueOf(flage.get()) + (String)this.portfolioMng.getBenchmarkName(id).get();
                    flage.set(s);
                } else {
                    s = String.valueOf(flage.get()) + (String)this.portfolioMng.getBenchmarkName(id).get() + ",";
                    flage.set(s);
                }
                ++i;
            }
            return flage;
        });
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((Portfolio)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((Portfolio)data.getValue()).getUpdater()));
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tablePortfolio));
        this.tablePortfolio.setItems(this.mlist.getList());
    }

    private StringProperty setTime(Portfolio p) {
        SimpleStringProperty s = new SimpleStringProperty("\u6c38\u4e45");
        if ("\u5b58\u7eed\u4ea4\u6613\u65e5".equals(p.getToPeriod().getValue())) {
            s.set((Object)p.getTotalPeriod());
        }
        return s;
    }

    private void onItemClicked(TreeItem<Party> item) {
        this.selectTreeParty = item;
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void query(String partyId) {
        try {
            this.portfolioMng.queryBenchmarkMap();
            List<Portfolio> listPortfolio = this.portfolioMng.getPortfoliosByParty(partyId);
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            listPortfolio.forEach(item -> {
                this.filterList.add((Portfolio)item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
            this.tablePortfolio.sort();
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void refresh() {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            if (this.partyMng.getUserParty().getId().equals(((Party)this.selectTreeParty.getValue()).getId())) {
                this.treeParty.getSelectionModel().select(root);
            } else {
                this.treeParty.getSelectionModel().select(this.selectTreeParty);
            }
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            this.tablePortfolio.getSelectionModel().select((Object)this.selectTablePortfolio);
            this.tablePortfolio.scrollTo((Object)this.selectTablePortfolio);
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void add() {
        AddPortfolioDialog obj = (AddPortfolioDialog)((Object)this.of.create(AddPortfolioDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            obj.setParty((Party)this.treeParty.getRoot().getValue());
        } else {
            obj.setParty((Party)treeItem.getValue());
        }
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u6295\u8d44\u7ec4\u5408");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            if (!obj.getNewPortfolioId().isEmpty()) {
                String portfolioId = obj.getNewPortfolioId();
                this.selectTablePortfolio = this.portfolioMng.getPortfolioById(portfolioId);
                if (this.selectTreeParty == null) {
                    return;
                }
                this.query(((Party)this.selectTreeParty.getValue()).getId());
                this.tablePortfolio.getSelectionModel().select((Object)this.selectTablePortfolio);
                this.tablePortfolio.scrollTo((Object)this.selectTablePortfolio);
            }
        }
        catch (MException | Exception e) {
            logger.error((Object)e, e);
        }
    }

    public void update() {
        UpdatePortfolioDialog obj = (UpdatePortfolioDialog)((Object)this.of.create(UpdatePortfolioDialog.class));
        Portfolio portfolio = (Portfolio)this.tablePortfolio.getSelectionModel().getSelectedItem();
        if (portfolio == null) {
            return;
        }
        Portfolio portfolioSet = this.pf.create();
        portfolioSet.update((Object)portfolio);
        obj.setPortfolio(portfolioSet);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u6295\u8d44\u7ec4\u5408");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            this.tablePortfolio.getSelectionModel().select((Object)this.selectTablePortfolio);
            this.tablePortfolio.scrollTo((Object)this.selectTablePortfolio);
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void enable() {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_ENABLE_PORTFOLIO, ALERT)) {
            try {
                this.portfolioMng.enablePortfolio(true, (Portfolio)this.tablePortfolio.getSelectionModel().getSelectedItem());
                this.query(((Party)this.selectTreeParty.getValue()).getId());
                this.tablePortfolio.getSelectionModel().select((Object)this.selectTablePortfolio);
                this.tablePortfolio.scrollTo((Object)this.selectTablePortfolio);
            }
            catch (MException e) {
                this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public void disable() {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_DISABLE_PORTFOLIO, ALERT)) {
            try {
                this.portfolioMng.enablePortfolio(false, (Portfolio)this.tablePortfolio.getSelectionModel().getSelectedItem());
                this.query(((Party)this.selectTreeParty.getValue()).getId());
                this.tablePortfolio.getSelectionModel().select((Object)this.selectTablePortfolio);
                this.tablePortfolio.scrollTo((Object)this.selectTablePortfolio);
            }
            catch (MException e) {
                this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    @FXML
    public void fundTransfer() {
        FundTransferDialog obj = (FundTransferDialog)((Object)this.of.create(FundTransferDialog.class));
        try {
            obj.setParty(this.partyMng.getUserParty());
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            e.printStackTrace();
        }
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u6295\u7ec4\u8d44\u91d1\u5212\u8f6c");
            dialog.launch().equals(ButtonType.OK);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void posiTransfer() {
        MEvent event = new MEvent();
        try {
            event.setObj((Object)this.partyMng.getUserParty());
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            e.printStackTrace();
        }
        this.es.postEvent("positionTransferEvent", event);
    }

    @FXML
    public void posiOtcTransfer() {
        MEvent event = new MEvent();
        try {
            event.setObj((Object)this.partyMng.getUserParty());
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            e.printStackTrace();
        }
        this.es.postEvent("positionOtcTransferEvent", event);
    }

    @FXML
    private void rightRefresh() {
        this.refresh();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tablePortfolio);
    }

    private class AutoTableCell<S, T>
    extends TableCell<Portfolio, T> {
        Portfolio portfolio;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.portfolio = (Portfolio)Portfolio.class.cast(this.getTableRow().getItem());
                if (this.portfolio == null) {
                    return;
                }
                if (!this.portfolio.getDes().isEmpty()) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(this.portfolio.getDes());
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(this.portfolio.getDes());
            }
        }
    }

    private class OperaCell
    extends TableCell<Portfolio, String> {
        final Label updateLab = new Label("\u8bbe\u7f6e");
        final HBox paddedLabel = new HBox();
        final Label statusLab = new Label("\u65e0");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            if (PortfolioMngPart.this.settingFlag) {
                this.paddedLabel.getChildren().add((Object)this.updateLab);
                HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
            }
            if (PortfolioMngPart.this.statusFlag) {
                this.paddedLabel.getChildren().add((Object)this.statusLab);
            }
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    PortfolioMngPart.this.update();
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof Portfolio) {
                        Portfolio r = (Portfolio)OperaCell.this.getTableRow().getItem();
                        PortfolioMngPart.this.selectTablePortfolio = r;
                        if ("\u505c\u7528".equals(r.getStatus().getValue())) {
                            OperaCell.this.statusLab.setText("\u542f\u7528");
                            PortfolioMngPart.this.enable();
                        } else {
                            OperaCell.this.statusLab.setText("\u505c\u7528");
                            PortfolioMngPart.this.disable();
                        }
                    }
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof Portfolio) {
                    Portfolio r = (Portfolio)this.getTableRow().getItem();
                    if ("\u505c\u7528".equals(r.getStatus().getValue())) {
                        this.statusLab.setText("\u542f\u7528");
                    } else {
                        this.statusLab.setText("\u505c\u7528");
                    }
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

