/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.Party;
import cms.tmx.entity.RolePermission;
import cms.tmx.entity.User;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PersonalFuncModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.PersonalFuncAssignDialog;
import cms.tmx.manage.parts.addPersonalFuncDialog;
import cms.tmx.rights.IUiRightService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersonalFuncMngPart
extends MxPart {
    @FXML
    private TreeView<FuncModule> treeFunc;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<User> tableUser;
    @FXML
    private TextField txtSearchNoWidth;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<User, String> creator;
    @FXML
    private TableColumn<User, String> updater;
    @FXML
    private TableColumn<User, Object> colOpera;
    @FXML
    private Button btnAddFunc;
    @FXML
    private Button btnQuery;
    @FXML
    private CheckBox cboxAssign;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyFactory pFactory;
    @Inject
    private PersonalFuncModel model;
    @Inject
    private IUiRightService right;
    private User selectTableUser;
    private TreeItem<Party> selectTreeParty;
    private TreeItem<FuncModule> selectTreeFunc;
    private MxList<User> mlist = new MxList();
    private List<User> listCache = new LinkedList<User>();
    private static final Logger logger = LogManager.getLogger(PersonalFuncMngPart.class);
    private Predicate<User> pd = user -> {
        String idName = this.txtSearchNoWidth.getText().trim();
        if (user.getUseCreditName().contains(idName) || user.getName().contains(idName)) {
            if (this.cboxAssign.isSelected()) {
                return "\u662f".equals(user.getAssign());
            }
            return true;
        }
        return false;
    };
    private InvalidationListener searchListner = ob -> {
        this.mlist.filter(this.listCache, this.pd);
        this.tableUser.sort();
    };
    private int changed = 0;
    protected InvalidationListener lstnModel = ob -> {
        this.initTreeFunc((TreeItem<FuncModule>)this.treeFunc.getRoot());
        this.treeFunc.getSelectionModel().select(0);
        ++this.changed;
    };
    private boolean statusFlag = false;
    private boolean refresh = false;

    @FXML
    public void initialize() {
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.createTableView();
        this.listener();
        this.checkRights();
        TreeItem<FuncModule> rootFunc = this.initRootFunc();
        TreeItem<Party> rootParty = this.initRootParty();
        this.exe.execute(() -> {
            this.initTreeFunc(rootFunc);
            this.initTreeParty(rootParty);
            this.treeFunc.getSelectionModel().select(0);
            this.treeParty.getSelectionModel().select(0);
        });
    }

    private TreeItem<FuncModule> initRootFunc() {
        FuncModule fModule = new FuncModule();
        fModule.setId("F00000");
        fModule.setName("\u529f\u80fd\u6811");
        TreeItem root = new TreeItem((Object)fModule);
        this.treeFunc.setRoot(root);
        return root;
    }

    private void initTreeFunc(TreeItem<FuncModule> root) {
        block5: {
            try {
                try {
                    root.getChildren().clear();
                    this.model.getStatisticRoot(root);
                }
                catch (MException e) {
                    Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private TreeItem<Party> initRootParty() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTreeParty(TreeItem<Party> root) {
        block5: {
            try {
                try {
                    ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private void checkRights() {
        this.right.registerCheck((Control)this.btnQuery, new String[]{"queryPersonalFunc"});
        this.statusFlag = this.right.registerCheck(new String[]{"personalFuncAssign"});
    }

    private void listener() {
        this.txtSearchNoWidth.textProperty().addListener(this.searchListner);
        this.cboxAssign.selectedProperty().addListener(this.searchListner);
        this.treeFunc.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.queryAssign((TreeItem<FuncModule>)now));
        this.treeParty.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.selectParty((TreeItem<Party>)now));
        this.tableUser.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            User user = this.selectTableUser = now;
        });
    }

    private void createTableView() {
        this.addViwer(this.tableUser);
        this.tableUser.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableUser);
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((User)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((User)data.getValue()).getUpdater()));
        this.colOpera.setCellValueFactory(data -> this.setOperate((User)data.getValue()));
        this.tableUser.setItems(this.mlist.getList());
    }

    private ReadOnlyObjectWrapper<Object> setOperate(User user) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        if (this.statusFlag) {
            Button btnStatus = new Button("\u5feb\u901f\u6388\u6743");
            btnStatus.getStyleClass().add((Object)"btnOperation");
            btnStatus.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "\u662f".equals(user.getAssign()) ? "\u53d6\u6d88\u6388\u6743" : "\u5feb\u901f\u6388\u6743", (Observable[])new Observable[]{user.assignProperty()}));
            btnStatus.setOnAction(event -> this.assign("\u662f".equals(user.getAssign()), user));
            box.getChildren().addAll((Object[])new Node[]{btnStatus});
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void assign(boolean assign, User user) {
        this.tableUser.getSelectionModel().select((Object)user);
        try {
            List list = user.getListRp();
            if (list.isEmpty()) {
                this.alert.alert(Alert.AlertType.INFORMATION, "\u8be5\u7528\u6237\u672a\u5173\u8054\u89d2\u8272\uff01");
                return;
            }
            LinkedList<RolePermission> listRole = new LinkedList<RolePermission>();
            LinkedList<String> listRoleId = new LinkedList<String>();
            user.getListRp().forEach(role -> {
                if (role.isAssigned() == assign) {
                    listRole.add((RolePermission)role);
                    listRoleId.add(role.getId());
                }
            });
            TreeItem func = (TreeItem)this.treeFunc.getSelectionModel().getSelectedItem();
            if (assign) {
                String info = this.getAffectedUsers(assign, listRole, listRoleId);
                if (this.alert.alert(Alert.AlertType.CONFIRMATION, info)) {
                    this.model.unassignMenuViaRoles(user.getId(), ((FuncModule)func.getValue()).getId(), listRoleId);
                    this.queryAssign((TreeItem<FuncModule>)func);
                }
            } else {
                PersonalFuncAssignDialog obj = (PersonalFuncAssignDialog)((Object)this.of.create(PersonalFuncAssignDialog.class));
                obj.setRole(listRole);
                MxDialog dialog = this.df.create((DialogObj)obj, "\u6388\u6743");
                ButtonType btnType = dialog.launch();
                if (ButtonType.OK == btnType) {
                    List<RolePermission> listResult = obj.getResult();
                    LinkedList<String> listResultId = new LinkedList<String>();
                    listResult.forEach(role -> listResultId.add(role.getId()));
                    String info = this.getAffectedUsers(assign, listResult, listResultId);
                    if (this.alert.alert(Alert.AlertType.CONFIRMATION, info)) {
                        this.model.assignMenuViaRoles(user.getId(), ((FuncModule)func.getValue()).getId(), listResultId);
                        this.queryAssign((TreeItem<FuncModule>)func);
                    }
                }
            }
        }
        catch (MException e) {
            logger.error("query affected users faild", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private String getAffectedUsers(boolean assign, List<RolePermission> listRole, List<String> listRoleId) throws MException {
        List<User> listUser = this.model.queryAffectedUsers(listRoleId);
        TreeItem tree = (TreeItem)this.treeFunc.getSelectionModel().getSelectedItem();
        StringBuilder buld = new StringBuilder(assign ? "\u672c\u64cd\u4f5c\u5c06\u53d6\u6d88 " : "\u672c\u64cd\u4f5c\u5c06\u589e\u52a0 ");
        listRole.forEach(r -> buld.append(r.getName()).append("(").append(r.getId()).append(")\u3001"));
        if (buld.length() - 1 == buld.lastIndexOf("\u3001")) {
            buld.deleteCharAt(buld.length() - 1);
        }
        buld.append(" \u7684 ").append(((FuncModule)tree.getValue()).getName()).append(" \u83dc\u5355\u6743\u9650\uff0c\u53d7\u5f71\u54cd\u7684\u7528\u6237\u6709 ");
        listUser.forEach(u -> buld.append(u.getName()).append("(").append(u.getId()).append(")\u3001"));
        if (buld.length() - 1 == buld.lastIndexOf("\u3001")) {
            buld.deleteCharAt(buld.length() - 1);
        }
        return buld.toString();
    }

    private void selectParty(TreeItem<Party> item) {
        if (item == null) {
            return;
        }
        this.selectTreeParty = item;
        this.queryUser(item);
        this.queryAssign((TreeItem<FuncModule>)((TreeItem)this.treeFunc.getSelectionModel().getSelectedItem()));
        this.mlist.update(this.listCache, this.pd);
        Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
    }

    private void queryUser(TreeItem<Party> item) {
        String partyId = ((Party)item.getValue()).getId();
        try {
            LinkedList<String> listIds = new LinkedList<String>();
            listIds.addAll(this.userMng.getUserIds(partyId));
            this.mlist.clear();
            this.listCache.clear();
            if (!listIds.isEmpty()) {
                LinkedList<User> listUsers = new LinkedList<User>();
                listUsers.addAll(this.userMng.getUserList(listIds));
                this.listCache.addAll(listUsers);
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void queryAssign(TreeItem<FuncModule> item) {
        if (this.refresh || item == null) {
            return;
        }
        this.selectTreeFunc = item;
        String funcId = ((FuncModule)item.getValue()).getId();
        if (this.listCache.isEmpty()) {
            return;
        }
        try {
            this.model.queryMenuPermision(funcId, this.listCache);
            this.tableUser.refresh();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void refresh() {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            this.refresh = true;
            this.model.getStatisticRoot(this.initRootFunc());
            this.treeFunc.getRoot().setExpanded(true);
            this.treeFunc.getSelectionModel().select(this.selectTreeFunc);
            this.refresh = false;
            boolean flag = this.partyMng.getUserParty().getId().equals(((Party)this.selectTreeParty.getValue()).getId());
            this.treeParty.getSelectionModel().clearSelection();
            this.treeParty.getSelectionModel().select(flag ? root : this.selectTreeParty);
            this.tableUser.getSelectionModel().select((Object)this.selectTableUser);
            this.tableUser.scrollTo((Object)this.selectTableUser);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void add() {
        addPersonalFuncDialog obj = (addPersonalFuncDialog)((Object)this.of.create(addPersonalFuncDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u83dc\u5355\u6388\u6743\u7edf\u8ba1");
        dialog.launch();
        if (this.changed > 0) {
            this.changed = 0;
            this.queryAssign((TreeItem<FuncModule>)this.treeFunc.getRoot());
        }
    }

    @FXML
    private void rightRefresh() {
        this.refresh();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableUser);
    }
}

