/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.AccountStatus;
import cms.tmx.entity.Party;
import cms.tmx.entity.PersonalAccount;
import cms.tmx.entity.TradeCounter;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PersonalAccounMngModel;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.manage.parts.AddPersonalAccountDialog;
import cms.tmx.manage.parts.UpdatePersonalAccountDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.MarketUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersonalAccountMngPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(PersonalAccountMngPart.class);
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<PersonalAccount> tableAccnt;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<PersonalAccount, String> colId;
    @FXML
    private TableColumn<PersonalAccount, String> colAccnt;
    @FXML
    private TableColumn<PersonalAccount, String> colParty;
    @FXML
    private TableColumn<PersonalAccount, String> colTraPlatform;
    @FXML
    private TableColumn<PersonalAccount, MxNode> colStatus;
    @FXML
    private TableColumn<PersonalAccount, MxNode> colLoginStaus;
    @FXML
    private TableColumn<PersonalAccount, Object> colOpera;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private DialogFactory df;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert alert;
    @Inject
    private PersonalAccounMngModel model;
    @Inject
    private IUiRightService right;
    @Inject
    private ExecutorService exe;
    private MxList<PersonalAccount> mlist = new MxList();
    private ObservableList<PersonalAccount> listCache = FxUtils.newList();
    private Map<String, TradeCounter> mapCounter = new HashMap<String, TradeCounter>();
    private Predicate<PersonalAccount> pd = account -> {
        String idName = this.txtSearch.getText().trim();
        return account.getInvestorId().contains(idName);
    };
    private InvalidationListener lstSearch = ob -> Platform.runLater(() -> {
        this.mlist.clear();
        this.mlist.update(this.listCache, this.pd);
        this.tableAccnt.refresh();
        this.tableAccnt.sort();
    });
    private boolean settingFlag = true;
    private boolean statusFlag = true;
    @Inject
    private TradeCounterServiceImpl counterMng;
    private static final String IS_ENABLE = "\u662f\u5426\u542f\u7528\u8be5\u8d26\u6237";
    private static final String IS_DISABLE = "\u662f\u5426\u505c\u7528\u8be5\u8d26\u6237";
    private static final String ALERT = "\u63d0\u793a";
    @Inject
    private AccountMngServiceImpl accountMng;
    private static final int PAGESIZE = 100;

    @FXML
    public void initialize() {
        this.bind();
        this.initTree();
        this.createTable();
        this.checkRights();
        this.exe.execute(() -> {
            if (this.treeParty.getRoot() == null) {
                return;
            }
            try {
                ObservableList<TradeCounter> list = this.counterMng.getTradeCounterList();
                list.forEach(tc -> {
                    TradeCounter tradeCounter = this.mapCounter.put(tc.getId(), (TradeCounter)tc);
                });
                this.refresh();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
        });
    }

    private void initTree() {
        try {
            TreeItem<Party> root = this.partyTree.getRoot();
            this.treeParty.setRoot(root);
            this.treeParty.getSelectionModel().select(0);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.lstSearch);
        this.treeParty.getSelectionModel().selectedItemProperty().addListener(item -> this.refresh());
    }

    private void checkRights() {
        this.right.registerCheck((Control)this.btnQuery, new String[]{"queryPersonalAccountControl"});
        this.right.registerCheckAll((Control)this.btnAdd, new String[]{"addPersonalAccountControl"});
        this.statusFlag = this.right.registerCheck(new String[]{"enablePersonalAccountControl"});
        this.settingFlag = this.right.registerCheck(new String[]{"updatePersonalAccountControl", "lookPersonalAccountBasic", "savePersonalAccountBasic"});
    }

    private void createTable() {
        TableUtils.isAuto(this.index);
        this.colId.setCellValueFactory(data -> ((PersonalAccount)data.getValue()).idProperty());
        this.colAccnt.setCellValueFactory(data -> ((PersonalAccount)data.getValue()).investorIdProperty());
        this.colParty.setCellValueFactory(data -> {
            String partyId = ((PersonalAccount)data.getValue()).getPartyId();
            Party party = this.partyTree.getMap().get(partyId);
            SimpleStringProperty name = new SimpleStringProperty();
            name.setValue(party != null ? party.getName() : "");
            return name;
        });
        this.colTraPlatform.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty();
            PersonalAccount accnt = (PersonalAccount)data.getValue();
            TradeCounter counter = this.mapCounter.get(accnt.getTraPlatform());
            name.setValue(counter != null ? counter.getName() : "");
            return name;
        });
        this.colStatus.setCellValueFactory(data -> ((PersonalAccount)data.getValue()).statusProperty());
        this.colLoginStaus.setCellValueFactory(data -> ((PersonalAccount)data.getValue()).loginStatusProperty());
        this.colOpera.setCellValueFactory(data -> this.setOperate((PersonalAccount)data.getValue()));
        this.tableAccnt.setItems(this.mlist.getList());
    }

    private ReadOnlyObjectWrapper<Object> setOperate(PersonalAccount accnt) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        if (this.settingFlag) {
            Button btnSet = new Button("\u8bbe\u7f6e");
            btnSet.getStyleClass().add((Object)"btnOperation");
            btnSet.setOnAction(event -> this.update(accnt));
            box.getChildren().addAll((Object[])new Node[]{btnSet});
        }
        if (this.statusFlag) {
            Button btnStatus = new Button("");
            btnStatus.getStyleClass().add((Object)"btnOperation");
            boolean isEnable = "\u542f\u7528".equals(accnt.getStatus().getValue());
            btnStatus.setText(isEnable ? "\u505c\u7528" : "\u542f\u7528");
            btnStatus.setOnAction(event -> this.enable(accnt, !isEnable));
            box.getChildren().addAll((Object[])new Node[]{btnStatus});
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    public void enable(PersonalAccount accnt, boolean isEnable) {
        String prompt;
        this.tableAccnt.getSelectionModel().select((Object)accnt);
        String string = prompt = isEnable ? IS_ENABLE : IS_DISABLE;
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, prompt, ALERT)) {
            try {
                String result = this.model.enablePersonalAccnt(accnt, isEnable);
                this.alert.alert(Alert.AlertType.INFORMATION, result);
                this.refresh();
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    @FXML
    public void refresh() {
        try {
            TreeItem item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
            List<PersonalAccount> list = this.model.query(((Party)item.getValue()).getId());
            this.listCache.setAll(list);
            this.mlist.clear();
            this.mlist.update(this.listCache, this.pd);
            this.reloadStatus(list);
            this.tableAccnt.refresh();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private synchronized void reloadStatus(List<PersonalAccount> list) {
        LinkedList<String> listCcs = new LinkedList<String>();
        LinkedList<String> listFut = new LinkedList<String>();
        list.forEach(accnt -> {
            if ("CCS".equals(MarketUtils.findMarketGrp((List)accnt.getSecExc()))) {
                listCcs.add(accnt.getInvestorId());
            } else if ("FUTURES".equals(MarketUtils.findMarketGrp((List)accnt.getSecExc()))) {
                listCcs.add(accnt.getInvestorId());
            }
        });
        HashMap map = new HashMap();
        if (!listCcs.isEmpty()) {
            List<AccountStatus> ccsList = this.getLoginStatusByIds(listCcs, "CCS");
            ccsList.forEach(status -> {
                AccountStatus accountStatus = map.put(status.getInvestorId(), status);
            });
        }
        if (!listFut.isEmpty()) {
            List<AccountStatus> ctpList = this.getLoginStatusByIds(listFut, "FUTURES");
            ctpList.forEach(status -> {
                AccountStatus accountStatus = map.put(status.getInvestorId(), status);
            });
        }
        if (map.isEmpty()) {
            return;
        }
        for (PersonalAccount accnt2 : list) {
            AccountStatus status2 = (AccountStatus)map.get(accnt2.getInvestorId());
            if (status2 == null) {
                accnt2.getLoginStatus().setRaw("");
                continue;
            }
            accnt2.getLoginStatus().setRaw(status2.getStatus().getRaw());
        }
        Platform.runLater(() -> this.tableAccnt.refresh());
    }

    private List<AccountStatus> getLoginStatusByIds(List<String> listId, String marketGrp) {
        int size = listId.size();
        int start = 0;
        int end = 0;
        LinkedList<AccountStatus> listStatus = new LinkedList<AccountStatus>();
        try {
            do {
                end = (end += 100) < size ? end : size;
                LinkedList<String> list = new LinkedList<String>();
                list.addAll(listId.subList(start, end));
                listStatus.addAll((Collection<AccountStatus>)this.accountMng.getLoginStatus(marketGrp, list));
            } while ((start = end) != size);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        return listStatus;
    }

    @FXML
    public void add() {
        AddPersonalAccountDialog obj = (AddPersonalAccountDialog)((Object)this.of.create(AddPersonalAccountDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        obj.setParty(treeItem == null ? (Party)this.treeParty.getRoot().getValue() : (Party)treeItem.getValue());
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u8d26\u53f7");
        dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        dialog.launch();
        String accountId = obj.getAccountId();
        if (accountId != null && !accountId.isEmpty()) {
            this.refresh();
            PersonalAccount accnt = (PersonalAccount)this.tableAccnt.getItems().parallelStream().filter(item -> item.getId().equals(accountId)).collect(Collectors.toList()).get(0);
            this.tableAccnt.getSelectionModel().select((Object)accnt);
        }
    }

    private void update(PersonalAccount accnt) {
        this.tableAccnt.getSelectionModel().select((Object)accnt);
        PersonalAccount account = new PersonalAccount();
        account.update((Object)accnt);
        UpdatePersonalAccountDialog obj = (UpdatePersonalAccountDialog)((Object)this.of.create(UpdatePersonalAccountDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        obj.setParty(treeItem == null ? (Party)this.treeParty.getRoot().getValue() : (Party)treeItem.getValue());
        obj.setPersonalAccount(account);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u8d26\u53f7");
        dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        dialog.launch();
        this.refresh();
    }

    @FXML
    public void rightRefresh() {
        this.refresh();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableAccnt);
    }
}

