/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Party;
import cms.tmx.entity.PersonalAccount;
import cms.tmx.entity.Role;
import cms.tmx.entity.TradeCounter;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountMngModel;
import cms.tmx.manage.models.CurCmbModel;
import cms.tmx.manage.models.ExcCmbModelSp;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PersonalAccounMngModel;
import cms.tmx.manage.models.RoleMngServiceImpl;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class PersonalAccountBasic
extends MxTabContent {
    @FXML
    private TextField txtAccount;
    @FXML
    private TextField txtName;
    @FXML
    private TextField txtCode;
    @FXML
    private TextField txtPhone;
    @FXML
    private TextField txtAddr;
    @FXML
    private TextField txtEmail;
    @FXML
    private Label lbTradeNameErr;
    @FXML
    private Label lbEchangeErr;
    @FXML
    private Label lbCurrencyErr;
    @FXML
    private Label lbAccountErr;
    @FXML
    private Label lbCur;
    @FXML
    private Label lbExc;
    @FXML
    private ComboBox<TradeCounter> cmbBrokerName;
    @FXML
    private ComboBox<TradeCounter> cmbTradeName;
    @FXML
    private ComboBox<MxNodePwf> cmbExchange;
    @FXML
    private ComboBox<Party> cmbPartyName;
    @FXML
    private ComboBox<MxNodePwf> cmbCurrency;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private CheckComboBox<Role> ccmbRole;
    @FXML
    private Label lbFuncErr;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @FXML
    private Label lbAlert;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbPhoneErr;
    @FXML
    private Label lbTypeErr;
    @FXML
    private Label lbCodeErr;
    @FXML
    private Label lbEmailErr;
    @Inject
    private AccountMngModel accntModel;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private TradeCounterServiceImpl counterMng;
    @Inject
    private RoleMngServiceImpl roleMng;
    @Inject
    private MxAlert alert;
    @Inject
    private PersonalAccounMngModel model;
    private Party party;
    private String accountId = "";
    private static final Logger logger = LogManager.getLogger(PersonalAccountBasic.class);
    private ObservableList<Party> listParty = FxUtils.newList();
    private CurCmbModel curModel = new CurCmbModel();
    private ExcCmbModelSp excModel = new ExcCmbModelSp();
    private PersonalAccount accnt;
    boolean flag = false;
    BooleanProperty result = new SimpleBooleanProperty(true);
    @Inject
    private FundAccountMngServiceImpl fundMng;

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.party = this.accntModel.getParentParty();
        this.accnt = new PersonalAccount();
        this.bind();
        this.bindUIs();
        this.addCheck();
    }

    public void initValues() {
        try {
            this.cmbBrokerName.setConverter((StringConverter)new StringConverter<TradeCounter>(){

                public String toString(TradeCounter object) {
                    return object.getBrokerName();
                }

                public TradeCounter fromString(String string) {
                    return null;
                }
            });
            this.cmbBrokerName.setItems(this.counterMng.getBroker());
            this.cmbBrokerName.getSelectionModel().select(0);
            this.listParty.addAll(this.partyMng.getPartyList(this.partyMng.getUserParty().getId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING));
            this.listParty.addAll((Object[])new Party[]{this.partyMng.getParty(this.partyMng.getUserParty().getId())});
            this.cmbPartyName.setItems(this.listParty);
            this.cmbPartyName.getSelectionModel().select((Object)this.party);
            this.curModel.initCellFactory(this.cmbCurrency, this.lbCur);
            MxNodePwf nodePwf = MxNodeFactory.createPwf((String)"currency_type", (String)"CNY");
            ObservableList listCur = nodePwf.getPwfNodes();
            this.cmbCurrency.setItems(listCur);
            this.excModel.getCheckItems().addListener(ob -> {
                block4: {
                    ObservableList<MxNodePwf> checkCur;
                    ObservableList<MxNodePwf> checkExc;
                    block3: {
                        checkExc = this.excModel.getCheckItems();
                        checkCur = this.curModel.getCheckItems();
                        if (checkExc.size() != 1 || !((MxNodePwf)checkExc.get(0)).getRaw().equals("XCFE")) break block3;
                        checkCur.clear();
                        this.curModel.initCellFactory(this.cmbCurrency, this.lbCur);
                        this.flag = true;
                        for (MxNodePwf mn : listCur) {
                            if (mn.getRaw().equals("CNY")) {
                                mn.setSelected(true);
                                this.curModel.getCheckItems().add((Object)mn);
                                mn.setDisable(false);
                                continue;
                            }
                            mn.setDisable(true);
                            mn.setSelected(false);
                        }
                        break block4;
                    }
                    if (!this.flag || checkExc.size() != 0) break block4;
                    checkCur.clear();
                    this.curModel.initCellFactory(this.cmbCurrency, this.lbCur);
                    this.flag = false;
                    for (MxNodePwf mn : listCur) {
                        mn.setDisable(false);
                        if (!mn.isSelected()) continue;
                        this.curModel.getCheckItems().add((Object)mn);
                    }
                }
            });
            this.excModel.initCellFactory(this.cmbExchange, this.lbExc, null);
            nodePwf = MxNodeFactory.createPwf((String)"market_code", (String)"XSHG");
            ObservableList listExc = nodePwf.getPwfNodes();
            this.cmbExchange.setItems(listExc);
            MxNode node = MxNodeFactory.create((String)"user_credit_type", (String)"1");
            this.cmbType.setItems(node.getNodes());
            List<Role> list = this.roleMng.getRoleListByParty(this.party.getId());
            this.ccmbRole.getItems().setAll((Collection)FXCollections.observableList(list));
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void bind() {
        this.txtAccount.textProperty().bindBidirectional((Property)this.accnt.investorIdProperty());
        this.txtName.textProperty().bindBidirectional((Property)this.accnt.nameProperty());
        this.txtPhone.textProperty().bindBidirectional((Property)this.accnt.phoneProperty());
        this.accnt.userCodeTypeProperty().bind((ObservableValue)this.cmbType.valueProperty());
        this.txtCode.textProperty().bindBidirectional((Property)this.accnt.codeProperty());
        this.txtAddr.textProperty().bindBidirectional((Property)this.accnt.addressProperty());
        this.txtEmail.textProperty().bindBidirectional((Property)this.accnt.emailProperty());
    }

    private void addCheck() {
        this.registerCheck((Node)this.lbAccountErr, (ObservableBooleanValue)this.txtAccount.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbCurrencyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.curModel.getCheckItems().isEmpty(), (Observable[])new Observable[]{this.curModel.getCheckItems()}));
        this.registerCheck((Node)this.lbTradeNameErr, (ObservableBooleanValue)this.cmbTradeName.getSelectionModel().selectedItemProperty().isNotNull());
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtPhone.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
        this.txtCode.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 50));
        this.txtEmail.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\\-.@]{0,50}", 1000));
        this.txtAddr.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)this.txtCode.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPhoneErr, (ObservableBooleanValue)this.txtPhone.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbEmailErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!(this.txtEmail.getText().isEmpty() || this.txtEmail.focusedProperty().get() || TextFieldUtils.isEmail((String)this.txtEmail.getText()))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtEmail.focusedProperty()}));
        this.registerCheck((Node)this.lbFuncErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.ccmbRole.getCheckModel().getCheckedItems().isEmpty(), (Observable[])new Observable[]{this.ccmbRole.getCheckModel().getCheckedItems()}));
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    private void bindUIs() {
        this.txtAccount.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 32));
        this.cmbPartyName.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.accnt.setPartyId(now.getId());
                try {
                    this.ccmbRole.getCheckModel().clearChecks();
                    this.ccmbRole.getItems().setAll((Collection)FXCollections.observableList(this.roleMng.getRoleListByParty(now.getId())));
                }
                catch (MException e) {
                    Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                }
            }
        });
        this.cmbPartyName.getSelectionModel().select((Object)this.party);
        this.cmbBrokerName.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.cmbTradeName.getSelectionModel().clearSelection();
                this.cmbTradeName.setItems(this.counterMng.getTradeCounterList(now.getBrokerId()));
            }
        });
        this.cmbTradeName.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                for (MxNodePwf item : this.cmbExchange.getItems()) {
                    if (now.getSecExchange().contains(item.getValue())) {
                        this.excModel.check(item, false);
                        continue;
                    }
                    this.excModel.clearCheck(item, false);
                }
            } else {
                for (MxNodePwf item : this.cmbExchange.getItems()) {
                    this.excModel.clearCheck(item, false);
                }
            }
        });
        this.lbAlert.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        TradeCounter counter = (TradeCounter)this.cmbTradeName.getSelectionModel().getSelectedItem();
        this.accnt.setTraPlatform(counter.getId());
        this.accnt.setBrokerId(counter.getBrokerId());
        LinkedList listExc = new LinkedList();
        this.excModel.getCheckItems().forEach(node -> {
            boolean bl = listExc.add(node.getRaw());
        });
        this.accnt.setSecExc(listExc);
        LinkedList listCur = new LinkedList();
        this.curModel.getCheckItems().forEach(node -> {
            boolean bl = listCur.add(node.getRaw());
        });
        this.accnt.setCurrency(listCur);
        ObservableList listRole = this.ccmbRole.getCheckModel().getCheckedItems();
        LinkedList listStr = new LinkedList();
        listRole.forEach(r -> {
            boolean bl = listStr.add(r.getId());
        });
        this.accnt.setRoles(listStr);
        try {
            this.accountId = this.model.addAccount(this.accnt);
            this.accnt.setId(this.accountId);
            this.fundMng.addFundAccount(this.accnt);
            this.toDisable();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        return true;
    }

    private void toDisable() {
        this.txtAccount.setDisable(true);
        this.cmbBrokerName.setDisable(true);
        this.cmbTradeName.setDisable(true);
        this.cmbPartyName.setDisable(true);
        this.cmbCurrency.setDisable(true);
        this.ccmbRole.setDisable(true);
        this.txtName.setDisable(true);
        this.cmbType.setDisable(true);
        this.txtCode.setDisable(true);
        this.txtPhone.setDisable(true);
        this.txtAddr.setDisable(true);
        this.txtEmail.setDisable(true);
        this.labSuccess.setVisible(true);
        this.btnSaveBasic.setDisable(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)4000.0), e -> {
            this.labSuccess.setVisible(false);
            this.result.setValue(Boolean.valueOf(false));
        }, new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PersonalAccount getPersonalAccount() {
        return this.accnt;
    }
}

