/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AddPartyDialog;
import cms.tmx.manage.parts.UpdatePartyDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartyMngPart
extends MxPart {
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Party> tableParty;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<Party, String> parentId;
    @FXML
    private TableColumn<Party, String> desc;
    @FXML
    private TableColumn<Party, String> creator;
    @FXML
    private TableColumn<Party, String> updater;
    @FXML
    private TableColumn<Party, String> colOpera;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @Inject
    private PartyMngServiceImpl partMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert mAlert;
    @Inject
    private PartyFactory pf;
    @Inject
    private IUiRightService model;
    @Inject
    private PartyFactory pFactory;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private ExecutorService exe;
    private Party selectTableParty;
    private TreeItem<Party> selectTreeParty;
    private MxList<Party> mlist = new MxList();
    private List<Party> filterList = new LinkedList<Party>();
    private TreeItem<Party> root;
    private static final Logger logger = LogManager.getLogger(PartyMngPart.class);
    private static final String IS_ENABLE_PARTY = "\u662f\u5426\u542f\u7528\u8be5\u673a\u6784";
    private static final String IS_DISABLE_PARTY = "\u662f\u5426\u505c\u7528\u8be5\u673a\u6784";
    private static final String ALERT = "\u63d0\u793a";
    private Predicate<Party> pd = inst -> {
        String idName = this.txtSearch.getText().trim();
        return inst.getName().contains(idName) || inst.getFullName().contains(idName);
    };
    private InvalidationListener instModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableParty.sort();
    };
    private boolean settingFlag = false;
    private boolean statusFlag = false;

    @FXML
    public void initialize() {
        this.root = this.initRoot();
        this.exe.execute(() -> {
            this.initTree(this.root);
            this.initPartyList();
        });
        this.bind();
        this.createTableView();
        this.checkRights();
    }

    private void initTree(TreeItem<Party> root) {
        block5: {
            try {
                try {
                    ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryPartyControl"});
        this.model.registerCheckAll((Control)this.btnAdd, new String[]{"addPartyControl", "savePartyBasic"});
        this.statusFlag = this.model.registerCheck(new String[]{"enablePartyControl"});
        this.settingFlag = this.model.registerCheck(new String[]{"savePartyBasic", "lookPartyBasic", "savePartyControl", "lookPartyControl"});
        this.settingFlag = this.settingFlag && this.model.registerCheck(new String[]{"updatePartyControl"});
    }

    private void initPartyList() {
        this.filterList.addAll(this.partyTree.getMap().values());
        this.mlist.addAll(this.filterList);
        this.mlist.update(this.filterList, this.pd);
        Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
    }

    private void bind() {
        MxNodeFactory.create((String)"post_status", (String)"1");
        this.txtSearch.textProperty().addListener(this.instModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.selectTableParty = null;
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()));
        });
        this.tableParty.setOnMouseClicked(event -> {
            this.selectTableParty = this.tableParty.getSelectionModel().getSelectedItem() == null ? this.selectTableParty : (Party)this.tableParty.getSelectionModel().getSelectedItem();
        });
    }

    protected void afterTableRestore() {
        this.tableParty.setPlaceholder((Node)new Label());
        this.treeParty.getSelectionModel().select(this.root);
        this.selectTreeParty = this.root;
    }

    private void createTableView() {
        this.addViwer(this.tableParty);
        TableUtils.initValueFactory(this.tableParty);
        this.parentId.setCellValueFactory(cellData -> {
            String parentId = ((Party)cellData.getValue()).getParentId();
            if (this.partyTree.getParty(parentId) == null) {
                return new SimpleStringProperty();
            }
            SimpleStringProperty flage = new SimpleStringProperty(this.partyTree.getParty(parentId).getName());
            return flage;
        });
        this.desc.setCellFactory(data -> new AutoTableCell());
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((Party)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((Party)data.getValue()).getUpdater()));
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableParty));
        this.tableParty.setItems(this.mlist.getList());
    }

    private void onItemClicked(TreeItem<Party> item) {
        this.selectTreeParty = item;
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void query(String partyId) {
        try {
            LinkedList listParty = new LinkedList();
            LinkedList<String> listIds = new LinkedList<String>();
            this.partMng.getPartyListContainsOwner(partyId).forEach(item -> {
                listParty.add(item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.filterList.clear();
            this.filterList.addAll(listParty);
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void refresh() {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            if (this.partMng.getUserParty().getId().equals(((Party)this.selectTreeParty.getValue()).getId())) {
                this.treeParty.getSelectionModel().select(root);
            } else {
                this.treeParty.getSelectionModel().select(this.selectTreeParty);
            }
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            this.tableParty.getSelectionModel().select((Object)this.selectTableParty);
            this.tableParty.scrollTo((Object)this.selectTableParty);
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void add() {
        AddPartyDialog obj = (AddPartyDialog)((Object)this.of.create(AddPartyDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        obj.setParty(treeItem == null ? (Party)this.treeParty.getRoot().getValue() : (Party)treeItem.getValue());
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u673a\u6784");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            if (!obj.getNewPartyId().isEmpty()) {
                this.selectTableParty = this.partMng.getParty(obj.getNewPartyId());
                this.refresh();
                this.sendMsgToWeb(obj.getNewPartyId());
            }
        }
        catch (MException | Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, e);
        }
    }

    private void sendMsgToWeb(String partyId) {
        if (!StringUtils.isEmpty((String)partyId)) {
            MEvent event = new MEvent();
            event.put((Object)"type", (Object)"party");
            event.put((Object)"id", (Object)partyId);
            this.es.postEvent("refresh_web_cache", event);
        }
    }

    public void update() {
        UpdatePartyDialog obj = (UpdatePartyDialog)((Object)this.of.create(UpdatePartyDialog.class));
        Party party = (Party)this.tableParty.getSelectionModel().getSelectedItem();
        if ("P0000001".equals(party.getId())) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u65e0\u4fee\u6539\u6743\u9650");
            return;
        }
        Party partySet = this.pf.create();
        partySet.update((Object)party);
        obj.setParty(partySet);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u673a\u6784");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            this.refresh();
            this.sendMsgToWeb(party.getId());
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void enable() {
        try {
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_ENABLE_PARTY, ALERT)) {
                this.partMng.enableParty((Party)this.tableParty.getSelectionModel().getSelectedItem(), true);
                this.refresh();
                this.sendMsgToWeb(((Party)this.tableParty.getSelectionModel().getSelectedItem()).getId());
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void disable() {
        try {
            if ("P0000001".equals(((Party)this.tableParty.getSelectionModel().getSelectedItem()).getId())) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u65e0\u4fee\u6539\u6743\u9650");
                return;
            }
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_DISABLE_PARTY, ALERT)) {
                this.partMng.enableParty((Party)this.tableParty.getSelectionModel().getSelectedItem(), false);
                this.refresh();
                this.sendMsgToWeb(((Party)this.tableParty.getSelectionModel().getSelectedItem()).getId());
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void rightRefresh() {
        this.refresh();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableParty);
    }

    private class AutoTableCell<S, T>
    extends TableCell<Party, T> {
        Party party;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.party = (Party)Party.class.cast(this.getTableRow().getItem());
                if (this.party == null) {
                    return;
                }
                if (!this.party.getDesc().isEmpty()) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(this.party.getDesc());
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(this.party.getDesc());
            }
        }
    }

    private class OperaCell
    extends TableCell<Party, String> {
        final Label updateLab = new Label("\u8bbe\u7f6e");
        final HBox paddedLabel = new HBox();
        final Label statusLab = new Label("\u65e0");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            if (PartyMngPart.this.settingFlag) {
                this.paddedLabel.getChildren().add((Object)this.updateLab);
                HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
            }
            if (PartyMngPart.this.statusFlag) {
                this.paddedLabel.getChildren().add((Object)this.statusLab);
            }
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    PartyMngPart.this.update();
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof Party) {
                        Party p = (Party)OperaCell.this.getTableRow().getItem();
                        PartyMngPart.this.selectTableParty = p;
                        if ("\u505c\u7528".equals(p.getStatus().getValue())) {
                            OperaCell.this.statusLab.setText("\u542f\u7528");
                            PartyMngPart.this.enable();
                        } else {
                            OperaCell.this.statusLab.setText("\u505c\u7528");
                            PartyMngPart.this.disable();
                        }
                    }
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof Party) {
                    Party p = (Party)this.getTableRow().getItem();
                    if ("\u505c\u7528".equals(p.getStatus().getValue())) {
                        this.statusLab.setText("\u542f\u7528");
                    } else {
                        this.statusLab.setText("\u505c\u7528");
                    }
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

