/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.PartyControl;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.PartyMngModel;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartyControlTabContent
extends MxTabContent {
    @FXML
    public CheckBox cboxMac;
    @FXML
    public TextField txtMac;
    @FXML
    public Label lbMacError;
    @FXML
    public Button btnAddMac;
    @FXML
    public TableView<PartyControl> tableMac;
    @FXML
    public TableColumn<PartyControl, String> index;
    @FXML
    public TableColumn<PartyControl, String> colMac;
    @FXML
    public TableColumn<PartyControl, String> colPostMac;
    @FXML
    public TableColumn<PartyControl, HBox> colOperaMac;
    @FXML
    public CheckBox cboxIp;
    @FXML
    public TextField txtIp;
    @FXML
    public Label lbIpError;
    @FXML
    public Button btnAddIp;
    @FXML
    public TableView<PartyControl> tableIp;
    @FXML
    public TableColumn<PartyControl, String> indexIp;
    @FXML
    public TableColumn<PartyControl, String> colIp;
    @FXML
    public TableColumn<PartyControl, String> colPostIp;
    @FXML
    public TableColumn<PartyControl, HBox> colOperaIp;
    @FXML
    public Label lbMessage;
    @FXML
    public Label lbMessageSpec;
    @FXML
    public Button btnSavePartyControl;
    @FXML
    private Label labSuccess;
    @Inject
    public PartyMngServiceImpl partyMng;
    @Inject
    public ExecutorService exe;
    @Inject
    private PartyMngModel partyModel;
    private ObservableList<PartyControl> listMac = FxUtils.newList();
    private ObservableList<PartyControl> listIp = FxUtils.newList();
    private Party selectParty;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert alert;
    public static final Logger logger = LogManager.getLogger(PartyControlTabContent.class);
    private static final int ADD_PARTYCONTROL = 1;
    private static final int UPDATE_PARTYCONTROL = 2;
    private static final int DELETE_PARTYCONTROL = 3;
    private static final int ERROR_PARTY_IP_MAC_ASSIGNED = 3128;

    @FXML
    public void initialize() {
        this.selectParty = this.partyModel.getCommonParty();
        this.labSuccess.setVisible(false);
        this.exe.execute(() -> this.initValues());
        this.addListener();
        this.createTableView();
        this.initBtn();
        this.initTextField();
    }

    public void initTextField() {
        this.txtMac.setTextFormatter((TextFormatter)new MxFormatter("^([0-9a-fA-F]{1,2})(([0-9a-fA-F]{0,2}){0,5})$", 12));
        this.txtIp.setTextFormatter((TextFormatter)new MxFormatter("^([0-9]{1,3})((\\.[0-9]{0,3}){0,3})$", 15));
    }

    public void initBtn() {
        this.btnAddIp.disableProperty().bind((ObservableValue)this.txtIp.textProperty().isEmpty());
        this.btnAddMac.disableProperty().bind((ObservableValue)this.txtMac.textProperty().isEmpty());
    }

    public void addListener() {
        this.tableMac.disableProperty().bind((ObservableValue)this.cboxMac.selectedProperty().not());
        this.tableIp.disableProperty().bind((ObservableValue)this.cboxIp.selectedProperty().not());
        this.lbMessageSpec.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.lbMessageSpec.setOpacity(0.0);
            }
        });
        this.txtMac.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbMacError.setOpacity(0.0);
                this.lbMacError.setText("");
            }
        });
        this.txtIp.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbIpError.setOpacity(0.0);
                this.lbIpError.setText("");
            }
        });
    }

    public void initValues() {
        try {
            this.listMac.clear();
            this.listIp.clear();
            List<PartyControl> list = this.partyMng.getPartyControl(this.selectParty.getId());
            if (list.isEmpty()) {
                return;
            }
            Map<Integer, List<PartyControl>> map = list.stream().collect(Collectors.groupingBy(PartyControl::getType));
            this.listMac.addAll(map.get(PartyControlType.MAC.code) == null ? this.listMac : FXCollections.observableList(map.get(PartyControlType.MAC.code)));
            this.listIp.addAll(map.get(PartyControlType.IP.code) == null ? this.listIp : FXCollections.observableList(map.get(PartyControlType.IP.code)));
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u673a\u6784\u63a7\u5236\u5f02\u5e38", (Throwable)e);
            this.lbMessage.setText(e.getMessage().isEmpty() ? "\u67e5\u8be2\u673a\u6784\u63a7\u5236\u5f02\u5e38" : e.getMessage());
        }
        Platform.runLater(() -> {
            this.cboxMac.setSelected(this.listMac.isEmpty() ? false : ((PartyControl)this.listMac.get(0)).isFlag());
            this.cboxIp.setSelected(this.listIp.isEmpty() ? false : ((PartyControl)this.listIp.get(0)).isFlag());
        });
    }

    public void createTableView() {
        TableUtils.isAuto(this.index);
        this.index.setSortable(false);
        TableUtils.isAuto(this.indexIp);
        this.indexIp.setSortable(false);
        this.colMac.setCellValueFactory(data -> ((PartyControl)data.getValue()).valueProperty());
        this.colIp.setCellValueFactory(data -> ((PartyControl)data.getValue()).valueProperty());
        this.colPostMac.setCellValueFactory(data -> ((PartyControl)data.getValue()).postIdListProperty());
        this.colPostMac.setCellFactory(data -> new TooltipTableCell<PartyControl, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((PartyControl)this.getValue()).getPostIdList();
            }
        });
        this.colPostIp.setCellValueFactory(data -> ((PartyControl)data.getValue()).postIdListProperty());
        this.colPostIp.setCellFactory(data -> new TooltipTableCell<PartyControl, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((PartyControl)this.getValue()).getPostIdList();
            }
        });
        this.colOperaMac.setCellValueFactory(data -> this.setOperateMac((PartyControl)data.getValue()));
        this.colOperaIp.setCellValueFactory(data -> this.setOperateIp((PartyControl)data.getValue()));
        this.tableMac.setPlaceholder((Node)new Label());
        this.tableIp.setPlaceholder((Node)new Label());
        this.tableMac.setItems(this.listMac);
        this.tableIp.setItems(this.listIp);
    }

    public ReadOnlyObjectWrapper<HBox> setOperateMac(final PartyControl ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                PartyControlTabContent.this.tableMac.getSelectionModel().select((Object)ap);
                if (PartyControlTabContent.this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664?")) {
                    PartyControlTabContent.this.delMac();
                }
            }
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    @FXML
    private void delMac() {
        PartyControl item = (PartyControl)this.tableMac.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        PartyControl control = (PartyControl)this.of.create(PartyControl.class);
        control.update((Object)item);
        try {
            this.partyMng.operatePartyControl(control, 3, this.selectParty.getId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u6210\u529f", "\u63d0\u793a");
            this.listMac.remove((Object)control);
        }
        catch (MException e) {
            if (e.getCode() == 3128) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u89e3\u9664\u76f8\u5e94\u804c\u4f4d\u7684\u7ed1\u5b9a\u5173\u7cfb\uff0c\u518d\u8fdb\u884c\u5220\u9664\u3002");
                return;
            }
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u5220\u9664\u673a\u6784\u63a7\u5236MAC\u5931\u8d25", (Throwable)e);
        }
    }

    public ReadOnlyObjectWrapper<HBox> setOperateIp(final PartyControl ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setStyle("-fx-cursor:hand;");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                PartyControlTabContent.this.tableIp.getSelectionModel().select((Object)ap);
                if (PartyControlTabContent.this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664?")) {
                    PartyControlTabContent.this.delIp();
                }
            }
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    private void delIp() {
        PartyControl item = (PartyControl)this.tableIp.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        PartyControl control = (PartyControl)this.of.create(PartyControl.class);
        control.update((Object)item);
        try {
            this.partyMng.operatePartyControl(control, 3, this.selectParty.getId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u6210\u529f", "\u63d0\u793a");
            this.listIp.remove((Object)control);
        }
        catch (MException e) {
            if (e.getCode() == 3128) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u89e3\u9664\u76f8\u5e94\u804c\u4f4d\u7684\u7ed1\u5b9a\u5173\u7cfb\uff0c\u518d\u8fdb\u884c\u5220\u9664\u3002");
                return;
            }
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u5220\u9664\u673a\u6784\u63a7\u5236IP\u5931\u8d25", (Throwable)e);
        }
    }

    @FXML
    public void addMac() {
        if (!this.checkMac()) {
            return;
        }
        PartyControl mac = new PartyControl();
        mac.setType(PartyControlType.MAC.code);
        mac.setValue(this.txtMac.getText().toUpperCase());
        try {
            this.partyMng.operatePartyControl(mac, 1, this.selectParty.getId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
            this.initValues();
            this.txtMac.clear();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u65b0\u589e\u673a\u6784\u63a7\u5236MAC\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean checkMac() {
        if (!this.txtMac.getText().isEmpty() && !StringUtils.isMac((String)this.txtMac.getText())) {
            this.lbMacError.setText("\u8bf7\u8f93\u5165\u6b63\u786eMac");
            this.lbMacError.setOpacity(1.0);
            return false;
        }
        if (!this.listMac.isEmpty() && this.listMac.stream().filter(item -> item.getValue().equalsIgnoreCase(this.txtMac.getText())).findFirst().isPresent()) {
            this.lbMacError.setText("Mac\u5df2\u5b58\u5728");
            this.lbMacError.setOpacity(1.0);
            return false;
        }
        return true;
    }

    @FXML
    public void addIp() {
        if (!this.checkIp()) {
            return;
        }
        PartyControl ip = new PartyControl();
        ip.setType(PartyControlType.IP.code);
        ip.setValue(this.txtIp.getText());
        try {
            this.partyMng.operatePartyControl(ip, 1, this.selectParty.getId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
            this.initValues();
            this.txtIp.clear();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u65b0\u589e\u673a\u6784\u63a7\u5236IP\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean checkIp() {
        if (!this.txtIp.getText().isEmpty() && !StringUtils.isIp((String)this.txtIp.getText())) {
            this.lbIpError.setText("\u8bf7\u8f93\u5165\u6b63\u786eIp");
            this.lbIpError.setOpacity(1.0);
            return false;
        }
        if (!this.listIp.isEmpty() && this.listIp.stream().filter(item -> item.getValue().equalsIgnoreCase(this.txtIp.getText())).findFirst().isPresent()) {
            this.lbIpError.setText("Ip\u5df2\u5b58\u5728");
            this.lbIpError.setOpacity(1.0);
            return false;
        }
        return true;
    }

    @FXML
    public boolean savePartyControl() {
        this.valid();
        if (this.listMac.isEmpty() && this.cboxMac.isSelected() || this.listIp.isEmpty() && this.cboxIp.isSelected()) {
            this.lbMessageSpec.setOpacity(1.0);
            Platform.runLater(() -> this.lbMessageSpec.requestFocus());
            return false;
        }
        LinkedList<PartyControl> PartyControls = new LinkedList<PartyControl>();
        PartyControls.addAll((Collection<PartyControl>)this.listMac);
        PartyControls.addAll((Collection<PartyControl>)this.listIp);
        try {
            this.partyMng.updatePartyControl(PartyControls, 2, this.selectParty.getId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
        }
        catch (MException e2) {
            logger.error("\u673a\u6784\u63a7\u5236\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25", (Throwable)e2);
            Platform.runLater(() -> {
                this.lbMessage.setText(e2.getMessage().isEmpty() ? "\u673a\u6784\u63a7\u5236\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25" : e2.getMessage());
                this.lbMessage.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getSelectParty() {
        return this.selectParty;
    }

    public void setSelectParty(Party selectParty) {
        this.selectParty = selectParty;
    }

    static enum PartyControlType {
        MAC("mac", 1),
        IP("ip", 2);

        private String desc;
        private int code;

        private PartyControlType(String desc, int code) {
            this.desc = desc;
            this.code = code;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getCode() {
            return this.code;
        }
    }
}

