/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Party;
import cms.tmx.entity.PartyControl;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartyControlDialog
extends DialogObj {
    @FXML
    private CheckBox cboxMac;
    @FXML
    private TextField txtMac;
    @FXML
    private Label lbMacError;
    @FXML
    private Button btnAddMac;
    @FXML
    private TableView<PartyControl> tableMac;
    @FXML
    private TableColumn<PartyControl, String> index;
    @FXML
    private TableColumn<PartyControl, String> colMac;
    @FXML
    private TableColumn<PartyControl, HBox> colOperaMac;
    @FXML
    private CheckBox cboxIp;
    @FXML
    private TextField txtIp;
    @FXML
    private Label lbIpError;
    @FXML
    private Button btnAddIp;
    @FXML
    private TableView<PartyControl> tableIp;
    @FXML
    private TableColumn<PartyControl, String> indexIp;
    @FXML
    private TableColumn<PartyControl, String> colIp;
    @FXML
    private TableColumn<PartyControl, HBox> colOperaIp;
    @FXML
    private Label lbMessage;
    @FXML
    private Label lbMessageSpec;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private ExecutorService exe;
    private ObservableList<PartyControl> listMac = FxUtils.newList();
    private ObservableList<PartyControl> listIp = FxUtils.newList();
    private Party selectParty;
    private static final Logger logger = LogManager.getLogger(PartyControlDialog.class);
    private static final int UPDATE_PARTYCONTROL = 2;

    @FXML
    public void initialize() {
        this.exe.execute(() -> this.initValues());
        this.addListener();
        this.createTableView();
        this.initBtn();
        this.initTextField();
    }

    private void initTextField() {
        this.txtMac.setTextFormatter((TextFormatter)new MxFormatter("^([0-9a-fA-F]{1,2})(([0-9a-fA-F]{0,2}){0,5})$", 12));
        this.txtIp.setTextFormatter((TextFormatter)new MxFormatter("^([0-9]{1,3})((\\.[0-9]{0,3}){0,3})$", 15));
    }

    private void initBtn() {
        this.btnAddIp.disableProperty().bind((ObservableValue)this.txtIp.textProperty().isEmpty());
        this.btnAddMac.disableProperty().bind((ObservableValue)this.txtMac.textProperty().isEmpty());
    }

    private void addListener() {
        this.tableMac.disableProperty().bind((ObservableValue)this.cboxMac.selectedProperty().not());
        this.tableIp.disableProperty().bind((ObservableValue)this.cboxIp.selectedProperty().not());
        this.lbMessageSpec.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.lbMessageSpec.setOpacity(0.0);
            }
        });
        this.txtMac.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbMacError.setOpacity(0.0);
                this.lbMacError.setText("");
            }
        });
        this.txtIp.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbIpError.setOpacity(0.0);
                this.lbIpError.setText("");
            }
        });
    }

    private void initValues() {
        try {
            List<PartyControl> list = this.partyMng.getPartyControl(this.selectParty.getId());
            if (list.isEmpty()) {
                return;
            }
            Map<Integer, List<PartyControl>> map = list.stream().collect(Collectors.groupingBy(PartyControl::getType));
            this.listMac.addAll(map.get(PartyControlType.MAC.code) == null ? this.listMac : FXCollections.observableList(map.get(PartyControlType.MAC.code)));
            this.listIp.addAll(map.get(PartyControlType.IP.code) == null ? this.listIp : FXCollections.observableList(map.get(PartyControlType.IP.code)));
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u673a\u6784\u63a7\u5236\u5f02\u5e38", (Throwable)e);
            this.lbMessage.setText(e.getMessage().isEmpty() ? "\u67e5\u8be2\u673a\u6784\u63a7\u5236\u5f02\u5e38" : e.getMessage());
        }
        Platform.runLater(() -> {
            this.cboxMac.setSelected(this.listMac.isEmpty() ? false : ((PartyControl)this.listMac.get(0)).isFlag());
            this.cboxIp.setSelected(this.listIp.isEmpty() ? false : ((PartyControl)this.listIp.get(0)).isFlag());
        });
    }

    private void createTableView() {
        TableUtils.isAuto(this.index);
        this.index.setSortable(false);
        TableUtils.isAuto(this.indexIp);
        this.indexIp.setSortable(false);
        this.colMac.setCellValueFactory(data -> ((PartyControl)data.getValue()).valueProperty());
        this.colIp.setCellValueFactory(data -> ((PartyControl)data.getValue()).valueProperty());
        this.colOperaMac.setCellValueFactory(data -> this.setOperateMac((PartyControl)data.getValue()));
        this.colOperaIp.setCellValueFactory(data -> this.setOperateIp((PartyControl)data.getValue()));
        this.tableMac.setPlaceholder((Node)new Label());
        this.tableIp.setPlaceholder((Node)new Label());
        this.tableMac.setItems(this.listMac);
        this.tableIp.setItems(this.listIp);
    }

    private ReadOnlyObjectWrapper<HBox> setOperateMac(PartyControl ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> this.listMac.remove((Object)ap));
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    private ReadOnlyObjectWrapper<HBox> setOperateIp(PartyControl ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> this.listIp.remove((Object)ap));
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    @FXML
    private void addMac() throws MException {
        if (!this.checkMac()) {
            return;
        }
        PartyControl mac = new PartyControl();
        mac.setType(PartyControlType.MAC.code);
        mac.setValue(this.txtMac.getText().toUpperCase());
        this.listMac.add((Object)mac);
        this.txtMac.clear();
    }

    private boolean checkMac() {
        if (!this.txtMac.getText().isEmpty() && !StringUtils.isMac((String)this.txtMac.getText())) {
            this.lbMacError.setText("\u8bf7\u8f93\u5165\u6b63\u786eMac");
            this.lbMacError.setOpacity(1.0);
            return false;
        }
        if (!this.listMac.isEmpty() && this.listMac.stream().filter(item -> item.getValue().equalsIgnoreCase(this.txtMac.getText())).findFirst().isPresent()) {
            this.lbMacError.setText("Mac\u5df2\u5b58\u5728");
            this.lbMacError.setOpacity(1.0);
            return false;
        }
        return true;
    }

    @FXML
    private void addIp() throws MException {
        if (!this.checkIp()) {
            return;
        }
        PartyControl ip = new PartyControl();
        ip.setType(PartyControlType.IP.code);
        ip.setValue(this.txtIp.getText());
        this.listIp.add((Object)ip);
        this.txtIp.clear();
    }

    private boolean checkIp() {
        if (!this.txtIp.getText().isEmpty() && !StringUtils.isIp((String)this.txtIp.getText())) {
            this.lbIpError.setText("\u8bf7\u8f93\u5165\u6b63\u786eIp");
            this.lbIpError.setOpacity(1.0);
            return false;
        }
        if (!this.listIp.isEmpty() && this.listIp.stream().filter(item -> item.getValue().equalsIgnoreCase(this.txtIp.getText())).findFirst().isPresent()) {
            this.lbIpError.setText("Ip\u5df2\u5b58\u5728");
            this.lbIpError.setOpacity(1.0);
            return false;
        }
        return true;
    }

    public boolean isOK(ButtonType bt) {
        if (this.listMac.isEmpty() && this.cboxMac.isSelected() || this.listIp.isEmpty() && this.cboxIp.isSelected()) {
            this.lbMessageSpec.setOpacity(1.0);
            Platform.runLater(() -> this.lbMessageSpec.requestFocus());
            return false;
        }
        LinkedList<PartyControl> PartyControls = new LinkedList<PartyControl>();
        PartyControls.addAll((Collection<PartyControl>)this.listMac);
        PartyControls.addAll((Collection<PartyControl>)this.listIp);
        try {
            this.partyMng.updatePartyControl(PartyControls, 2, this.selectParty.getId(), this.cboxMac.isSelected(), this.cboxIp.isSelected());
        }
        catch (MException e) {
            logger.error("\u673a\u6784\u63a7\u5236\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            Platform.runLater(() -> {
                this.lbMessage.setText(e.getMessage().isEmpty() ? "\u673a\u6784\u63a7\u5236\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25" : e.getMessage());
                this.lbMessage.requestFocus();
            });
            return false;
        }
        return true;
    }

    public Party getSelectParty() {
        return this.selectParty;
    }

    public void setSelectParty(Party selectParty) {
        this.selectParty = selectParty;
    }

    static enum PartyControlType {
        MAC("mac", 1),
        IP("ip", 2);

        private String desc;
        private int code;

        private PartyControlType(String desc, int code) {
            this.desc = desc;
            this.code = code;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getCode() {
            return this.code;
        }
    }
}

