/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.MsgSetting;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.MsgSettingMngServiceImpl;
import cms.tmx.manage.models.MsgSettingModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.MsgSettingDialog;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MsgSettingsPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(MsgSettingsPart.class);
    @FXML
    private TextField txtSearch;
    @FXML
    private TableView<MsgSetting> tableMsgSetting;
    @FXML
    private TableColumn<MsgSetting, String> index;
    @FXML
    private TableColumn<MsgSetting, String> interval;
    @FXML
    private TableColumn<MsgSetting, String> other;
    @FXML
    private TableColumn<MsgSetting, String> operat;
    @FXML
    private TableColumn<MsgSetting, String> creator;
    @FXML
    private TableColumn<MsgSetting, String> updater;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MsgSettingMngServiceImpl msgImlp;
    @Inject
    private MxAlert mAlert;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private ExecutorService exe;
    @Inject
    private MsgSettingModel msgm;
    private MsgSetting selectTableSetting;
    private MxList<MsgSetting> mlist = new MxList();
    private List<MsgSetting> filterList = new LinkedList<MsgSetting>();
    private Predicate<MsgSetting> pd = portfolio -> {
        String subType = this.txtSearch.getText().trim();
        return portfolio.getSubType().getValue().contains(subType);
    };
    private InvalidationListener msgMod = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableMsgSetting.sort();
    };

    @FXML
    public void initialize() {
        this.txtSearch.textProperty().addListener(this.msgMod);
        this.creatTable();
        this.exe.execute(() -> this.query());
    }

    private void creatTable() {
        this.tableMsgSetting.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableMsgSetting);
        this.interval.setCellFactory(data -> new IntervalCell());
        this.other.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MsgSetting, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MsgSetting, String> arg0) {
                MsgSetting msg = (MsgSetting)arg0.getValue();
                String s = "";
                if (msg.isEmail()) {
                    s = msg.isMsg() ? "\u90ae\u4ef6,\u77ed\u4fe1" : "\u90ae\u4ef6";
                } else if (msg.isMsg()) {
                    s = "\u77ed\u4fe1";
                }
                return new SimpleStringProperty(s);
            }
        });
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((MsgSetting)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((MsgSetting)data.getValue()).getUpdater()));
        this.operat.setCellFactory(data -> new OperaCell(this.stage, this.tableMsgSetting));
        this.tableMsgSetting.setItems(this.mlist.getList());
    }

    @FXML
    private void add() {
        MsgSettingDialog obj = (MsgSettingDialog)((Object)this.of.create(MsgSettingDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u6d88\u606f\u63d0\u793a");
        if (ButtonType.OK == dialog.launch()) {
            this.exe.execute(() -> this.query());
        }
    }

    @FXML
    private void query() {
        try {
            List<MsgSetting> listPortfolio = this.msgImlp.getMsgSetting();
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            listPortfolio.forEach(item -> {
                this.filterList.add((MsgSetting)item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
        this.mlist.setAll(this.filterList);
        this.mlist.update(this.filterList, this.pd);
        Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
        this.tableMsgSetting.sort();
    }

    private void update() {
        this.selectTableSetting = (MsgSetting)this.tableMsgSetting.getSelectionModel().getSelectedItem();
        if (this.selectTableSetting == null) {
            return;
        }
        this.msgm.setSetting(this.selectTableSetting);
        try {
            MsgSettingDialog obj = (MsgSettingDialog)((Object)this.of.create(MsgSettingDialog.class));
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u6d88\u606f\u63d0\u793a");
            if (ButtonType.OK == dialog.launch()) {
                this.exe.execute(() -> this.query());
            }
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void delete() {
        if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u5220\u9664", "\u63d0\u793a")) {
            try {
                this.msgImlp.deleteMsgSetting((MsgSetting)this.tableMsgSetting.getSelectionModel().getSelectedItem());
                this.exe.execute(() -> this.query());
            }
            catch (MException e) {
                this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private class IntervalCell
    extends TableCell<MsgSetting, String> {
        private IntervalCell() {
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof MsgSetting) {
                    MsgSetting r = (MsgSetting)this.getTableRow().getItem();
                    if ("0".equals(r.getInterval())) {
                        this.setText("\u65e0");
                    } else if ("-1".equals(r.getInterval())) {
                        this.setText("\u6c38\u4e45");
                    } else {
                        this.setText(String.valueOf(r.getInterval()) + "\u79d2");
                    }
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class OperaCell
    extends TableCell<MsgSetting, String> {
        final Label updateLab = new Label("\u4fee\u6539");
        final HBox paddedLabel = new HBox();
        final Label statusLab = new Label("\u5220\u9664");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            this.paddedLabel.getChildren().add((Object)this.updateLab);
            HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
            this.paddedLabel.getChildren().add((Object)this.statusLab);
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    MsgSettingsPart.this.update();
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    MsgSettingsPart.this.delete();
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

