/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.MsgSetting;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.MsgSettingMngServiceImpl;
import cms.tmx.manage.models.MsgSettingModel;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MsgSettingDialog
extends DialogObj {
    @FXML
    private HBox hboxTime;
    @FXML
    private CheckBox cboxInterval;
    @FXML
    private HBox hboxTxt;
    @FXML
    private TextField txtInterval;
    @FXML
    private Label lbIntervalErr;
    @FXML
    private CheckBox cboxRing;
    @FXML
    private ComboBox<MxNode> cmbLevel;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private ComboBox<MxNode> cmbSubType;
    @FXML
    private Label lbTypeErr;
    @FXML
    private Label lbSubTypeErr;
    @FXML
    private ComboBox<String> cmbRing;
    @FXML
    private Label lbRingErr;
    @FXML
    private ColorPicker cpColor;
    @FXML
    private ComboBox<MxNode> cmbNotifyWay;
    @FXML
    private CheckBox cboxEmail;
    @FXML
    private CheckBox cboxMsg;
    @FXML
    private CheckBox cboxPush;
    @FXML
    private CheckBox cboxCustom;
    @FXML
    private CheckBox cboxReset;
    @FXML
    private TextArea txaContent;
    @FXML
    private FlowPane fpaneParam;
    @FXML
    private Label labSuccess;
    @FXML
    private Label lbAlert;
    @Inject
    private MObjFactory of;
    @Inject
    private MsgSettingMngServiceImpl msgImlp;
    @Inject
    private MsgSettingModel msgm;
    private static final Logger logger = LogManager.getLogger(MsgSettingDialog.class);
    private MsgSetting setting;
    private ObservableList<MxNode> tip;
    private ObservableList<MxNode> task;
    private String newSettingId = "";

    @FXML
    private void initialize() {
        this.setting = (MsgSetting)this.of.create(MsgSetting.class);
        if (this.msgm.getSetting() != null) {
            this.setting.update((Object)this.msgm.getSetting());
            this.msgm.setSetting(null);
            this.cmbType.setDisable(true);
            this.cmbSubType.setDisable(true);
        }
        this.initControl();
        this.addListen();
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.cmbLevel.valueProperty().bindBidirectional((Property)this.setting.levelProperty());
        this.cmbType.valueProperty().bindBidirectional((Property)this.setting.typeProperty());
        this.cmbSubType.valueProperty().bindBidirectional((Property)this.setting.subTypeProperty());
        this.cmbNotifyWay.valueProperty().bindBidirectional((Property)this.setting.notifyWayProperty());
        this.cpColor.valueProperty().bindBidirectional((Property)this.setting.colorProperty());
        this.cboxRing.selectedProperty().bindBidirectional((Property)this.setting.ringProperty());
        this.cmbRing.valueProperty().bindBidirectional((Property)this.setting.ringNameProperty());
        this.cboxEmail.selectedProperty().bindBidirectional((Property)this.setting.emailProperty());
        this.cboxMsg.selectedProperty().bindBidirectional((Property)this.setting.msgProperty());
        this.cboxPush.selectedProperty().bindBidirectional((Property)this.setting.forcedPushProperty());
        this.cboxCustom.selectedProperty().bindBidirectional((Property)this.setting.customProperty());
        this.cboxReset.selectedProperty().bindBidirectional((Property)this.setting.resetProperty());
        this.txaContent.textProperty().bindBidirectional((Property)this.setting.contentProperty());
    }

    private void addListen() {
        this.cmbType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.cmbSubType.getSelectionModel().clearSelection();
                if (now.getRaw().equals("1")) {
                    this.cmbSubType.setItems(this.tip);
                } else {
                    this.cmbSubType.setItems(this.task);
                }
            }
        });
        Button instNum = new Button("+\u6307\u4ee4\u7f16\u53f7");
        this.buttonAction(instNum);
        Button accnt = new Button("+\u8d44\u91d1\u8d26\u53f7");
        this.buttonAction(accnt);
        Button portfolio = new Button("+\u6295\u8d44\u7ec4\u5408");
        this.buttonAction(portfolio);
        Button obj = new Button("+\u4ea4\u6613\u5bf9\u8c61");
        this.buttonAction(obj);
        Button instStatus = new Button("+\u6307\u4ee4\u72b6\u6001");
        this.buttonAction(instStatus);
        Button mark = new Button("+\u5907\u6ce8");
        this.buttonAction(mark);
        Button time = new Button("+\u65f6\u95f4");
        this.buttonAction(time);
        Button operator = new Button("+\u64cd\u4f5c\u4eba");
        this.buttonAction(operator);
        Button stepName = new Button("+\u6b65\u9aa4\u540d\u79f0");
        this.buttonAction(stepName);
        Button orderNum = new Button("+\u59d4\u6258\u7f16\u53f7");
        this.buttonAction(orderNum);
        Button secNum = new Button("+\u8bc1\u5238\u4ee3\u7801");
        this.buttonAction(secNum);
        Button secName = new Button("+\u8bc1\u5238\u540d\u79f0");
        this.buttonAction(secName);
        Button direc = new Button("+\u4ea4\u6613\u65b9\u5411");
        this.buttonAction(direc);
        Button price = new Button("+\u4ef7\u683c");
        this.buttonAction(price);
        Button count = new Button("+\u6570\u91cf");
        this.buttonAction(count);
        Button trader = new Button("+\u4ea4\u6613\u5458");
        this.buttonAction(trader);
        Button serviceName = new Button("+\u670d\u52a1\u540d\u79f0");
        this.buttonAction(serviceName);
        Button riskTypeName = new Button("+\u98ce\u63a7\u5206\u7c7b\u540d\u79f0");
        this.buttonAction(riskTypeName);
        Button objName = new Button("+\u5bf9\u8c61\u540d\u79f0");
        this.buttonAction(objName);
        Button cjOp = new Button("+\u89e6\u8b66\u64cd\u4f5c");
        this.buttonAction(cjOp);
        Button szfz = new Button("+\u8bbe\u7f6e\u9608\u503c");
        this.buttonAction(szfz);
        Button cfhzbz = new Button("+\u51fa\u53d1\u540e\u6307\u6807\u503c");
        this.buttonAction(cfhzbz);
        Button userName = new Button("+\u7528\u6237\u540d");
        this.buttonAction(userName);
        Button loginStatus = new Button("+\u767b\u5f55\u72b6\u6001");
        this.buttonAction(loginStatus);
        Button market = new Button("+\u4ea4\u6613\u5e02\u573a");
        this.buttonAction(market);
        Button marketStatus = new Button("+\u5e02\u573a\u72b6\u6001");
        this.buttonAction(marketStatus);
        Button orig = new Button("+\u53d1\u8d77\u4eba");
        this.buttonAction(orig);
        Button insStep = new Button("+\u6307\u4ee4\u6b65\u9aa4");
        this.buttonAction(insStep);
        Button riskName = new Button("+\u98ce\u63a7\u540d\u79f0");
        this.buttonAction(riskName);
        Button ip = new Button("+IP");
        this.buttonAction(ip);
        Button mac = new Button("+MAC");
        this.buttonAction(mac);
        LinkedList<Button> instructTips = new LinkedList<Button>();
        instructTips.add(instNum);
        instructTips.add(accnt);
        instructTips.add(portfolio);
        instructTips.add(obj);
        instructTips.add(instStatus);
        instructTips.add(mark);
        instructTips.add(time);
        instructTips.add(operator);
        instructTips.add(stepName);
        LinkedList<Button> orderTips = new LinkedList<Button>();
        orderTips.add(orderNum);
        orderTips.add(secNum);
        orderTips.add(secName);
        orderTips.add(direc);
        orderTips.add(price);
        orderTips.add(count);
        orderTips.add(time);
        orderTips.add(trader);
        orderTips.add(mark);
        orderTips.add(accnt);
        orderTips.add(portfolio);
        LinkedList<Button> systemTips = new LinkedList<Button>();
        systemTips.add(serviceName);
        systemTips.add(time);
        LinkedList<Button> netTips = new LinkedList<Button>();
        netTips.add(time);
        LinkedList<Button> riskTips = new LinkedList<Button>();
        riskTips.add(riskTypeName);
        riskTips.add(objName);
        riskTips.add(cjOp);
        riskTips.add(szfz);
        riskTips.add(cfhzbz);
        riskTips.add(time);
        LinkedList<Button> loginTips = new LinkedList<Button>();
        loginTips.add(userName);
        loginTips.add(time);
        loginTips.add(loginStatus);
        loginTips.add(ip);
        loginTips.add(mac);
        loginTips.add(mark);
        LinkedList<Button> marketTips = new LinkedList<Button>();
        marketTips.add(market);
        marketTips.add(marketStatus);
        marketTips.add(time);
        LinkedList<Button> funcTips = new LinkedList<Button>();
        funcTips.add(operator);
        funcTips.add(time);
        LinkedList<Button> dataTips = new LinkedList<Button>();
        dataTips.add(operator);
        dataTips.add(time);
        LinkedList<Button> insAprTips = new LinkedList<Button>();
        insAprTips.add(instNum);
        insAprTips.add(trader);
        insAprTips.add(orig);
        insAprTips.add(insStep);
        insAprTips.add(time);
        LinkedList<Button> riskAprTips = new LinkedList<Button>();
        riskAprTips.add(riskName);
        riskAprTips.add(objName);
        riskAprTips.add(operator);
        riskAprTips.add(time);
        this.cmbSubType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.fpaneParam.getChildren().clear();
                if ("10000".equals(now.getRaw()) || "10001".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)instructTips);
                } else if ("10002".equals(now.getRaw()) || "10003".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)orderTips);
                } else if ("10004".equals(now.getRaw()) || "10005".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)systemTips);
                } else if ("10006".equals(now.getRaw()) || "10007".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)netTips);
                } else if ("10008".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)riskTips);
                } else if ("10009".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)loginTips);
                } else if ("10010".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)marketTips);
                } else if ("10011".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)funcTips);
                } else if ("10012".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)dataTips);
                } else if ("20001".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)insAprTips);
                } else if ("20002".equals(now.getRaw())) {
                    this.fpaneParam.getChildren().addAll((Collection)riskAprTips);
                }
                for (Node item : this.fpaneParam.getChildren()) {
                    FlowPane.setMargin((Node)item, (Insets)new Insets(10.0, 0.0, 0.0, 15.0));
                }
                this.txaContent.clear();
            }
        });
        this.cmbNotifyWay.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                if (now.getRaw().equals("0") || now.getRaw().equals("1")) {
                    this.hboxTime.setVisible(false);
                } else {
                    this.hboxTime.setVisible(true);
                    if (!this.setting.getInterval().isEmpty()) {
                        if ("-1".equals(this.setting.getInterval())) {
                            this.cboxInterval.setSelected(false);
                        } else {
                            this.cboxInterval.setSelected(true);
                            this.txtInterval.setText(this.setting.getInterval());
                        }
                    }
                }
            }
        });
        this.cboxInterval.selectedProperty().addListener((ob, old, now) -> {
            if (now != null) {
                if (now.booleanValue()) {
                    this.hboxTxt.setVisible(true);
                    if (this.txtInterval.getText().isEmpty()) {
                        this.txtInterval.setText("1");
                    }
                } else {
                    this.hboxTxt.setVisible(false);
                }
            }
        });
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    private void buttonAction(Button btn) {
        btn.setOnAction(ob -> this.printParam("[" + btn.getText().replaceAll("\\+", "") + "]"));
    }

    private void printParam(String s) {
        this.txaContent.setText(this.txaContent.getText().concat(s));
    }

    private void addCheck() {
        this.txtInterval.setTextFormatter((TextFormatter)new MxFormatter("^([1-9]{1}\\d*)$", 5));
        this.txaContent.setTextFormatter((TextFormatter)new MxFormatter(300));
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbSubTypeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbSubType.getValue() != null && !((MxNode)this.cmbSubType.getValue()).getRaw().isEmpty()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.cmbSubType.valueProperty()}));
        this.registerCheck((Node)this.lbIntervalErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.hboxTime.isVisible() && this.hboxTxt.isVisible()) {
                return !this.txtInterval.getText().isEmpty();
            }
            return true;
        }, (Observable[])new Observable[]{this.txtInterval.textProperty(), this.hboxTime.visibleProperty(), this.hboxTxt.visibleProperty()}));
    }

    private void initControl() {
        MxNode node = MxNodeFactory.create((String)"msg_level", (String)"1");
        this.cmbLevel.setItems(node.getNodes());
        node = MxNodeFactory.create((String)"msg_type", (String)"1");
        this.cmbType.setItems(node.getNodes());
        node = MxNodeFactory.create((String)"msg_notify", (String)"0");
        this.cmbNotifyWay.setItems(node.getNodes());
        MxNode subType = MxNodeFactory.create((String)"msg_subtype", (String)"1");
        List listTip = subType.getNodes().subList(0, 13);
        listTip.sort(new Comparator<MxNode>(){

            @Override
            public int compare(MxNode arg1, MxNode arg2) {
                int o2;
                int o1 = Integer.valueOf(arg1.getRaw());
                if (o1 > (o2 = Integer.valueOf(arg2.getRaw()).intValue())) {
                    return 1;
                }
                return -1;
            }
        });
        this.tip = FXCollections.observableList((List)listTip);
        this.task = FXCollections.observableList((List)subType.getNodes().subList(13, 15));
        LinkedList<String> music = new LinkedList<String>();
        music.add("instruction_notice.wav");
        this.cmbRing.setItems(FXCollections.observableList(music));
        this.txaContent.setWrapText(true);
    }

    public boolean isOK(ButtonType bt) {
        if (!this.valid()) {
            return false;
        }
        if (this.hboxTime.isVisible()) {
            if (this.cboxInterval.isSelected()) {
                this.setting.setInterval(this.txtInterval.getText());
            } else {
                this.setting.setInterval("-1");
            }
        } else {
            this.setting.setInterval("0");
        }
        try {
            if (this.newSettingId.isEmpty() && this.setting.getId() <= 0) {
                this.newSettingId = this.msgImlp.addMsgSetting(this.setting);
                this.setting.setId(Integer.parseInt(this.newSettingId));
                this.cmbType.setDisable(true);
                this.cmbSubType.setDisable(true);
            } else {
                this.msgImlp.updateMsgSetting(this.setting);
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        return true;
    }
}

