/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.LoggerMessage;
import cms.tmx.entity.LoggerMsgPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.UserMngServiceImpl;
import java.io.File;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggerMessagePart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(LoggerMessagePart.class);
    private static final String FORMAT = "yyyy-MM-dd";
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> pageSize;
    @FXML
    private Pagination pagination;
    @FXML
    private Label totalCount;
    @FXML
    private TextField jumpPage;
    @FXML
    private TextField userIdSearch;
    @FXML
    private Button btnSearch;
    @FXML
    private TableView<LoggerMessage> tableLogger;
    @FXML
    private TableColumn<LoggerMessage, String> index;
    @FXML
    private TableColumn<LoggerMessage, String> userId;
    @FXML
    private TableColumn<LoggerMessage, String> userName;
    @FXML
    private TableColumn<LoggerMessage, String> date;
    @FXML
    private TableColumn<LoggerMessage, String> interfaceNum;
    @FXML
    private TableColumn<LoggerMessage, String> reason;
    @FXML
    private TableColumn<LoggerMessage, String> ip;
    @FXML
    private TableColumn<LoggerMessage, String> mac;
    @FXML
    private TableColumn<LoggerMessage, String> sn;
    @Inject
    private UserMngServiceImpl userService;
    @Inject
    private MxAlert alert;
    private LoggerMsgPage<LoggerMessage> page = new LoggerMsgPage();
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem excel;
    private Map<String, String> reactMap = new HashMap<String, String>();

    @FXML
    public void initialize() {
        this.initValue();
        this.page.changedProperty().addListener(ob -> this.queryAll());
        this.creatTableLogger();
        this.query();
    }

    private void creatTableLogger() {
        this.tableLogger.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.index);
        this.index.setSortable(false);
        this.userId.setCellValueFactory(data -> ((LoggerMessage)data.getValue()).userIdProperty());
        this.reactMap.put(this.userId.getId(), "UserId");
        this.userName.setCellValueFactory(data -> ((LoggerMessage)data.getValue()).userNameProperty());
        this.reactMap.put(this.userName.getId(), "UserName");
        this.date.setCellValueFactory(data -> ((LoggerMessage)data.getValue()).dateProperty());
        this.reactMap.put(this.date.getId(), "Date");
        this.interfaceNum.setCellValueFactory(data -> ((LoggerMessage)data.getValue()).actionProperty());
        this.reactMap.put(this.interfaceNum.getId(), "Action");
        this.reason.setCellValueFactory(data -> ((LoggerMessage)data.getValue()).reasonProperty());
        this.reactMap.put(this.reason.getId(), "Reason");
        this.ip.setCellValueFactory(data -> ((LoggerMessage)data.getValue()).ipProperty());
        this.reactMap.put(this.ip.getId(), "Ip");
        this.mac.setCellValueFactory(data -> ((LoggerMessage)data.getValue()).macProperty());
        this.reactMap.put(this.mac.getId(), "Mac");
        this.sn.setCellValueFactory(data -> ((LoggerMessage)data.getValue()).snProperty());
        this.reactMap.put(this.sn.getId(), "Sn");
        this.tableLogger.setItems(this.page.getDataList());
    }

    private void initValue() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
        this.page.userIdProperty().bind((ObservableValue)this.userIdSearch.textProperty());
        this.userIdSearch.setTextFormatter((TextFormatter)new MxFormatter("^U[0-9]*$", 11));
        this.userIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initPage(this.pagination, this.totalCount, this.jumpPage, this.pageSize, this.page);
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, LoggerMsgPage<?> pageModel) {
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"20");
        node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw()));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, LoggerMsgPage<?> pageModel) {
        int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
        pageModel.setPageSize(Integer.valueOf(pageSize));
    }

    @FXML
    protected void query() {
        this.page.clear();
        this.queryAll();
    }

    private void queryAll() {
        this.page.setBeginDate(String.valueOf(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", "")) + " 00:00:00");
        this.page.setEndDate(String.valueOf(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", "")) + " 23:59:59");
        try {
            this.userService.query(this.page);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.tableLogger.scrollTo(0);
        this.tableLogger.sort();
    }

    @FXML
    public void refresh() {
        this.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableLogger);
    }

    @FXML
    private void exportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u64cd\u4f5c\u65e5\u5fd7\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.excel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    ExcelUtils.writeExcel(this.tableLogger, this.userService.queryAllLogger(this.page), this.reactMap, (File)file);
                    Platform.runLater(() -> this.excel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.excel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception exception) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38");
        }
    }
}

