/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.Search;
import cms.tmx.control.search.StrSuggest;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.Portfolio;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.utils.MarketUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FundTransferDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(FundTransferDialog.class);
    @Inject
    private IPortfolioApi portApi;
    @FXML
    private VBox vbox;
    @FXML
    private ComboBox<Party> cmbParty;
    @FXML
    private ComboBox<String> cmbFund;
    @FXML
    private ComboBox<MxNode> cmbCurrency;
    @FXML
    private ComboBox<String> cmbSrc;
    @FXML
    private ComboBox<String> cmbDest;
    @FXML
    private Label lbCan;
    @FXML
    private Label lbBaseErr;
    @FXML
    private Label lbCanTransfer;
    @FXML
    private TextField txtBase;
    @FXML
    private TextField txtPercent;
    @FXML
    private Label lbTransfer;
    @FXML
    private Label lbDestErr;
    @FXML
    private Label lbDestErr1;
    @FXML
    private Label lbSrcErr;
    @FXML
    private Label lbTransferErr;
    @FXML
    private GridPane gridTop;
    @FXML
    private GridPane gridBottom;
    @FXML
    private RadioButton radioOut;
    @FXML
    private RadioButton radioIn;
    @FXML
    private RadioButton radioOutIn;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private IAccountService account;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert alert;
    @Inject
    private IFundAccountApi fundAcctApi;
    private ObservableList<String> listPort = FxUtils.newList();
    private Map<String, Portfolio> mapPort = new HashMap<String, Portfolio>();
    private ObservableList<String> listAcc = FxUtils.newList();
    private Map<String, Account> mapAcc = new HashMap<String, Account>();
    protected StrSuggest spSrc = new StrSuggest();
    protected StrSuggest spAcc = new StrSuggest();
    protected StrSuggest spDest = new StrSuggest();
    private DecimalFormat df = new DecimalFormat("#0.000");
    private ToggleGroup group = new ToggleGroup();
    private String srcSubAccntId = "";
    private String dstSubAccntId = "";
    private Party party;
    private int type = 2;

    public void setParty(Party party) {
        this.party = party;
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{new ButtonType("\u5212\u8f6c", ButtonBar.ButtonData.OK_DONE)};
    }

    @FXML
    public void initialize() {
        this.queryPortfolio();
        this.queryAccnt();
        this.initValues();
        this.registerCheck();
    }

    private void registerCheck() {
        this.registerCheck((Node)this.lbSrcErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.radioIn.isSelected()) {
                return true;
            }
            try {
                this.setFund((String)this.cmbSrc.getSelectionModel().getSelectedItem());
                this.cmbDest.getItems().clear();
            }
            catch (MException e) {
                logger.error("\u6839\u636e\u6295\u7ec4id\u67e5\u4e00\u7ea7\u8d26\u6237\u5931\u8d25\uff1a", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
            if (this.cmbSrc.getSelectionModel().getSelectedItem() != null && this.cmbFund.getItems().size() == 0) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbSrc.getSelectionModel().selectedItemProperty()}));
        this.registerCheck((Node)this.lbDestErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.radioOut.isSelected()) {
                return true;
            }
            this.setDstPortfolio();
            if (this.cmbDest.getItems().size() == 0 && this.cmbFund.getSelectionModel().getSelectedItem() != null) {
                this.lbDestErr.setText("\u65e0\u76ee\u6807\u7ec4\u5408\u4e0e\u6b64\u8d44\u91d1\u8d26\u6237\u5173\u8054");
                this.lbDestErr1.setText("");
                return false;
            }
            this.lbDestErr1.setText("\u8bf7\u9009\u62e9\u76ee\u6807\u6295\u7ec4");
            return true;
        }, (Observable[])new Observable[]{this.cmbFund.getSelectionModel().selectedItemProperty()}));
        this.registerCheck((Node)this.lbDestErr1, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.radioOut.isSelected()) {
                return true;
            }
            this.lbDestErr1.setText("\u8bf7\u9009\u62e9\u76ee\u6807\u6295\u7ec4");
            if (this.cmbDest.getSelectionModel().getSelectedItem() == null && this.cmbFund.getSelectionModel().getSelectedItem() != null) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbDest.getSelectionModel().selectedItemProperty()}));
    }

    private void setDstPortfolio() {
        String investorId = (String)this.cmbFund.getSelectionModel().getSelectedItem();
        Account acc = this.mapAcc.get(investorId);
        if (acc == null) {
            return;
        }
        try {
            ObservableList listRelate = FxUtils.newList();
            List details = this.portApi.getPortfolioIdsByAccntId(acc.getId());
            for (PPortfolio.PortAccntAssignDetails detail : details) {
                if (detail.getAssignStatus() != 1) continue;
                listRelate.add((Object)detail.getPortfolioId());
            }
            this.cmbDest.getItems().clear();
            this.spDest.clearSuggestions();
            for (String src : this.listPort) {
                Portfolio po;
                String nowSrc = (String)this.cmbSrc.getSelectionModel().getSelectedItem();
                if (this.radioOutIn.isSelected() && src.equals(nowSrc) || !listRelate.contains((Object)(po = this.mapPort.get(src)).getId())) continue;
                this.cmbDest.getItems().add((Object)src);
            }
            this.spDest.addPossibleSuggestions((Collection)this.cmbDest.getItems());
        }
        catch (MException e) {
            logger.error("\u6839\u636e\u8d26\u6237\u67e5\u6295\u7ec4\u5931\u8d25\uff1a", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void setFund(String portName) throws MException {
        logger.debug("setFund \u5165\u53c2\uff1a " + portName);
        this.cmbFund.getItems().clear();
        this.spAcc.clearSuggestions();
        Portfolio port = this.mapPort.get(portName);
        if (port == null) {
            logger.debug("port is null " + this.mapPort);
            return;
        }
        logger.debug("portfolio: " + port.getName());
        ArrayList<String> listParent = new ArrayList<String>();
        List details = this.portApi.getAccntsByPortfolioIds(port.getId());
        logger.debug("details: " + details);
        for (PPortfolio.PortAccntAssignDetails detail : details) {
            if (detail.getAccntType() != 2 || detail.getAssignStatus() != 1) continue;
            listParent.add(detail.getParentId());
        }
        logger.debug("listParent : " + listParent);
        for (String investorId : this.listAcc) {
            Account acc = this.mapAcc.get(investorId);
            if (!listParent.contains(acc.getId())) continue;
            logger.debug("investorId: " + investorId);
            this.cmbFund.getItems().add((Object)investorId);
        }
        this.spAcc.addPossibleSuggestions((Collection)this.cmbFund.getItems());
    }

    private void initValues() {
        this.cmbParty.setValue((Object)this.party);
        this.cmbSrc.setItems(this.listPort);
        this.spSrc.addPossibleSuggestions(this.listPort);
        Search.bindAutoCompletion((TextField)this.cmbSrc.getEditor(), (Callback)this.spSrc).setPrefWidth(150.0);
        this.cmbSrc.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbSrc.getSelectionModel().select(now);
            this.cmbSrc.hide();
        });
        this.txtBase.requestFocus();
        Search.bindAutoCompletion((TextField)this.cmbFund.getEditor(), (Callback)this.spAcc).setPrefWidth(150.0);
        this.cmbFund.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbFund.getSelectionModel().select(now);
            this.cmbFund.hide();
        });
        ObservableList listCur = FxUtils.newList();
        this.cmbFund.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            Account acc = this.mapAcc.get(now);
            if (acc == null) {
                return;
            }
            listCur.clear();
            for (String str : acc.getCurrency()) {
                MxNode node1 = MxNodeFactory.create((String)"currency_type", (String)"CNY");
                node1.setRaw(str);
                listCur.add((Object)node1);
            }
            this.cmbCurrency.setItems(listCur);
            this.cmbCurrency.getSelectionModel().select(0);
        });
        this.cmbCurrency.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.setAvailable());
        Search.bindAutoCompletion((TextField)this.cmbDest.getEditor(), (Callback)this.spDest).setPrefWidth(150.0);
        this.cmbDest.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbDest.getSelectionModel().select(now);
            this.cmbDest.hide();
        });
        this.txtPercent.setTextFormatter((TextFormatter)new MxFormatter("^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$", 5));
        this.txtPercent.setText("100");
        this.txtBase.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 12, 3)));
        this.radioIn.setToggleGroup(this.group);
        this.radioOut.setToggleGroup(this.group);
        this.radioOutIn.setToggleGroup(this.group);
        this.radioOutIn.setSelected(true);
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            this.cmbFund.getItems().clear();
            this.cmbDest.getItems().clear();
            this.vbox.getChildren().clear();
            LinkedList<Object> list = new LinkedList<Object>();
            if (this.radioIn.isSelected()) {
                list.add(this.gridTop);
                list.add(this.cmbFund.getParent().getParent());
                list.add(this.cmbDest.getParent().getParent());
                list.add(this.gridBottom);
                this.cmbFund.getItems().addAll(this.listAcc);
                this.spAcc.setAllSuggestions((Collection)this.cmbFund.getItems());
                this.type = 0;
            } else {
                try {
                    this.setFund((String)this.cmbSrc.getSelectionModel().getSelectedItem());
                }
                catch (MException e) {
                    logger.error("\u91cd\u7f6e\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e);
                }
            }
            if (this.radioOut.isSelected()) {
                list.add(this.gridTop);
                list.add(this.cmbSrc.getParent().getParent());
                list.add(this.cmbFund.getParent().getParent());
                list.add(this.gridBottom);
                this.type = 1;
            }
            if (this.radioOutIn.isSelected()) {
                list.add(this.gridTop);
                list.add(this.cmbSrc.getParent().getParent());
                list.add(this.cmbFund.getParent().getParent());
                list.add(this.cmbDest.getParent().getParent());
                list.add(this.gridBottom);
                this.type = 2;
            }
            this.vbox.getChildren().addAll(list);
            this.setAvailable();
            this.lbDestErr.setOpacity(0.0);
            this.lbDestErr1.setOpacity(0.0);
        });
        this.txtPercent.textProperty().addListener((ob, old, now) -> {
            double percent = 0.0;
            if (!now.isEmpty()) {
                percent = Double.valueOf(now);
            }
            double base = Double.valueOf(this.txtBase.getText());
            this.lbTransfer.setText(this.df.format(base * percent / 100.0));
        });
        this.txtBase.textProperty().addListener((ob, old, now) -> {
            double base = 0.0;
            if (!now.isEmpty()) {
                base = Double.valueOf(now);
            }
            double percent = Double.valueOf(this.txtPercent.getText());
            this.lbTransfer.setText(this.df.format(base * percent / 100.0));
        });
        this.lbTransfer.textProperty().addListener((ob, old, now) -> this.checkTransferErr());
        this.lbCanTransfer.textProperty().addListener((ob, old, now) -> this.checkTransferErr());
    }

    private void checkTransferErr() {
        double trans = 0.0;
        double can = 0.0;
        if (!this.lbTransfer.getText().isEmpty()) {
            trans = Double.valueOf(this.lbTransfer.getText());
        }
        if (!this.lbCanTransfer.getText().isEmpty()) {
            can = Double.valueOf(this.lbCanTransfer.getText());
        }
        if (trans > can) {
            this.lbTransferErr.setOpacity(1.0);
        } else {
            this.lbTransferErr.setOpacity(0.0);
        }
    }

    public boolean isOK(ButtonType bt) {
        String dstSubAccnt;
        if (!this.checkValid()) {
            return false;
        }
        Portfolio src = this.mapPort.get(this.cmbSrc.getSelectionModel().getSelectedItem());
        Portfolio dst = this.mapPort.get(this.cmbDest.getSelectionModel().getSelectedItem());
        if (src == null) {
            src = (Portfolio)this.of.create(Portfolio.class);
            src.setPartyId(dst.getPartyId());
        }
        if (dst == null) {
            dst = (Portfolio)this.of.create(Portfolio.class);
            dst.setPartyId(src.getPartyId());
        }
        if ((dstSubAccnt = this.getDstSubAccntId()).equals("")) {
            this.alert.alert(Alert.AlertType.ERROR, "\u76ee\u6807\u7ec4\u5408\u5b50\u8d26\u6237\u4e3a\u7a7a");
            return false;
        }
        if (this.srcSubAccntId.equals("")) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6e90\u7ec4\u5408\u5b50\u8d26\u6237\u4e3a\u7a7a");
            return false;
        }
        try {
            this.portApi.TransferCash(this.type, this.srcSubAccntId, src.getPartyId(), dstSubAccnt, dst.getPartyId(), Double.valueOf(this.lbTransfer.getText()).doubleValue());
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8d44\u91d1\u5212\u8f6c\u6210\u529f");
            this.setAvailable();
        }
        catch (MException e) {
            logger.error("\u8d44\u91d1\u5212\u8f6c\u5931\u8d25\uff1a", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        return false;
    }

    private void setAvailable() {
        this.srcSubAccntId = "";
        String investorId = (String)this.cmbFund.getSelectionModel().getSelectedItem();
        Account acc = this.mapAcc.get(investorId);
        if (acc == null || this.cmbCurrency.getSelectionModel().getSelectedItem() == null) {
            this.reset();
            return;
        }
        PAccount.ExtFundAccnt accnt = null;
        try {
            accnt = this.fundAcctApi.getFundAccount(acc.getId(), MarketUtils.getMarketGroup((String)((String)acc.getSecExc().get(0))), ((MxNode)this.cmbCurrency.getSelectionModel().getSelectedItem()).getRaw());
        }
        catch (MException e1) {
            logger.error("\u6839\u636e\u4e00\u7ea7\u8d26\u53f7\u67e5\u4e00\u7ea7\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e1);
            this.alert.alert(Alert.AlertType.ERROR, e1.getMessage());
        }
        if (accnt == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6839\u636e\u8d26\u53f7\u67e5\u8d44\u91d1\u8d26\u53f7\u5931\u8d25");
            return;
        }
        PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
        newBuilder.setCurrencyId(((MxNode)this.cmbCurrency.getSelectionModel().getSelectedItem()).getRaw());
        newBuilder.setExtAccntId(accnt.getExtAccntId());
        if (this.radioIn.isSelected()) {
            newBuilder.setIsZeroAccnt(1);
        } else {
            String portName = (String)this.cmbSrc.getSelectionModel().getSelectedItem();
            newBuilder.setPortfolioId(this.mapPort.get(portName).getId());
        }
        List list = new ArrayList();
        try {
            list = this.fundAcctApi.getSubFundAccountList(MarketUtils.getMarketGroup((String)((String)acc.getSecExc().get(0))), newBuilder.build());
        }
        catch (MException e3) {
            logger.error("\u67e5\u8be2\u4e8c\u7ea7\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e3);
        }
        PCcsExtra.CcsSubFundAccntExtra sub = null;
        if (list.size() == 0) {
            this.reset();
            return;
        }
        for (PAccount.SubFundAccnt s : list) {
            if (!s.getPortfolioId().equals(newBuilder.getPortfolioId())) continue;
            try {
                this.srcSubAccntId = s.getSubAccntId();
                sub = (PCcsExtra.CcsSubFundAccntExtra)s.getObject().unpack(PCcsExtra.CcsSubFundAccntExtra.class);
                break;
            }
            catch (InvalidProtocolBufferException e) {
                logger.error("\u67e5\u8be2\u4e8c\u7ea7\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        if (sub == null) {
            this.reset();
            return;
        }
        String str = this.df.format(sub.getFundAccnt().getAvailable());
        if (str.equals("-0.000")) {
            str = "0";
        }
        this.lbCan.setText(str);
        this.lbCanTransfer.setText(str);
        this.txtBase.setText(this.df.format(sub.getFundAccnt().getAvailable()));
    }

    private void reset() {
        this.lbCan.setText("0");
        this.lbCanTransfer.setText("0");
        this.txtBase.setText("0");
    }

    private String getDstSubAccntId() {
        String accId = (String)this.cmbFund.getSelectionModel().getSelectedItem();
        Account account = this.mapAcc.get(accId);
        if (this.cmbCurrency.getSelectionModel().getSelectedItem() == null || account == null) {
            return "";
        }
        PAccount.ExtFundAccnt accnt = null;
        try {
            accnt = this.fundAcctApi.getFundAccount(account.getId(), MarketUtils.getMarketGroup((String)((String)account.getSecExc().get(0))), ((MxNode)this.cmbCurrency.getSelectionModel().getSelectedItem()).getRaw());
        }
        catch (MException e1) {
            logger.error("\u6839\u636e\u4e00\u7ea7\u8d26\u53f7\u67e5\u4e00\u7ea7\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e1);
            this.alert.alert(Alert.AlertType.ERROR, e1.getMessage());
        }
        if (accnt == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6839\u636e\u8d26\u53f7\u67e5\u8d44\u91d1\u8d26\u53f7\u5931\u8d25");
            return "";
        }
        PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
        newBuilder.setCurrencyId(((MxNode)this.cmbCurrency.getSelectionModel().getSelectedItem()).getRaw());
        newBuilder.setExtAccntId(accnt.getExtAccntId());
        if (this.radioOut.isSelected()) {
            newBuilder.setIsZeroAccnt(1);
        } else {
            Portfolio dest = this.mapPort.get(this.cmbDest.getSelectionModel().getSelectedItem());
            newBuilder.setPortfolioId(dest.getId());
        }
        List list = new ArrayList();
        try {
            list = this.fundAcctApi.getSubFundAccountList(MarketUtils.getMarketGroup((String)((String)account.getSecExc().get(0))), newBuilder.build());
        }
        catch (MException e3) {
            logger.error("\u67e5\u8be2\u4e8c\u7ea7\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e3);
        }
        for (PAccount.SubFundAccnt sub : list) {
            if (!sub.getPortfolioId().equals(newBuilder.getPortfolioId())) continue;
            this.dstSubAccntId = sub.getSubAccntId();
        }
        if (list == null || list.size() == 0) {
            this.dstSubAccntId = "";
        }
        return this.dstSubAccntId;
    }

    private boolean checkValid() {
        String srcName;
        Portfolio src;
        if ((this.radioOutIn.isSelected() || this.radioOut.isSelected()) && (src = this.mapPort.get(srcName = this.cmbSrc.getEditor().getText())) == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6e90\u6295\u7ec4");
            return false;
        }
        String investorId = this.cmbFund.getEditor().getText();
        Account acc = this.mapAcc.get(investorId);
        if (acc == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u8d44\u91d1\u8d26\u53f7");
            return false;
        }
        if (this.radioOutIn.isSelected() || this.radioIn.isSelected()) {
            String destName = this.cmbDest.getEditor().getText();
            if (!this.cmbDest.getItems().contains((Object)destName)) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u76ee\u6807\u6295\u7ec4");
                return false;
            }
        }
        if (this.txtBase.getText().equals("")) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u5212\u8f6c\u57fa\u6570");
            return false;
        }
        if (this.txtPercent.getText().equals("")) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u5212\u8f6c\u6bd4\u4f8b");
            return false;
        }
        if (Double.valueOf(this.lbTransfer.getText()) <= 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u5212\u8f6c\u91d1\u989d\u5e94\u5927\u4e8e0");
            return false;
        }
        return true;
    }

    private void queryPortfolio() {
        try {
            List<Portfolio> list = this.portfolioMng.getPortfoliosByParty(this.party.getId());
            list.forEach(portf -> {
                Portfolio portfolio = this.mapPort.put(portf.getName(), (Portfolio)portf);
            });
            this.listPort.addAll(this.mapPort.keySet());
        }
        catch (MException e) {
            logger.error("\u6839\u636e\u673a\u6784\u67e5\u6295\u7ec4\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void queryAccnt() {
        try {
            LinkedList<Account> list = new LinkedList<Account>();
            list.addAll((Collection<Account>)this.account.getAccountListByParty(this.party.getId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            list.addAll((Collection<Account>)this.account.getAccountListByParty(this.party.getId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            list.forEach(accnt -> {
                this.mapAcc.put(accnt.getInvestorId(), (Account)accnt);
                logger.debug("\u4e00\u7ea7\u8d26\u53f7ID\uff1a" + accnt.getId());
            });
            this.listAcc.addAll(this.mapAcc.keySet());
        }
        catch (MException e) {
            e.printStackTrace();
            logger.error("\u83b7\u53d6\u673a\u6784\u4e0b\u6240\u6709\u4e00\u7ea7\u8d26\u6237\u5931\u8d25\uff1a", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

