/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.hierarchy.PRbac;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.factory.FuncFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.FuncMngServiceImpl;
import cms.tmx.manage.models.FuncTreeModel;
import cms.tmx.manage.parts.AddFuncDialog;
import cms.tmx.manage.parts.AddFuncThreeDialog;
import cms.tmx.manage.parts.AddFuncTwoDialog;
import cms.tmx.manage.parts.UpdateFuncDialog;
import cms.tmx.manage.parts.UpdateFuncThreeDialog;
import cms.tmx.manage.parts.UpdateFuncTwoDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;

public class FuncModuleMngPart
extends MxPart {
    private static final String IS_DELETE = "\u662f\u5426\u786e\u8ba4\u5220\u9664\u8be5\u529f\u80fd\u6a21\u5757";
    @FXML
    private TreeView<FuncModule> treeFunc;
    @FXML
    private TableView<FuncModule> tableFunc;
    @FXML
    private TableColumn<FuncModule, String> parentId;
    @FXML
    private TableColumn<FuncModule, String> colOpera;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @Inject
    private FuncTreeModel funcTree;
    @Inject
    private FuncMngServiceImpl funcMng;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @Inject
    private FuncFactory ff;
    private FuncModule selectTableFunc;
    private TreeItem<FuncModule> selectTreeFunc;
    private MxList<FuncModule> mlist = new MxList();
    private List<FuncModule> filterList = new LinkedList<FuncModule>();
    private static final Logger logger = LogManager.getLogger(FuncModuleMngPart.class);
    private Predicate<FuncModule> pd = func -> {
        String name = this.txtSearch.getText().trim();
        return func.getName().contains(name);
    };
    private InvalidationListener funcModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableFunc.sort();
    };
    private boolean settingFlag = true;
    private boolean deleteFlag = true;

    @FXML
    public void initialize() {
        TreeItem<FuncModule> root = this.initRoot();
        this.exe.execute(() -> {
            this.initTree(root);
            this.query(((FuncModule)root.getValue()).getId(), PRbac.GetFuncModulesReq.Option.SUBCLASS);
        });
        this.bind();
        this.createTableView();
        this.checkRights();
    }

    private void initTree(TreeItem<FuncModule> root) {
        block5: {
            try {
                try {
                    ((FuncModule)root.getValue()).update(this.funcTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.funcTree.getRoot().getChildren());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u529f\u80fd\u83dc\u5355\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeFunc.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeFunc.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeFunc.refresh());
        }
    }

    private TreeItem<FuncModule> initRoot() {
        TreeItem root = new TreeItem();
        FuncModule func = this.ff.create();
        root.setValue((Object)func);
        this.treeFunc.setRoot(root);
        return root;
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnAdd, new String[]{"addFuncControl"});
        this.settingFlag = this.model.registerCheck(new String[]{"updateFuncControl"});
        this.deleteFlag = this.model.registerCheck(new String[]{"delFuncControl"});
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryFuncControl"});
    }

    protected void afterTableRestore() {
        this.treeFunc.getSelectionModel().select(0);
        this.selectTreeFunc = (TreeItem)this.treeFunc.getSelectionModel().getSelectedItem();
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.funcModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeFunc.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeFunc.getSelectionModel().selectedItemProperty()}));
        this.btnAdd.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            TreeItem item = (TreeItem)this.treeFunc.getSelectionModel().selectedItemProperty().getValue();
            if (item == null) {
                return true;
            }
            if (item.getParent() == null || item.getParent().getParent() == null || item.getParent().getParent().getParent() == null) {
                return false;
            }
            if (((FuncModule)item.getParent().getParent().getParent().getValue()).getId().equals("F00000")) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeFunc.getSelectionModel().selectedItemProperty()}));
        this.treeFunc.setOnMouseClicked(event -> {
            if (this.treeFunc.getSelectionModel().getSelectedItem() == null || this.selectTreeFunc == this.treeFunc.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.selectTableFunc = null;
            this.onItemClicked((TreeItem<FuncModule>)((TreeItem)this.treeFunc.getSelectionModel().getSelectedItem()));
        });
        this.tableFunc.setOnMouseClicked(event -> {
            if (this.tableFunc.getSelectionModel().getSelectedItem() != null) {
                this.selectTableFunc = (FuncModule)this.tableFunc.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        this.addViwer(this.tableFunc);
        this.tableFunc.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableFunc);
        this.parentId.setCellValueFactory(cellData -> {
            String parentId = ((FuncModule)cellData.getValue()).getParentId();
            if (this.funcTree.getFunc(parentId) != null) {
                FuncModule func = (FuncModule)this.funcTree.getFunc(parentId).getValue();
                SimpleStringProperty flage = new SimpleStringProperty("");
                if (func != null) {
                    flage.set(func.getName());
                    ((FuncModule)cellData.getValue()).setParentName(flage.get());
                }
                return flage;
            }
            return null;
        });
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableFunc));
        this.tableFunc.setItems(this.mlist.getList());
    }

    private void onItemClicked(TreeItem<FuncModule> item) {
        this.selectTreeFunc = item;
        if (item.isLeaf()) {
            this.query(((FuncModule)this.selectTreeFunc.getValue()).getId(), PRbac.GetFuncModulesReq.Option.LIST);
        } else {
            this.query(((FuncModule)this.selectTreeFunc.getValue()).getId(), PRbac.GetFuncModulesReq.Option.SUBCLASS);
        }
    }

    private void query(String funcId, PRbac.GetFuncModulesReq.Option option) {
        try {
            List<FuncModule> list = this.funcMng.getFuncDetails(option, funcId);
            this.filterList.clear();
            this.filterList.addAll(list);
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void refresh() {
        try {
            TreeItem<FuncModule> root = this.funcTree.refresh();
            this.treeFunc.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeFunc == null) {
                return;
            }
            if ("F00000".equals(((FuncModule)this.selectTreeFunc.getValue()).getId())) {
                this.treeFunc.getSelectionModel().select(root);
            } else {
                this.treeFunc.getSelectionModel().select(this.selectTreeFunc);
            }
            if (((TreeItem)this.treeFunc.getSelectionModel().getSelectedItem()).isLeaf()) {
                this.query(((FuncModule)this.selectTreeFunc.getValue()).getId(), PRbac.GetFuncModulesReq.Option.LIST);
            } else {
                this.query(((FuncModule)this.selectTreeFunc.getValue()).getId(), PRbac.GetFuncModulesReq.Option.SUBCLASS);
            }
            this.tableFunc.getSelectionModel().select((Object)this.selectTableFunc);
            this.tableFunc.scrollTo((Object)this.selectTableFunc);
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void add() {
        TreeItem treeItem = (TreeItem)this.treeFunc.getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            return;
        }
        FuncModule funcModule = (FuncModule)treeItem.getValue();
        if ("F00000".equals(funcModule.getId())) {
            this.addFunc(funcModule);
        } else if ("F00000".equals(funcModule.getParentId())) {
            this.addFuncTwo(funcModule);
        } else if ("F00000".equals(((FuncModule)treeItem.getParent().getParent().getValue()).getId())) {
            this.addFuncThree(funcModule);
        }
        this.exe.execute(() -> this.sendMsgToWeb(funcModule.getId()));
        this.refresh();
        this.tableFunc.getSelectionModel().select((Object)this.selectTableFunc);
        this.tableFunc.scrollTo((Object)this.selectTableFunc);
    }

    public void update() {
        TreeItem treeItem = (TreeItem)this.treeFunc.getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            return;
        }
        FuncModule funcUpdate = (FuncModule)this.tableFunc.getSelectionModel().getSelectedItem();
        TreeItem<FuncModule> select = this.funcTree.getFunc(funcUpdate.getId());
        if ("F00000".equals(((FuncModule)select.getParent().getValue()).getId())) {
            this.updateFunc(funcUpdate);
        } else if ("F00000".equals(((FuncModule)select.getParent().getValue()).getParentId())) {
            this.updateFuncTwo(funcUpdate);
        } else if ("F00000".equals(((FuncModule)select.getParent().getParent().getParent().getValue()).getId())) {
            this.updateFuncThree(funcUpdate);
        }
        this.exe.execute(() -> this.sendMsgToWeb(funcUpdate.getId()));
        this.refresh();
        this.tableFunc.getSelectionModel().select((Object)this.selectTableFunc);
        this.tableFunc.scrollTo((Object)this.selectTableFunc);
    }

    private void sendMsgToWeb(String id) {
        if (!StringUtils.isEmpty((String)id)) {
            MEvent event = new MEvent();
            event.put((Object)"type", (Object)"function");
            event.put((Object)"id", (Object)id);
            this.es.postEvent("refresh_web_cache", event);
        }
    }

    private void delete() {
        String funcId = ((FuncModule)this.tableFunc.getSelectionModel().getSelectedItem()).getId();
        String parentId = ((FuncModule)this.tableFunc.getSelectionModel().getSelectedItem()).getParentId();
        if ("F00000".equals(funcId)) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u65e0\u4fee\u6539\u6743\u9650");
            return;
        }
        if (!this.funcTree.getFunc(funcId).getChildren().isEmpty()) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u8bf7\u5148\u5220\u9664\u5b50\u8282\u70b9");
            return;
        }
        try {
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_DELETE, "")) {
                this.funcMng.delFuc(funcId);
                this.selectTreeFunc = this.funcTree.getFunc(parentId);
                this.exe.execute(() -> this.sendMsgToWeb(funcId));
                this.refresh();
                this.tableFunc.getSelectionModel().clearSelection();
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void rightRefresh() {
        this.refresh();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableFunc);
    }

    private void updateFuncThree(FuncModule funcModule) {
        UpdateFuncThreeDialog obj = (UpdateFuncThreeDialog)((Object)this.of.create(UpdateFuncThreeDialog.class));
        FuncModule func = (FuncModule)this.of.create(FuncModule.class);
        func.update((Object)funcModule);
        func.setParentName(func.getParentName());
        obj.setFunc(func);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u529f\u80fd\u6a21\u5757");
            TextField txtName = obj.getTxtName();
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.setFirstNode((Node)txtName);
            dialog.launch();
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void updateFuncTwo(FuncModule funcModule) {
        UpdateFuncTwoDialog obj = (UpdateFuncTwoDialog)((Object)this.of.create(UpdateFuncTwoDialog.class));
        FuncModule func = (FuncModule)this.of.create(FuncModule.class);
        func.update((Object)funcModule);
        func.setParentName(func.getParentName());
        obj.setfunc(func);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u529f\u80fd\u6a21\u5757");
            TextField txtName = obj.getTxtName();
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.setFirstNode((Node)txtName);
            dialog.launch();
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void updateFunc(FuncModule funcModule) {
        UpdateFuncDialog obj = (UpdateFuncDialog)((Object)this.of.create(UpdateFuncDialog.class));
        FuncModule func = (FuncModule)this.of.create(FuncModule.class);
        func.update((Object)funcModule);
        func.setParentName("\u529f\u80fd\u6811");
        obj.setfunc(func);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u529f\u80fd\u6a21\u5757");
            TextField txtName = obj.getTxtName();
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.setFirstNode((Node)txtName);
            dialog.launch();
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void addFuncThree(FuncModule funcModule) {
        AddFuncThreeDialog obj = (AddFuncThreeDialog)((Object)this.of.create(AddFuncThreeDialog.class));
        obj.getFuncAdd().setParentId(funcModule.getId());
        obj.getFuncAdd().setIdentifier(funcModule.getIdentifier());
        obj.getFuncAdd().setParentName(funcModule.getName());
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u529f\u80fd\u6a21\u5757");
            TextField txtName = obj.getTxtName();
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.setFirstNode((Node)txtName);
            dialog.launch();
            if (!obj.getNewFuncId().isEmpty()) {
                this.refresh();
            }
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void addFuncTwo(FuncModule funcModule) {
        AddFuncTwoDialog obj = (AddFuncTwoDialog)((Object)this.of.create(AddFuncTwoDialog.class));
        obj.getFuncAdd().setParentId(funcModule.getId());
        obj.getFuncAdd().setParentName(funcModule.getName());
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u529f\u80fd\u6a21\u5757");
            TextField txtName = obj.getTxtName();
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.setFirstNode((Node)txtName);
            dialog.launch();
            if (!obj.getNewFuncId().isEmpty()) {
                this.refresh();
            }
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void addFunc(FuncModule funcModule) {
        AddFuncDialog obj = (AddFuncDialog)((Object)this.of.create(AddFuncDialog.class));
        obj.getFuncAdd().setParentId(funcModule.getId());
        obj.getFuncAdd().setParentName(funcModule.getName());
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u529f\u80fd\u6a21\u5757");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            if (!obj.getNewFuncId().isEmpty()) {
                this.refresh();
            }
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void exportExcel() {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet spreadsheet = workbook.createSheet();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleOne = workbook.createCellStyle();
        cellStyleOne.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        cellStyleOne.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleTwo = workbook.createCellStyle();
        cellStyleTwo.setFillForegroundColor(IndexedColors.ROSE.getIndex());
        cellStyleTwo.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFCellStyle cellStyleThree = workbook.createCellStyle();
        cellStyleThree.setFillForegroundColor(IndexedColors.TAN.getIndex());
        cellStyleThree.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFRow row = null;
        row = spreadsheet.createRow(0);
        String[] head = new String[]{"\u83dc\u5355ID", "\u83dc\u5355\u540d\u79f0", "\u83dc\u5355\u5c42\u7ea7", "\u7236\u7ea7\u83dc\u5355ID", "\u5206\u7c7b"};
        int j = 0;
        while (j < head.length) {
            HSSFCell cell = row.createCell(j);
            cell.setCellValue(head[j]);
            cell.setCellStyle(cellStyle);
            ++j;
        }
        int index = 1;
        for (TreeItem treeItem : this.treeFunc.getRoot().getChildren()) {
            index = this.createCell(spreadsheet, cellStyleOne, head, index, (TreeItem<FuncModule>)treeItem, "1");
            for (TreeItem treeItem2 : treeItem.getChildren()) {
                index = this.createCell(spreadsheet, cellStyleTwo, head, index, (TreeItem<FuncModule>)treeItem2, "2");
                for (TreeItem treeItem3 : treeItem2.getChildren()) {
                    index = this.createCell(spreadsheet, cellStyleThree, head, index, (TreeItem<FuncModule>)treeItem3, "3");
                }
            }
        }
        int j2 = 0;
        while (j2 < head.length) {
            spreadsheet.setDefaultColumnWidth(18);
            ++j2;
        }
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("excel files (*.xls)", new String[]{".xls"});
        chooser.getExtensionFilters().add((Object)filter);
        chooser.setInitialFileName("\u83dc\u5355");
        File file = chooser.showSaveDialog(null);
        try {
            if (file != null) {
                FileOutputStream out = new FileOutputStream(file);
                workbook.write((OutputStream)out);
                workbook.close();
                out.close();
            } else {
                workbook.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private int createCell(HSSFSheet spreadsheet, HSSFCellStyle cellStyleOne, String[] head, int index, TreeItem<FuncModule> treeItem, String floor) {
        HSSFRow row = spreadsheet.createRow(index);
        FuncModule func = (FuncModule)treeItem.getValue();
        int j = 0;
        while (j < head.length) {
            HSSFCell cell = row.createCell(j);
            if (head[j].equals("\u83dc\u5355ID")) {
                cell.setCellValue(func.getId());
            } else if (head[j].equals("\u83dc\u5355\u540d\u79f0")) {
                cell.setCellValue(func.getName());
            } else if (head[j].equals("\u83dc\u5355\u5c42\u7ea7")) {
                cell.setCellValue(floor);
            } else if (head[j].equals("\u7236\u7ea7\u83dc\u5355ID")) {
                cell.setCellValue(func.getParentId());
            } else if (head[j].equals("\u5206\u7c7b")) {
                cell.setCellValue(func.getModuleType().getValue());
            }
            cell.setCellStyle(cellStyleOne);
            ++j;
        }
        return ++index;
    }

    private class OperaCell
    extends TableCell<FuncModule, String> {
        final Label updateLab = new Label("\u8bbe\u7f6e");
        final HBox paddedLabel = new HBox();
        final Label deleteLab = new Label("\u5220\u9664");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.deleteLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.deleteLab.getStyleClass().add((Object)"text-blue");
            if (FuncModuleMngPart.this.settingFlag) {
                this.paddedLabel.getChildren().add((Object)this.updateLab);
                HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
            }
            if (FuncModuleMngPart.this.deleteFlag) {
                this.paddedLabel.getChildren().add((Object)this.deleteLab);
            }
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    FuncModuleMngPart.this.update();
                }
            });
            this.deleteLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    FuncModuleMngPart.this.delete();
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

