/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.FuncModule;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IUserService;
import java.io.File;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.util.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeedBackSubBasic
extends MxTabContent {
    @FXML
    private HBox hboxmenu;
    @FXML
    private HBox hboxImg;
    @FXML
    private Button btnImg;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnClear;
    @FXML
    private CheckBox cboxFunc;
    @FXML
    private CheckBox cboxPart;
    @FXML
    private CheckBox cboxInter;
    @FXML
    private CheckBox cboxSpeed;
    @FXML
    private CheckBox cboxOther;
    @FXML
    private TextArea txtDesc;
    @FXML
    private Label errorType;
    @FXML
    private Label errorDesc;
    @FXML
    private Label lbAlert;
    @FXML
    private Label lbPic;
    @FXML
    private Label labSuccess;
    @Inject
    private IUserService usi;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private ObservableList<FuncModule> list = FxUtils.newList();
    private ObservableList<Node> btnList;
    private static final Logger logger = LogManager.getLogger(FeedBackSubBasic.class);
    private File file;
    private Image image;
    private ImageView remove;
    private InvalidationListener roleModel = ob -> {
        this.btnList.clear();
        for (FuncModule func : this.list) {
            this.btnList.add((Object)this.creatHbox(func));
        }
    };

    @FXML
    private void initialize() {
        String imagePath = "res/menuxx.png";
        this.image = new Image(imagePath);
        String imageCPath = "res/picc.png";
        Image imageClear = new Image(imageCPath);
        this.remove = new ImageView(imageClear);
        this.remove.setFitWidth(8.0);
        this.remove.setFitHeight(8.0);
        this.remove.setStyle("-fx-cursor:hand;");
        this.remove.setOnMouseClicked(event -> this.clearFileName());
        this.addListen();
        this.check();
    }

    private void check() {
        this.registerCheck((Node)this.errorType, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!(this.cboxFunc.selectedProperty().get() || this.cboxPart.selectedProperty().get() || this.cboxInter.selectedProperty().get() || this.cboxSpeed.selectedProperty().get() || this.cboxOther.selectedProperty().get())) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cboxFunc.selectedProperty(), this.cboxPart.selectedProperty(), this.cboxInter.selectedProperty(), this.cboxSpeed.selectedProperty(), this.cboxOther.selectedProperty()}));
        this.registerCheck((Node)this.errorDesc, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !((String)this.txtDesc.textProperty().get()).trim().isEmpty(), (Observable[])new Observable[]{this.txtDesc.textProperty()}));
    }

    private HBox creatHbox(FuncModule func) {
        ImageView mv = new ImageView(this.image);
        mv.setFitWidth(9.0);
        mv.setFitHeight(9.0);
        mv.setStyle("-fx-cursor:hand;");
        Label name = new Label(func.getName());
        name.setMinWidth((double)(func.getName().length() * 12));
        HBox h = new HBox(new Node[]{name, mv});
        h.setSpacing(10.0);
        h.setStyle("-fx-background-color: #2B3E68;");
        h.setAlignment(Pos.CENTER);
        h.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
        mv.setOnMouseClicked(event -> this.list.remove((Object)func));
        return h;
    }

    private void addListen() {
        this.list.addListener(this.roleModel);
        this.cboxFunc.selectedProperty().addListener((ob, old, now) -> {
            if (now != null && now.booleanValue()) {
                if (!this.txtDesc.getText().isEmpty()) {
                    this.txtDesc.setText(String.valueOf(this.txtDesc.getText()) + "\n" + "\u529f\u80fd\u4e0d\u5b8c\u5584");
                } else {
                    this.txtDesc.setText("\u529f\u80fd\u4e0d\u5b8c\u5584");
                }
            }
        });
        this.cboxPart.selectedProperty().addListener((ob, old, now) -> {
            if (now != null && now.booleanValue()) {
                if (!this.txtDesc.getText().isEmpty()) {
                    this.txtDesc.setText(String.valueOf(this.txtDesc.getText()) + "\n" + "\u754c\u9762\u4e0d\u597d\u770b");
                } else {
                    this.txtDesc.setText("\u754c\u9762\u4e0d\u597d\u770b");
                }
            }
        });
        this.cboxInter.selectedProperty().addListener((ob, old, now) -> {
            if (now != null && now.booleanValue()) {
                if (!this.txtDesc.getText().isEmpty()) {
                    this.txtDesc.setText(String.valueOf(this.txtDesc.getText()) + "\n" + "\u4ea4\u4e92\u4f53\u9a8c\u5dee");
                } else {
                    this.txtDesc.setText("\u4ea4\u4e92\u4f53\u9a8c\u5dee");
                }
            }
        });
        this.cboxSpeed.selectedProperty().addListener((ob, old, now) -> {
            if (now != null && now.booleanValue()) {
                if (!this.txtDesc.getText().isEmpty()) {
                    this.txtDesc.setText(String.valueOf(this.txtDesc.getText()) + "\n" + "\u901f\u5ea6\u6162");
                } else {
                    this.txtDesc.setText("\u901f\u5ea6\u6162");
                }
            }
        });
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    @FXML
    public void selectPicture() {
        FileChooser fileChooser = new FileChooser();
        FeedBackSubBasic.configureFileChooser(fileChooser);
        this.file = fileChooser.showOpenDialog(null);
        this.setLableName(this.file);
    }

    private void clearFileName() {
        this.file = null;
        this.setLableName(this.file);
    }

    private static void configureFileChooser(FileChooser fileChooser) {
        fileChooser.setTitle("View Pictures");
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("\u5168\u9009", new String[]{"*.png", "*.jpg", "*.jpeg", "*.bmp"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"}), new FileChooser.ExtensionFilter("JPEG", new String[]{"*.jpeg"}), new FileChooser.ExtensionFilter("BMP", new String[]{"*.bmp"})});
    }

    private void setLableName(File file) {
        if (file != null) {
            this.lbPic.setText(file.getName());
            double l = this.width(file.getName());
            double width = l > 380.0 ? 380.0 : l;
            this.lbPic.setMinWidth(width);
            if (!this.hboxImg.getChildren().contains((Object)this.remove)) {
                this.hboxImg.getChildren().add((Object)this.remove);
            }
        } else {
            this.lbPic.setText("");
            if (this.hboxImg.getChildren().contains((Object)this.remove)) {
                this.hboxImg.getChildren().remove((Object)this.remove);
            }
        }
    }

    private double width(String s) {
        int m = s.length();
        int n = s.replaceAll("[\u4e00-\u9fa5]", "").length();
        int b = m - n;
        return b * 12 + n * 6 + 10;
    }

    public void save() {
        try {
            this.usi.setOpinion(this.txtDesc.getText(), this.file);
            this.labSuccess.setVisible(true);
            Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
            animation.setCycleCount(1);
            animation.setAutoReverse(false);
            animation.play();
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
        }
    }

    public void clear() {
        this.clearFileName();
        this.txtDesc.clear();
        this.cboxFunc.setSelected(false);
        this.cboxPart.setSelected(false);
        this.cboxInter.setSelected(false);
        this.cboxSpeed.setSelected(false);
        this.cboxOther.setSelected(false);
    }
}

