/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.Account;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountMngModel;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.HedgeFlagCmbModel;
import cms.tmx.manage.models.SecAccountMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpSecAccountTabContent
extends MxTabContent {
    @FXML
    private TextField txtAcctId;
    @FXML
    private TextField txtMemberId;
    @FXML
    private TextField txtClientId;
    @FXML
    private ComboBox<MxNode> cmbCurrency;
    @FXML
    private ComboBox<MxNode> cmbExchange;
    @FXML
    private ComboBox<MxNode> cmbAcctType;
    @FXML
    private ComboBox<MxNodePwf> cmbHedgeFlag;
    @FXML
    private Label lbHedge;
    @FXML
    private TableView<SecAccount> tableSecAcct;
    @FXML
    private Label lbMessage;
    @FXML
    private TableColumn<CtpSecAccount, String> colAcctId;
    @FXML
    private TableColumn<CtpSecAccount, MxNode> colCurrency;
    @FXML
    private TableColumn<CtpSecAccount, MxNode> colExchange;
    @FXML
    private TableColumn<CtpSecAccount, String> colHedgeFlag;
    @FXML
    private TableColumn<CtpSecAccount, String> colSecAcct;
    @FXML
    private TableColumn<CtpSecAccount, HBox> colOperate;
    @FXML
    private Button btnAdd;
    @Inject
    private MObjFactory of;
    @Inject
    private SecAccountMngServiceImpl secAccountMng;
    @Inject
    private FundAccountMngServiceImpl fundService;
    @Inject
    private IUiRightService model;
    @Inject
    private AccountMngModel accntModel;
    @Inject
    private MxAlert mAlert;
    private Account account;
    private HedgeFlagCmbModel hedgeModel = new HedgeFlagCmbModel();
    private List<SecAccount> secList = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(CtpSecAccountTabContent.class);
    private boolean deleteFlag = true;
    private static final int CODE_OK = 1;
    private BooleanProperty warning = new SimpleBooleanProperty(false);
    private MxNode returnStatus;

    public void setAccount(Account acc) {
        this.account = acc;
    }

    @FXML
    public void initialize() {
        this.account = this.accntModel.getCommonAccount();
        this.model.registerCheck((Control)this.btnAdd, new String[]{"addSecAccountControl"});
        this.deleteFlag = this.model.registerCheck(new String[]{"delSecAccountControl"});
        this.initValues();
        this.txtAcctId.setText(this.account.getInvestorId());
        this.txtMemberId.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.txtClientId.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.createTableView();
        this.refresh();
        CssUtils.priceTag((Control)this.lbMessage);
        this.warning.addListener(obs -> CssUtils.checkSecMessage((Control)this.lbMessage, (boolean)this.warning.getValue()));
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"currency_type", (String)((String)this.account.getCurrency().get(0)));
        this.cmbCurrency.setValue((Object)node);
        ObservableList curObList = FXCollections.observableArrayList();
        for (String str : this.account.getCurrency()) {
            MxNode node1 = MxNodeFactory.create((String)"currency_type", (String)"CNY");
            node1.setRaw(str);
            curObList.add((Object)node1);
        }
        this.cmbCurrency.setItems(curObList);
        node = MxNodeFactory.create((String)"market_code", (String)((String)this.account.getSecExc().get(0)));
        this.cmbExchange.setValue((Object)node);
        this.cmbExchange.valueProperty().addListener((ob, old, now) -> this.marketChange());
        ObservableList marObList = FXCollections.observableArrayList();
        for (String str : this.account.getSecExc()) {
            MxNode node1 = MxNodeFactory.create((String)"market_code", (String)"XSHG");
            node1.setRaw(str);
            marObList.add((Object)node1);
        }
        this.cmbExchange.setItems(marObList);
        this.hedgeModel.initCellFactory(this.cmbHedgeFlag, this.lbHedge, this.cmbExchange);
        MxNodePwf nodePwf = MxNodeFactory.createPwf((String)"sh_flag", (String)"1");
        this.cmbHedgeFlag.setItems(nodePwf.getPwfNodes());
        this.returnStatus = MxNodeFactory.create((String)"error_code", (String)"");
    }

    private void marketChange() {
        this.lbHedge.setText("");
        this.hedgeModel.initCellFactory(this.cmbHedgeFlag, this.lbHedge, this.cmbExchange);
    }

    private void createTableView() {
        this.colAcctId.setCellValueFactory(data -> ((CtpSecAccount)data.getValue()).inverstorIdProperty());
        this.colCurrency.setCellValueFactory(data -> ((CtpSecAccount)data.getValue()).currencyProperty());
        this.colExchange.setCellValueFactory(data -> ((CtpSecAccount)data.getValue()).exchangeProperty());
        this.colHedgeFlag.setCellValueFactory(data -> ((CtpSecAccount)data.getValue()).strFlagProperty());
        this.colSecAcct.setCellValueFactory(data -> ((CtpSecAccount)data.getValue()).extSecAccntIdProperty());
        this.colOperate.setCellValueFactory(data -> this.setOperate((CtpSecAccount)data.getValue()));
        this.tableSecAcct.setPlaceholder((Node)new Label());
    }

    public void refresh() {
        this.tableSecAcct.getItems().clear();
        this.secList.clear();
        try {
            List<FundAccount> fundList = this.fundService.queryFundAccountList(this.account.getId(), this.account.getSecExc());
            for (FundAccount fund : fundList) {
                this.secList = this.secAccountMng.querySecAccountList(fund);
            }
        }
        catch (MException e) {
            this.lbMessage.setText(e.getMessage());
            this.warning.setValue(Boolean.valueOf(true));
            logger.error((Object)e, (Throwable)e);
        }
        ObservableList obList = FXCollections.observableList(this.secList);
        this.tableSecAcct.setItems(obList);
    }

    public void addSecAcct() {
        if (this.txtMemberId.getText().isEmpty()) {
            this.lbMessage.setText("\u4f1a\u5458\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
            this.warning.setValue(Boolean.valueOf(true));
            return;
        }
        if (this.txtClientId.getText().isEmpty()) {
            this.lbMessage.setText("\u5ba2\u6237\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
            this.warning.setValue(Boolean.valueOf(true));
            return;
        }
        if (this.hedgeModel.getCheckItems().isEmpty()) {
            this.lbMessage.setText("\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
            this.warning.setValue(Boolean.valueOf(true));
            return;
        }
        CtpSecAccount ctp = (CtpSecAccount)this.of.create(CtpSecAccount.class);
        ctp.setMemberId(this.txtMemberId.getText());
        ctp.setClientId(this.txtClientId.getText());
        LinkedList listFlag = new LinkedList();
        this.hedgeModel.getCheckItems().forEach(node -> {
            boolean bl = listFlag.add(node.getRaw());
        });
        int flagNum = 0;
        if (listFlag.contains("1")) {
            ++flagNum;
        }
        if (listFlag.contains("2")) {
            flagNum += 2;
        }
        if (listFlag.contains("4")) {
            flagNum += 4;
        }
        if (listFlag.contains("8")) {
            flagNum += 8;
        }
        ctp.setHedgeFlag(flagNum);
        ctp.setCurrency((MxNode)this.cmbCurrency.getValue());
        ctp.setExchange((MxNode)this.cmbExchange.getValue());
        ctp.setInverstorId(this.account.getInvestorId());
        ctp.setInverstorSecId(String.valueOf(this.txtMemberId.getText()) + "_" + this.txtClientId.getText());
        ctp.setExtAccntId(String.valueOf(this.account.getInvestorId()) + "_" + this.account.getBrokerId() + "_" + ((MxNode)this.cmbCurrency.getValue()).getRaw());
        ctp.setExtSecAccntId(String.valueOf(this.txtMemberId.getText()) + "_" + this.txtClientId.getText() + "_" + ((MxNode)this.cmbCurrency.getValue()).getRaw() + "_" + this.account.getBrokerId());
        try {
            PBase.OpStatus status = this.secAccountMng.addSecAccount((SecAccount)ctp, this.account);
            this.message(status, ctp, "\u589e\u52a0");
            for (SecAccount sec : this.tableSecAcct.getItems()) {
                if (!sec.getExtSecAccntId().equals(String.valueOf(this.txtMemberId.getText()) + "_" + this.txtClientId.getText() + "_" + ((MxNode)this.cmbCurrency.getValue()).getRaw())) continue;
                this.tableSecAcct.getSelectionModel().select((Object)sec);
            }
        }
        catch (MException e) {
            this.lbMessage.setText(e.getMessage());
            this.warning.setValue(Boolean.valueOf(true));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void message(PBase.OpStatus status, CtpSecAccount secAcc, String operate) throws MException {
        this.returnStatus.setRaw(String.valueOf(status.getStatus()));
        this.lbMessage.setText(String.valueOf(operate) + secAcc.getExtSecAccntId() + ": " + this.returnStatus.getValue());
        if (status.getStatus() == 1) {
            this.warning.setValue(Boolean.valueOf(false));
        } else {
            this.warning.setValue(Boolean.valueOf(true));
        }
        this.refresh();
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(CtpSecAccount ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> {
            try {
                if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664" + ap.getInverstorSecId() + "?")) {
                    this.delete(ap);
                }
            }
            catch (MException e) {
                this.lbMessage.setText(e.getMessage());
                this.warning.setValue(Boolean.valueOf(true));
                logger.error((Object)e, (Throwable)e);
            }
        });
        if (this.deleteFlag) {
            hBox.getChildren().add(0, (Object)lbIn);
        }
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    private void delete(CtpSecAccount secAcc) throws MException {
        PBase.OpStatus status = this.secAccountMng.delSecAccount((SecAccount)secAcc, this.account);
        this.message(status, secAcc, "\u522a\u9664");
    }
}

