/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.entity.ClearingInfo;
import cms.tmx.entity.ClearingStep;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.IClearingModel;
import cms.tmx.manage.heartbeat.HeartBeatMng;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClearingPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(ClearingPart.class);
    @FXML
    private TableView<ClearingStep> tableClearing;
    @FXML
    private TableColumn<ClearingStep, String> colStepName;
    @FXML
    private TableColumn<ClearingStep, String> colStepNo;
    @FXML
    private TableColumn<ClearingStep, String> colFrontStepNo;
    @FXML
    private TableColumn<ClearingStep, MxNode> colStepType;
    @FXML
    private TableColumn<ClearingStep, String> colBeginTime;
    @FXML
    private TableColumn<ClearingStep, String> colEndTime;
    @FXML
    private TableColumn<ClearingStep, MxNode> colCurrStatus;
    @FXML
    private TextArea txtAreaClearing;
    @FXML
    private TextField txtLastTrdDay;
    @FXML
    private TextField txtCurTrdDay;
    @FXML
    private TextField txtStartClrDay;
    @FXML
    private TextField txtEndClrDay;
    @FXML
    private TextField txtSysStatus;
    @Inject
    private MxAlert alert;
    @Inject
    private HeartBeatMng hb;
    @Inject
    private IClearingModel model;
    private MxList<ClearingStep> mxList = new MxList();
    private static String MENU_ITEM_START = "\u542f\u52a8";
    @Inject
    private ScheduledExecutorService ses;
    private ScheduledFuture<?> future;
    private ChangeListener<String> lstnLastDayChange = (ob, old, now) -> this.txtLastTrdDay.setText(now);
    private ChangeListener<String> lstnCurDayChange = (ob, old, now) -> {
        this.txtCurTrdDay.setText(now);
        this.txtStartClrDay.setText(now);
        this.txtEndClrDay.setText(now);
    };
    private InvalidationListener lstnTable = ob -> Platform.runLater(() -> {
        this.mxList.update(this.model.getStepList());
        this.txtSysStatus.textProperty().set((Object)this.model.getStatus().getSysStatus().getValue());
    });
    private InvalidationListener lstnLog = ob -> Platform.runLater(() -> this.txtAreaClearing.appendText(this.model.getLog()));
    private InvalidationListener lstnLogOverride = ob -> Platform.runLater(() -> this.txtAreaClearing.setText(this.model.getLog()));

    @PreDestroy
    public void destroy() {
        this.future.cancel(true);
        this.model.clearLogNum();
        this.model.changedProperty().removeListener(this.lstnTable);
        this.model.logChangedProperty().removeListener(this.lstnLog);
        this.model.logOverridedProperty().removeListener(this.lstnLogOverride);
    }

    @FXML
    public void initialize() {
        if (this.hb.isConnected()) {
            this.future = this.ses.scheduleWithFixedDelay(() -> this.refresh(), 0L, 1000L, TimeUnit.MILLISECONDS);
        }
        this.createTable();
        ClearingInfo info = this.model.getStatus();
        this.txtLastTrdDay.setText(info.lastTradingDayProperty().getValue());
        info.lastTradingDayProperty().addListener((ChangeListener)new WeakChangeListener(this.lstnLastDayChange));
        this.txtCurTrdDay.setText(info.curTradingDayProperty().getValue());
        this.txtStartClrDay.setText(info.curTradingDayProperty().getValue());
        this.txtEndClrDay.setText(info.curTradingDayProperty().getValue());
        info.curTradingDayProperty().addListener((ChangeListener)new WeakChangeListener(this.lstnCurDayChange));
        this.txtSysStatus.textProperty().set((Object)this.model.getStatus().getSysStatus().getValue());
        this.model.changedProperty().addListener(this.lstnTable);
        this.model.logChangedProperty().addListener(this.lstnLog);
        this.model.logOverridedProperty().addListener(this.lstnLogOverride);
    }

    private void createTable() {
        this.tableClearing.setPlaceholder((Node)new Label());
        this.colStepName.setCellValueFactory(data -> ((ClearingStep)data.getValue()).stepNameProperty());
        this.colStepName.setCellFactory(m -> new ClearingCell());
        this.colStepNo.setCellValueFactory(data -> ((ClearingStep)data.getValue()).stepNoProperty());
        this.colFrontStepNo.setCellValueFactory(data -> ((ClearingStep)data.getValue()).frontStepNoProperty());
        this.colStepType.setCellValueFactory(data -> ((ClearingStep)data.getValue()).stepTypeProperty());
        this.colBeginTime.setCellValueFactory(data -> ((ClearingStep)data.getValue()).beginTimeProperty());
        this.colEndTime.setCellValueFactory(data -> ((ClearingStep)data.getValue()).endTimeProperty());
        this.colCurrStatus.setCellValueFactory(data -> ((ClearingStep)data.getValue()).currStatusProperty());
        this.tableClearing.setItems(this.mxList.getList());
    }

    public void refresh() {
        try {
            this.model.queryStatus();
            this.model.queryStepList();
            this.model.queryLog();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void startClearing() {
        try {
            this.model.runClearing();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private class ClearingCell
    extends TableCell<ClearingStep, String> {
        public void updateItem(String value, boolean empty) {
            super.updateItem((Object)value, empty);
            if (!empty) {
                ContextMenu tabMenu = new ContextMenu();
                MenuItem start = new MenuItem(MENU_ITEM_START);
                tabMenu.getItems().setAll((Object[])new MenuItem[]{start});
                if (this.getTableRow() != null) {
                    this.getTableRow().setContextMenu(tabMenu);
                    start.setOnAction(event -> {
                        ClearingStep step = this.getTableView().getItems() != null && this.getTableView().getItems().get(this.getIndex()) != null ? (ClearingStep)this.getTableView().getItems().get(this.getIndex()) : null;
                        try {
                            ClearingPart.this.model.startRun(step);
                        }
                        catch (MException e) {
                            ClearingPart.this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                        }
                    });
                }
                this.setText(value);
            } else {
                this.setText("");
            }
        }
    }
}

