/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.entity.ClearingNewInfo;
import cms.tmx.entity.ClearingNewStep;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.IClearingNewModel;
import cms.tmx.manage.heartbeat.HeartBeatMng;
import java.util.concurrent.ScheduledExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClearingNewPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(ClearingNewPart.class);
    @FXML
    private TableView<ClearingNewStep> tableClearing;
    @FXML
    private TableColumn<ClearingNewStep, String> colStepName;
    @FXML
    private TableColumn<ClearingNewStep, String> colStepNo;
    @FXML
    private TableColumn<ClearingNewStep, String> colFrontStepNo;
    @FXML
    private TableColumn<ClearingNewStep, MxNode> colStepType;
    @FXML
    private TableColumn<ClearingNewStep, String> colBeginTime;
    @FXML
    private TableColumn<ClearingNewStep, String> colEndTime;
    @FXML
    private TableColumn<ClearingNewStep, String> colAttachment;
    @FXML
    private TableColumn<ClearingNewStep, MxNode> colCurrStatus;
    @FXML
    private TextArea txtAreaClearing;
    @FXML
    private TextField txtLastTrdDay;
    @FXML
    private TextField txtCurTrdDay;
    @FXML
    private TextField txtStartClrDay;
    @FXML
    private TextField txtEndClrDay;
    @FXML
    private TextField txtSysStatus;
    @Inject
    private MxAlert alert;
    @Inject
    private HeartBeatMng hb;
    @Inject
    private IClearingNewModel model;
    private MxList<ClearingNewStep> mxList = new MxList();
    private static String MENU_ITEM_START = "\u542f\u52a8";
    @Inject
    private ScheduledExecutorService ses;
    private ChangeListener<String> lstnLastDayChange = (ob, old, now) -> this.txtLastTrdDay.setText(now);
    private ChangeListener<String> lstnCurDayChange = (ob, old, now) -> {
        this.txtCurTrdDay.setText(now);
        this.txtStartClrDay.setText(now);
        this.txtEndClrDay.setText(now);
    };
    private InvalidationListener lstnTable = ob -> Platform.runLater(() -> {
        this.mxList.update(this.model.getStepList());
        this.txtSysStatus.textProperty().set((Object)this.model.getStatus().getSysStatus().getValue());
    });
    private InvalidationListener lstnLog = ob -> Platform.runLater(() -> {
        if (this.model.isFirstPush()) {
            this.txtAreaClearing.setText("");
            this.txtAreaClearing.appendText(this.model.getLog());
            this.model.setFirstPush(false);
        } else {
            this.txtAreaClearing.appendText(this.model.getLog());
        }
    });
    private InvalidationListener lstnLogOverride = ob -> Platform.runLater(() -> this.txtAreaClearing.setText(this.model.getLog()));

    @PreDestroy
    public void close() {
        this.model.clearLogNum();
        this.model.setFirstPush(true);
        this.model.changedProperty().removeListener(this.lstnTable);
        this.model.logChangedProperty().removeListener(this.lstnLog);
        this.model.logOverridedProperty().removeListener(this.lstnLogOverride);
    }

    @FXML
    public void initialize() {
        this.createTable();
        ClearingNewInfo info = this.model.getStatus();
        this.txtLastTrdDay.setText(info.lastTradingDayProperty().getValue());
        info.lastTradingDayProperty().addListener((ChangeListener)new WeakChangeListener(this.lstnLastDayChange));
        this.txtCurTrdDay.setText(info.curTradingDayProperty().getValue());
        this.txtStartClrDay.setText(info.curTradingDayProperty().getValue());
        this.txtEndClrDay.setText(info.curTradingDayProperty().getValue());
        info.curTradingDayProperty().addListener((ChangeListener)new WeakChangeListener(this.lstnCurDayChange));
        this.txtSysStatus.textProperty().set((Object)this.model.getStatus().getSysStatus().getValue());
        this.model.changedProperty().addListener(this.lstnTable);
        this.model.logChangedProperty().addListener(this.lstnLog);
        this.model.logOverridedProperty().addListener(this.lstnLogOverride);
        if (this.hb.isConnected()) {
            this.refresh();
        }
    }

    private void createTable() {
        this.tableClearing.setPlaceholder((Node)new Label());
        this.colStepName.setCellValueFactory(data -> ((ClearingNewStep)data.getValue()).stepNameProperty());
        this.colStepName.setCellFactory(m -> new ClearingCell());
        this.colStepNo.setCellValueFactory(data -> ((ClearingNewStep)data.getValue()).stepNoProperty());
        this.colFrontStepNo.setCellValueFactory(data -> ((ClearingNewStep)data.getValue()).frontStepNoProperty());
        this.colStepType.setCellValueFactory(data -> ((ClearingNewStep)data.getValue()).stepTypeProperty());
        this.colBeginTime.setCellValueFactory(data -> ((ClearingNewStep)data.getValue()).beginTimeProperty());
        this.colEndTime.setCellValueFactory(data -> ((ClearingNewStep)data.getValue()).endTimeProperty());
        this.colAttachment.setCellValueFactory(data -> ((ClearingNewStep)data.getValue()).attachmentProperty());
        this.colCurrStatus.setCellValueFactory(data -> ((ClearingNewStep)data.getValue()).currStatusProperty());
        this.tableClearing.setItems(this.mxList.getList());
    }

    public void refresh() {
        try {
            this.model.queryStatus();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.model.queryStepList();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void startClearing() {
        try {
            this.model.runClearing();
        }
        catch (MException e) {
            logger.error("\u65b0\u6846\u67b6\u4e00\u952e\u6e05\u7b97\u5931\u8d25" + e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private class ClearingCell
    extends TableCell<ClearingNewStep, String> {
        public void updateItem(String value, boolean empty) {
            super.updateItem((Object)value, empty);
            if (!empty) {
                ContextMenu tabMenu = new ContextMenu();
                MenuItem start = new MenuItem(MENU_ITEM_START);
                tabMenu.getItems().setAll((Object[])new MenuItem[]{start});
                if (this.getTableRow() != null) {
                    this.getTableRow().setContextMenu(tabMenu);
                    start.setOnAction(event -> {
                        ClearingNewStep step = this.getTableView().getItems() != null && this.getTableView().getItems().get(this.getIndex()) != null ? (ClearingNewStep)this.getTableView().getItems().get(this.getIndex()) : null;
                        try {
                            ClearingNewPart.this.model.startRun(step);
                        }
                        catch (MException e) {
                            logger.error("\u65b0\u6846\u67b6\u5355\u6b65\u6e05\u7b97\u5931\u8d25" + step.getStepNo() + step.getStepName() + e.getMessage(), (Throwable)e);
                            ClearingNewPart.this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                        }
                    });
                }
                this.setText(value);
            } else {
                this.setText("");
            }
        }
    }
}

