/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.entity.FuncModule;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.rights.IRightService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChooiceFuncDialog
extends DialogObj {
    @FXML
    private TreeTableColumn<FuncModule, Boolean> colFunction;
    @FXML
    private TreeTableColumn<FuncModule, Boolean> isSelected;
    @FXML
    private TreeTableView<FuncModule> treeTableFunc;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveRights;
    @Inject
    private IRightService irs;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    private static final Logger logger = LogManager.getLogger(ChooiceFuncDialog.class);
    private Map<String, TreeItem<FuncModule>> map = new HashMap<String, TreeItem<FuncModule>>();
    private ObservableList<TreeItem<FuncModule>> allFunc = FxUtils.newList();
    private ObservableList<FuncModule> choiceList;
    private MxList<FuncModule> mlist = new MxList();
    private FuncModule funcModule;
    private TreeItem<FuncModule> root;
    private BooleanProperty save = new SimpleBooleanProperty(false);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.initRoot();
        this.exe.execute(() -> this.initValue());
        this.createTableView();
    }

    public void initValue() {
        block6: {
            this.allFunc.clear();
            this.root.getChildren().clear();
            List funcModules = this.irs.getFuncListByUserPost(this.postMng.getUserPost().getId());
            this.mlist.update(funcModules);
            if (!funcModules.isEmpty()) break block6;
            Platform.runLater(() -> this.treeTableFunc.refresh());
            return;
        }
        try {
            try {
                this.mlist.getList().forEach(item -> {
                    if (!"F00000".equals(item.getId())) {
                        this.allFunc.add((Object)new TreeItem(item));
                    }
                });
                this.allFunc.add(this.root);
                this.buildTree(this.root, ((FuncModule)this.root.getValue()).getId());
                for (FuncModule f : this.choiceList) {
                    this.chooiceParent(this.map.get(f.getId()));
                }
            }
            catch (MException e) {
                Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> this.treeTableFunc.refresh());
            }
        }
        catch (Throwable throwable) {
            Platform.runLater(() -> this.treeTableFunc.refresh());
            throw throwable;
        }
        Platform.runLater(() -> this.treeTableFunc.refresh());
    }

    private void chooiceParent(TreeItem<FuncModule> f) {
        ((FuncModule)f.getValue()).setSelected(true);
        if (f.getParent() != null) {
            this.chooiceParent((TreeItem<FuncModule>)f.getParent());
        }
    }

    private void initRoot() {
        FuncModule fModule = new FuncModule();
        fModule.setId("F00000");
        fModule.setName("\u529f\u80fd\u6811");
        this.root = new TreeItem((Object)fModule);
        this.treeTableFunc.setRoot(this.root);
    }

    private void createTableView() {
        this.isSelected.setCellValueFactory(cellDate -> ((FuncModule)cellDate.getValue().getValue()).selectedProperty());
        this.isSelected.setCellFactory(cellDate -> new MxCheckBoxTreeTableCell());
        this.colFunction.setCellFactory(cellDate -> new MxFuncCheckBoxTreeTableCell());
    }

    @FXML
    public boolean saveRights() {
        this.choiceList.clear();
        for (TreeItem treeItem : this.allFunc) {
            if (!treeItem.isLeaf() || !((FuncModule)treeItem.getValue()).isSelected()) continue;
            this.choiceList.add((Object)((FuncModule)treeItem.getValue()));
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public FuncModule getFuncModule() {
        return this.funcModule;
    }

    public void setFuncModule(FuncModule funcModule) {
        this.funcModule = funcModule;
    }

    private void buildTree(TreeItem<FuncModule> root, String rootId) {
        Collections.sort(this.allFunc, (o1, o2) -> ((FuncModule)o1.getValue()).getSort() > ((FuncModule)o2.getValue()).getSort() ? 1 : (((FuncModule)o1.getValue()).getSort() == ((FuncModule)o2.getValue()).getSort() ? Integer.parseInt(((FuncModule)o1.getValue()).getId().substring(1)) - Integer.parseInt(((FuncModule)o2.getValue()).getId().substring(1)) : -1));
        block0: for (TreeItem itemI : this.allFunc) {
            this.map.put(((FuncModule)itemI.getValue()).getId(), (TreeItem<FuncModule>)itemI);
            String idI = ((FuncModule)itemI.getValue()).getId();
            String parentIdI = ((FuncModule)itemI.getValue()).getParentId();
            if (idI.isEmpty()) continue;
            if (parentIdI.equals(rootId)) {
                root.getChildren().add((Object)itemI);
                continue;
            }
            for (TreeItem itemJ : this.allFunc) {
                String idJ = ((FuncModule)itemJ.getValue()).getId();
                if (!idJ.equals(parentIdI)) continue;
                itemJ.getChildren().add((Object)itemI);
                continue block0;
            }
        }
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.CANCEL};
    }

    public ObservableList<FuncModule> getChoiceList() {
        return this.choiceList;
    }

    public void setChoiceList(ObservableList<FuncModule> choiceList) {
        this.choiceList = choiceList;
    }

    private class MxCheckBoxTreeTableCell<S, T>
    extends TreeTableCell<FuncModule, T> {
        FuncModule funcItem;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.funcItem = (FuncModule)this.getTreeTableRow().getItem();
                if (this.funcItem == null) {
                    return;
                }
                this.checkbox = new CheckBox();
                this.checkbox.selectedProperty().bindBidirectional((Property)this.funcItem.selectedProperty());
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.checkbox.selectedProperty().get()));
                this.setGraphic((Node)this.checkbox);
            }
        }

        private void checkBoxSelected(Boolean selected) {
            ChooiceFuncDialog.this.save.set(true);
            if (selected.booleanValue()) {
                this.selectChdItems((TreeItem<FuncModule>)this.getTreeTableRow().getTreeItem(), true);
                this.selectPrtItems((TreeItem<FuncModule>)this.getTreeTableRow().getTreeItem(), true);
            } else {
                this.selectChdItems((TreeItem<FuncModule>)this.getTreeTableView().getTreeItem(this.getIndex()), false);
                this.selectPrtItems((TreeItem<FuncModule>)this.getTreeTableView().getTreeItem(this.getIndex()), false);
            }
        }

        private void selectChdItems(TreeItem<FuncModule> seleItem, Boolean selected) {
            if (seleItem.getChildren() != null) {
                seleItem.getChildren().forEach(item -> {
                    ((FuncModule)item.getValue()).selectedProperty().set(selected.booleanValue());
                    if (!item.getChildren().isEmpty()) {
                        this.selectChdItems((TreeItem<FuncModule>)item, selected);
                    }
                });
            }
        }

        private void selectPrtItems(TreeItem<FuncModule> seleItem, Boolean selected) {
            if (seleItem != null) {
                TreeItem item = seleItem.getParent();
                if (item == null) {
                    return;
                }
                if (selected.booleanValue()) {
                    ((FuncModule)item.getValue()).selectedProperty().set(selected.booleanValue());
                    this.selectPrtItems((TreeItem<FuncModule>)item, true);
                } else {
                    ObservableList brotheres = item.getChildren();
                    boolean flag = false;
                    for (TreeItem brother : brotheres) {
                        if (!((FuncModule)brother.getValue()).isSelected() || seleItem == brother) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        ((FuncModule)item.getValue()).selectedProperty().set(false);
                        this.selectPrtItems((TreeItem<FuncModule>)item, false);
                    }
                }
            }
        }
    }

    private class MxFuncCheckBoxTreeTableCell<S, T>
    extends TreeTableCell<FuncModule, T> {
        private String text = "";
        Label label = null;
        FuncModule funcItem;
        private final PseudoClass leaf = PseudoClass.getPseudoClass((String)"treeLeaf");
        private final PseudoClass notLeaf = PseudoClass.getPseudoClass((String)"treeNotLeaf");

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.funcItem = (FuncModule)this.getTreeTableRow().getItem();
                if (this.funcItem == null) {
                    return;
                }
                this.text = this.funcItem.getName();
                this.label = new Label(this.text);
                this.setGraphic((Node)this.label);
                if (this.getTreeTableRow().getTreeItem().isLeaf()) {
                    this.getTreeTableRow().pseudoClassStateChanged(this.leaf, true);
                    this.getTreeTableRow().pseudoClassStateChanged(this.notLeaf, false);
                } else {
                    this.getTreeTableRow().pseudoClassStateChanged(this.notLeaf, true);
                    this.getTreeTableRow().pseudoClassStateChanged(this.leaf, false);
                }
            }
        }
    }
}

