/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountMngModel;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.SecAccountMngServiceImpl;
import cms.tmx.utils.MarketUtils;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CfetsSecAccountTabContent
extends MxTabContent {
    private static final int CODE_OK = 1;
    @FXML
    private TextField txtAcctId;
    @FXML
    private TextField txtSecAcctId;
    @FXML
    private ComboBox<MxNode> cmbCurrency;
    @FXML
    private ComboBox<MxNode> cmbExchange;
    @FXML
    private ComboBox<MxNode> cmbCustodianInstitutionName;
    @FXML
    private TextField txtSecuritiesAccountName;
    @FXML
    private TableView<SecAccount> tableSecAcct;
    @FXML
    private Label lbMessage;
    @FXML
    private TableColumn<SecAccount, String> colAcctId;
    @FXML
    private TableColumn<SecAccount, MxNode> colCurrency;
    @FXML
    private TableColumn<SecAccount, MxNode> colExchange;
    @FXML
    private TableColumn<SecAccount, String> colSecAcct;
    @FXML
    private TableColumn<SecAccount, String> colSecuritiesAccountName;
    @FXML
    private TableColumn<SecAccount, MxNode> colCustodianInstitutionName;
    @FXML
    private TableColumn<SecAccount, HBox> colOperate;
    @FXML
    private Button btnAdd;
    @Inject
    private FundAccountMngServiceImpl fundService;
    @Inject
    private MxAlert mAlert;
    @Inject
    private MObjFactory of;
    @Inject
    private SecAccountMngServiceImpl secAccountMng;
    @Inject
    private AccountMngModel accntModel;
    private Account account;
    private MxNode returnStatus;
    private static final Logger logger = LogManager.getLogger(CfetsSecAccountTabContent.class);
    private List<SecAccount> secList = FxUtils.newList();
    private BooleanProperty warning = new SimpleBooleanProperty(false);

    @FXML
    public void initialize() throws MException {
        this.account = this.accntModel.getCommonAccount();
        this.initValues();
        this.txtAcctId.setText(this.account.getInvestorId());
        this.txtSecAcctId.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.createTableView();
        this.refresh();
        CssUtils.priceTag((Control)this.lbMessage);
        this.warning.addListener(obs -> CssUtils.checkSecMessage((Control)this.lbMessage, (boolean)this.warning.getValue()));
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"currency_type", (String)"CNY");
        this.cmbCurrency.setValue((Object)node);
        ObservableList curObList = FXCollections.observableArrayList();
        for (String str : this.account.getCurrency()) {
            MxNode node1 = MxNodeFactory.create((String)"currency_type", (String)"CNY");
            node1.setRaw(str);
            curObList.add((Object)node1);
        }
        this.cmbCurrency.setItems(curObList);
        node = MxNodeFactory.create((String)"market_code", (String)((String)this.account.getSecExc().get(0)));
        this.cmbExchange.setValue((Object)node);
        ObservableList marObList = FXCollections.observableArrayList();
        for (String str : this.account.getSecExc()) {
            MxNode node1 = MxNodeFactory.create((String)"market_code", (String)"XSHG");
            node1.setRaw(str);
            marObList.add((Object)node1);
        }
        this.cmbExchange.setItems(marObList);
        node = MxNodeFactory.create((String)"CUSTODIAN_INSTITUTIONS", (String)"1");
        this.cmbCustodianInstitutionName.setItems(node.getNodes());
        this.cmbCustodianInstitutionName.setValue((Object)node);
        this.returnStatus = MxNodeFactory.create((String)"error_code", (String)"");
    }

    private void createTableView() {
        this.colAcctId.setCellValueFactory(data -> ((SecAccount)data.getValue()).inverstorIdProperty());
        this.colCurrency.setCellValueFactory(data -> ((SecAccount)data.getValue()).currencyProperty());
        this.colExchange.setCellValueFactory(data -> ((SecAccount)data.getValue()).exchangeProperty());
        this.colCustodianInstitutionName.setCellValueFactory(data -> ((SecAccount)data.getValue()).custodianInstitutionNameProperty());
        this.colSecAcct.setCellValueFactory(data -> ((SecAccount)data.getValue()).inverstorSecIdProperty());
        this.colSecuritiesAccountName.setCellValueFactory(data -> ((SecAccount)data.getValue()).securitiesAccountNameProperty());
        this.colOperate.setCellValueFactory(data -> this.setOperate((SecAccount)data.getValue()));
        this.tableSecAcct.setPlaceholder((Node)new Label());
    }

    public void refresh() throws MException {
        this.tableSecAcct.getItems().clear();
        this.secList.clear();
        List<FundAccount> fundList = this.fundService.queryFundAccountList(this.account.getId(), this.account.getSecExc());
        for (FundAccount fund : fundList) {
            this.secList.addAll(this.secAccountMng.querySecAccountList(fund));
        }
        ObservableList obList = FXCollections.observableList(this.secList);
        this.tableSecAcct.setItems(obList);
    }

    public void addSecAcct() throws MException {
        if (this.txtSecAcctId.getText().isEmpty()) {
            this.lbMessage.setText("\u8bc1\u5238\u8d26\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
            this.warning.setValue(Boolean.valueOf(true));
            return;
        }
        if (this.txtSecuritiesAccountName.getText().isEmpty()) {
            this.lbMessage.setText("\u6258\u7ba1\u8d26\u6237\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            this.warning.setValue(Boolean.valueOf(true));
            return;
        }
        SecAccount secAcc = (SecAccount)this.of.create(SecAccount.class);
        secAcc.setAccntId(this.account.getId());
        secAcc.setInverstorId(this.account.getInvestorId());
        secAcc.setCurrency((MxNode)this.cmbCurrency.getValue());
        secAcc.setExchange((MxNode)this.cmbExchange.getValue());
        secAcc.setCustodianInstitutionName((MxNode)this.cmbCustodianInstitutionName.getValue());
        secAcc.setInverstorSecId(this.txtSecAcctId.getText());
        secAcc.setSecuritiesAccountName(this.txtSecuritiesAccountName.getText());
        secAcc.setExtAccntId(String.valueOf(this.account.getInvestorId()) + "_" + ((MxNode)this.cmbCurrency.getValue()).getRaw());
        secAcc.setExtSecAccntId(String.valueOf(this.txtSecAcctId.getText()) + "_" + ((MxNode)this.cmbCurrency.getValue()).getRaw());
        try {
            PBase.OpStatus status = this.secAccountMng.addSecAccount(secAcc, this.account);
            this.returnStatus.setRaw(String.valueOf(status.getStatus()));
            this.lbMessage.setText("\u589e\u52a0" + this.txtSecAcctId.getText() + ": " + this.returnStatus.getValue());
            if (status.getStatus() == 1) {
                this.warning.setValue(Boolean.valueOf(false));
            } else {
                this.warning.setValue(Boolean.valueOf(true));
            }
        }
        catch (MException e) {
            this.lbMessage.setText(e.getMessage());
            this.warning.setValue(Boolean.valueOf(true));
            logger.error((Object)e, (Throwable)e);
        }
        this.refresh();
        this.tableSecAcct.getSelectionModel().select((Object)((SecAccount)this.tableSecAcct.getItems().filtered(item -> item.getInverstorSecId().equals(this.txtSecAcctId.getText())).get(0)));
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(SecAccount ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        String type = MarketUtils.findMarketGrp((String)ap.getExchange().getRaw());
        ap.setMarketGrp(type);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> {
            try {
                if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664" + ap.getInverstorSecId() + "?")) {
                    this.delete(ap);
                }
            }
            catch (MException e) {
                this.lbMessage.setText(e.getMessage());
                this.warning.setValue(Boolean.valueOf(true));
                logger.error((Object)e, (Throwable)e);
            }
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    private void delete(SecAccount secAcc) throws MException {
        PBase.OpStatus status = this.secAccountMng.delSecAccount(secAcc, this.account);
        this.returnStatus.setRaw(String.valueOf(status.getStatus()));
        this.lbMessage.setText("\u5220\u9664" + secAcc.getInverstorSecId() + ": " + this.returnStatus.getValue());
        if (status.getStatus() == 1) {
            this.warning.setValue(Boolean.valueOf(false));
        } else {
            this.warning.setValue(Boolean.valueOf(true));
        }
        this.refresh();
    }

    public void setAccount(Account acc) {
        this.account = acc;
    }
}

