/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Broker;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.BrokerMngServiceImpl;
import cms.tmx.manage.parts.AddBrokerDialog;
import cms.tmx.manage.parts.UpdateBrokerDialog;
import cms.tmx.rights.IUiRightService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrokerMngPart
extends MxPart {
    @FXML
    private Button btnUpdate;
    @FXML
    private Button btnAdd;
    @FXML
    private TableView<Broker> tableBroker;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnQuery;
    @FXML
    private TableColumn<String, String> index;
    @Inject
    private DialogFactory df;
    @Inject
    private MObjFactory of;
    @Inject
    private ExecutorService exe;
    @Inject
    private BrokerMngServiceImpl brokerMng;
    @Inject
    private IUiRightService model;
    private List<Broker> filterList = new LinkedList<Broker>();
    private Broker selectTable;
    private static final Logger logger = LogManager.getLogger(BrokerMngPart.class);
    private MxList<Broker> mlist = new MxList();
    private Predicate<Broker> pd = broker -> {
        String param = this.txtSearch.getText().trim();
        return broker.getCode().contains(param) || broker.getName().contains(param) || broker.getFullName().contains(param);
    };
    private InvalidationListener accModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableBroker.sort();
    };

    @FXML
    public void initialize() {
        this.createTableView();
        this.bingUI();
        this.exe.execute(() -> this.query());
        this.checkRights();
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnAdd, new String[]{"addBrokerControl"});
        this.model.registerCheck((Control)this.btnUpdate, new String[]{"updateBrokerControl"});
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryBrokerControl"});
    }

    private void bingUI() {
        this.txtSearch.textProperty().addListener(this.accModel);
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter(32));
        this.btnUpdate.disableProperty().bind((ObservableValue)this.tableBroker.getSelectionModel().selectedItemProperty().isNull());
        this.selectTable = null;
        this.tableBroker.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.selectTable = (Broker)this.tableBroker.getSelectionModel().getSelectedItem();
            }
        });
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableBroker);
    }

    @FXML
    private void rightRefresh() {
        this.query();
    }

    @FXML
    private void refresh() {
        this.rightRefresh();
    }

    private void query() {
        try {
            this.filterList.clear();
            this.mlist.clear();
            this.filterList.addAll((Collection<Broker>)this.brokerMng.queryBrokerList());
            this.mlist.addAll(this.filterList);
            Collections.sort(this.mlist.getList(), (o1, o2) -> {
                if (Integer.parseInt(o1.getId().substring(1)) < Integer.parseInt(o2.getId().substring(1))) {
                    return 1;
                }
                return -1;
            });
        }
        catch (MException e) {
            logger.error("query broker failed", (Throwable)e);
        }
    }

    private void createTableView() {
        this.addViwer(this.tableBroker);
        this.tableBroker.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableBroker);
        this.tableBroker.setItems(this.mlist.getList());
    }

    @FXML
    private void add() {
        String brokerId;
        AddBrokerDialog obj = (AddBrokerDialog)((Object)this.of.create(AddBrokerDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6dfb\u52a0\u7ecf\u7eaa\u5546");
        dialog.setFirstNode((Node)obj.getTxtName());
        dialog.setLastNode((Node)obj.getTxtCode());
        if (dialog.launch().equals(ButtonType.OK)) {
            this.query();
        }
        if ((brokerId = obj.getBrokerId()) != null) {
            this.tableBroker.getSelectionModel().select((Object)((Broker)this.tableBroker.getItems().parallelStream().filter(item -> item.getId().equals(brokerId)).collect(Collectors.toList()).get(0)));
        }
    }

    @FXML
    private void update() {
        Broker item = (Broker)this.tableBroker.getSelectionModel().getSelectedItem();
        Broker broker = (Broker)this.of.create(Broker.class);
        broker.update((Object)item);
        UpdateBrokerDialog obj = (UpdateBrokerDialog)((Object)this.of.create(UpdateBrokerDialog.class));
        obj.setBroker(broker);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u7ecf\u6d4e\u5546");
        ButtonType bt = dialog.launch();
        if (bt.equals(ButtonType.OK)) {
            this.query();
        }
    }
}

