/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Blacklist;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.IBlacklistService;
import cms.tmx.manage.parts.AddBlacklistDialog;
import cms.tmx.manage.parts.UpdateBlacklistDialog;
import cms.tmx.rights.IUiRightService;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlacklistMngPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(BlacklistMngPart.class);
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @FXML
    private TableView<Blacklist> tableBlacklist;
    @FXML
    private TableColumn<Blacklist, String> index;
    @FXML
    private TableColumn<Blacklist, String> colIp;
    @FXML
    private TableColumn<Blacklist, String> colSource;
    @FXML
    private TableColumn<Blacklist, String> colDesc;
    @FXML
    private TableColumn<Blacklist, String> colStatus;
    @FXML
    private TableColumn<Blacklist, String> colOpera;
    @FXML
    private TableColumn<Blacklist, String> colCreator;
    @FXML
    private TableColumn<Blacklist, String> colCreateTime;
    @FXML
    private TableColumn<Blacklist, String> colUpdator;
    @FXML
    private TableColumn<Blacklist, String> colUpdateTime;
    @FXML
    private MenuItem expExcel;
    private List<Blacklist> filterList = new LinkedList<Blacklist>();
    private MxList<Blacklist> mlist = new MxList();
    @Inject
    private DialogFactory df;
    @Inject
    private MObjFactory of;
    @Inject
    protected Stage stage;
    @Inject
    private MxAlert alert;
    @Inject
    private IBlacklistService iBlacklist;
    @Inject
    private IUiRightService right;
    private static final String IS_ENABLE_BLACK = "\u662f\u5426\u542f\u7528\u8be5\u9ed1\u540d\u5355";
    private static final String IS_DISABLE_BLACK = "\u662f\u5426\u505c\u7528\u8be5\u9ed1\u540d\u5355";
    private static final String ALERT = "\u63d0\u793a";
    private static final int DELETE_IP_BLACKLIST = 3;
    private static final int ENABLE_IP_BLACKLIST = 4;
    private static final int QUERY_IP_BLACKLIST = 6;
    private int type;
    private boolean updateFlag = true;
    private boolean deleteFlag = true;
    private boolean statusFlag = true;
    private Predicate<Blacklist> pd = Blacklist2 -> {
        String param = this.txtSearch.getText().trim();
        return Blacklist2.getIp().contains(param) || Blacklist2.getSource().contains(param) || Blacklist2.getDesc().contains(param);
    };
    private InvalidationListener blModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableBlacklist.sort();
    };

    @FXML
    private void initialize() {
        this.exe.execute(() -> this.query());
        this.bingUI();
        this.createTableView();
        this.checkRights();
    }

    private void checkRights() {
        this.right.registerCheck((Control)this.btnQuery, new String[]{"queryBlacklistControl"});
        this.right.registerCheckAll((Control)this.btnAdd, new String[]{"addBlacklistControl"});
        this.statusFlag = this.right.registerCheck(new String[]{"enableBlacklistControl"});
        this.updateFlag = this.right.registerCheck(new String[]{"updateBlacklistControl"});
        this.deleteFlag = this.right.registerCheck(new String[]{"deleteBlacklistControl"});
    }

    private void bingUI() {
        this.txtSearch.textProperty().addListener(this.blModel);
    }

    @FXML
    private void add() {
        AddBlacklistDialog obj = (AddBlacklistDialog)((Object)this.of.create(AddBlacklistDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6dfb\u52a0\u9ed1\u540d\u5355");
        if (dialog.launch().equals(ButtonType.OK)) {
            this.query();
        }
    }

    @FXML
    private void query() {
        try {
            this.filterList.clear();
            this.mlist.clear();
            this.type = 6;
            this.filterList.addAll(this.iBlacklist.queryBlacklistList(this.type));
        }
        catch (MException e) {
            logger.error("query blacklist failed", (Throwable)e);
        }
        this.mlist.addAll(this.filterList);
        this.mlist.update(this.filterList, this.pd);
        this.tableBlacklist.sort();
    }

    @FXML
    private void update() {
        Blacklist item = (Blacklist)this.tableBlacklist.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        Blacklist blacklist = (Blacklist)this.of.create(Blacklist.class);
        blacklist.update((Object)item);
        UpdateBlacklistDialog obj = (UpdateBlacklistDialog)((Object)this.of.create(UpdateBlacklistDialog.class));
        obj.setBlacklist(blacklist);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u9ed1\u540d\u5355");
        if (dialog.launch().equals(ButtonType.OK)) {
            this.query();
        }
    }

    @FXML
    private void delete() {
        Blacklist item = (Blacklist)this.tableBlacklist.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        Blacklist blacklist = (Blacklist)this.of.create(Blacklist.class);
        blacklist.update((Object)item);
        try {
            this.type = 3;
            this.iBlacklist.delBlacklist(blacklist, this.type);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u6210\u529f", ALERT);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u5220\u9664\u9ed1\u540d\u5355\u5931\u8d25", (Throwable)e);
        }
        this.query();
    }

    private void createTableView() {
        this.addViwer(this.tableBlacklist);
        this.tableBlacklist.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableBlacklist);
        this.colIp.setCellValueFactory(data -> ((Blacklist)data.getValue()).ipProperty());
        this.colSource.setCellValueFactory(data -> ((Blacklist)data.getValue()).sourceProperty());
        this.colDesc.setCellValueFactory(data -> ((Blacklist)data.getValue()).descProperty());
        this.colStatus.setCellValueFactory(data -> ((Blacklist)data.getValue()).statusTextProperty());
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableBlacklist));
        this.colCreator.setCellValueFactory(data -> ((Blacklist)data.getValue()).creatorProperty());
        this.colCreateTime.setCellValueFactory(data -> ((Blacklist)data.getValue()).createTimeProperty());
        this.colUpdator.setCellValueFactory(data -> ((Blacklist)data.getValue()).updatorProperty());
        this.colUpdateTime.setCellValueFactory(data -> ((Blacklist)data.getValue()).updateTimeProperty());
        this.tableBlacklist.setItems(this.mlist.getList());
    }

    private void close() {
        Blacklist item = (Blacklist)this.tableBlacklist.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        Blacklist blacklist = (Blacklist)this.of.create(Blacklist.class);
        blacklist.update((Object)item);
        this.type = 4;
        try {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, IS_DISABLE_BLACK, ALERT)) {
                this.iBlacklist.enableBlacklist(item, this.type, false);
                this.alert.alert(Alert.AlertType.INFORMATION, "\u5df2\u505c\u7528\u9ed1\u540d\u5355", ALERT);
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u505c\u7528\u9ed1\u540d\u5355\u5931\u8d25", (Throwable)e);
        }
    }

    private void open() {
        Blacklist item = (Blacklist)this.tableBlacklist.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        Blacklist blacklist = (Blacklist)this.of.create(Blacklist.class);
        blacklist.update((Object)item);
        this.type = 4;
        try {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, IS_ENABLE_BLACK, ALERT)) {
                this.iBlacklist.enableBlacklist(item, this.type, true);
                this.alert.alert(Alert.AlertType.INFORMATION, "\u5df2\u542f\u7528\u9ed1\u540d\u5355", ALERT);
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u542f\u7528\u9ed1\u540d\u5355\u5931\u8d25", (Throwable)e);
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithTwoHead(this.tableBlacklist, (int)0, (int)0);
    }

    @FXML
    private void refresh() {
        this.query();
    }

    @FXML
    private void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableBlacklist, (String)"IP\u9ed1\u540d\u5355");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private class OperaCell
    extends TableCell<Blacklist, String> {
        final HBox paddedLabel = new HBox();
        final Label updateLab = new Label("\u4fee\u6539");
        final Label deleteLab = new Label("\u5220\u9664");
        final Label statusLab = new Label("\u65e0");

        OperaCell(Stage stage, final TableView table) {
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.deleteLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.deleteLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            this.paddedLabel.setSpacing(20.0);
            if (BlacklistMngPart.this.updateFlag) {
                this.paddedLabel.getChildren().add((Object)this.updateLab);
            }
            if (BlacklistMngPart.this.deleteFlag) {
                this.paddedLabel.getChildren().add((Object)this.deleteLab);
            }
            if (BlacklistMngPart.this.statusFlag) {
                this.paddedLabel.getChildren().add((Object)this.statusLab);
            }
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    BlacklistMngPart.this.update();
                }
            });
            this.deleteLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (BlacklistMngPart.this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664?")) {
                        BlacklistMngPart.this.delete();
                    }
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof Blacklist) {
                        Blacklist bl = (Blacklist)OperaCell.this.getTableRow().getItem();
                        if (!bl.isStatus()) {
                            OperaCell.this.statusLab.setText("\u542f\u7528");
                            BlacklistMngPart.this.open();
                        } else {
                            OperaCell.this.statusLab.setText("\u505c\u7528");
                            BlacklistMngPart.this.close();
                        }
                        BlacklistMngPart.this.query();
                    }
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof Blacklist) {
                    Blacklist bl = (Blacklist)this.getTableRow().getItem();
                    if (bl.isStatus()) {
                        this.statusLab.setText("\u505c\u7528");
                    } else {
                        this.statusLab.setText("\u542f\u7528");
                    }
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

